﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView.NtHtml
{
    partial class NTHtmlUtils
    {


        public static void init()
        {
            HTMLEscapeTable.init();
        }

        public static string parseActionUrl(string host, string url, NTHtmlParser parser)
        {
            string action = null;
            foreach (KeyValuePair<string, string> pair in parser.mFormAttributes)
            {
                if (pair.Key.Trim().Equals("action", StringComparison.CurrentCultureIgnoreCase))
                {
                    action = pair.Value;
                    break;
                }
            }
            return parseActionUrl( host, url, action);
        }

        public static string parseActionUrl(string host, string url, string action)
        {
            if (action == null)
                return null;

            int idx = action.LastIndexOf('?');
            if (idx > 0)
            {
                action = action.Substring(0, idx);
            }
            action = action.Trim();

            idx = url.LastIndexOf('/');
            if (idx > 0 && idx < url.Length - 1)
            {
                url = url.Substring(0, idx + 1);
            }

            string newUrl = null;

            idx = action.IndexOf("http://", StringComparison.CurrentCultureIgnoreCase);
            if (idx == 0)
            {
                newUrl = action;
            }
            if (newUrl == null)
            {
                idx = action.IndexOf("../");
                if (idx == 0)
                {
                    int n1 = url.LastIndexOf('/', url.Length - 2);
                    if (n1 < 0)
                        return null;
                    newUrl = url.Substring(0, n1) + action.Substring(idx + 2);
                }
            }
            if (newUrl == null)
            {
                idx = action.IndexOf("./");
                if (idx == 0)
                {
                    newUrl = url + action.Substring(idx + 2);
                }
            }
            if (newUrl == null)
            {
                idx = action.IndexOf('/');
                if (idx == 0)
                {
                    newUrl = "http://" + host + action;
                }
                else if(idx < 0)
                {
                    newUrl = url + action;
                }
            }
            return newUrl;
        }


      public  enum TOKEN{
            NOTHING,
            ALPHABET,
            NUMBER,
            WHITESPACE,
            CONTROL_CODE,
            NON_ASCII,
            OTHER
        };

        public static TOKEN getToken(char c)
        {
            if (('a' <= c && c <= 'z') || ('A' <= c && c <= 'Z'))
            {
                return TOKEN.ALPHABET;
            }
            else if ('0' <= c && c <= '9')
            {
                return TOKEN.NUMBER;
            }
            else if (c == ' ' || c == '\t' || c == '\n')
            {
                return TOKEN.WHITESPACE;
            }
            else if (c < 0x21 || 0x7e < c)
            {
                return TOKEN.CONTROL_CODE;
            }
            else if (c > 0x7f)
            {
                return TOKEN.NON_ASCII;
            }
            else
            {
                return TOKEN.OTHER;
            }
        }
         static int parseWebHost(string source, int start){
    		int charCnt = 0;
    	    TOKEN previous = TOKEN.NOTHING;
    	    char previousC = '\0';
    	    bool hasComma = false; // must has a comma at least one;
    	    bool initFirstChar = false;
    	    bool hasAlphabet = false;
    	    int i;
    	    //DebugUtil.log(source.substring(start));
    	    bool loop = true;//LABEL:
    	    for( i = start; i < source.Length; i++){
        	    //DebugUtil.log(source.substring(i));
    		    char c = source[i];
    		    TOKEN token = getToken(c);
    		    switch(token){
    		    case TOKEN.ALPHABET:
    			    hasAlphabet = true;
                    initFirstChar = true;
                    charCnt++;
                    break;
                case TOKEN.NUMBER:
        		    initFirstChar = true;
    			    charCnt++;
    			    break;
    		    case TOKEN.CONTROL_CODE:
                    loop = false;
    			    break;// LABEL;
    		    case TOKEN.OTHER:
    		    default:
    			    if(initFirstChar){
	        		    // only hyphen allowed in domain name.
	    			    if('-' == c){
	    				    charCnt++;
	    				    break;
	    			    }
	    			    // not allowed successive comma
	    			    if('.' == c && previousC != '.' && previousC != '-'){
	    				    charCnt++;
	    				    hasComma = true;
	    				    break;
	    			    }
    			    }
                    loop = false;
    			    break;// LABEL;
    		    }
                if (!loop)
                    break;
                previous = token;
			    previousC = c;
    	    }
    	    if('-' == previousC || '.' == previousC){
    		    charCnt--;
    		    i--;
    		    previousC = source[i];
    	    }
    	
    	    // top domain names haven't degits. 
    	    if(TOKEN.NUMBER == previous && hasAlphabet == true){
    		    bool loop2 = true;//LABEL2:
    		    for(i--; i > 0; i--){
        		    char c = source[i];
        		    TOKEN token = getToken(c);
        		    switch(token){
        		    case TOKEN.NUMBER:
        			    charCnt--;
        			    break;
        		    case TOKEN.ALPHABET:
        		    default:
                        loop2 = false;
            		    break;// LABEL2; 
        		    }
        		    previous = token;
                    if (!loop2)
                        break;
    		    }
    	    }
    	    return ((TOKEN.ALPHABET == previous || TOKEN.NUMBER == previous) && hasComma) ? charCnt : -1;
         }
         public static int parseWebAddress(string source, int start){
    	    int n = parseWebHost(source, start);

    	    if(0 > n || (source.Length <= (start+n)) || '/' != source[start + n]){
    		    return n;
    	    }
    	    n++;
    	    bool loop = true;//LABEL:
            while ((start + n) < source.Length)
            {
    		    char c = source[start + n];
    		    TOKEN token = getToken(c);
    		    switch(token){
    		    case TOKEN.NUMBER:
                    break;
    		    case TOKEN.ALPHABET:
    			    break;
    		    case TOKEN.OTHER:
    			    switch(c){
    			    case '-':
                    case '+':
        		    case '_':
    			    case '.':
    			    case '/':
    			    case '?':
    			    case '%':
    			    case '&':
    			    case '=':
    			    case '[':
    			    case ']':
    			    case '*':
    			    case '~':
    			    case ':':
    			    case '#':
    			    case '!':
                    case '@':
                    case '(':
                    case ')':
                        break;
    			    default:
                        loop = false;
    				    break;// LABEL;
    			    }//end of switch(c)
    			    break;
    		    case TOKEN.NON_ASCII:
    		    case TOKEN.CONTROL_CODE:
        	    default:
                    loop = false;
        		    break;// LABEL; 
    		    }// end of switch(token)   
                if (!loop)
                    break;
    		    n++;
    	    }// end of while:LABEL
    	    return n--;
        }

    }
}
