﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Media;
using System.Globalization;
using System.Windows.Documents;


namespace NT2chView.NtHtml
{
    class NTHtmlParser
    {

    	
	    public static void init(){
		    HTMLElementTable.init();
	    }
	
	    /*public static final int TYPE_NONE = -1;
	    public static final int TYPE_HTML = 0;
	    public static final int TYPE_COMMENT = 1;
	    public static final int TYPE_TITLE = 2;
	    public static final int TYPE_BODY = 3;
	    public static final int TYPE_ALINK = 4;
	    public static final int TYPE_INPUT = 5;*/
	    int mUnnumberedListIndent = 0;
	
	    String mTitle = string.Empty;//new String();
	    StringBuilder mOutput = new StringBuilder(2048);
	    String mParsedHtml = null;
	    public List<String> mCommentList = new List<String>();
	    public List<KeyValuePair<string,string>> mInputTypeHidden = new List<KeyValuePair<string,string>>();
	    public List<KeyValuePair<string,string>> mInputTypeSubmit = new List<KeyValuePair<string,string>>();
	    public List<KeyValuePair<string,string>> mInputTypeCheckBox = new List<KeyValuePair<string,string>>();
	    public List<KeyValuePair<string,string>> mInputTypeText = new List<KeyValuePair<string,string>>();
	    public List<KeyValuePair<string,string>> mInputTypePasswd = new List<KeyValuePair<string,string>>();
	    public List<KeyValuePair<string,string>> mHtmlAttributes = new List<KeyValuePair<string,string>>();
	    public List<KeyValuePair<string,string>> mBodyAttributes = new List<KeyValuePair<string,string>>();
        public List<KeyValuePair<string, string>> mFormAttributes = new List<KeyValuePair<string, string>>();
        public List<KeyValuePair<string, string>> mTextAreaAttributes = new List<KeyValuePair<string, string>>();
        //public ArrayList<SpannableObject> mSpannableObjectStack = new ArrayList<SpannableObject>();
	
	    public String getParsedHtml(){return mParsedHtml;}
	
	    public String getTitle(){return mTitle;}

        FlowDocument mDocRoot;
        Stack<TextElement> mDrawElementStack = new Stack<TextElement>();

	    public NTHtmlParser(FlowDocument document){

            mDocRoot = document;
            Paragraph para = new Paragraph();
            document.Blocks.Add(para);
            mDrawElementStack.Push(para);
	    }

        public void DrawElementClear()
        {
           
            mDocRoot.Blocks.Clear();
            mDrawElementStack.Clear();

            Paragraph para = new Paragraph();
            mDocRoot.Blocks.Add(para);
            mDrawElementStack.Push(para);
        }

        public void DrawElementAdd(Inline inline)
        {
           //TextElement element = mDrawElementStack.Peek();

           Block block = mDocRoot.Blocks.LastBlock;

            Paragraph para  = block as Paragraph;
            if(para != null){
                TextElement element = mDrawElementStack.Peek();
                Span span = element as Span;
                if (span != null)
                {
                    span.Inlines.Add(inline);
                    return;
                }
                //Paragraph para2 = element as Paragraph;
                //if(para2 != null)
                //{
                para.Inlines.Add(inline);
                //}
                return;
            }

            List list = block as List;
            if(list != null)
            {
                if (inline is Run)
                {
                    if (((Run)inline).Text.Trim().Length > 0)
                    {
                        ListItem item = new ListItem();
                        para = new Paragraph(inline);
                        item.Blocks.Add(para);
                        list.ListItems.Add(item);
                    }
                }
                return;
            }
         }

        public void DrawElementPushList()
        {
            List list = new List();
            list.MarkerStyle = System.Windows.TextMarkerStyle.Disc;
            mDocRoot.Blocks.Add(list);

            mDrawElementStack.Clear();
        }

        public void DrawElementPopList()
        {
            mDrawElementStack.Clear();
            Paragraph para = new Paragraph();
            mDocRoot.Blocks.Add(para);
            mDrawElementStack.Push(para);

        }
        public void DrawElementPush(Span source)
        {
            if (mDrawElementStack.Count <= 0)
            {
                return;
            }

            TextElement element = mDrawElementStack.Peek();
            Paragraph para = element as Paragraph;
            if (para != null)
            {
               para.Inlines.Add(source);
               mDrawElementStack.Push(source);
               return;
            }

            Span span = element as Span;
            if (span != null)
            {
                span.Inlines.Add(source);
                mDrawElementStack.Push(source);
                return;
            }
       }
        public void  DrawElementPop()
        {
            if (mDrawElementStack.Count <= 0)
            {
                return;
            }

            if(mDrawElementStack.Peek() is Paragraph)
                return;

            TextElement element = mDrawElementStack.Pop();
            
        }

	
	    public String parse(String htmlSource){
		
		
		    int[] retVal = new int[1];
		
		
		    AbstractElement ae = new AbstractElement(this);
		
		
		    ae.parse(htmlSource, 0, retVal,HTMLElementTable.ELEMENT_TOKEN_NULL);
		
		    mParsedHtml = mOutput.ToString();
		
		    return mParsedHtml;
		
	    }

        
	
	    public Color getBgColor() {
		    for(int i  = 0; i < mBodyAttributes.Count; i++){
			    KeyValuePair<string,string> pair = mBodyAttributes[i];
			    if(pair.Key.Equals("bgcolor")){
				    return parseColor(pair.Value, 0);
			    }
		    }
		    throw new Exception();
	    }
	
	    static Color parseColor(String source, int start) {
		    int i = start;
		    if('#' != source[i] || 7 > (source.Length-start)){
			    throw new Exception();
		    }
		    i++;
		    String wrk = source.Substring(i, 2);
		    int red = int.Parse(wrk, NumberStyles.HexNumber);
		
		    i += 2;
		    wrk = source.Substring(i, 2);
		    int green = int.Parse(wrk, NumberStyles.HexNumber);
		    i += 2;
		    wrk = source.Substring(i, 2);
		    int blue = int.Parse(wrk, NumberStyles.HexNumber);
		
		    return Color.FromArgb((byte)255, (byte)red, (byte)green, (byte)blue);	
	    }
	
	
	    public class AbstractElement {
		    protected NTHtmlParser mParser = null;
		    public AbstractElement(NTHtmlParser parser){
			    mParser = parser;
		    }
		    public virtual int parse(String source, int start,  int [] retVal, int breakType){
			    int start2 = start;
			    int i = 0;
			    for(i = start; i < source.Length; i++){
				    int type = HTMLElementTable.getElementTypeFromSource(source, i,  retVal);
				    if(breakType == type){
					    mParser.mOutput.Append(source.Substring(start2, i-start2));
                        //*****
                        Run run = new Run(source.Substring(start2, i-start2));
                        mParser.DrawElementAdd(run);
					    return retVal[0];
				    }
				    if(HTMLElementTable.ELEMENT_TOKEN_NONE == type){
					    continue;
				    }
				    if(start2 < i){
					    mParser.mOutput.Append(source.Substring(start2, i-start2));
                        //***
                        if (i > start2)
                        {
                            Run run = new Run(source.Substring(start2, i - start2));
                            mParser.DrawElementAdd(run);
                        }
					    start2 = i + 1;
				    }
				
				    AbstractElement ae = null;
				
				    switch(type){
				    case HTMLElementTable.ELEMENT_TOKEN_UL_S:
					    mParser.mUnnumberedListIndent++;
                        mParser.DrawElementPushList();
                        start2 = retVal[0];
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_UL_E:
                        mParser.mUnnumberedListIndent--;
                        mParser.DrawElementPopList();
					    start2 = retVal[0];
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_LI:
					    ae = new  ListItemElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_NULL);
					    i = start2 - 1;
					    break;	
				    case HTMLElementTable.ELEMENT_TOKEN_PARAGRAPH:
					    mParser.mOutput.Append('\n');
                        mParser.mOutput.Append('\n');
                        //***
                        mParser.DrawElementAdd(new LineBreak());
                        mParser.DrawElementAdd(new LineBreak());
                        start2 = retVal[0];
                        i = start2 - 1;
                        break;
                    case HTMLElementTable.ELEMENT_TOKEN_BREAK:
					    mParser.mOutput.Append('\n');
                        //***
                        mParser.DrawElementAdd(new LineBreak());
                        start2 = retVal[0];
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_HR:
					    ae = new  HRElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_NULL);
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_BOLD_S:
					    ae = new  BoldElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_BOLD_E);
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_HTML_S:
					    mParser.mOutput.Remove(0, mParser.mOutput.Length);
                        //***
                        mParser.DrawElementClear();

                         ae = new  HtmlElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_HTML_E);
					    return source.Length;
				    case HTMLElementTable.ELEMENT_TOKEN_BODY_S:
					    mParser.mOutput.Remove(0, mParser.mOutput.Length);
                        //***
                        mParser.DrawElementClear();
                        
                        ae = new BodyElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_BODY_E);
					    return source.Length;
				    case HTMLElementTable.ELEMENT_TOKEN_COMMENT_S:
					    ae = new  CommentElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_COMMENT_E);
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_TITLE_S:
					    ae = new  TitleElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_TITLE_E);
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_CENTER_S:
					    ae = new  CenterElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_CENTER_E);
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_ALINK_S:
					    ae = new  ALinkElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_ALINK_E);
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_INPUT:
					    ae = new  InputElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_NULL);
					    i = start2 - 1;
					    break;
				    case HTMLElementTable.ELEMENT_TOKEN_FONT_S:
					    ae = new  FontElement(mParser);
					    start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_FONT_E);
					    i = start2 - 1;
					    break;
                    case HTMLElementTable.ELEMENT_TOKEN_FORM_S:
                        ae = new FormElement(mParser);
                        start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_FORM_E);
                        i = start2 - 1;
                        break;
                    case HTMLElementTable.ELEMENT_TOKEN_TEXTAREA_S:
                        ae = new TextAreaElement(mParser);
                        start2 = ae.parse(source, retVal[0], retVal, HTMLElementTable.ELEMENT_TOKEN_TEXTAREA_E);
                        i = start2 - 1;
                        break;
                    default:
					    break;
				    }
				
			    }
			    return i;
		    }
	    }
	
	    /*public class SpannableObject{
		    Object mWhat;
		    int mStart, mEnd, mFlags;
		    public SpannableObject(Object what, int start, int end, int flags){
			    mWhat = what; mStart = start; mEnd = end; mFlags = flags;			
		    }
	    }*/

	    class HtmlElement : AbstractElement{
		    public HtmlElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
            public override int parse(String source, int start, int[] retVal, int breakType){
                mParser.mHtmlAttributes = mParser.parseAttributes(source, start, retVal);
			    start = retVal[0];
			    return base.parse(source, start, retVal, breakType);
		    }
	    }

	    class BodyElement : AbstractElement{
		    public BodyElement(NTHtmlParser parser) : base(parser)
            {
		
		    }
		    public override int parse(String source, int start, int[] retVal, int breakType){
                mParser.mBodyAttributes = mParser.parseAttributes(source, start, retVal);
			    start = retVal[0];
			    return base.parse(source, start, retVal, breakType);
		    }
	    }

	    class HRElement : AbstractElement{
		    public HRElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
            public override int parse(String source, int dummy, int[] retVal, int breakType){
                String hr = "\n\n                                                            \n\n";
                
                //***
                String hr2 = "---------------------------------------------------------------";
                mParser.DrawElementAdd(new LineBreak());
                mParser.DrawElementAdd(new LineBreak());
                mParser.DrawElementAdd(new Run(hr2));
                mParser.DrawElementAdd(new LineBreak());
                mParser.DrawElementAdd(new LineBreak());
			    

                StringBuilder buf = mParser.mOutput;
			    int start = buf.Length;
			    buf.Append(hr);
			    int end = buf.Length;
			    /*StrikethroughSpan span = new StrikethroughSpan();
			    mSpannableObjectStack.add(
					    new SpannableObject(span, 
							    start+2, end-2, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE));
			    AlignmentSpan.Standard center_span = 
					    new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER);
			    mSpannableObjectStack.add(
					    new SpannableObject(center_span, 
							    start+2, end-2, 
							    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE));
                */
			    return retVal[0];
		    }
	    }
	    class ListItemElement : AbstractElement{
		    public ListItemElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
            public override int parse(String source, int dummy, int[] retVal, int breakType){
			    String indent = "\n";
                mParser.DrawElementAdd(new LineBreak());
			    int i =  0;
			    for(; i < mParser.mUnnumberedListIndent; i++){
				    indent += "　 　";
			    }
			    if(0 < i){
				    indent += '●';
				    mParser.mOutput.Append(indent);
                    //mParser.DrawElementAdd(new Run(indent));
			    }
			    return retVal[0];
		    }
	    }

	    class BoldElement : AbstractElement{
		    public BoldElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
            public override int parse(String source, int start, int[] retVal, int breakType){
			    //mParser.mBodyAttributes = parseAttributes( source,  start, retVal);
			    //start = retVal[0];
                Bold bold = new Bold();
                //mParser.mDrawElementStack.Push(bold);
			    //int textStart = mParser.mOutput.Length;
                mParser.DrawElementPush(new Bold());
                int end = base.parse(source, start, retVal, breakType);
                mParser.DrawElementPop();
                //int textEnd =  mParser.mOutput.Length;
			    /*StyleSpan span = new StyleSpan(android.graphics.Typeface.BOLD); 
			    mSpannableObjectStack.add( 
					    new SpannableObject(span, 
								    textStart, textEnd, 
								    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE));*/
                return end;
		    }
	    }

	
	    class CenterElement : AbstractElement{
		    public CenterElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
            public override int parse(String source, int start, int[] retVal, int breakType){
			    //mParser.mBodyAttributes = parseAttributes( source,  start, retVal);
			    //start = retVal[0];
			    //int textStart = mParser.mOutput.Length;
			    int end = base.parse(source, start, retVal, breakType);
			    //int textEnd =  mParser.mOutput.Length;
			    //if(textStart < textEnd){	
				/*    AlignmentSpan.Standard center_span = 
						    new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER);
		        
				    mSpannableObjectStack.add(
						    new SpannableObject(center_span, 
								    textStart, textEnd, 
								    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE));*/
			   // }
			    return end;
		    }
	    }

	    class CommentElement : AbstractElement{
		    public CommentElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
		    public override int parse(String source, int start, int[] retVal, int breakType){
			    //int start2 = start;
			    int i = 0;
			    for(i = start; i < source.Length; i++){
				    int type = HTMLElementTable.getElementTypeFromSource(source, i, retVal);
				    if(breakType == type){
					    String comment = source.Substring(start, retVal[0]-start);
					    mParser.mCommentList.Add(comment.Trim());
					    return retVal[0];
				    }
			    }
			    return i;
		    }
	    }
	
	    class TitleElement : AbstractElement{
		    public TitleElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
		    public override int parse(String source, int start, int[] retVal, int breakType){
			    //int start2 = start;
			    int i = 0;
			    for(i = start; i < source.Length; i++){
				    int type = HTMLElementTable.getElementTypeFromSource(source, i, retVal);
				    if(breakType == type){
					    String title = source.Substring(start, retVal[0]-8-start);
					    mParser.mTitle = title.Trim();
					    return retVal[0];
				    }
			    }
			    return i;
		    }
	    }
	
	    class InputElement : AbstractElement{
		    public InputElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
		    public override int parse(String source, int start, int[] retVal, int breakType){
			
			    List<KeyValuePair<string,string>> list = mParser.parseAttributes( source,  start, retVal);
			
			    String type = "", name = "", value = "";
			
			    for(int i = 0; i < list.Count; i++){
				    KeyValuePair<string,string> pair = list[i];
                    if (pair.Key.Equals("type") || pair.Key.Equals("TYPE"))
                    {
					    type = pair.Value;
                    }
                    else if (pair.Key.Equals("name") || pair.Key.Equals("NAME"))
                    {
					    name = pair.Value;
                    }
                    else if (pair.Key.Equals("value") || pair.Key.Equals("VALUE"))
                    {
					    value = pair.Value;
				    }
			    }
			
				if(type.Equals("submit") || type.Equals("SUBMIT")){
                    //if (0 <= value.Length)
                   // {
                        //if (name.Length == 0)
                        //    name = type;
                  mParser.mInputTypeSubmit.Add(new KeyValuePair<string, string>(name, value));
				  //  }
                }
                else// if (0 < name.Length && 0 <= value.Length)
                {
                    if (0 < type.Length)
                    {
                        if (type.Equals("hidden") || type.Equals("HIDDEN"))
                        {
                            mParser.mInputTypeHidden.Add(new KeyValuePair<string, string>(name, value));
                        }
                        else if (type.Equals("text") || type.Equals("TEXT"))
                        {
                            mParser.mInputTypeText.Add(new KeyValuePair<string, string>(name, value));
                        }
                        else if (type.Equals("password") || type.Equals("PASSWORD"))
                        {
                            mParser.mInputTypePasswd.Add(new KeyValuePair<string, string>(name, value));
                        }
                        else if (type.Equals("checkbox") || type.Equals("CHECKBOX"))
                        {
                            mParser.mInputTypeCheckBox.Add(new KeyValuePair<string, string>(name, value));
                        }
                    }
                    else
                    {
                        mParser.mInputTypeText.Add(new KeyValuePair<string, string>(name, value));
                    }                   
			    }
			    return retVal[0];
		    }
	    }
		
	    class ALinkElement : AbstractElement{
		    public ALinkElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
		    public override int parse(String source, int start, int[] retVal, int breakType){

                List<KeyValuePair<string, string>> list = mParser.parseAttributes(source, start, retVal);
			
			    String url = "";//, name = "", value = "";
			
			    for(int i = 0; i < list.Count; i++){
				    KeyValuePair<string,string> pair = list[i];
				    if(pair.Key.Equals("href")){
					    url = pair.Value;
					    break;
				    }else if(pair.Key.Equals("HREF")){
					    url = pair.Value;
					    break;
				    }
			    }
			    int textStart = mParser.mOutput.Length;
                Hyperlink hl = new Hyperlink();
                //hl.NavigateUri = new Uri(url);
                mParser.DrawElementPush(hl);
			    int end = base.parse(source, retVal[0], retVal, breakType);
                mParser.DrawElementPop();
                int textEnd = mParser.mOutput.Length;
			
			    if(0 < url.Length){
				    if(0 <= url.IndexOf("http") || 0 <= url.IndexOf("HTTP")){

					    /*URLSpan urls = new URLSpan(url);
			    
					    mSpannableObjectStack.add(
						    new SpannableObject(urls, textStart, textEnd, 0));*/
				    }
			    }
			    return end;
		    }
	    }
	    class FontElement : AbstractElement{
		    public FontElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
		    public override int parse(String source, int start, int[] retVal, int breakType){

                List<KeyValuePair<string, string>> list = mParser.parseAttributes(source, start, retVal);
			
			    int nSize = 0;
                Color color;

                Span span = new Span();
                for(int i = 0; i < list.Count; i++){
				    KeyValuePair<string,string> pair = list[i];
				    if(pair.Key.Equals("size")){
					    try
                        {
                           nSize = int.Parse(pair.Value, NumberStyles.Integer);
                        }
                        catch 
                        {
                        }
                    }else if(pair.Key.Equals("color")){
					    try
                        {
                            color = parseColor(pair.Value, 0);
                            span.Foreground = new SolidColorBrush(color);
                        }
                        catch (Exception e)
                        {
                            NTDebug.l(e.Message);
                        }
				    }
			    }
                if (nSize >= 0)
                {
                    double fSize = span.FontSize;
                    fSize += fSize / 2 * nSize;
                    span.FontSize = fSize;
                }
                else if (nSize <= 0)
                {
                    double fSize = span.FontSize;
                    fSize += 2 * (double)nSize;
                    span.FontSize = fSize;
                }



			    //int textStart = mParser.mOutput.Length;
                mParser.DrawElementPush(span);
			    int end = base.parse(source, retVal[0], retVal, breakType);
                mParser.DrawElementPop();
			    //int textEnd =  mParser.mOutput.Length;
			
			   /* if(0 < color.Length){
				    try{
					    Color c = parseColor(color, 0);
					    //if(0 < nColor){
						   ForegroundColorSpan span = new ForegroundColorSpan(nColor);
				    
						    mSpannableObjectStack.add(
							    new SpannableObject(span, textStart, textEnd, 0));//Spannable.SPAN_EXCLUSIVE_EXCLUSIVE));
					    //}
				    }catch(Exception e){
                        NTDebug.l(e.Message);
                    }
			    }*/
			    /*if(0 < size.Length){
				    try{
					    int nSize;
					    if('+' == size[0]){
						    size = size.Substring(1);
						    nSize = int.Parse(size, NumberStyles.Integer);
					    }else if('-' == size.charAt(0)){
						    size = size.substring(1);
                            nSize = Integer.parseInt(size, NumberStyles.Integer);
						    nSize *= -1;
					    }else{
                            nSize = Integer.parseInt(size, NumberStyles.Integer);
					    }
                        nSize = int.Parse(size, NumberStyles.Integer);
					    float fSize = (float)nSize;
					    fSize /= 5;
					    fSize += 1;
					    //RelativeSizeSpan span = new RelativeSizeSpan(fSize);
				        //mSpannableObjectStack.add(
						//	    new SpannableObject(span, textStart, textEnd, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE));
					
				    }catch(Exception e){
                        NTDebug.l(e.Message);
                    }
			    }*/
			    return end;
		    }
	    }
	    class FormElement : AbstractElement{
		    public FormElement(NTHtmlParser parser) : base(parser)
            {
			
		    }
		
		    public override int parse(String source, int start, int[] retVal, int breakType){
			
			    mParser.mFormAttributes = mParser.parseAttributes( source,  start, retVal);
			    int n = source.IndexOf('>', start);
			    if(0 > n){
				    return source.Length;
			    }
			    return base.parse(source, n+1, retVal, breakType);
		    }
	
	    }

        class TextAreaElement : AbstractElement
        {
            public TextAreaElement(NTHtmlParser parser)
                : base(parser)
            {

            }

            public override int parse(String source, int start, int[] retVal, int breakType)
            {

                mParser.mTextAreaAttributes = mParser.parseAttributes(source, start, retVal);
                int n = source.IndexOf('>', start);
                if (0 > n)
                {
                    return source.Length;
                }
                return base.parse(source, n + 1, retVal, breakType);
            }

        }

        
        protected List<KeyValuePair<string, string>> parseAttributes(String source, int start, int[] retVal)
        {

            List<KeyValuePair<string, string>> list = new List<KeyValuePair<string, string>>();
		    bool dFlag = false;//processing text within double quarts 
		    bool nameFlag = true; //processing the name word
		    String wrkStr = "";
		    String name = "";//, value = "";
		
		    for(int i = start; i < source.Length; i++){
			    char c = source[i];
			    switch(c){
			    case '>':
				    if(!dFlag){
					    if(name.Length > 0 && wrkStr.Length > 0){
						    list.Add(new KeyValuePair<string,string>(name, wrkStr));
					    }
					    retVal[0] = i+1;
					    return list;
				    }
				    wrkStr += c;
				    break;
			    case ' ':
				    if(dFlag){
					    wrkStr += c;
				    }else{
					    if(name.Length > 0 && wrkStr.Length > 0){
						    list.Add(new KeyValuePair<string,string>(name, wrkStr));
					    }
					    name = wrkStr = "";
					    nameFlag = true;
				    }
				    break;
			    case '=':
				    if(dFlag){
					    wrkStr += c;
				    }else if(nameFlag){
					    name = wrkStr;
					    wrkStr = "";
					    nameFlag = false;
				    }
				    break;
                case '"':
                case '\'':
                    if (dFlag)
                    {
					    if(0 < wrkStr.Length){
						    char c1 = wrkStr[wrkStr.Length-1];
						    if('\\' == c1){
							    wrkStr += c;
							    break;
						    }
					    }
					    dFlag = false;
					    if(!nameFlag){
						    if(name.Length > 0 && wrkStr.Length > 0){
							    list.Add(new KeyValuePair<string,string>(name, wrkStr));
						    }
						    name = wrkStr = "";
						    nameFlag = true;
					    }
				    }else{
					    dFlag = true;
				    }
				    break;
			    default:
				    wrkStr += c;
				    break;
			    }
		    }
		    retVal[0] = source.Length;
		    return list;		
	    }
	
    }

    //--------------------------------------------------------------------------------------

    class HTMLElementTree{
	    public char mC;
	    public int mType;
        public List<HTMLElementTree> mTree = new List<HTMLElementTree>();
	    public HTMLElementTree(char c){mC = c; mType = HTMLElementTable.ELEMENT_TOKEN_NONE;}
    }

    class HTMLElementTable{

	    public const  int ELEMENT_TOKEN_NULL = -2;
	    public const  int ELEMENT_TOKEN_NONE = -1;
	    public const  int ELEMENT_TOKEN_HTML_S = 0;
	    public const  int ELEMENT_TOKEN_HTML_E = 1;
	    public const  int ELEMENT_TOKEN_COMMENT_S = 2;
	    public const  int ELEMENT_TOKEN_COMMENT_E = 3;
	    public const  int ELEMENT_TOKEN_TITLE_S = 4;
	    public const  int ELEMENT_TOKEN_TITLE_E = 5;
	    public const  int ELEMENT_TOKEN_BODY_S = 6;
	    public const  int ELEMENT_TOKEN_BODY_E = 7;
	    public const  int ELEMENT_TOKEN_ALINK_S = 8;
	    public const  int ELEMENT_TOKEN_ALINK_E = 9;
	    public const  int ELEMENT_TOKEN_BOLD_S = 10;
	    public const  int ELEMENT_TOKEN_BOLD_E = 11;
	    public const  int ELEMENT_TOKEN_INPUT = 12;
	    public const  int ELEMENT_TOKEN_BREAK = 13;
	    public const  int ELEMENT_TOKEN_CENTER_S = 14;
	    public const  int ELEMENT_TOKEN_CENTER_E = 15;
	    public const  int ELEMENT_TOKEN_FONT_S = 16;
	    public const  int ELEMENT_TOKEN_FONT_E = 17;
	    public const  int ELEMENT_TOKEN_HR = 18;
	    public const  int ELEMENT_TOKEN_PARAGRAPH = 19;
	    public const  int ELEMENT_TOKEN_UL_S = 20;
	    public const  int ELEMENT_TOKEN_UL_E = 21;
	    public const  int ELEMENT_TOKEN_LI = 22;
        public const int ELEMENT_TOKEN_FORM_S = 23;
        public const int ELEMENT_TOKEN_FORM_E = 24;
        public const int ELEMENT_TOKEN_TEXTAREA_S = 25;
        public const int ELEMENT_TOKEN_TEXTAREA_E = 26;



        static HTMLElementTree mTopTree = null;
	    private String mElement;
	    private int mType;
	
	    HTMLElementTable (string element, int type){
		    mElement = element;
		    mType = type;
	    }
	
	    //static int counter = 0;
	
	    public static int getElementTypeFromSource(String source, int index, int [] returnLength){
		    return findTree(mTopTree, source, index, returnLength);
	    }
	
	    static int findTree(HTMLElementTree parent, String source, int index, int [] returnLength){
		
		    if(source.Length == index){
			    return ELEMENT_TOKEN_NONE;
		    }
		
		    char c = source[index];
		
		    for(int i = 0; i < parent.mTree.Count; i++){
			    HTMLElementTree current = parent.mTree[i];
			    if(current.mC == c){
				    index++;
				    if(current.mType != ELEMENT_TOKEN_NONE){			
					    returnLength[0] = index;
					    return current.mType;
				    }
				    return findTree(current, source, index, returnLength);
			    }
		    }
		    return HTMLElementTable.ELEMENT_TOKEN_NONE;// No match code available
	    }
	
	
	    public static void init(){
		    //Making element parse tree
		    mTopTree = new HTMLElementTree((char)0x00);
		    NTDebug.l("HTMLElement.length: " + htmlElement.Length);
		    for( int i = 0; i < htmlElement.Length; i++){
			    parseTree(mTopTree, htmlElement[i].mElement, 0, htmlElement[i].mType);
		    }
	    }
	
	
	    static void parseTree(HTMLElementTree tree, String source, int index, int type){
		    try{
			    List<HTMLElementTree> parentTree = tree.mTree;
			    HTMLElementTree newTree;
			    char c = source[index];
			    int i;
			    for(i = 0; i < parentTree.Count; i++){
				    if(parentTree[i].mC == c){
					    break;
				    }
			    }
			    if(i == parentTree.Count){
				    newTree = new HTMLElementTree(c);
				    parentTree.Add(newTree);
					//    NTDebug.l("HTMLEscape.parseTree(): err occured. #1");
					//    return;
				    //}
			    }else{
				    newTree = parentTree[i];
			    }
			    index++;
			    if(source.Length == index){
				    newTree.mType = type;
				    //DebugUtil.log("Element setup:" + source + ":" + type + ":" + ++counter);
			    }else{
				    parseTree(newTree, source, index, type);
			    }
		    }catch(Exception e){
                NTDebug.l(e.Message);
		    }
	    }
	
	    static HTMLElementTable [] htmlElement = {
		    new HTMLElementTable("<html", ELEMENT_TOKEN_HTML_S),
		    new HTMLElementTable("<HTML", ELEMENT_TOKEN_HTML_S),
		    new HTMLElementTable("<!--", ELEMENT_TOKEN_COMMENT_S),
		    new HTMLElementTable("-->", ELEMENT_TOKEN_COMMENT_E),
		    new HTMLElementTable("<TITLE>", ELEMENT_TOKEN_TITLE_S),
		    new HTMLElementTable("<title>", ELEMENT_TOKEN_TITLE_S),
		    new HTMLElementTable("<BODY", ELEMENT_TOKEN_BODY_S),
		    new HTMLElementTable("<body", ELEMENT_TOKEN_BODY_S),
		    new HTMLElementTable("<A ", ELEMENT_TOKEN_ALINK_S),
		    new HTMLElementTable("<a ", ELEMENT_TOKEN_ALINK_S),
		    new HTMLElementTable("<input ", ELEMENT_TOKEN_INPUT),
		    new HTMLElementTable("<INPUT ", ELEMENT_TOKEN_INPUT),
		    new HTMLElementTable("</html>", ELEMENT_TOKEN_HTML_E),
		    new HTMLElementTable("</HTML>", ELEMENT_TOKEN_HTML_E),
		    new HTMLElementTable("</TITLE>", ELEMENT_TOKEN_TITLE_E),
		    new HTMLElementTable("</title>", ELEMENT_TOKEN_TITLE_E),
		    new HTMLElementTable("</BODY>", ELEMENT_TOKEN_BODY_E),
		    new HTMLElementTable("</body>", ELEMENT_TOKEN_BODY_E),
		    new HTMLElementTable("</A>", ELEMENT_TOKEN_ALINK_E),
		    new HTMLElementTable("</a>", ELEMENT_TOKEN_ALINK_E),
		    new HTMLElementTable("<br>", ELEMENT_TOKEN_BREAK),
		    new HTMLElementTable("<BR>", ELEMENT_TOKEN_BREAK),
		    new HTMLElementTable("<CENTER>", ELEMENT_TOKEN_CENTER_S),
		    new HTMLElementTable("<center>", ELEMENT_TOKEN_CENTER_S),
		    new HTMLElementTable("</CENTER>", ELEMENT_TOKEN_CENTER_E),
		    new HTMLElementTable("</center>", ELEMENT_TOKEN_CENTER_E),
		    new HTMLElementTable("<FONT", ELEMENT_TOKEN_FONT_S),
		    new HTMLElementTable("<font", ELEMENT_TOKEN_FONT_S),
		    new HTMLElementTable("</font>", ELEMENT_TOKEN_FONT_E),
		    new HTMLElementTable("</FONT>", ELEMENT_TOKEN_FONT_E),
		    new HTMLElementTable("<B>", ELEMENT_TOKEN_BOLD_S),
		    new HTMLElementTable("<b>", ELEMENT_TOKEN_BOLD_S),
		    new HTMLElementTable("</B>", ELEMENT_TOKEN_BOLD_E),
		    new HTMLElementTable("</b>", ELEMENT_TOKEN_BOLD_E),
		    new HTMLElementTable("<HR>", ELEMENT_TOKEN_HR),
		    new HTMLElementTable("<hr>", ELEMENT_TOKEN_HR),
		    new HTMLElementTable("<p>", ELEMENT_TOKEN_PARAGRAPH),
		    new HTMLElementTable("<P>", ELEMENT_TOKEN_PARAGRAPH),
		    new HTMLElementTable("<LI>", ELEMENT_TOKEN_LI),
		    new HTMLElementTable("<li>", ELEMENT_TOKEN_LI),
		    new HTMLElementTable("<ul>", ELEMENT_TOKEN_UL_S),
		    new HTMLElementTable("<UL>", ELEMENT_TOKEN_UL_S),
		    new HTMLElementTable("</ul>", ELEMENT_TOKEN_UL_E),
		    new HTMLElementTable("</UL>", ELEMENT_TOKEN_UL_E),
		    new HTMLElementTable("<FORM", ELEMENT_TOKEN_FORM_S),
		    new HTMLElementTable("<form", ELEMENT_TOKEN_FORM_S),
		    new HTMLElementTable("</FORM>", ELEMENT_TOKEN_FORM_E),
		    new HTMLElementTable("</form>", ELEMENT_TOKEN_FORM_E),
		    new HTMLElementTable("<TEXTAREA", ELEMENT_TOKEN_TEXTAREA_S),
		    new HTMLElementTable("<textarea", ELEMENT_TOKEN_TEXTAREA_S),
		    new HTMLElementTable("</TEXTAREA>", ELEMENT_TOKEN_TEXTAREA_E),
		    new HTMLElementTable("</textarea>", ELEMENT_TOKEN_TEXTAREA_E),
		    //new HTMLElementTable("\n", ELEMENTTYPE_BLANK)
	    };
    }// end of class HTMLElement

}
