﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using NT2chView.NtFile;

namespace NT2chView
{
    class NTMovieHistory
    {
        private static bool mDirty = false;
 
        private static ObservableCollection<NTMovie> 
            mList = new ObservableCollection<NTMovie>();
        public static ObservableCollection<NTMovie> GetList()
        {
            return mList;
        }

        public static NTMovie GetMovie(string id)
        {
            foreach (NTMovie movie in mList)
            {
                if (id.Equals(movie.ID))
                    return movie;
            }
            return null;
        }

        public static void AddMovie(NTMovie movie)
        {
            if (movie == null)
                return;
            NTMovie exist = GetMovie(movie.ID);
            if (exist != null)
                mList.Remove(exist);

            mList.Insert(0, movie);
            mDirty = true;
        }

        public static void RemoveMovie(NTMovie movie)
        {
            if (movie == null)
                return;
            NTMovie exist = GetMovie(movie.ID);
            if (exist != null)
                mList.Remove(exist);
        }

        public static void Load()
        {
            mList.Clear();

            mDirty = false;
            string [] lines = NTFileAccess.retrieveMovieHistory();
            if (lines == null)
                return;
            foreach (string line in lines)
            {
                NTMovie movie = NTMovie.CreateFromDescription(line);
                if (movie == null)
                    continue;
                mList.Add(movie);
            }


        }
        public static void Save()
        {
            mDirty = true;
            List<string> list = new List<string>();
            foreach (NTMovie movie in mList)
            {
                string line = movie.GetDescription();
                if (line == null)
                    continue;
                list.Add(line);
            }
            NTFileAccess.storeMovieHistory(list.ToArray());

        }

    }
    class NTMovie
    {
        private static bool mDirty = false;
        private string mId;
        private string mCaption;
        private DateTime mDateTime;

        public static bool GetDirty()
        {
            return mDirty;
        }
        public static void ClearDirty()
        {
            mDirty = false;
        }

        public string ID
        {
            get { return mId; }
            set
            {
                mDirty = true;
                mId = value;
            }
        }
        public string Caption
        {
            get { return mCaption; }
            set
            {
                mDirty = true;
                mCaption = value;
            }
        }
        public DateTime LastAccessDate
        {
            get { return mDateTime; }
            set
            {
                mDirty = true;
                mDateTime = value;
            }
        }

        public NTMovie(string id)
        {
            ID = id;
        }

        public string GetDescription()
        {
            string caption = mCaption.Replace(",", "&#44;");
            StringBuilder sb = new StringBuilder();
            sb.Append(mId).Append(',')
                .Append(caption).Append(',')
                .Append(mDateTime.ToString());
            return sb.ToString();
        }

        public static NTMovie CreateFromDescription(string description)
        {
            if (description == null)
                return null;

            string [] values = description.Split(NTTextUtiles.COMMA_VALUE);
            if (values == null || values.Length != 3)
                return null;

            string id = values[0];
            if (id.Length != 11)
                return null;

            DateTime dt;
            if (!DateTime.TryParse(values[2], out dt))
                return null;
            string caption = values[1].Replace("&#44;", ",");

            NTMovie movie = new NTMovie(id);
            movie.mCaption = values[1];
            movie.mDateTime = dt;
            return movie;
        }


    }
}
