﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace NT2chView
{
    /// <summary>
    /// NTHistoryPanel.xaml の相互作用ロジック
    /// </summary>
    public partial class NTHistoryPanel : UserControl
    {
        static readonly string[] LIST_COLUMN_HEADERS_PNAME = { "Title", "DateTimeDescription" };

        public MainWindow.DelegateMsgOpenThreadRequest OpenThreadRequest { get; set; }
        public MainWindow.DelegateMsgGetHistoryOnCloud GetHistoryOnCloud { get; set; }

        NTHistory mHistory = null;
        public NTHistory History
        {
            set 
            {
                if (mHistory != null)
                    mHistory.onDetach();

                mHistory = value;
                parse();
            }
        }

        public NTHistoryPanel()
        {
            InitializeComponent();
        }


        private void parse()
        {
            if (mHistory == null)
                return;

            GridView gv = lstHistory.View as GridView;
            int cnt = gv.Columns.Count;
            cnt = (cnt < LIST_COLUMN_HEADERS_PNAME.Length) ? cnt : LIST_COLUMN_HEADERS_PNAME.Length;

            for(int i = 0; i < cnt; i++)
            {
                GridViewColumn gvc = gv.Columns[i]; 
                PropertyPath pp = new PropertyPath(LIST_COLUMN_HEADERS_PNAME[i]);
                Binding b = new Binding();
                b.Path = pp;
                gvc.DisplayMemberBinding = b;

            }

            lstHistory.ItemsSource = mHistory.getThreadList();

        }

        private void lstHistory_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            ListView lv = sender as ListView;
            if (lv == null)
                return;

            NTHistoryThread ht = lv.SelectedItem as NTHistoryThread;
            if (ht == null)
                return;

            //NTDebug.l(ht.Title);
            NTBoard board = NTDataRoot.getBoardByName(ht.BoardName);
            if(board == null)
                return;
            NTThreadTitle tt = board.findThreadTitleByDatName(ht.getDatName());
            if (tt != null)
            {
                if (OpenThreadRequest != null)
                    OpenThreadRequest(tt);
            }
        }

        private void cmbHistoryType_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (1 != e.AddedItems.Count)
                return;
            ComboBoxItem cbi1 = e.AddedItems[0] as ComboBoxItem;
            if (cbi1 == null)
                return;

            //string addStr = e.AddedItems[0] as string;

            if (1 != e.RemovedItems.Count)
                return;

            ComboBoxItem cbi2 = e.RemovedItems[0] as ComboBoxItem;
            if (cbi2 == null)
                return;

            int type;
            string text = cbi1.Content as string;
            if (text == null)
                return;

            switch (text)
            {

                case "読み込み履歴（クラウド）":
                    type = 1;
                    break;
                case "書込履歴（クラウド）":
                    type = 2;
                    break;
                case "しおりの履歴（クラウド）":
                    type = 3;
                    break;
                default:
                    return;
            }
            //NTDebug.l(cbi1.ToString() + ":" + cbi2.ToString());
            if(GetHistoryOnCloud != null)
                GetHistoryOnCloud(type);
        }
    }
}
