﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO;
using NT2chView.NtNet;
using NT2chView.NtFile;
using NT2chView.NtHtml;
using System.Threading;
using System.Windows.Threading;
using System.ComponentModel;
using NT2chCtrl;
using NT2chHistory;
using NT2chObject;
using NT2chView.NtUI;

namespace NT2chView
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {

        Dictionary<string, NTBoard> mDicBoardUpdateRequest = 
            new Dictionary<string, NTBoard>();
        //int mProgressDelta;
        //int mProgressValue;

        NTFavorite mFavoriteData;

        NTBoard.DelegateMsgOnNotifyBoardUpdate mOnNotifyBoardUpdate;
        NTBoard.DelegateMsgOnNotifyBoardUpdate mOnNotifyBoardUpdateB;

        public NTFavorite getFavoriteData()
        {
            return mFavoriteData;
        }

        public MainWindow()
        {
            InitializeComponent();

            mOnNotifyBoardUpdate = new NTBoard.DelegateMsgOnNotifyBoardUpdate(onNotifyBoardUpdateA);
            mOnNotifyBoardUpdateB = new NTBoard.DelegateMsgOnNotifyBoardUpdate(onNotifyBoardUpdateB);


            if (!init())
            {
                Close();
                return;
            }

            Width = NTUserPreference.WindowWidth;
            Height = NTUserPreference.WindowHeight;
            this.Top = NTUserPreference.WindowTop;
            this.Left = NTUserPreference.WindowLeft;

            if (NTUserPreference.WindowMaximized)
            {
                this.WindowStyle = System.Windows.WindowStyle.None;
                this.WindowState = System.Windows.WindowState.Maximized;
                this.btnMaximizeWindow.Visibility = System.Windows.Visibility.Collapsed;
            }
            else
            {
                this.WindowState = System.Windows.WindowState.Normal;
                this.btnRestoreWindow.Visibility = System.Windows.Visibility.Collapsed;
            }

            mMainColumn1.Width = new GridLength(NTUserPreference.WindowColumn1);
            mMainRow1.Height = new GridLength(NTUserPreference.WindowRow1);
            mLeftPanelRow1.Height = new GridLength(NTUserPreference.WindowLeftPanelRow1);

            this.ResizeMode = System.Windows.ResizeMode.CanResizeWithGrip;

            if (NTUserPreference.ResViewToolbarPosition ==
                NTDragDrop.TOOLBAR_LOCATION_LEFT)
            {
                mTooltrayResView.SetValue(DockPanel.DockProperty, Dock.Left);
            }
            if (NTUserPreference.ThreadTitleViewToolbarPosition ==
                NTDragDrop.TOOLBAR_LOCATION_LEFT)
            {
                mTooltrayThreadTitleView.SetValue(DockPanel.DockProperty, Dock.Left);
            }

            hideAllToolbarDropCanvas();


        }

        bool init()
        {

            // Assign the file of root path to store and retrive.
            string path = System.Reflection.Assembly.GetExecutingAssembly().Location;
            int n = path.LastIndexOf(@"\");
            if (0 > n)
                return false;

            path = path.Substring(0, n);

            if (!NTFileAccess.init(path))
                return false;

            NTExportUtil.init(path);

            NTAppState.init(this);

            NTHtmlUtils.init();

            NTHtmlParser.init();

            NTUserPreference.init();

            NTMaru.init();

            NTResMenuCommand.init();

            progressCtrlCloud.IsIndeterminate = NTUserPreference.NTCloudIsEnabled;

            NTExportUtil util = new NTExportUtil();
            util.MsgOpenThreadTitleListRequest += MsgOpenThreadtitleListRequest;
            mSubjectPanel.OnInitApplicationInterface(util, util);
            mResPanel.OnInitApplicationInterface(util, util);

            mGraphicsPanel.Init();

            mMoviePanel.Init();

            return true;
        }

        
        private void MainWindow_Loaded(object sender, RoutedEventArgs e)
        {

            mCategoryPanel.OpenBoardListRequest =
                new DelegateMsgOpenBoardListRequest(MsgOpenBoardListRequest);
            mCategoryPanel.OpenFavoriteListRequest =
                new DelegateMsgOpenFavoriteListRequest(MsgOpenFavoriteListRequest);
            mBoardPanel.OpenThreadTitleListRequest =
                new DelegateMsgOpenThreadTitleListRequest(MsgOpenThreadtitleListRequest);
            mFavoritePanel.OpenThreadTitleListRequest =
                new DelegateMsgOpenThreadTitleListRequest2(MsgOpenThreadtitleListRequest2);
            mHistoryPanel.OpenThreadRequest =
                new DelegateMsgOpenThreadRequest(MsgOpenThreadRequest);
            mHistoryPanel.GetHistoryOnCloud =
                new DelegateMsgGetHistoryOnCloud(MsgGetHistoryOnCloud);


            btnSaveNgEdit.IsEnabled = false;

            btnStopAutoScroll.Visibility = System.Windows.Visibility.Collapsed;

#if DOTNET45
            if (NTUserPreference.ResViewTextSelMode)
                btnTextTool.Visibility = System.Windows.Visibility.Collapsed;
            else
                btnTouchMode.Visibility = System.Windows.Visibility.Collapsed;
#endif

            mResPanel.initResLayout(NTUserPreference.DebugOption);

            initData();

        }

       
        private void MainWindow_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            mFavoritePanel.OnClosing();
            mResPanel.SaveCurrentState();
            //tabCtrlDat_AppClosing();

            //storeOpenedThreadList();
            
            storeOpenedBoardList();

            List<IThreadDescription> threadHistoryList = mResPanel.QueryThreadReadHistory();

            if(threadHistoryList != null)
            {
                NTOpenedThreadTable.saveThreadHistoryList(threadHistoryList);
            }


            NTUserPreference.WindowWidth =  this.Width;
            NTUserPreference.WindowHeight = this.Height;
            NTUserPreference.WindowTop = this.Top;
            NTUserPreference.WindowLeft = this.Left;

            NTUserPreference.WindowColumn1 = mMainColumn1.Width.Value;
            NTUserPreference.WindowRow1 = mMainRow1.Height.Value;
            NTUserPreference.WindowLeftPanelRow1 = mLeftPanelRow1.Height.Value;



            NTUserPreference.savePreferences();


        }


        private void initData()
        {
            BackgroundWorker bkWorkerInitBoardMenu =
                new BackgroundWorker();

            bkWorkerInitBoardMenu.DoWork += 
                new DoWorkEventHandler(InitBoardMenu_OnDoWork);
            bkWorkerInitBoardMenu.RunWorkerCompleted += 
                new RunWorkerCompletedEventHandler(InitBoardMenu_OnRunWorkerCompleted); 

            bkWorkerInitBoardMenu.RunWorkerAsync();
        }

        private void completeData()
        {
            if (!NTUserPreference.NTCloudIsEnabled)
            {
                initThreadHistoryList();
            }


            MainWindowProgressBar.Width = 0;
            MainWindowProgressBar.Height = 0;
            MainWindowLblStatusBar.Content = " Ready ";

            NTMaru.loginAsync();
        }

        private void InitBoardMenu(bool? result)
        {
            if(result == null || result == false)
                NTDebug.l("ボードメニューの取得に失敗");

            string html = NTFileAccess.retrieveBoardMenuDataFromFile();
            if (null == html)
            {
                MessageBox.Show("ボードファイルが見つかりません。");
                return;
            }

            List<NTCategory> cList = NTCategory.parseBoardMenu(html);

            NTDataRoot.mCategoryList = cList;

            mCategoryPanel.CategoryTable = cList;
            //constructCategoryTreeView();
            Thread thread = new Thread(getFavorites);
            thread.Start();
            thread = new Thread(getNgItems);
            thread.Start();

            MsgGetHistoryOnCloud(1);

            //MainWindowProgressBar.Value = e.ProgressPercentage;
            int progressValue = 10;
            MainWindowProgressBar.Value = progressValue;

            string[] boardlist = NTPersistentFileAccess.retrieveOpenedBoards();

            int progressDelta;

            if (boardlist != null && boardlist.Length > 0)
            {

                progressDelta = 40 / boardlist.Length;

                List<IBoard> iboardList = new List<IBoard>();
                foreach (string s in boardlist)
                {
                    NTBoard board = NTDataRoot.getBoardByName(s);
                    if (board != null)
                    {
                        //mSubjectPanel.OpenBoard(board);
                        iboardList.Add(board);
                        //constructBoardTabItem(board);
                    }
                    progressValue += progressDelta;
                    MainWindowProgressBar.Value = progressValue;
                }
                mSubjectPanel.InitBoardList(iboardList);
                if (iboardList.Count > 0)
                {
                    //mSubjectPanel.OpenBoard(iboardList[iboardList.Count-1]);
                    ((NTBoard)(iboardList[iboardList.Count - 1])).Update(mOnNotifyBoardUpdate);
                }

                /*int num = tabCtrlSubject.Items.Count;
                if (0 < num)
                {
                    int idx = tabCtrlSubject.SelectedIndex;
                    if (idx < 0)
                        idx = num - 1;

                    TabItem item = tabCtrlSubject.Items[idx] as TabItem;
                    if (item != null)
                    {
                        NTBoard board = item.Tag as NTBoard;
                        if (board != null)
                        {
                            tabCtrlSubject.SelectedIndex = idx;
                            board.Update(mOnNotifyBoardUpdate);
                        }
                    }
                }*/
            }

            /*string[] threadList = NTPersistentFileAccess.retrieveOpenedThreads();
            if (threadList != null && threadList.Length > 0)
            {
              foreach (string s in threadList)
              {
                    //Thread.Sleep(100);
                    string[] words = s.Split(NTTextUtiles.COMMA_VALUE);
                    if (words.Length != 2)
                        continue;
                    string boardName = words[1];

                    if (mDicBoardUpdateRequest.ContainsKey(boardName))
                        continue;

                    NTBoard board = NTDataRoot.getBoardByName(boardName);
                    if (board == null)
                        continue;

                    mDicBoardUpdateRequest.Add(boardName, board);
              }
            }*/

            /*foreach(NTBoard board in mDicBoardUpdateRequest.Values)
            {
                board.Update(new NTBoard.DelegateMsgOnNotifyBoardUpdate(onNotifyBoardUpdateForFavoriteThread));
            }

            if (mDicBoardUpdateRequest.Count > 0)
            {
                //mProgressValue = 50;
                //mProgressDelta = 50 / mDicBoardUpdateRequest.Count;
            }
            else*/
            completeData();
        }

        private void onNotifyBoardUpdateA(NTBoard board)
        {
            mSubjectPanel.OpenBoard((IBoard)board);
        }
        private void onNotifyBoardUpdateB(NTBoard board)
        {
            mDicBoardUpdateRequest.Remove(board.mName);
            mResPanel.OnNotifyThreadUpdated((IBoard)board);
        }
#if false
        private void onNotifyBoardUpdateForFavoriteThread(NTBoard board)
        {
            

            /*string[] threadList = NTPersistentFileAccess.retrieveOpenedThreads();
            if (threadList != null && threadList.Length > 0)
            {
                foreach (string s in threadList)
                {
                    string[] words = s.Split(NTTextUtiles.COMMA_VALUE);
                    if (words.Length != 2)
                        continue;
                    string boardName = words[1];
                    if (!boardName.Equals(board.mName))
                        continue;
                    string datName = words[0];

                    NTThreadTitle tt = board.findThreadTitleByDatName(datName);
                    //if (tt != null)
                    //    constructResViewTabItem(tt);
                    mProgressValue += mProgressDelta;
                    MainWindowProgressBar.Value = mProgressValue;
                }
            }
            mDicBoardUpdateRequest.Remove(board.mName);
            if (mDicBoardUpdateRequest.Count == 0)
            {
                completeData();
            }*/
        }
#endif

#if false 
        private void backgroundWorker_DoWork(object sender, System.ComponentModel.DoWorkEventArgs e)
        {

            if (!NTHttpAccess.getBoardMenu())
            {
                NTDebug.l("ボードメニューの取得に失敗");
            }
            
            string html = NTFileAccess.retrieveBoardMenuDataFromFile();
            if (null == html)
            {
                this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                (ThreadStart)delegate()
                {
                    MessageBox.Show("ボードファイルが見つかりません。");
                    
                });
                return;
            }

            List<NTCategory> cList = NTCategory.parseBoardMenu(html);

            NTDataRoot.mCategoryList = cList;

           // string[] externalBoards = NTFileAccess.retrieveExternalBoards();
           // if (null != externalBoards && externalBoards.Length > 0)
           //     NTCategory.parseExternalBoardMenu(externalBoards);

            this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                (ThreadStart)delegate()
            {
                mCategoryPanel.CategoryTable = cList;
                constructCategoryTreeView();
                Thread thread = new Thread(getFavorites);
                thread.Start();
                thread = new Thread(getNgItems);
                thread.Start();
           });
           
           int progressValue = 10;

            mBackgroundWorker.ReportProgress(progressValue);

            Thread.Sleep(500);

            
            string[] boardlist = NTPersistentFileAccess.retrieveOpenedBoards();

            int progressOffset;

            if (boardlist != null && boardlist.Length > 0)
            {
                       
                progressOffset = 40 / boardlist.Length;

                foreach (string s in boardlist)
                {
                    NTBoard board = NTDataRoot.getBoardByName(s);
                    if (board != null)
                    {
                        this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                                                    (ThreadStart)delegate()
                        {
                            constructBoardTabItem(board /*, false*/);
                            //TabItem item = null;
                           // constructBoardTabItemContent(board, item);
                        });
                       // Thread.Sleep(1000);
                    }
                    progressValue += progressOffset;
                    mBackgroundWorker.ReportProgress(progressValue);
                }

                this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                                                    (ThreadStart)delegate()
                {

                    int num = tabCtrlSubject.Items.Count;
                    if (0 < num)
                    {
                        TabItem item = tabCtrlSubject.Items[num - 1] as TabItem;
                        if (item != null)
                        {
                            NTBoard board = item.Tag as NTBoard;
                            if (board != null)
                            {
                                tabCtrlSubject.SelectedIndex = num - 1;
                                constructBoardTabItemContent(board, item);
                            }
                        }
                    }
                });

                        
           }

            /*this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
            (ThreadStart)delegate()
            {
                Thread.Sleep(100);
            });*/

            //Thread.Sleep(2000);

            progressValue = 50;

            string[] threadList = NTPersistentFileAccess.retrieveOpenedThreads();
            if (threadList != null && threadList.Length > 0)
            {
                progressOffset = 50 / threadList.Length;
                 //this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                 //                               (ThreadStart)delegate()
                 //                           {
                
                    foreach (string s in threadList)
                    {
                        //Thread.Sleep(100);
                        string[] words = s.Split(NTTextUtiles.COMMA_VALUE);
                        if (words.Length != 2)
                            continue;

                        NTBoard board = NTDataRoot.getBoardByName(words[1]);
                        if (board == null)
                            continue;

                        string strSubject= null;
                        if (!board.mDataInit)
                        {
                            NTHttpAccess.getSubject(board.mAddress, board.mName);
                            strSubject = NTFileAccess.retrieveSubjectDataFromFile(board.mName);
                        }
                        
                        //if(strSubject == null)
                        //    continue;

                        //bool bRet = false;
                         
                        this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                                                (ThreadStart)delegate()
                        {
                            if (strSubject != null)
                            {
                                if (!board.parseSubjectData(strSubject))
                                    return;
                            }
                            

                            NTThreadTitle tt = board.findThreadTitleByDatName(words[0]);
                            if (tt != null)
                                constructResViewTabItem(tt/*, false*/);
                        });
                       
                        progressValue += progressOffset;
                        mBackgroundWorker.ReportProgress(progressValue);
                        //Thread.Sleep(1000);


                    }
                this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                                         (ThreadStart)delegate()
                {
                    int num = tabCtrlDat.Items.Count;
                    if (num > 0)
                    {
                        TabItem tabItem = tabCtrlDat.Items[num - 1] as TabItem;
                        if (tabItem != null)
                        {
                            
                            tabCtrlDat.SelectedIndex = num - 1;
                            constructResContent(tabItem);
                           // tabCtrlDat.Items.CurrentChanging += Items_CurrentChanging;
                           // tabCtrlDat.SelectionChanged += tabCtrlDat_SelectionChanged;
                        }
                    }
                });

           }
           mBackgroundWorker.ReportProgress(100);
        }

        //void Items_CurrentChanging(object sender, CurrentChangingEventArgs e)
       // {
        //    NTDebug.l(sender.ToString());
            //throw new NotImplementedException();
       // }
  
        
        

        private void backgroundWorker_ProgressChanged(object sender, System.ComponentModel.ProgressChangedEventArgs e)
        {
            MainWindowProgressBar.Value = e.ProgressPercentage;
        }

        private void backgroundWorker_RunWorkerCompleted(object sender, System.ComponentModel.RunWorkerCompletedEventArgs e)
        {
            MainWindowProgressBar.Width = 0;
            MainWindowProgressBar.Height = 0;
            MainWindowLblStatusBar.Content = " Ready ";

            NTMaru.loginAsync();
            
        }
#endif
        private void initThreadHistoryList()
        {
            List<IThreadDescription> threadHistoryList = NTOpenedThreadTable.retrieveThreadHistoryList();
            if (threadHistoryList == null)
                threadHistoryList = new List<IThreadDescription>();
            foreach (IThreadDescription threadDecl in threadHistoryList)
            {
                NTBoard board = threadDecl.getBoard() as NTBoard;
                if (board == null)
                    continue;

                 if (threadDecl.getTitle() == null)
                {
                    if (!NTUserPreference.NTCloudIsEnabled)
                    {

                        string strSubject = null;
                        if (!board.mDataInit)
                        {
                            if (!NTFileAccess.isSubjectExsists(board.mName))
                                if (!NTHttpAccess.getSubject(board.mAddress, board.mName))
                                    continue;

                            strSubject = NTFileAccess.retrieveSubjectDataFromFile(board.mName);
                            if (strSubject == null)
                                continue;

                            if (!board.parseSubjectData(strSubject, mFavoriteData))
                                continue;
                        }
                        NTThreadTitle tt = board.findThreadTitleByDatName(threadDecl.getDatName());
                        string title = null;
                        if (tt != null && (null != (title = tt.getTitle())))
                        {
                            NTThreadCashData data = threadDecl as NTThreadCashData;
                            if (data != null)
                                data.setTitle(title);
                        }
                    }
                    else
                    {
                        if (!mDicBoardUpdateRequest.ContainsKey(board.mName))
                        {
                            mDicBoardUpdateRequest.Add(board.mName, board);
                        }
                    }
                }
            }
            if (NTUserPreference.NTCloudIsEnabled)
            {
                foreach (NTBoard board in mDicBoardUpdateRequest.Values)
                {
                   board.Update(mOnNotifyBoardUpdateB);
                }
            }
            mResPanel.SetThreadReadHistory(threadHistoryList);
       }

        

        private void getFavorites()
        {

            //bool initHistory = false;
            string boardList;// = string.Empty;
            string [] threadLists;// = string.Empty;
            if (NTUserPreference.NTCloudIsEnabled)
            {
                NTHttpAccess.getFavoriteBoards();
                NTHttpAccess.getFavoriteThreads();
                NTHttpAccess.getExternalBoards();
                //initHistory =
                NTHttpAccess.getThreadHistoryList();
            }

            boardList = NTFileAccess.retrieveFavoriteBoardFromFile();
            threadLists = NTFileAccess.retrieveFavoriteThreadFromFile();

            string[] externalBoards = NTFileAccess.retrieveExternalBoards();


            this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                (ThreadStart)delegate()
                {
                    if (boardList.Length > 0 || threadLists[0].Length > 0 || null != externalBoards)
                    {
                        NTFavorite favorite = new NTFavorite();
                        if (boardList.Length > 0)
                            favorite.parseBoardList(boardList);
                        //if (threadLists[0].Length > 0)
                        favorite.parseThreadList(threadLists);
                        mFavoritePanel.FavoriteData = favorite;
                        mFavoriteData = favorite;

                        //constructFavoriteList(boardList, threadList);

                        if (null != externalBoards && externalBoards.Length > 0)
                        {
                            NTCategory.parseExternalBoardMenu(externalBoards);
                            NTCategory exCate = NTDataRoot.getExternalBoards();
                            if (exCate != null)
                                mCategoryPanel.addExternalCategory(exCate);
                            //constructExternalBoardToCategoryTree();
                            //NTBoard board = NTDataRoot.getExternalBoards
                            //appendBoardToExternalCategoryTree(NTBoard board);
                        }
                    }
                    else
                    {
                        NTFavorite favorite = new NTFavorite();
                        favorite.parseThreadList(threadLists);
                        mFavoritePanel.FavoriteData = favorite;
                        mFavoriteData = favorite;


                    }

                    //if (initHistory)
                    if (NTUserPreference.NTCloudIsEnabled)
                    {
                        initThreadHistoryList();
                    }
                });
        }

        private void getReadHistoryOnCloud()
        {
            if (NTUserPreference.NTCloudIsEnabled)
            {
                string uid, pass, result;
                if (NTUserPreference.NTUserCloudIsEnabled)
                {
                    uid = NTUserPreference.NTCloudID;
                    pass = NTUserPreference.NTUserCloudGetHashedPasswd();
                    result = NTHttpAccess.UserCloudQueryReadHistory(uid, pass);
                }
                else
                {
                    uid = NTUserPreference.NTCloudID;
                    pass = NTUserPreference.NTCloudPSS;
                    result = NTHttpAccess.ntQueryReadHistory(uid, pass);
                }
                if (result != null)
                {
                    this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                        (ThreadStart)delegate()
                        {
                            NTDebug.l(result);
                            NTHistory history = new NTHistory();
                            if (history.parse(result))
                            {
                                mHistoryPanel.History = history;
                            }
                        });
                }
            }
        }

        private void getWriteHistoryOnCloud()
        {
            if (NTUserPreference.NTCloudIsEnabled)
            {
                string uid, pass, result;
                if (NTUserPreference.NTUserCloudIsEnabled)
                {
                    uid = NTUserPreference.NTCloudID;
                    pass = NTUserPreference.NTUserCloudGetHashedPasswd();
                    result = NTHttpAccess.UserCloudQueryWriteHistory(uid, pass);
                }
                else
                {
                    uid = NTUserPreference.NTCloudID;
                    pass = NTUserPreference.NTCloudPSS;
                    result = NTHttpAccess.ntQueryWriteHistory(uid, pass);
                }
                if (result != null)
                {
                    this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                        (ThreadStart)delegate()
                        {
                            NTDebug.l(result);
                            NTHistory history = new NTHistory();
                            if (history.parse(result))
                            {
                                mHistoryPanel.History = history;
                            }
                        });
                }
            }
        }

        private void getBookmarkHistoryOnCloud()
        {
            if (NTUserPreference.NTCloudIsEnabled)
            {
                string uid, pass, result;
                if (NTUserPreference.NTUserCloudIsEnabled)
                {
                    uid = NTUserPreference.NTCloudID;
                    pass = NTUserPreference.NTUserCloudGetHashedPasswd();
                    result = NTHttpAccess.UserCloudQueryBookmarkHistory(uid, pass);
                }
                else
                {
                    uid = NTUserPreference.NTCloudID;
                    pass = NTUserPreference.NTCloudPSS;
                    result = NTHttpAccess.ntQueryBookmarkHistory(uid, pass);
                }
                if (result != null)
                {
                    this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                        (ThreadStart)delegate()
                        {
                            NTDebug.l(result);
                            NTHistory history = new NTHistory();
                            if (history.parse(result))
                            {
                                mHistoryPanel.History = history;
                            }
                        });
                }
            }
        }

        private void getNgItems()
        {

           // string boardList = string.Empty;
            //string threadList = string.Empty;
            if (NTUserPreference.NTCloudIsEnabled)
            {
                if (NTUserPreference.NTUserCloudIsEnabled)
                {
                    NTHttpAccess.UserCloudGetNgId();
                    NTHttpAccess.UserCloudGetNgName();
                    NTHttpAccess.UserCloudGetNgWord();
                }
                else
                {
                    NTHttpAccess.ntGetNgId();
                    NTHttpAccess.ntGetNgName();
                    NTHttpAccess.ntGetNgWord();
                }
            }

            NTNgItems ngItem = NTNgItems.getContext();
            string source = NTFileAccess.retrieveNgWordFromFile();
            if (source != null && source.Length > 0)
            {
                string[] lines = NTTextUtiles.splitLine(source);
                for (int i = 0; i < lines.Length; i++)
                {
                    string line;
                    if(NTUserPreference.AESEnabled)
                        line = NTTextUtiles.aesDecodeBase64URL(lines[i]);
                    else
                        line = NTTextUtiles.decodeBase64URL(lines[i]);
                    lines[i] = line;
                }
                ngItem.WriteNgWord(lines);
            }

            source = NTFileAccess.retrieveNgIdFromFile();
            if (source != null && source.Length > 0)
            {
                string [] lines = NTTextUtiles.splitLine(source);
                for (int i = 0; i < lines.Length; i++)
                {
                    string line;
                    if (NTUserPreference.AESEnabled)
                        line = NTTextUtiles.aesDecodeBase64URL(lines[i]);
                    else
                        line = NTTextUtiles.decodeBase64URL(lines[i]);
                    lines[i] = line;
                }
                ngItem.WriteNgId(lines);
            }

            source = NTFileAccess.retrieveNgNameFromFile();
            if (source != null && source.Length > 0)
            {
                string [] lines = NTTextUtiles.splitLine(source);
                for (int i = 0; i < lines.Length; i++)
                {
                    string line;
                    if (NTUserPreference.AESEnabled)
                        line = NTTextUtiles.aesDecodeBase64URL(lines[i]);
                    else
                        line = NTTextUtiles.decodeBase64URL(lines[i]);
                    lines[i] = line;
                }
                ngItem.WriteNgName(lines);
            }

        }

        private void MainWindow_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.F11)
            {
                if (this.WindowState == System.Windows.WindowState.Maximized)
                    RestoreMainWindow();
                else
                    MaximizeMainWindow();

            }
        }

        private void RestoreMainWindow()
        {
            NTUserPreference.WindowMaximized = false;
            this.WindowStyle = System.Windows.WindowStyle.ThreeDBorderWindow;
            this.WindowState = System.Windows.WindowState.Normal;
            this.btnMaximizeWindow.Visibility = System.Windows.Visibility.Visible;
            this.btnRestoreWindow.Visibility = System.Windows.Visibility.Collapsed;
        }
        private void MaximizeMainWindow()
        {
            NTUserPreference.WindowMaximized = true;
            this.WindowStyle = System.Windows.WindowStyle.None;
            this.WindowState = System.Windows.WindowState.Maximized;
            this.btnMaximizeWindow.Visibility = System.Windows.Visibility.Collapsed;
            this.btnRestoreWindow.Visibility = System.Windows.Visibility.Visible;
        }
    }
}
