﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;


namespace NT2chObject
{
    /*
     * アプリケーションフレームワークとの通信に使用します。
     * コントロール初期化時に設定されます。
     */
    public interface ICommand
    {
        //アプリケーションでサポートしているAPIのバージョンを取得します。
        int GetApplicationApiVersion();
        //このコントロールの永続的なデータを保存する為のフォルダーのパスを取得します。
        string GetDataPath();

        //アプリケーションの設定画面でユーザーが指定した値を取得します。
        //取得した値はプロセスの生存期間中有効で有り、ユーザーが設定画面で
        //編集すると、この値も反映されます。
        //この動作が適さない場合、取得したデータをコピーして下さい。
        //※NTConstants.csのPREF_PARAMも参照して下さい
        Dictionary<PREF_PARAM, object> GetPreference();

        //スレッドディスクリプターを指定して、フレームワークに
        //スレッドを開くように要求します
        void OpenThread(IThreadDescription threaDesc);

        //スレッドディスクリプターを指定して、フレームワークに
        //スレッドをお気に入りに追加するように要求します
        bool AddThreadToFavorite(IThreadDescription threaDesc);
        //スレッドディスクリプターを指定して、フレームワークに        
        //レスにブックマークをつけるように要求します
        bool AddBookmark(IThread ithread, IRes ires);
        //レスにブックマークをつけるように要求します
        bool DeleteBookmark(IThread ithread, IRes ires);
        //スレッドを指定して、書き込み用のダイアログを開きます。
        //メッセージの初期値を指定できます。
        //指定する値がない場合、nullを指定できます。
        bool WriteMessage(IThread ithread, string message);

        bool CreateThread(IBoard iboard, string title, string message);
        void ShowThreadInfoWindow(string title, string address);

        //板オブジェクトを指定して、板を開きます。
        void TryToOpenBoard(IBoard board);

        //URLを指定して、外部プログラムを実行します。
        void ExecURL(string url);

        //NGワード編集ダイアログを開きます。
        //iresを指定すると、そのレスからNGに指定する各項目の文字列を
        //抽出して初期設定します。
        void ShowNgwordDialog(IRes ires);

        //設定されているNGワード文字列のリストを取得します
        //返される値はプレーンな複数行テキストで、現時点で
        //オリジナル実装では行毎に一つのNGワードとして判定することを想定しています。
        //将来的な拡張の為に推奨する書式は以下になります
        //　[板名!dat番号]ngワード
        //　例：[ニュース速報!1311837176]あああ
        //先頭に角カッコがあるNGワードを指定する場合、先頭に空の角カッコを付加します[]
        //上記は、板ごと、スレッド毎のNGワードを指定する為の書式です。
        //板毎のNGワードを指定するときはdat番号を省略します。
        string[] GetNgWordList();

        //設定されているNG-ID文字列のリストを取得します
        string[] GetNgIdList();

        //設定されているNG-NAME文字列のリストを取得します
        string[] GetNgNameList();

        void SetThumbnailImage(ThumbnailImageHelper helper, string url);

    }

    public interface ICommand2 :  ICommand
    {
        //スレッドディスクリプターを指定して、フレームワークに
        //スレッドをお気に入りに追加するように要求します
        void AddBoardToFavorite(IBoard iboard);
       
        //スレッドディスクリプターを指定して、フレームワークに
        //スレッドをお気に入りから削除するように要求します
        bool RemoveThreadFromFavorite(IThreadDescription threaDesc);

        //指定したスレッドの取得済ログを消去します
        //クラウド同期が有効な場合、クラウドの同期情報も削除されます。
        void DeleteLog(IThread ithread);

        //指定した板に含まれるスレッドの全ての取得済ログを消去します
        //クラウド同期が有効な場合、クラウドの同期情報も削除されます。
        void DeleteLog(IBoard iboard);

        //板オブジェクトを指定して、板を更新します。
        void UpdateBoard(IBoard board);

        //指定したスレッドと類似したタイトルを持つ
        //スレッドを検索します。表示方法はフレームワークが
        //決定するので、呼び出し側ではコールバックを受け取りません
        void SearchSimilarTitle(IThread2 ithread);
    }  
    /*
     * 汎用的に使えるように用意したユーティリティメソッドです。
     * コントロール初期化時にアプリケーションフレームワークから
     * 設定されます。
     */
    public interface IUtil
    {
        //2チャンネルのレス参照フォーマットを判定し、
        //有効フォーマットと判定された文字数を返します。
        //例：>>1-10    ＞12,14,21 など。一つ目は6を返します。二つ目は9を返します。
        //文字列が有効なフォーマットで始まっていない場合、-1を返します。
        //source 判定する文字列 
        //startPosition 判定を開始する位置を指定します。
        int ParseResLinkReference(string source, int startPosition);

        //上記のフォーマットから、参照しているレス番号の整数値の配列を取得します。
        int[] ParseResLinkReferenceNumber(string source);

        //startIndexから始まる文字列sourceが有効なURLで有るかを判定します。
        //戻り値 -1. 有効なURLでは無い 0以上.URLとして認識した最後の文字の次のインデックスを返します。
        int ParseURLString(string source, int startIndex);

        //曖昧検索オブジェクトを取得します。
        //word 検索の元になる文字列。
        //指定されたwordを使って、字句検索オブジェクトが生成されます。
        IAmbiguousSearch　CreateAmbiguousSearchInstance(string word);
        //ユーザーの設定ファイルから
        //レス画面用のコンテキストメニューを生成します。
        void CreateResViewContextMenu(FlowDocumentScrollViewer sv);

    }

    /*
     * ボードメニューから読み込んで生成された板オブジェクトを表します。
     */
    public interface IBoard : IBase
    {
        //板の名前を取得します。
        string getName();
        //板のアドレスを取得します
        string getAddress();
        //この板のスレッド一覧を取得します。
        //※スレッドが読み込まれていない場合があります。
        //その場合、NULLが返ります。
        List<IThread> getThreadList();
    }


    /*
     * Subjectファイルから読み込んで生成されたスレッドオブジェクトを表します  
     */
    public interface IThread : IBase
    {
        //このスレッドのタイトルを取得します。
        string getTitle();
        //このスレッドが配置されている板オブジェクトを取得します。
        IBoard getBoard();
        //このスレッドのDATファイル名を取得します。
        string getDatName();
        //このスレッドのメッセージが格納された配列
        List<IRes> getResList();
        //更新される前に読み込んでいたスレッドのレス数。
        int getPrevReadCount();
    }

    public interface IThread2 : IThread
    {
        NTThread getDependencyObject();
    }
    /*
     * IRes datファイルから読み込んで生成されたメッセージオブジェクトを表します
     */
    public interface IRes : IBase
    {
        //スレッド内のシーケンス番号(１を基点とする)
        int getSequenceNo();
        //名前欄に指定された文字列
        string getName();
        //メール欄に指定された文字列
        string getMail();
        //メッセージ本文
        string getMsg();
        //その他の文字列
        string getMisc();
        //書き込まれた日時を示す文字列
        string getDate();
        //　IDを示す文字列
        string getID();
        //当該レスオブジェクトに設定されている属性を取得します。
        //RES_ATTRUBUTE列挙子の値を参照して下さい。
        bool getAttribute(RES_ATTRIBUTE attr);
        //同じスレッド内でこのレスを参照している番号のリスト
        int[] getReferenceArray();

    }

    public interface IBase
    {
        //オブジェクトに設定した追加情報を取得します。
        object getExtra();
        //オブジェクトのインスタンスに追加情報を設定します。
        void setExtra(object o);
    }

    public interface ISubjectView
    {
        bool OpenBoard(IBoard iboard);
        bool InitBoardList(List<IBoard> boardList);
        void OnInitApplicationInterface(ICommand2 command, IUtil util);
        IBoard GetCurrentBoard();
        //このコントロールで管理している表示状態の板リストを取得する為に呼ばれます。
        List<IBoard> QueryOpenedBoardList();
    }
    public interface ISubjectViewJump
    {
        //フレームワークから呼ばれます。先頭のレスにジャンプしてください。
        void JumpToTop();
        //フレームワークから呼ばれます。最後のレスにジャンプしてください。
        void JumpToBottom();
    }

    /*
     * レスデータをGUI画面上に表示する為にアプリケーションフレームワークから
     * 呼び出す、メソッドを定義しています。
     * このインターフェースを実装したコントロールを作成して
     * ２ぃとちゃんの実行ファイル（NT2ｃｈView.exe）と同じフォルダーに配置します。
     * 
     */
    public interface IResView
    {

        //フレームワークで、スレッドが開かれた時に呼ばれます。
        //渡された情報を使って、スレッドを表示して下さい。
        bool OpenThread(IThread ithread);
        //コントロール初期化時に、これまでに閲覧したスレッドの履歴リストが渡されます。
        //呼び出し側では履歴リストを管理していません。
        //アプリケーション終了時にQueryThreadReadHistoryが呼び出されて、
        //コントロールが管理している履歴リストが取得されます。
        bool SetThreadReadHistory(List<IThreadDescription> threadDescriptionList);
        //
        void OnNotifyThreadUpdated(IBoard iboard);

        //このコントロールで管理しているスレッドの履歴リストを取得する為に呼ばれます。
        List<IThreadDescription> QueryThreadReadHistory();
        //ユーティリティ関数のポインターが設定されます。
        //渡されたポインターをコピーしておきます。
        //（NTResViewPanel_util.csファイルで実装されています。）
        void OnInitApplicationInterface(ICommand command, IUtil util);
        //現在アクティブなスレッドを確認する為に呼ばれます。
        //OpenThreadで渡された識別子を返して下さい。
        IThread getCurrentThread();
        //オブジェクトがアンロードされる前に呼ばれます。
        //ここで、オブジェクトの永続データーを保存して下さい。
        void SaveCurrentState();
        //レス画面でのフォントサイズ設定ツールの表示/非表示を切り替えます
        void ToggleFontSetupTool();
    }

    //フレームワークからのジャンプコマンドをサポートする
    //コントロールはこのインターフェースをサポートして下さい。
    public interface IResViewJump
    {
        //フレームワークから呼ばれます。先頭のレスにジャンプしてください。
        void JumpToTop();
        //フレームワークから呼ばれます。最後のレスにジャンプしてください。
        void JumpToBottom();
        //フレームワークから呼ばれます。新着のレスにジャンプしてください。
        void JumpToNew();
        //フレームワークから呼ばれます。ブックマークの付いたレスに順番に
        //ジャンプしてください。
        void JumpToNextBookmark();
    }
    //アプリケーションのコマンドからユーザーが検索操作を行ったときに
    //コントロールで検索を実行する場合に、このインターフェースをコントロールに
    //実装します
    public interface IResViewSearch
    {
        //指定された検索文字列を選択状態にして下さい。
        void SetSearchWord(string searchWord);
        //指定された検索文字列の後方にマッチする文字列を選択して下さい。
        void SearchNext();
        //指定された検索文字列の前方にマッチする文字列を選択して下さい。
        void SearchPrev();
    }

    /*
     * スレッドを特定する為の情報が記述されます。
     * クラウドで同期した既読スレッドのリストを受け取ったり、
     * スレッドをお気に入りに追加したり、ドラッグドロップの
     * オブジェクトとして利用する事を想定しています。
     * 【注意】このインターフェースを実装したオブジェクトの
     * インスタンスは、必ずしも、実際に読み込んだメモリー上の
     * スレッドに対応している訳では有りません。つまり、
     * このインターフェースのメソッドで、必ず有効な値が
     * 取得できることは（正常系であっても）保証されないと言うことです。
     * 
     * スレッドオブジェクトの実態ではなく、単なる注文書のようなもので
     * あると考えて下さい。
     * コントロールの呼び出し側では、このオブジェクトの特定の実装には依存しない為、
     * ユーザーコントロールがこのインターフェースを実装したインスタンスを作成して
     * APIに渡すことが出来ます。
     * 
     */
    public interface IThreadDescription
    {
        //スレッドのタイトルを取得します。
        //【注意】クラウド同期されたデータなどを取得した時に
        //空の値を返す場合が有ります。
        string getTitle();
        //ダットファイルの名前を取得します。
        //この値とIBoardオブジェクトを使って、アプリケーションフレームワークに
        //スレッドを取得させることが出来ます。
        string getDatName();
        //このスレッドが設定されている板オブジェクトを取得します。
        IBoard getBoard();
    }

    /**
     * 曖昧検索インターフェース
     * IUtil.GetIAmbiguousSearchを参照して下さい。
     */
    public interface IAmbiguousSearch
    {
        //source 検索される文字列
        //startIndex sourceの検索開始基点インデックス
        //out firstIndex　検索が成功したときに、
        //見つかった単語のsource内の位置インデックスが返ります。
        // out length 検索が成功したときにfirstIndexからの文字数が返ります
        bool match(string source, int startIndex, out int firstIndex, out int length);
    }
 }
