﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using NT2chCtrl;
using NT2chCtrl.html.css;
using NT2chObject;

namespace NT2chCtrl.html.wpf
{
    class Html2FlowDoc
    {
        static Dictionary<string, FontFamily> mFontList = new Dictionary<string, FontFamily>();

        static FontFamily getFontFamily(string familyName)
        {
            FontFamily font;
            if (mFontList.TryGetValue(familyName, out font))
                return font;

            font = new FontFamily(familyName);
            mFontList.Add(familyName, font);
            return font;
        }

        public static bool DrawHtml(ResListAdapter adapter, Section rootSection,
            IThread thread, IRes res, HtmlElement bodyElem)
        {
            return drawHtmlForBlocks(adapter, rootSection.Blocks,thread , res,  bodyElem);
        }


        public static void applyCSSProperiesForElement(HtmlElement hElem, TextElement tElem)
        {
            Brush brush;
            //BitmapImage bImg;
            Color c;
            double d;
            int nVal;
            string sVal;
            Property.FontStyle fontStyle;
            if (hElem.tryGetColor(out c))
            {
                tElem.Foreground = new SolidColorBrush(c);
            }
            if (hElem.tryGetBackgroundColor(out c))
            {
                tElem.Background = new SolidColorBrush(c);
            }
            if (hElem.tryGetBackgroundImage(out brush))
            {
               // iBrush = new ImageBrush(bImg);
                //iBrush.Stretch = Stretch.UniformToFill;
               // iBrush.TileMode = TileMode.Tile;
                tElem.Background = brush;
            }

            if (hElem.tryGetFontFamily(out sVal))
            {
                FontFamily font = getFontFamily(sVal);
                tElem.FontFamily = font;
            }
            if (hElem.tryGetLength("font-size", out d, null))
            {
                if (d != double.NaN)
                    tElem.FontSize = d;
            }
            if (hElem.tryGetFontWeight(out nVal))
            {
                tElem.FontWeight = parseFontWeight(nVal);
            }
            if (hElem.tryGetFontStyle(out fontStyle))
            {
                switch (fontStyle)
                {
                    case Property.FontStyle.Normal:
                        tElem.FontStyle = FontStyles.Normal;
                        break;
                    case Property.FontStyle.Italic:
                        tElem.FontStyle = FontStyles.Italic;
                        break;
                    case Property.FontStyle.Oblique:
                        tElem.FontStyle = FontStyles.Oblique;
                        break;
                }
            }
        }
        public static void applyCSSProperiesForElement(HtmlElement hElem, TextBlock tElem)
        {
            Brush brush;
            //BitmapImage bImg;
            Color c;
            double d;
            int nVal;
            string sVal;
            if (hElem.tryGetColor(out c))
            {
                tElem.Foreground = new SolidColorBrush(c);
            }
            if (hElem.tryGetBackgroundColor(out c))
            {
                tElem.Background = new SolidColorBrush(c);
            }
            if (hElem.tryGetBackgroundImage(out brush))
            {

                //iBrush = new ImageBrush(bImg);
                //iBrush.Stretch = Stretch.UniformToFill;
                //iBrush.TileMode = TileMode.Tile;
                //iBrush.Viewport
                tElem.Background = brush;

            }
            if (hElem.tryGetPropertyValue("font-family", out sVal))
            {
                FontFamily font = getFontFamily(sVal);
                tElem.FontFamily = font;
            }
            if (hElem.tryGetLength("font-size", out d, null))
            {
                if(d != double.NaN)
                    tElem.FontSize = d;
            }
            if (hElem.tryGetFontWeight(out nVal))
            {
                tElem.FontWeight = parseFontWeight(nVal);
            }
            if (hElem.tryGetLength("height", out d, null))
            {
                if (d != double.NaN)
                    tElem.Height = d;
            }
            if (hElem.tryGetLength("min-height", out d, null))
            {
                if (d != double.NaN)
                    tElem.MinHeight = d;
            }
            if (hElem.tryGetLength("max-height", out d, null))
            {
                if (d != double.NaN)
                    tElem.MaxHeight = d;
            }
            if (hElem.tryGetLength("width", out d, null))
            {
                if (d != double.NaN)
                    tElem.Width = d;
            }
            if (hElem.tryGetLength("min-width", out d, null))
            {
                if (d != double.NaN)
                    tElem.MinWidth = d;
            }
            if (hElem.tryGetLength("max-width", out d, null))
            {
                if (d != double.NaN)
                    tElem.MaxWidth = d;
            }
        }

        private static FontWeight parseFontWeight(int value)
        {
            if (value <= 100)
                return FontWeights.Thin;
            else if (value <= 200)
                return FontWeights.ExtraLight;
            else if (value <= 300)
                return FontWeights.Light;
            else if (value <= 400)
                return FontWeights.Normal;
            else if (value <= 500)
                return FontWeights.Medium;
            else if (value <= 600)
                return FontWeights.SemiBold;
            else if (value <= 700)
                return FontWeights.Bold;
            else if (value <= 800)
                return FontWeights.ExtraBold;
            else if (value <= 900)
                return FontWeights.Black;
            else
                return FontWeights.ExtraBlack;
        }

        
 

        private static bool drawHtmlForBlocks(ResListAdapter adapter, 
            BlockCollection blocks, IThread thread, IRes res, HtmlElement parent)
        {
            StringBuilder sb = new StringBuilder();
            string[] sArr;
            StringElement sElem;
            Paragraph paraBase = null;
            Paragraph para;
            Span span;
            Section sec;
            Hyperlink hLink;
            Run run;
            string attrName;
            css.Property.Visibility visibility;
            List<HtmlElement> children = parent.getChildren();
            int count = children.Count;
            foreach (HtmlElement elem in children)
            {
                bool bHandled = false;
                para = null;
                string attrVal = elem.getAttributeValue("id");
                switch (attrVal)
                {
                    /*case "msg":
                        if(paraBase == null)
                            paraBase = new Paragraph();
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        adapter.parseResMsg(paraBase.Inlines, thread, res, -1, -1, true);
                        bHandled = true;
                        break;*/
                    case "sequence":
                        if(paraBase == null)
                            paraBase = new Paragraph();
                        adapter.parseSequenceNo(paraBase.Inlines, thread, res);
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        bHandled = true;
                        break;
                    /*case "identifier":
                        if(paraBase == null)
                            paraBase = new Paragraph();
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        adapter.parseIdentifier(paraBase.Inlines, thread, res);
                        bHandled = true;
                        break;*/
                    /*case "backwardreferences":
                        if(paraBase == null)
                            paraBase = new Paragraph();
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        adapter.parseBackwardReferences(paraBase.Inlines, thread, res);
                        bHandled = true;
                        break;*/
                }
                if (bHandled)
                {
                    blocks.Add(paraBase);
                    continue;
                }
                attrName = elem.getAttributeValue("res-link");
                if (attrName != null)
                {
                    if (paraBase == null)
                    {
                        paraBase = new Paragraph();
                        blocks.Add(paraBase);
                    }
                    if (sb.Length > 0)
                    {
                        setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                        sb.Clear();
                    }
                    if (elem.tryGetVisibility(out visibility))
                    {
                        if (visibility == css.Property.Visibility.Collapse ||
                            visibility == css.Property.Visibility.Hidden)
                        {
                            continue;
                        }
                    }
                    hLink = new Hyperlink();
                    //span = new Span();
                    Html2FlowDoc.applyCSSProperiesForElement(elem, hLink);
                    paraBase.Inlines.Add(hLink);
                    drawHtmlForInlines(adapter, hLink.Inlines, thread, res, elem);
                    sArr = elem.getStringContent();
                    if (sArr != null && sArr.Length > 0)
                    {
                        string s = sArr[0].Replace("<<", ">>");
                        List<object> param = new List<object>(2);
                        param.Add(thread);
                        param.Add(s);
                        hLink.Tag = param;
                        hLink.Click += adapter.resLinkSubItem_MouseEnter2;
                    }
                    continue;
                }
                attrName = elem.getAttributeValue("id-link");
                if (attrName != null)
                {
                    if (paraBase == null)
                    {
                        paraBase = new Paragraph();
                        blocks.Add(paraBase);
                    }
                    if (sb.Length > 0)
                    {
                        setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                        sb.Clear();
                    }
                    if (elem.tryGetVisibility(out visibility))
                    {
                        if (visibility == css.Property.Visibility.Collapse ||
                            visibility == css.Property.Visibility.Hidden)
                        {
                            continue;
                        }
                    }
                    List<int> numArr = collectResId(thread, attrName);
                    if (numArr != null && numArr.Count > 1)
                    {
                        hLink = new Hyperlink();
                        Html2FlowDoc.applyCSSProperiesForElement(elem, hLink);
                        paraBase.Inlines.Add(hLink);
                        drawHtmlForInlines(adapter, hLink.Inlines, thread, res, elem);
                        List<object> param = new List<object>(2);
                        param.Add(thread);
                        param.Add(numArr.ToArray());
                        hLink.Tag = param;
                        if(adapter.getEnablePopupMouseHover())
                            hLink.MouseEnter += adapter.resLink_MouseEnter;
                        else
                            hLink.Click += adapter.resLink_MouseEnter;
                    }
                    else
                    {
                        span = new Span();
                        Html2FlowDoc.applyCSSProperiesForElement(elem, span);
                        paraBase.Inlines.Add(span);
                        drawHtmlForInlines(adapter, span.Inlines, thread, res, elem);
                    }
                    continue;
                }
                string tagName = elem.getTagName();
                switch (tagName)
                {
                    case "":
                        sElem = elem as StringElement;
                        if (sElem != null)
                        {
                            sb.Append(sElem.getString());
                        }
                        break;
                    case "hr":
                        if (paraBase == null)
                        {
                            paraBase = new Paragraph();
                            paraBase.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                            blocks.Add(paraBase);
                        }
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        paraBase.Inlines.Add(new LineBreak());
                        paraBase.Inlines.Add(new LineBreak());
                        System.Windows.Shapes.Rectangle rectangle = new Rectangle();
                        rectangle.HorizontalAlignment = System.Windows.HorizontalAlignment.Center;
                        rectangle.Width = 800;
                        rectangle.Height = 4;
                        rectangle.StrokeThickness = 1;
                        rectangle.Stroke = new SolidColorBrush(Colors.White);
                        rectangle.Fill = new SolidColorBrush(Colors.Black);
                        InlineUIContainer ui = new InlineUIContainer(rectangle);
                        rectangle.Margin = new System.Windows.Thickness(20, 0, 20, 0);


                        paraBase.Inlines.Add(ui);
                        paraBase.Inlines.Add(new LineBreak());
                        paraBase.Inlines.Add(new LineBreak());
                        break;
                    case "br":
                        if (paraBase == null)
                        {
                            paraBase = new Paragraph();
                            paraBase.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                            blocks.Add(paraBase);
                        }
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        paraBase.Inlines.Add(new LineBreak());
                        break;
                    case "p":
                        if (sb.Length > 0)
                        {
                            string s = convertHtmlString(sb.ToString());
                            if (s.Length > 0)
                            {
                                if (paraBase == null && !" ".Equals(s))
                                {
                                    paraBase = new Paragraph();
                                    paraBase.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                                    blocks.Add(paraBase);
                                }
                                if (paraBase != null)
                                {
                                    run = new Run(convertHtmlString(sb.ToString()));
                                    paraBase.Inlines.Add(run);
                                }
                            }
                            sb.Clear();
                        }
                        paraBase = null;
                        if (elem.tryGetVisibility(out visibility))
                        {
                            if (visibility == css.Property.Visibility.Collapse ||
                                visibility == css.Property.Visibility.Hidden)
                            {
                                break;
                            }
                        }
                        para = new Paragraph();
                        //para.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                        //blocks.Add(para);
                        //sec = new Section();
                        Html2FlowDoc.applyCSSProperiesForElement(elem, para);
                        drawHtmlForInlines(adapter, para.Inlines, thread, res, elem);
                        blocks.Add(para);
                        break;
                    case "div":
                        if (sb.Length > 0)
                        {
                            string s = convertHtmlString(sb.ToString());
                            if (s.Length > 0)
                            {
                                if (paraBase == null && !" ".Equals(s))
                                {
                                    paraBase = new Paragraph();
                                    paraBase.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                                    blocks.Add(paraBase);
                                }
                                if (paraBase != null)
                                {
                                    run = new Run(convertHtmlString(sb.ToString()));
                                    paraBase.Inlines.Add(run);
                                }
                            }
                            sb.Clear();
                        }
                        paraBase = null;
                        if (elem.tryGetVisibility(out visibility))
                        {
                            if (visibility == css.Property.Visibility.Collapse ||
                                visibility == css.Property.Visibility.Hidden)
                            {
                                break;
                            }
                        }
                        //Paragraph para = new Paragraph();
                       // para.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                        //blocks.Add(para);
                        sec = new Section();
                        Html2FlowDoc.applyCSSProperiesForElement(elem, sec);
                        drawHtmlForBlocks(adapter, sec.Blocks, thread, res, elem);
                        blocks.Add(sec);
                        break;
                    case "span":
                        if (paraBase == null)
                        {
                            paraBase = new Paragraph();
                            paraBase.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                            blocks.Add(paraBase);
                        }
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        if (elem.tryGetVisibility(out visibility))
                        {
                            if (visibility == css.Property.Visibility.Collapse ||
                                visibility == css.Property.Visibility.Hidden)
                            {
                                break;
                            }
                        }
                        span = new Span();
                        Html2FlowDoc.applyCSSProperiesForElement(elem, span);
                        paraBase.Inlines.Add(span);
                        drawHtmlForInlines(adapter, span.Inlines, thread, res, elem);
                        break;
                    case "a":
                        if (paraBase == null)
                        {
                            paraBase = new Paragraph();
                            paraBase.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                            blocks.Add(paraBase);
                        }
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        if (elem.tryGetVisibility(out visibility))
                        {
                            if (visibility == css.Property.Visibility.Collapse ||
                                visibility == css.Property.Visibility.Hidden)
                            {
                                break;
                            }
                        }
                        string url = elem.getAttributeValue("href");
                        hLink = new Hyperlink();
                        if (url != null)
                        {
                            /*if (adapter.chkGraphicLink(url))
                            {
                                ThumbnailImageHelper helper =
                                    ThumbnailImageHelper.CreateInstance(url);
                                paraBase.Inlines.Add(helper.GetContainer());
                                adapter.setThumbnailImage(helper, url);
                            }*/
                            hLink.NavigateUri = new Uri(url);
                            hLink.Click += adapter.urlLink_Click;
                        }
                        Html2FlowDoc.applyCSSProperiesForElement(elem, hLink);
                        paraBase.Inlines.Add(hLink);
                        drawHtmlForInlines(adapter, hLink.Inlines, thread, res, elem);
                        break;
                    case "img":
                        if (paraBase == null)
                        {
                            paraBase = new Paragraph();
                            paraBase.Margin = new System.Windows.Thickness(10, 0, 10, 0);
                            blocks.Add(paraBase);
                        }
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(paraBase.Inlines, sb.ToString());
                            sb.Clear();
                        }
                        if (elem.tryGetVisibility(out visibility))
                        {
                            if (visibility == css.Property.Visibility.Collapse ||
                                visibility == css.Property.Visibility.Hidden)
                            {
                                break;
                            }
                        }
                        url = elem.getAttributeValue("src");
                        hLink = new Hyperlink();
                        if (url != null)
                        {
                            if (chkLocalPath(url))
                            {
                                Image img;
                                if (elem.tryGetImage(out img, url))
                                {
                                    paraBase.Inlines.Add(new InlineUIContainer(img));
                                }
                            }
                            else
                            {
                                ThumbnailImageHelper helper =
                                     ThumbnailImageHelper.CreateInstance(url);
                                paraBase.Inlines.Add(helper.GetContainer());
                                adapter.setThumbnailImage(helper, url);
                                hLink.NavigateUri = new Uri(url);
                                hLink.Click += adapter.urlLink_Click;
                            }
                        }
                        Html2FlowDoc.applyCSSProperiesForElement(elem, hLink);
                        paraBase.Inlines.Add(hLink);
                        //drawHtmlForInlines(adapter, hLink.Inlines, thread, res, elem);
                        break;
                }


            }
            if (sb.Length > 0)
            {
                string s = convertHtmlString(sb.ToString());
                if (s.Length > 0 && !" ".Equals(s))
                {
                    if (paraBase == null)
                    {
                        paraBase = new Paragraph();
                        
                        blocks.Add(paraBase);
                    }
                    run = new Run(convertHtmlString(sb.ToString()));
                    paraBase.Inlines.Add(run);
                }
                sb.Clear();
            }
            return true;
        }

        private static bool chkLocalPath(string path)
        {
            if (path != null && path.Length > 0)
            {
                int idx = path.IndexOf("://");
                if (idx > 0)
                    return false;
            }
            return true;
        }

        private static bool drawHtmlForInlines(ResListAdapter adapter, InlineCollection inlines, 
            IThread thread, IRes res, HtmlElement parent)
        {
            StringBuilder sb = new StringBuilder();
            StringElement sElem;
            //Run run;
            Span span;
            Hyperlink hLink;
            //TextBlock tb;
            Paragraph para;
            Floater fl;
            css.Property.Visibility visibility;
            string[] sArr;


            List<HtmlElement> children = parent.getChildren();
            int count = children.Count;
            foreach (HtmlElement elem in children)
            {
                bool bHandled = false;
                string attrVal = elem.getAttributeValue("id");
                switch (attrVal)
                {
                    /*case "msg":
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        adapter.parseResMsg(inlines, thread, res, -1, -1, true);
                        bHandled = true;
                        break;*/
                    case "sequence":
                        adapter.parseSequenceNo(inlines, thread, res);
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        bHandled = true;
                        break;
                    /*case "identifier":
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        adapter.parseIdentifier(inlines, thread, res);
                        bHandled = true;
                        break;*/
                    /*case "backwardreferences":
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        adapter.parseBackwardReferences(inlines,thread, res);
                        bHandled = true;
                        break;*/
                }
                if (bHandled)
                {
                    continue;
                }

                string attrName = elem.getAttributeValue("res-link");
                if (attrName != null)
                {
                    if (sb.Length > 0)
                    {
                        setStringAvoidEmpty(inlines, sb.ToString());
                        sb.Clear();
                    }
                    if (elem.tryGetVisibility(out visibility))
                    {
                        if (visibility == css.Property.Visibility.Collapse ||
                            visibility == css.Property.Visibility.Hidden)
                        {
                            continue;
                        }
                    }
                    hLink = new Hyperlink();
                    //span = new Span();
                    Html2FlowDoc.applyCSSProperiesForElement(elem, hLink);
                    inlines.Add(hLink);
                    drawHtmlForInlines(adapter, hLink.Inlines, thread, res, elem);
                    sArr = elem.getStringContent();
                    if (sArr != null && sArr.Length > 0)
                    {
                        string s = sArr[0].Replace("<<", ">>");
                        List<object> param = new List<object>(2);
                        param.Add(thread);
                        param.Add(s);
                        hLink.Tag = param;
                        if (adapter.getEnablePopupMouseHover())
                            hLink.MouseEnter += adapter.resLinkSubItem_MouseEnter2;
                        else
                            hLink.Click += adapter.resLinkSubItem_MouseEnter2;
                    }
                    continue;
                }
                attrName = elem.getAttributeValue("id-link");
                if (attrName != null)
                {
                    if (sb.Length > 0)
                    {
                        setStringAvoidEmpty(inlines, sb.ToString());
                        sb.Clear();
                    }
                    if (elem.tryGetVisibility(out visibility))
                    {
                        if (visibility == css.Property.Visibility.Collapse ||
                            visibility == css.Property.Visibility.Hidden)
                        {
                            continue;
                        }
                    }
                    List<int> numArr = collectResId(thread, attrName);
                    if (numArr != null && numArr.Count > 1)
                    {
                        hLink = new Hyperlink();
                        Html2FlowDoc.applyCSSProperiesForElement(elem, hLink);
                        inlines.Add(hLink);
                        drawHtmlForInlines(adapter, hLink.Inlines, thread, res, elem);

                        List<object> param = new List<object>(2);
                        param.Add(thread);
                        param.Add(numArr.ToArray());
                        hLink.Tag = param;
                        if (adapter.getEnablePopupMouseHover())
                            hLink.MouseEnter += adapter.resLink_MouseEnter;
                        else
                            hLink.Click += adapter.resLink_MouseEnter;
                    }
                    else
                    {
                        span = new Span();
                        Html2FlowDoc.applyCSSProperiesForElement(elem, span);
                        inlines.Add(span);
                        drawHtmlForInlines(adapter, span.Inlines, thread, res, elem);
                    }
                    continue;
                }
                string tagName = elem.getTagName();
                switch (tagName)
                {
                    case "":
                        sElem = elem as StringElement;
                        if (sElem != null)
                        {
                            sb.Append(sElem.getString());
                        }
                        break;
                    case "hr":
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        inlines.Add(new LineBreak());
                        inlines.Add(new LineBreak());
                        System.Windows.Shapes.Rectangle rectangle = new Rectangle();
                        rectangle.HorizontalAlignment = System.Windows.HorizontalAlignment.Center;
                        rectangle.Width = 800;
                        rectangle.Height = 4;
                        rectangle.StrokeThickness = 1;
                        rectangle.Stroke = new SolidColorBrush(Colors.White);
                        rectangle.Fill = new SolidColorBrush(Colors.Black);
                        InlineUIContainer ui = new InlineUIContainer(rectangle);
                        rectangle.Margin = new System.Windows.Thickness(20, 0, 20, 0);
                        
                        
                        inlines.Add(ui);
                        inlines.Add(new LineBreak());
                        inlines.Add(new LineBreak());
                        break;
                    case "br":
                       if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        inlines.Add(new LineBreak());
                        break;
                    case "p":
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        if (elem.getChildren().Count == 0)
                            break;
                        if (elem.tryGetVisibility(out visibility))
                        {
                            if (visibility == css.Property.Visibility.Collapse ||
                                visibility == css.Property.Visibility.Hidden)
                            {
                                break;
                            }
                        }
                        //span = new Span();
                        //tb = new TextBlock();
                        //tb.Margin = new System.Windows.Thickness(0);
                        //tb.Padding = new System.Windows.Thickness(0);
                        para = new Paragraph();
                        fl = new Floater(para);
                        fl.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
                        //fl.Width = double.NaN;
                        //tb.TextWrapping = System.Windows.TextWrapping.Wrap;
                        //tb.TextAlignment = System.Windows.TextAlignment.Left;
                        //tb.HorizontalAlignment = System.Windows.HorizontalAlignment.Stretch;
                        //span.Inlines.Add(tb);
                        Html2FlowDoc.applyCSSProperiesForElement(elem, para);
                        //inlines.Add(new LineBreak());
                        inlines.Add(fl);
                        drawHtmlForInlines(adapter, para.Inlines, thread, res, elem);
                        //if (!findLastLineBreak(inlines))
                        //{                            
                        //inlines.Add(new LineBreak());
                        //}
                        break;
                    case "div":
                        if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        if (elem.getChildren().Count == 0)
                            break;
                        if (elem.tryGetVisibility(out visibility))
                        {
                            if (visibility == css.Property.Visibility.Collapse ||
                                visibility == css.Property.Visibility.Hidden)
                            {
                                break;
                            }
                        }
                        //span = new Span();
                        //tb = new TextBlock();
                        //tb.Margin = new System.Windows.Thickness(0);
                        //tb.Padding = new System.Windows.Thickness(0);
                        //para = new Paragraph();
                        Section sec = new Section();
                        fl = new Floater(sec);
                        fl.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
                        //fl.Width = double.NaN;
                        //tb.TextWrapping = System.Windows.TextWrapping.Wrap;
                        //tb.TextAlignment = System.Windows.TextAlignment.Left;
                        //tb.HorizontalAlignment = System.Windows.HorizontalAlignment.Stretch;
                        //span.Inlines.Add(tb);
                        Html2FlowDoc.applyCSSProperiesForElement(elem, sec);
                        //inlines.Add(new LineBreak());
                        inlines.Add(fl);
                        drawHtmlForBlocks(adapter, sec.Blocks, thread, res, elem);
                        //if (!findLastLineBreak(inlines))
                        //{                            
                        //inlines.Add(new LineBreak());
                        //}
                        break;
                    case "span":
                         if (sb.Length > 0)
                        {
                            setStringAvoidEmpty(inlines, sb.ToString());
                            sb.Clear();
                        }
                        if (elem.tryGetVisibility(out visibility))
                        {
                            if (visibility == css.Property.Visibility.Collapse ||
                                visibility == css.Property.Visibility.Hidden)
                            {
                                break;
                            }
                        }
                        span = new Span();
                        Html2FlowDoc.applyCSSProperiesForElement(elem, span);
                        inlines.Add(span);
                        drawHtmlForInlines(adapter, span.Inlines, thread, res, elem);
                       break;
                    case "a":
                       if (sb.Length > 0)
                       {
                           setStringAvoidEmpty(inlines, sb.ToString());
                           sb.Clear();
                       }
                       if (elem.tryGetVisibility(out visibility))
                       {
                           if (visibility == css.Property.Visibility.Collapse ||
                               visibility == css.Property.Visibility.Hidden)
                           {
                               break;
                           }
                       }
                       string url = elem.getAttributeValue("href");
                       hLink = new Hyperlink();
                       if (url != null)
                       {
                           /*if (adapter.chkGraphicLink(url))
                           {
                               ThumbnailImageHelper helper =
                                   ThumbnailImageHelper.CreateInstance(url);
                               inlines.Add(helper.GetContainer());
                               adapter.setThumbnailImage(helper, url);
                           }*/
                           try
                           {
                               hLink.NavigateUri = new Uri(url);
                               hLink.Click += adapter.urlLink_Click;
                           }
                           catch (UriFormatException e)
                           {
                           }
                       }
                       Html2FlowDoc.applyCSSProperiesForElement(elem, hLink);
                       inlines.Add(hLink);
                       drawHtmlForInlines(adapter, hLink.Inlines, thread, res, elem);
                       break;
                    case "img":
                       if (sb.Length > 0)
                       {
                           setStringAvoidEmpty(inlines, sb.ToString());
                           sb.Clear();
                       }
                       if (elem.tryGetVisibility(out visibility))
                       {
                           if (visibility == css.Property.Visibility.Collapse ||
                               visibility == css.Property.Visibility.Hidden)
                           {
                               break;
                           }
                       }
                       url = elem.getAttributeValue("src");
                       hLink = new Hyperlink();
                       if (url != null)
                       {
                           if (chkLocalPath(url))
                           {
                               Image img;
                               if (elem.tryGetImage(out img, url))
                               {
                                   inlines.Add(new InlineUIContainer(img));
                               }
                           }
                           else
                           {
                               ThumbnailImageHelper helper =
                                    ThumbnailImageHelper.CreateInstance(url);
                               inlines.Add(helper.GetContainer());
                               adapter.setThumbnailImage(helper, url);
                               hLink.NavigateUri = new Uri(url);
                               hLink.Click += adapter.urlLink_Click;
                           }
                       }
                       Html2FlowDoc.applyCSSProperiesForElement(elem, hLink);
                       inlines.Add(hLink);
                       //drawHtmlForInlines(adapter, hLink.Inlines, thread, res, elem);
                       break;
                }
            }
            if (sb.Length > 0)
            {
                setStringAvoidEmpty(inlines, sb.ToString());
                sb.Clear();
            }
            return true;
        }
#if false
        private static  bool aaafindLastLineBreak(InlineCollection inlines)
        {
            int n = findLastLineBreak_sub(inlines);
            if (n == 1 || n == 2)
                return true;
            else
                return false;
        }

        private static int findLastLineBreak_sub(InlineCollection inlines)
        {
            int state = 0;
            foreach (Inline i1 in inlines)
            {
                LineBreak lb = i1 as LineBreak;
                if (lb != null)
                    state = 1;
                else
                {
                    Run run = i1 as Run;
                    if (run != null)
                    {
                        string s = run.Text;
                        if (s.Length == 0 || " ".Equals(s))
                        {
                            if (state == 1)
                                state = 2;
                        }
                        else
                        {
                            state = 3;
                        }
                    }
                    else
                    {
                        Span span = i1 as Span;
                        if (span != null)
                        {
                            if (span.Inlines.FirstInline != null)
                            {
                                int n = findLastLineBreak_sub(span.Inlines);
                                if (n == 1)
                                    state = 1;
                                else if (n == 2)
                                    state = 2;
                                else if (n == 3)
                                    state = 3;
                            }
                            else
                            {
                                if (state == 1 || state == 2)
                                    state = 2;
                                else
                                    state = 0;
                            }
                        }
                        else
                        {
                            state = 3;
                        }
                    }
                }
            }
            return state;
        }
#endif
        private static void setStringAvoidEmpty(InlineCollection inlines, string source)
        {
            string s = convertHtmlString(source);
            if (s.Length == 0)
                return;
            inlines.Add(s);
        }
        private static string convertHtmlString(string source)
        {
            int state = 0;
            int length = source.Length;
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; i++)
            {
                char c = source[i];
                switch(c){
                    case ' ':
                    case '\t':
                    case '\r':
                    case '\n':
                        state = 1;
                        break; 
                    case '&':
                        int retLen;
                        if ((i + 1 < source.Length) && source[i + 1] == '#')
                        {
                            c = HtmlEscape.parseHTMLDecimalHexEscape(source, i + 2, out retLen);
                            if (c != '\0')
                            {
                                //if (start < i)
                                //    sb.Append(source.Substring(start, i - start));
                                sb.Append(c);
                                //start = retLen;
                                i = retLen - 1;

                            }
                        }
                        else
                        {
                            c = HtmlEscape.HTMLEscapeTable.getCodeFromEscape(source, i + 1, out retLen);
                            if (c != '\0')
                            {
                                //if (start < i)
                                //    sb.Append(source.Substring(start, i - start));
                                sb.Append(c);
                                //start = retLen;
                                i = retLen - 1;
                            }
                        }

                        break;
                    default:
                        if(state == 1)
                            sb.Append(' ');
                        sb.Append(c);
                        state = 0;
                        break;
                }
            }
            if(state == 1)
                sb.Append(' ');

            return sb.ToString();
        }
        public static bool MargeResDataIntoHtml(HtmlElement rootElement,
            IThread ithread, IRes res, 
            bool newMsg,  bool msgOwner, bool reply,
            bool bookmark, bool asciiart,
            string ngword, string ngname, string ngid, IAmbiguousSearch search)
        {
            HtmlElement hElem;
            HtmlAttribute hAttr;
            StringElement sElem;
            string backRefText;

            string msg = res.getMsg();
            string id = res.getID();
            string name = res.getName();
            string email = res.getMail();
            string date = res.getDate();

            int[] refArray = res.getReferenceArray();

            List<HtmlElement> rList = rootElement.getElements(
                null, "body", null, null, null, false);
            if (rList == null || rList.Count != 1)
                return false;

            List<HtmlElement> elems =
                rList[0].getElements(null, null, null, "sequence", null, true);
            if (elems != null && elems.Count > 0)
            {
                foreach (HtmlElement elem in elems)
                {
                    elem.setInnerText(res.getSequenceNo().ToString());
                }
            }

            elems = rList[0].getElements(null, null, null, "uname", null, true);
            if (elems != null && elems.Count > 0)
            {
                foreach (HtmlElement elem in elems)
                {
                    elem.setInnerText(res.getName());
                }
            }

            elems = rList[0].getElements(null, null, null, "email", null, true);
            if (elems != null && elems.Count > 0)
            {
                foreach (HtmlElement elem in elems)
                {
                    elem.setInnerText(res.getMail());
                }
            }

            elems = rList[0].getElements(null, null, null, "datetime", null, true);
            if (elems != null && elems.Count > 0)
            {
                foreach (HtmlElement elem in elems)
                {
                    elem.setInnerText(res.getDate());
                }
            }

            elems = rList[0].getElements(null, null, null, "identifier", null, true);
            if (elems != null && elems.Count > 0)
            {
                DebugContext ctx = new DebugContext();
                foreach (HtmlElement elem in elems)
                {
                    string innerHtml = getResIdHtml(ithread, res);
                    elem.setInnerText(innerHtml);
                    //elem.clearChildren();
                    //if (0 > HtmlParser.parseElement(ctx, elem, innerHtml, 0))
                    //    continue;
                    elem.addAttribute(new HtmlAttribute("id-link", res.getID()));
                }
            }

            elems = rList[0].getElements(null, null, null, "msg", null, true);
            if (elems != null && elems.Count > 0)
            {
                foreach (HtmlElement elem in elems)
                {
                    elem.setInnerResHtml(res.getMsg(), search);
                }
            }

            if (ngword != null)
            {
                elems = rList[0].getElements(null, null, null, "ngword", null, true);
                if (elems != null && elems.Count > 0)
                {
                    foreach (HtmlElement elem in elems)
                    {
                        elem.setInnerText(ngword);
                    }
                }
            }
            if (ngname != null)
            {
                elems = rList[0].getElements(null, null, null, "ngname", null, true);
                if (elems != null && elems.Count > 0)
                {
                    foreach (HtmlElement elem in elems)
                    {
                        elem.setInnerText(ngname);
                    }
                }
            }
            if (ngid != null)
            {
                elems = rList[0].getElements(null, null, null, "ngid", null, true);
                if (elems != null && elems.Count > 0)
                {
                    foreach (HtmlElement elem in elems)
                    {
                        elem.setInnerText(ngid);
                    }
                }
            }

            if (refArray != null && refArray.Length > 0)
            {
                backRefText = formatReferenceNumbers(refArray);
                if (backRefText != null)
                {
                    backRefText = "<<" + backRefText;
                    elems = rList[0].getElements(null, null, null, "backwardreferences", null, true);
                    if (elems != null && elems.Count > 0)
                    {
                        foreach (HtmlElement elem in elems)
                        {
                            hElem = new HtmlElement(elem, "span");
                            hAttr = new HtmlAttribute("res-link");
                            hElem.addAttribute(hAttr);
                            sElem = new StringElement(hElem, backRefText);
                        }
                    }
                }
            }


            List<string> cList = new List<string>(1);
            cList.Add("resparam");
            elems = rList[0].getElements(null, null, cList, null,  null, true);
            if (elems != null && elems.Count > 0)
            {
                foreach (HtmlElement elem in elems)
                {
                    //List<string> cList2 = elem.getClasses();
                    if (newMsg)
                        elem.addAttribute(new HtmlAttribute("new-message"));
                    if (msgOwner)
                        elem.addAttribute(new HtmlAttribute("message-owner"));
                    if (reply)
                        elem.addAttribute(new HtmlAttribute("reply-message"));
                    if (bookmark)
                        elem.addAttribute(new HtmlAttribute("bookmark"));
                    if (asciiart)
                        elem.addAttribute(new HtmlAttribute("ascii-art"));
                    if (refArray != null && refArray.Length > 0)
                        elem.addAttribute(new HtmlAttribute("backwardreferences"));
                    if(ngword != null)
                        elem.addAttribute(new HtmlAttribute("ngword"));
                    if(ngname != null)
                        elem.addAttribute(new HtmlAttribute("ngname"));
                    if(ngid != null)
                        elem.addAttribute(new HtmlAttribute("ngid"));
                }
            }
            return true;
        }
        private static string formatReferenceNumbers(int[] valList)
        {
            if (null == valList) { return null; }
            if (0 >= valList.Length) { return null; }

            StringBuilder buf = new StringBuilder();
            //buf.Append("<<");

            bool flagFirst = true;

            int prevVal = 0;
            int i = 0;
            for (; i < valList.Length - 1; i++)
            {
                int val1 = valList[i];
                int val2 = valList[i + 1];
                if (val1 == val2 - 1)
                {
                    if (0 == prevVal)
                    {
                        prevVal = val1;
                    }
                }
                else
                {
                    if (!flagFirst)
                    {
                        buf.Append(',');
                    }
                    else
                    {
                        flagFirst = false;
                    }
                    if (0 != prevVal)
                    {
                        buf.Append(prevVal.ToString());
                        buf.Append('-');
                        buf.Append(val1.ToString());
                        prevVal = 0;
                    }
                    else
                    {
                        buf.Append(val1.ToString());
                    }
                }
            }

            if (!flagFirst)
            {
                buf.Append(',');
            }
            if (0 != prevVal)
            {
                buf.Append(prevVal.ToString());
                buf.Append('-');
                buf.Append(valList[i].ToString());
            }
            else
            {
                buf.Append(valList[i].ToString());
            }

            return buf.ToString();
        }

        private static string getResIdHtml(IThread ithread, IRes ires)
        {
            StringBuilder sb = new StringBuilder();
            //Span span;
            //Run r;
            string id = ires.getID();
            if (id != null && id.Length > 0)
            {
                int before = 0;
                int after = 0;
                bool chk = false;
                List<IRes> rList = ithread.getResList();
                List<int> arrSeqNum = new List<int>();
                if (rList != null)
                {
                    int rCnt = rList.Count;
                    for (int i = 0; i < rCnt; i++)
                    {
                        if (!id.Equals(rList[i].getID()))
                            continue;

                        arrSeqNum.Add(rList[i].getSequenceNo());
                        if (ires.Equals(rList[i]))
                        {
                            chk = true;
                            continue;
                        }


                        if (chk)
                            after++;
                        else
                            before++;
                    }
                }
                if (0 < (before + after))
                {
                    //List<object> param = new List<object>();
                    //param.Add(thread);
                    //param.Add(arrSeqNum.ToArray());
                    sb.Append("ID:").Append(id).Append('(').Append(before + 1).Append('/').Append(before + after + 1).Append(')');
                    //Hyperlink hl = new Hyperlink(new Run(id + "(" + (before + 1) + "/" + (before + after + 1) + ")"));
                    //hl.Tag = param;
                    //if (topItem)
                    //{
                    //if (getEnablePopupMouseHover())
                    //    hl.MouseEnter += resLink_MouseEnter;
                    //else
                    //    hl.Click += resLink_MouseEnter;
                    /*}
                    else
                    {
                        if (getEnablePopupMouseHover())
                            hl.MouseEnter += resLinkSubItem_MouseEnter;
                        else
                            hl.Click += resLinkSubItem_MouseEnter;
                    }*/
                    //inlines.Add(hl);
                }
                else
                {
                    sb.Append("ID:").Append(id);
                    //r = new Run();
                    //r.Text = id;
                    //span = new Span();
                    //span.Foreground = Brushes.Black;
                    //span.Inlines.Add(r);
                    //inlines.Add(span);
                }
            }
            return sb.ToString();
        }

        private static List<int> collectResId(IThread ithread, string id)
        {
            List<IRes> rList = ithread.getResList();
            List<int> arrSeqNum = new List<int>();
            if (rList != null)
            {
                int rCnt = rList.Count;
                for (int i = 0; i < rCnt; i++)
                {
                    if (!id.Equals(rList[i].getID()))
                        continue;

                    arrSeqNum.Add(rList[i].getSequenceNo());

                }
            }
            return arrSeqNum; 
        }
    }
}
