﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Media;
using NT2chCtrl.html.css;

namespace NT2chCtrl.html
{
    partial class HtmlParser
    {

        const string ERROR_INVALIE_TAG_FORMAT = "タグの書式が不正です";
        const string ERROR_UNMACHED_TAG_PAIR = "開始タグと終了タグが一致しません";

        //int mCurrentLine;
        //int mErrorIdx;
        //string mErrorMessage;
        DebugContext mDbgCtx = new DebugContext();
        string mHtmlSource;
        bool mHasError;
        public bool hasError() { return mHasError; }
        public int getErrorLine() { return mDbgCtx.mCurrentLine; }
        public int getErrorSrcIndex() { return mDbgCtx.mCurentIndex; }
        public string getErrorMessage() { return mDbgCtx.mErrorMessage; }

        HtmlElement mRootElement;
        List<Selector> mCSSSelectors;
        js.JsParser mJsParser;

        public string getHtmlSource() { return mHtmlSource; }

        public HtmlParser(string basePath)
        {
            HtmlEscape.init();
            wpf.ImageCash.init(basePath);
            mDbgCtx.mCurrentLine = 1;
            mHasError = false;
        }

        public string getError()
        {
            string line = "(" + mDbgCtx.mCurrentLine + ") " +
                mDbgCtx.mErrorMessage;
            return line;
        }

        public HtmlElement CloneHtmlElement()
        {
            if (mRootElement == null)
                return null;

            return mRootElement.Clone(null);

        }

        public bool Parse(string htmlSource)
        {            

            mRootElement = null;

            mHtmlSource = htmlSource;
            if (htmlSource == null)
                return false;
            
            //DebugContext ctx = new DebugContext();
            mDbgCtx.init();
            //HtmlParser parser = new HtmlParser();

            HtmlElement rootElement = new HtmlElement(null, string.Empty);

            if (0 > parseElement(mDbgCtx, rootElement, htmlSource, 0))
            {
                mHasError = true;
                return false;
            }

            mCSSSelectors = new List<Selector>();
            if (!parseCSS(mDbgCtx, rootElement, mCSSSelectors))
            {
                mHasError = true;
                //mDbgCtx.mCurentIndex = ctx.getCurrentIndex();
                //mDbgCtx.mCurrentLine = ctx.getCurrentLine();
                //mDbgCtx.mErrorMessage = ctx.getErrorMessage();
                return false;
            }
            if (!parseJS(mDbgCtx, rootElement, out mJsParser))
            {
                mHasError = true;
                //mDbgCtx.mCurrentIndex = ctx.getCurrentIndex();
                //mDbgCtx.mCurrentLine = ctx.getCurrentLine();
                //mDbgCtx.mErrorMessage = ctx.getErrorMessage();
                return false;
            }
            mRootElement = rootElement;
            return true;
        }

        private bool parseJS(DebugContext ctx, HtmlElement parent, out js.JsParser parser)
        {
            parser = new js.JsParser();

            List<HtmlElement> list = parent.getElements(null, "script", null, null, "type", true);
            foreach (HtmlElement hElem in list)
            {
                string attrVal = hElem.getAttributeValue("type");
                if (attrVal == null)
                    continue;
                if (!attrVal.Equals("text/javascript"))
                    continue;

                ctx.setCurrentLine(hElem.mDebugLine);
                ctx.mBaseIndex = hElem.mDebugSourceIndex;
                if (!parser.PreCompile(ctx, hElem))
                {
                    return false;
                }
            }
            return true;
        }

        public bool runJS(DebugContext dCtx, HtmlElement rootElement, out js.JsFunctionContext fCtx)
        {
            return mJsParser.run(dCtx, rootElement, out fCtx);
        }

        private bool parseCSS(DebugContext ctx, HtmlElement parent, List<Selector> cssList)
        {
            List<HtmlElement> children = parent.getChildren();
            int len = children.Count;
            for (int i = 0; i < len; i++)
            {
                if ("style".Equals(children[i].getTagName()))
                {
                    string attrVal = children[i].getAttributeValue("type");
                    if (attrVal == null)
                        continue;
                    if (!attrVal.Equals("text/css"))
                        continue;

                    ctx.setCurrentLine(children[i].mDebugLine);
                    ctx.mBaseIndex = children[i].mDebugSourceIndex;
                    string[] contents = children[i].getStringContent();
                    if (contents.Length > 0)
                        if(!Selector.Parse(ctx, contents[0], cssList))
                            return false;
                }
                else
                {
                    if(!parseCSS(ctx, children[i], cssList))
                        return false;
                }
            }
            return true;

        }

        public bool applyCSS(HtmlElement rootElement)
        {
            List<HtmlElement> eList = rootElement.getElements(null,
                "body", null, null, null, true);

            if (eList == null || eList.Count != 1)
                return false;



            List<Select> sList;
            int count = mCSSSelectors.Count;
            for(int i = 0; i < count; i++)
            {
                Selector stor = mCSSSelectors[i];
                //List<Property> properties = stor.getProperties();
                sList = stor.getList();

                if(!applyCSS(eList[0], sList, 0, stor, false))
                    continue;
            }
            return true;
        }

        private bool applyCSS(HtmlElement baseElement,
                List<Select> sList, int currListIdx, Selector stor, bool skipParent)
        {
            List<HtmlElement> eList;

            if (baseElement == null)
                return false;

            int sCnt = sList.Count;
            if (sCnt == currListIdx)
                return false;

            Select select = sList[currListIdx];


            List<string> cList = null;
            string className = select.getClassName();
            if (className != null && className.Length > 0 && !"*".Equals(className))
            {
                cList = new List<string>();
                cList.Add(className);
            }

            string tagName = select.getTagName();
            string idName = select.getIdName();
            string attrName = select.getAttrName();
            if (tagName != null && "*".Equals(tagName))
                tagName = null;
            if (idName != null && "*".Equals(idName))
                idName = null;
            if (attrName != null && "*".Equals(attrName))
                attrName = null;

            if (select.isImmidiateChild())
            {
                eList = baseElement.getChildren(
                    tagName, cList, idName, attrName);
            }
            else
            {
                eList = baseElement.getElements(null,
                    tagName, cList, idName, attrName, skipParent);
            }
            if (eList == null)
                return false;
            if (eList.Count == 0)
                return true;
            
            currListIdx++;
            if (sCnt == currListIdx)
            {
                foreach (HtmlElement elem in eList)
                {
                    elem.addSelector(stor);
                }
            }
            else
            {
                foreach (HtmlElement elem in eList)
                {
                    applyCSS(elem, sList, currListIdx, stor, true);                    
                }
            }
            return true;
        }



        public static int parseElement(DebugContext ctx, HtmlElement parent, string source, int startIdx)
        {
            int n;
            string tagName;

            int state = 0;//out of tag
            //1. after <
            //2. after !
            //3. processing tagName

            int tagTextStart = startIdx;

            int textStart = startIdx;
            int textEnd = 0;

            int srcLen = source.Length;
            for (int i = startIdx; i < srcLen; i++)
            {
                switch (getCharToken(source[i]))
                {
                    case CHAR_TOKEN.LT:
                        state = 1;
                        textEnd = i;
                        break;
                    case CHAR_TOKEN.EXCLAMATION:
                        if (state == 0)
                        {
                            break;
                        }
                        else if (state == 1)
                        {
                            state = 2;
                            break;
                        }
                        else
                        {
                            ctx.mCurentIndex = i;
                            return -1;
                        }
                    case CHAR_TOKEN.HYPHIEN:
                        if(state == 2)
                        {
                            if (i + 1 < srcLen)
                            {
                                if (source[i + 1] == '-')
                                {
                                    setStringElement(ctx, parent, source, textStart, textEnd);
                                    n = parseComment(ctx, parent, source, i + 2);
                                    if (n < 0)
                                        return n;
                                    i = n;
                                    textStart = i + 1;
                                }
                            }
                        }
                        state = 0;
                        break;
                    case CHAR_TOKEN.NL:
                        if (state == 3)
                        {
                            setStringElement(ctx, parent, source, textStart, textEnd);
                            tagName = source.Substring(tagTextStart, i);
                            n = parseTag(ctx, parent, tagName, source, i + 1);
                            if (n < 0)
                            {
                                 return -1;
                            }
                            i = n;
                            textStart = i + 1;
                        }
                        ctx.mCurrentLine++;
                        state = 0;
                        break;
                    case CHAR_TOKEN.SLASH:
                        if (state == 1)
                        {
                            setStringElement(ctx, parent, source, textStart, textEnd);
                            n = closeTag(ctx, parent, source, i + 1);
                            if (n < 0)
                            {
                                return -1;
                            }
                            i = n;
                            textStart = i + 1;
                        }
                        else if (state == 3)
                        {
                            setStringElement(ctx, parent, source, textStart, textEnd);
                            tagName = source.Substring(tagTextStart, i - tagTextStart);
                            n = parseTag(ctx, parent, tagName, source, i);
                            if (n < 0)
                            {
                                return -1;
                            }
                            i = n;
                            textStart = i + 1;
                        }
                        state = 0;
                        break;
                    case CHAR_TOKEN.WHITESPACE:
                    case CHAR_TOKEN.GT:
                        if (state == 3)
                        {
                            setStringElement(ctx, parent, source, textStart, textEnd);
                            tagName = source.Substring(tagTextStart, i - tagTextStart);
                            n = parseTag(ctx, parent, tagName, source, i);
                            if (n < 0)
                            {
                                return -1;
                            }
                            i = n;
                            textStart = i + 1;
                        }
                        state = 0;
                        break;
                    case CHAR_TOKEN.ALPHA:
                        if (state == 1 || state == 2)
                        {
                            state = 3;
                            tagTextStart = i;
                        }
                        break;
                    case CHAR_TOKEN.NUMBER:
                        if (state != 3)
                        {
                            state = 0;
                        }
                        break;
                }
            }
            if(textStart < srcLen)
                setStringElement(ctx, parent, source, textStart, srcLen);

            return 0;
        }

        private static int parseTag(DebugContext ctx, HtmlElement parent, string tagName, string source, int startIdx)
        {
            int length = source.Length;
            string attrName;
            string attrValue;
            int n;
            int state = 0;
            int textStart = startIdx;
            int textEnd = -1;
            
            HtmlElement element = new HtmlElement(parent, tagName);
            element.setDebugInfo(ctx.mCurrentLine, startIdx);

            for (int i = startIdx; i < length; i++)
            {
                switch (getCharToken(source[i]))
                {
                    case CHAR_TOKEN.NL:
                        ctx.mCurrentLine++;
                        if (state == 0)
                        {
                            state = 1;
                        }
                        else if (state == 2)
                        {
                            state = 3;
                            textEnd = i;
                        }
                        break;
                    case CHAR_TOKEN.WHITESPACE:
                        if (state == 0)
                        {
                            state = 1;
                        }
                        else if (state == 2)
                        {
                            state = 3;
                            textEnd = i;
                        }
                        break;
                    case CHAR_TOKEN.EQUAL:
                        if (state == 2)
                        {
                            attrName = source.Substring(textStart, i - textStart);
                        }
                        else if (state == 3)
                        {
                            attrName = source.Substring(textStart, textEnd - textStart);
                        }
                        else
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }
                        n = parseAttrValue(ctx, source, i + 1, out attrValue);
                        if (n < 0)
                        {
                            return n;
                        }
                        element.addAttribute(new HtmlAttribute(attrName, attrValue));
                        i = n;
                        state = 0;
                        break;
                    /*case CHAR_TOKEN.DQUOTE:
                    case CHAR_TOKEN.SQUOTE:
                        if (state == 2)
                        {
                            attrName = source.Substring(textStart, i - textStart);
                        }
                        else if (state == 3)
                        {
                            attrName = source.Substring(textStart, textEnd - textStart);
                        }
                        else
                        {
                            mErrorIdx = i;
                            mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }
                        n = parseAttrValue(source, i, out attrValue);
                        if (n < 0)
                        {
                            return n;
                        }
                        element.addAttribute(new HtmlAttribute(attrName, attrValue));
                        i = n;
                        state = 0;
                        break;*/
                    case CHAR_TOKEN.GT:
                        bool closeTag = false;
                        if (i > 0)
                        {
                            if ('/' == source[i - 1])
                            {
                                element.setClosed(true);
                                closeTag = true;
                            }
                        }
                        if (state == 2 || state == 3)
                        {
                            if (state == 2)
                                textEnd = (closeTag) ? i - 1 : i;
                            attrName = source.Substring(textStart, textEnd - textStart);
                            element.addAttribute(new HtmlAttribute(attrName));
                        }
                        if(!closeTag)
                        {
                            if(tagName.Equals("style") ||
                                tagName.Equals("script"))
                            {
                                if(!parseScriptElement(ctx, element, tagName, source, i + 1, out n))
                                {
                                    return -1;
                                }
                                i = n;
                            }
                        }
                        return i;
                    case CHAR_TOKEN.ALPHA:
                        if (state == 1)
                        {
                            textStart = i;
                            state = 2;
                        }
                        else if (state == 2)
                        {
                            break;
                        }
                        else if (state == 3)
                        {
                            //single attribute
                            attrName = source.Substring(textStart, textEnd - textStart);
                            element.addAttribute(new HtmlAttribute(attrName));
                            break;
                        }
                        else
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }
                        break;
                    case CHAR_TOKEN.NUMBER:
                    case CHAR_TOKEN.HYPHIEN:
                        if (state != 2)
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }
                        break;
                }
            }
            return - 1;
            /*
            int idx = source.IndexOf('>', startIdx);
            if (idx < 0)
                return source.Length - 1;

            HtmlElement element = new HtmlElement(parent, tagName);

            if (idx > 1)
            {
                if (source[idx - 1] == '/')
                {
                    element.setClosed(true);
                }
            }
            return idx;*/
        }

        private static bool parseScriptElement(DebugContext ctx, HtmlElement pElem,
            string tagName, string source, int startIdx, out int endIdx)
        {
            int textEnd;
            StringElement sElem;
            endIdx = 0;
            int comment = 0;
            int length = source.Length;
            for (int i = startIdx; i < length; i++)
            {
                char c = source[i];
                switch (c)
                {
                    case '/':
                        if (comment > 0)
                            break;
                        if (i >= (length - 1))
                            break;
                        switch(source[i+1]){
                            case '/':
                                comment = 1;
                                i++;
                                break;
                            case '*':
                                comment = 2;
                                i++;
                                break;
                        }
                        break;
                    case '\'':
                        if (comment > 0)
                            break;
                        while(true)
                        {
                            i = source.IndexOf('\'', i + 1);
                            if (i < 0)
                                return false;
                            if (source[i - 1] == '\\')
                                continue;
                            break;
                        }
                        //i++;
                        break;
                    case '\"':
                        if (comment > 0)
                            break;
                        while(true)
                        {
                            i = source.IndexOf('\"', i + 1);
                            if (i < 0)
                                return false;
                            if (source[i - 1] == '\\')
                                continue;
                            break;
                        }
                        //i++;
                        break;
                    case '\n':
                        ctx.incrementLine();
                        if (comment == 1)
                            comment = 0;
                        break;
                    case '*':
                        if (comment < 2)
                            break;
                        if (i >= (length - 1))
                            break;
                        if (source[i + 1] == '/')
                        {
                            i++;
                            comment = 0;
                        }
                        break;
                    case '<':
                        if (comment > 0)
                            break;
                        if (i >= (length - 1) || source[i + 1] != '/')
                            break;
                        textEnd = i;
                        i += 2;
                        if (i == source.IndexOf(tagName, i))
                        {
                            int tagLength = tagName.Length;
                            if (i + tagLength >= length)
                                return false;
                            if ('>' == source[i + tagLength])
                            {
                                sElem = new StringElement(
                                    pElem, source.Substring(startIdx, textEnd-startIdx));
                                pElem.setClosed(true);
                                endIdx = i + tagLength;
                                return true;
                            }
                        }
                        break;
                }

            }
            return false;
        }

        private  static int parseAttrValue(DebugContext ctx, string source, int startIdx, out string attrValue)
        {
            attrValue = string.Empty;

            int length = source.Length;
            bool dquote = false;
            bool squote = false;
            int state = 0;
            int textStart = startIdx;
            for (int i = startIdx; i < length; i++)
            {
                switch (getCharToken(source[i]))
                {
                    case CHAR_TOKEN.DQUOTE:
                        if (squote)
                        {
                            if (state == 0)
                            {
                                textStart = i;
                                state = 1;
                            }
                            break;
                        }
                        if (state == 0 && !dquote)
                        {
                            dquote = true;
                        }
                        else if (state == 1 && dquote)
                        {
                            attrValue = source.Substring(textStart, i - textStart);
                            return i;
                        }
                        else
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }                        
                        break;
                    case CHAR_TOKEN.SQUOTE:
                        if (dquote)
                        {
                            if (state == 0)
                            {
                                textStart = i;
                                state = 1;
                            }
                            break;
                        }
                        if (state == 0 && !squote)
                        {
                            squote = true;
                        }
                        else if (state == 1 && squote)
                        {
                            attrValue = source.Substring(textStart, i - textStart);
                            return i;
                        }
                        else
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }                        
                        break;
                    case CHAR_TOKEN.ESCAPE:
                        if (i < length - 1)
                        {
                            i++;
                        }
                        else
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return - 1;
                        }
                        break;
                    case CHAR_TOKEN.NL:
                        if (state == 1)
                        {
                            ctx.mCurrentLine++;
                            if (dquote || squote)
                                break;
                            attrValue = source.Substring(textStart, i - textStart);
                            return i;
                        }
                        else
                        {
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            ctx.mCurentIndex = i;
                            return -1;
                        }
                    case CHAR_TOKEN.WHITESPACE:
                        if (state == 1)
                        {
                            if (dquote || squote)
                                break;
                            attrValue = source.Substring(textStart, i - textStart);
                            return i;
                        }
                        else
                        {
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            ctx.mCurentIndex = i;
                            return -1;
                        }
                    case CHAR_TOKEN.ALPHA:
                    case CHAR_TOKEN.NUMBER:
                    case CHAR_TOKEN.OTHER:
                    default:
                        if (state == 0)
                        {
                            textStart = i;
                            state = 1;
                        }
                        break;
                }
            }
            return -1;
        }

        private static  int closeTag(DebugContext ctx, HtmlElement parent, string source, int startIdx)
        {
            int length = source.Length;
            int endIdx = 0;
            string tagName = string.Empty;
            int state = 0;
            int tagTextStart = startIdx;
            
            for (int i = startIdx; i < length; i++)
            {
                switch(getCharToken(source[i]))
                {
                    case CHAR_TOKEN.NL:
                    case CHAR_TOKEN.WHITESPACE:
                        if (state == 0 || state == 2)
                            break;
                        if(state == 1)
                        {
                            tagName = source.Substring(tagTextStart, i - tagTextStart);
                            state = 2;
                        }
                        break;
                    case CHAR_TOKEN.GT:
                        if (state == 1)
                        {
                            tagName = source.Substring(tagTextStart, i - tagTextStart);
                        }
                        else if (state != 2)
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }
                        endIdx = i;
                        goto LABEL1;
                    case CHAR_TOKEN.ALPHA:
                        if (state == 0)
                        {
                            tagTextStart = i;
                            state = 1;
                        }
                        else if (state == 1)
                        {
                            break;
                        }
                        else
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }
                        break;
                    case CHAR_TOKEN.NUMBER:
                        if (state != 1)
                        {
                            ctx.mCurentIndex = i;
                            ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                            return -1;
                        }
                        break;
                }
            }
        LABEL1:

            if (tagName == null || tagName.Length == 0 || endIdx == 0)
            {
                ctx.mCurentIndex = startIdx;
                ctx.mErrorMessage = ERROR_INVALIE_TAG_FORMAT;
                return -1;
            }
            List<HtmlElement> children = parent.getChildren();

            length = children.Count;
            int childCnt = 0;
            for (int i = length - 1; i >= 0; i--)
            {
                HtmlElement element = children[i];
                if (!element.Closed())
                {
                    if (tagName.Equals(element.getTagName()))
                    {
                        if (childCnt > 0)
                        {
                            List<HtmlElement> children2 = children.GetRange(i + 1, childCnt);
                            children.RemoveRange(i+1, childCnt);
                            element.setChildren(children2);
                            element.setClosed(true);
                        }
                        return endIdx;
                    }
                }
                childCnt ++;
            }

            ctx.mCurentIndex = startIdx;
            ctx.mErrorMessage = ERROR_UNMACHED_TAG_PAIR;
            return -1;
        }

        static void setStringElement(DebugContext ctx, HtmlElement parent, string source, int start, int end)
        {
            int length = end - start;
            if (0 >= length)
                return;

            string value = source.Substring(start, length);
            StringElement element = 
                new StringElement(parent, value);
            element.setDebugInfo(ctx.mCurrentLine, start);
        }

        private static int parseComment(DebugContext ctx, HtmlElement parent, string source, int startIdx)
        {
            //int n;

            int state = 0;

            int start = startIdx;

            int srcLen = source.Length;
            for (int i = startIdx; i < srcLen; i++)
            {
                switch (getCharToken(source[i]))
                {
                    case CHAR_TOKEN.HYPHIEN:
                        if (state == 0)
                        {
                            state = 1;
                        }
                        else if (state == 1 || state == 2)
                        {
                            state = 2;
                        }
                        else if (state == 3)
                        {
                            state = 0;
                        }
                        break;
                    case CHAR_TOKEN.ESCAPE:
                        if (state == 3)
                            state = 0;
                        else
                            state = 3;
                        break;
                    case CHAR_TOKEN.GT:
                        if (state == 2)
                        {

                            string comment =
                                source.Substring(startIdx, i - 2 - startIdx); 
                            CommentElement element = 
                                new CommentElement(parent, comment);
                            element.setDebugInfo(ctx.mCurrentLine, startIdx);
                            return i;
                        }
                        state = 0;
                        break;
                    case CHAR_TOKEN.NL:
                        state = 0;
                        ctx.mCurrentLine++;
                        break;
                    default :
                        state = 0;
                        break;
                }
            }
            return srcLen - 1;
        }

    }
}
