﻿using System;
using System.Collections.Generic;
using System.Text;
using NT2chObject;

namespace NT2chCtrl
{
    partial class ResListAdapter : UIElementListPanel.IUIElementListAdapter
    {
        double mZoomValue;

        bool? mPopupMouseHover = null;
        public bool getEnablePopupMouseHover()
        {
            if (mPopupMouseHover.HasValue)
                return (bool)mPopupMouseHover;

            Dictionary<PREF_PARAM, object> dict =
                mCommand.GetPreference();
            if (dict == null)
                return true;
            object o;
            if (dict.TryGetValue(PREF_PARAM.RES_VIEW_POPUP_MOUSEHOVER, out o))
            {
                string s = o as string;
                if (s != null)
                {
                    bool hover;
                    if (bool.TryParse(s, out hover))
                    {
                        mPopupMouseHover = hover;
                        return hover;
                    }
                }
            }
            return true;
        }

        bool getZoomValue(out double zoom)
        {
            zoom = 0;
            Dictionary<PREF_PARAM, object> dict =
                mCommand.GetPreference();
            if (dict == null)
                return false;
            object o;
            if (dict.TryGetValue(PREF_PARAM.RES_VIEW_ZOOM_VALUE, out o))
            {
                string s = o as string;
                if (s != null)
                {
                    if (double.TryParse(s, out zoom))
                    {
                        return true;
                    }
                }
            }
            return false;
        }
        bool setZoomValue(double zoom)
        {
            Dictionary<PREF_PARAM, object> dict =
                mCommand.GetPreference();
            if (dict == null)
                return false;


            dict.Remove(PREF_PARAM.RES_VIEW_ZOOM_VALUE);
            dict.Add(PREF_PARAM.RES_VIEW_ZOOM_VALUE, zoom.ToString());
            return true;
        }
    }

}
