﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows;

namespace NT2chCtrl2
{
    class ListItemViewPopup : Popup
    {
 
        IThread2 mThread;
        ICommand2 mCommand;

        public ListItemViewPopup(IThread2 ithread, ICommand2 command, bool exsitsLog) : base()
        {
            mThread = ithread;
            mCommand = command;

            string title = ithread.getTitle().Trim();
            if (title.Length > 20)
                title = title.Substring(0, 20);

            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;


            StackPanel panel = new StackPanel();
            Border border = new Border();
            border.BorderThickness = new System.Windows.Thickness(1);
            border.BorderBrush = new SolidColorBrush(Colors.DarkGray);


            ListBoxItem item1 = new ListBoxItem();

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run(title)));
            item1.Content = sp;
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new Separator());
            item1 = new ListBoxItem();
            item1.BorderBrush = new SolidColorBrush(Colors.LightGray);
            item1.BorderThickness = new System.Windows.Thickness(1);
            item1.Height = 1;
            item1.Content = sp;
            panel.Children.Add(item1);
            panel.Background = new SolidColorBrush(Colors.White);


            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("類似スレを検索")));
            sp.MouseLeftButtonDown += itemSearchSimilarTitle_MouseLeftButtonDown;
            sp.Tag = ithread;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("ログを削除")));
            sp.MouseLeftButtonDown += itemDeleteLog_MouseLeftButtonDown;
            sp.Tag = ithread;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            if (!exsitsLog)
                item1.IsEnabled = false;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("次スレ作成")));
            sp.MouseLeftButtonDown += itemCreateNextThread_MouseLeftButtonDown;
            sp.Tag = ithread;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("アドレスを表示")));
            sp.MouseLeftButtonDown += itemShowAddress_MouseLeftButtonDown;
            sp.Tag = ithread;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("閉じる")));
            sp.MouseLeftButtonDown += itemClose_MouseLeftButtonDown;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);
            border.Child = panel;
            this.Child = border;

        }


        public void show()
        {
            IsOpen = true;
            Placement = PlacementMode.Mouse;
            Focus();
            this.StaysOpen = false;
      
        }

        string parse2chAddress(string address, string dat)
        {
            if (address == null)
                return string.Empty;

            int len = address.Length;
            if(len == 0)
                return string.Empty;

            string address1;
            string dat1;
            if (dat == null)
                dat1 = string.Empty;
            else
                dat1 = dat;


            int idx = address.IndexOf("machi.to");
            if (idx >= 0)
            {
                idx += "machi.to".Length;
                address1 = address.Substring(0, idx);
                address1 += "/bbs/read.cgi" + address.Substring(idx);
                idx = dat1.IndexOf(".cgi");
                if (idx >= 0)
                {
                    dat1 = dat.Substring(0, idx) + "/";
                }
            }
            else
            {
                idx = address.LastIndexOf('/', len - 2);
                if (idx <= 0)
                    return string.Empty;

                address1 = address.Substring(0, idx);
                address1 += "/test/read.cgi" + address.Substring(idx);
                idx = dat1.IndexOf(".dat");
                if (idx >= 0)
                {
                    dat1 = dat.Substring(0, idx) + "/";
                }
            }

            if (dat != null)
                address1 += dat1;

            return address1;
        }


        void itemCreateNextThread_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            string msg;
            IBoard iboard;

            if (mThread != null)
            {
                string caption = mThread.getTitle();
                iboard = mThread.getBoard();
                if (iboard != null)
                {
                    string address = parse2chAddress(iboard.getAddress(), mThread.getDatName());
                    msg = "前スレ\n" +
                        caption + "\n" +
                        address + "\n";
                    mCommand.CreateThread(iboard, caption, msg);
                }
            }
        }

        void itemShowAddress_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            string caption = string.Empty;
            string address = string.Empty;
            if (mThread != null)
            {
                caption = mThread.getTitle();
                IBoard iboard = mThread.getBoard();
                if (iboard != null)
                    address = parse2chAddress(iboard.getAddress(), mThread.getDatName());
            }
            mCommand.ShowThreadInfoWindow(caption, address);
            //MessageBox.Show(address, caption);

        }
        void itemDeleteLog_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            mCommand.DeleteLog(mThread);

        }

        void itemSearchSimilarTitle_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            mCommand.SearchSimilarTitle(mThread);

        }

        void itemClose_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;
        }
    }
}
