/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer;

import java.io.*;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceNotFoundException;

/**
 * WóEWG[o͂ւ̏o͂s{@link MessageWriter}T[rXB<p>
 * ȉɁAT[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="ConsoleWriter"
 *                  code="jp.ossc.nimbus.service.writer.ConsoleMessageWriterService"&gt;
 *             &lt;attribute name="Output"&gt;STDOUT&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author y-tokuda
 */
public class ConsoleMessageWriterService extends ServiceBase
 implements ConsoleMessageWriterServiceMBean, MessageWriter{
    
    private static final long serialVersionUID = 4209363683339544273L;
    
    /** o͎ */
    private String outputKind = OUTPUT_STDOUT;
    
    /** o̓Xg[T[rX */
    private ServiceName outputStreamServiceName;
    
    /** o̓Xg[ */
    private transient PrintStream outputStream = System.out;
    
    // ConsoleMessageWriterServiceMBean JavaDoc
    public void setOutput(String kind){
        if(OUTPUT_STDOUT.equals(kind)
            || OUTPUT_STDERR.equals(kind)){
            outputKind = kind;
        }
        else{
            throw new IllegalArgumentException(kind);
        }
        if(outputKind.equals(OUTPUT_STDERR)){
            outputStream = System.err;                
        }
        else{
            outputStream = System.out;
        }
    }
    
    // ConsoleMessageWriterServiceMBean JavaDoc
    public String getOutput(){
        return outputKind;
    }
    
    // ConsoleMessageWriterServiceMBean JavaDoc
    public void setOutputPrintStreamServiceName(ServiceName name){
        outputStreamServiceName = name;
    }
    // ConsoleMessageWriterServiceMBean JavaDoc
    public ServiceName getOutputPrintStreamServiceName(){
        return outputStreamServiceName;
    }
    
    public void setOutputPrintStream(PrintStream ps){
        outputStream = ps;
        if(System.out.equals(ps)){
            outputKind = OUTPUT_STDOUT;
        }else if(System.err.equals(ps)){
            outputKind = OUTPUT_STDERR;
        }else{
            outputKind = null;
        }
    }
    public PrintStream getOutputPrintStream(){
        return outputStream;
    }
    
    @Override
    public void startService() throws Exception{
        if(outputStreamServiceName != null){
            setOutputPrintStream(ServiceManagerFactory.<PrintStream>getServiceObject(outputStreamServiceName));
        }
    }
    
    // MessageWriter JavaDoc
    public void write(WritableRecord rec){
        outputStream.println(rec.toString());
    }
    
    /**
     * fVACYsB<p>
     *
     * @param in fVACY̌ƂȂXg[
     * @exception IOException ǂݍ݂Ɏsꍇ
     * @exception ClassNotFoundException fVACY悤ƂIuWFNg̃NXȂꍇ
     */
    private void readObject(ObjectInputStream in)
     throws IOException, ClassNotFoundException{
        in.defaultReadObject();
        if(outputStreamServiceName != null){
            try{
                setOutputPrintStream(ServiceManagerFactory.<PrintStream>getServiceObject(outputStreamServiceName));
            }catch(ServiceNotFoundException e){
                setOutput(OUTPUT_STDOUT);
            }
        }else if(outputKind != null){
            setOutput(outputKind);
        }
    }
}
