/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import java.sql.Connection;
import java.util.Map;

/**
 * iǗB<p>
 *
 * @author M.Takata
 */
public interface PersistentManager{
    
    /**
     * f[^x[XǂݍށB<p>
     * w肳ꂽqueryɎw肳ꂽinput̏𖄂ߍݎsāAsʂResultSetw肳ꂽoutputɋl߂ĕԂB<br>
     * p[^querýAߍ݃NGŁASQLinputǂnoutputɂǂl߂ĕԂw肷Bp[^input̏𖄂ߍޏꍇ́A"<-{vpeB}"ŖߍށB܂AsʂResultSetAoBeanɋl߂ɂ́A"->{vpeB}"ŖߍށB<br>
     * <pre>
     *   Fselect USER.NAME->{Header(user).name}, MAIL.ADDRESS->{RecordList(mail).address}, from USER, MAIL where USER.ID = ?<-{Id} and USER.ID = MAIL.ID
     * </pre>
     *
     * @param con RlNV
     * @param query ߍ݃NG
     * @param input Bean
     * @param output oBean
     * @return f[^x[Xǂݍ񂾏oBean
     * @exception PersistentException ǂݍ݂Ɏsꍇ
     */
    public Object loadQuery(Connection con, String query, Object input, Object output) throws PersistentException;
    
    /**
     * f[^x[XǂݍށB<p>
     * w肳ꂽqueryɎw肳ꂽinput̏𖄂ߍݎsāAsʂResultSetw肳ꂽoutputɋl߂ĕԂB<br>
     * p[^querýAߍ݃NGŁASQLinputǂnoutputɂǂl߂ĕԂw肷Bp[^input̏𖄂ߍޏꍇ́A"<-{vpeB}"ŖߍށB܂AsʂResultSetAoBeanɋl߂ɂ́A"->{vpeB}"ŖߍށB<br>
     * <pre>
     *   Fselect USER.NAME->{Header(user).name}, MAIL.ADDRESS->{RecordList(mail).address}, from USER, MAIL where USER.ID = ?<-{Id} and USER.ID = MAIL.ID
     * </pre>
     *
     * @param con RlNV
     * @param query ߍ݃NG
     * @param input Bean
     * @param output oBean
     * @param statementProps java.sql.Statementɑ΂vpeB̃}bv
     * @param resultSetProps java.sql.ResultSetɑ΂vpeB̃}bv
     * @return f[^x[Xǂݍ񂾏oBean
     * @exception PersistentException ǂݍ݂Ɏsꍇ
     */
    public Object loadQuery(Connection con, String query, Object input, Object output, Map<String, Object> statementProps, Map<String, Object> resultSetProps) throws PersistentException;
    
    /**
     * f[^x[XǂݍށB<p>
     *
     * @param con RlNV
     * @param sql ߍSQL
     * @param input Bean
     * @param inputProps BeanƓ̓p[^̃}bsOBvpeBStringAString[]A܂List<String>
     * @param output oBean
     * @param outputProps oBeanƗ񖼂̃}bsOBvpeBStringAString[]A܂List<String>A܂̓L[񖼂ŒlvpeBƂȂMap<String, String>
     * @return f[^x[Xǂݍ񂾏oBean
     * @exception PersistentException ǂݍ݂Ɏsꍇ
     */
    public Object load(Connection con, String sql, Object input, Object inputProps, Object output, Object outputProps) throws PersistentException;
    
    /**
     * f[^x[XǂݍށB<p>
     *
     * @param con RlNV
     * @param sql ߍSQL
     * @param input Bean
     * @param inputProps BeanƓ̓p[^̃}bsOBvpeBStringAString[]A܂List<String>
     * @param output oBean
     * @param outputProps oBeanƗ񖼂̃}bsOBvpeBStringAString[]A܂List<String>A܂̓L[񖼂ŒlvpeBƂȂMap<String, String>
     * @param statementProps java.sql.Statementɑ΂vpeB̃}bv
     * @param resultSetProps java.sql.ResultSetɑ΂vpeB̃}bv
     * @return f[^x[Xǂݍ񂾏oBean
     * @exception PersistentException ǂݍ݂Ɏsꍇ
     */
    public Object load(Connection con, String sql, Object input, Object inputProps, Object output, Object outputProps, Map<String, Object> statementProps, Map<String, Object> resultSetProps) throws PersistentException;
    
    /**
     * f[^x[XǂݍރJ[\𐶐B<p>
     *
     * @param con RlNV
     * @param query ߍ݃NG
     * @param input Bean
     * @return J[\
     * @exception PersistentException J[\̍쐬Ɏsꍇ
     * @see #loadQuery(Connection, String, Object, Object)
     */
    public Cursor createQueryCursor(Connection con, String query, Object input) throws PersistentException;
    
    /**
     * f[^x[XǂݍރJ[\𐶐B<p>
     *
     * @param con RlNV
     * @param query ߍ݃NG
     * @param input Bean
     * @param statementProps java.sql.Statementɑ΂vpeB̃}bv
     * @param resultSetProps java.sql.ResultSetɑ΂vpeB̃}bv
     * @return J[\
     * @exception PersistentException J[\̍쐬Ɏsꍇ
     * @see #loadQuery(Connection, String, Object, Object)
     */
    public Cursor createQueryCursor(Connection con, String query, Object input, Map<String, Object> statementProps, Map<String, Object> resultSetProps) throws PersistentException;
    
    /**
     * f[^x[XǂݍރJ[\𐶐B<p>
     *
     * @param con RlNV
     * @param sql ߍSQL
     * @param input Bean
     * @param inputProps BeanƓ̓p[^̃}bsOBvpeBStringAString[]A܂List<String>
     * @param outputProps oBeanƗ񖼂̃}bsOBvpeBStringAString[]A܂List<String>A܂̓L[񖼂ŒlvpeBƂȂMap<String, String>
     * @return J[\
     * @exception PersistentException J[\̍쐬Ɏsꍇ
     * @see #load(Connection, String, Object, Object, Object, Object)
     */
    public Cursor createCursor(Connection con, String sql, Object input, Object inputProps, Object outputProps) throws PersistentException;
    
    /**
     * f[^x[XǂݍރJ[\𐶐B<p>
     *
     * @param con RlNV
     * @param sql ߍSQL
     * @param input Bean
     * @param inputProps BeanƓ̓p[^̃}bsOBvpeBStringAString[]A܂List<String>
     * @param outputProps oBeanƗ񖼂̃}bsOBvpeBStringAString[]A܂List<String>A܂̓L[񖼂ŒlvpeBƂȂMap<String, String>
     * @param statementProps java.sql.Statementɑ΂vpeB̃}bv
     * @param resultSetProps java.sql.ResultSetɑ΂vpeB̃}bv
     * @return J[\
     * @exception PersistentException J[\̍쐬Ɏsꍇ
     * @see #load(Connection, String, Object, Object, Object, Object)
     */
    public Cursor createCursor(Connection con, String sql, Object input, Object inputProps, Object outputProps, Map<String, Object> statementProps, Map<String, Object> resultSetProps) throws PersistentException;
    
    /**
     * f[^x[XɏށB<p>
     * w肳ꂽsqlɎw肳ꂽinput̏𖄂ߍݎsāAXVԂB<br>
     * p[^querýAߍ݃NGŁASQLinputǂnA"<-{vpeB}"ŖߍށB<br>
     * <pre>
     *   Fupdate MAIL set ADDRESS = ?<-{RecordList(mail).address} where USER.ID = ?<-{Header(user).Id}
     * </pre>
     *
     * @param con RlNV
     * @param query ߍ݃NG
     * @param input Bean
     * @return XV
     * @exception PersistentException ݂Ɏsꍇ
     */
    public int persistQuery(Connection con, String query, Object input) throws PersistentException;
    
    /**
     * f[^x[XɏށB<p>
     * w肳ꂽsqlɎw肳ꂽinput̏𖄂ߍݎsāAXVԂB<br>
     * p[^querýAߍ݃NGŁASQLinputǂnA"<-{vpeB}"ŖߍށB<br>
     * <pre>
     *   Fupdate MAIL set ADDRESS = ?<-{RecordList(mail).address} where USER.ID = ?<-{Header(user).Id}
     * </pre>
     *
     * @param con RlNV
     * @param query ߍ݃NG
     * @param input Bean
     * @param statementProps java.sql.Statementɑ΂vpeB̃}bv
     * @return XV
     * @exception PersistentException ݂Ɏsꍇ
     */
    public int persistQuery(Connection con, String query, Object input, Map<String, Object> statementProps) throws PersistentException;
    
    /**
     * f[^x[XɏށB<p>
     *
     * @param con RlNV
     * @param sql ߍSQL
     * @param input ̓p[^̔z
     * @param inputProps BeanƓ̓p[^̃}bsOBvpeBStringAString[]A܂List<String>
     * @return XV
     * @exception PersistentException ݂Ɏsꍇ
     */
    public int persist(Connection con, String sql, Object input, Object inputProps) throws PersistentException;
    
    /**
     * f[^x[XɏށB<p>
     *
     * @param con RlNV
     * @param sql ߍSQL
     * @param input ̓p[^̔z
     * @param inputProps BeanƓ̓p[^̃}bsOBvpeBStringAString[]A܂List<String>
     * @param statementProps java.sql.Statementɑ΂vpeB̃}bv
     * @return XV
     * @exception PersistentException ݂Ɏsꍇ
     */
    public int persist(Connection con, String sql, Object input, Object inputProps, Map<String, Object> statementProps) throws PersistentException;
    
    /**
     * f[^x[XɃob`ssBatchExecutor𐶐B<p>
     *
     * @param con RlNV
     * @param query ߍ݃NG
     * @return BatchExecutor
     * @exception PersistentException BatchExecutor̐Ɏsꍇ
     */
    public BatchExecutor createQueryBatchExecutor(Connection con, String query) throws PersistentException;
    
    /**
     * f[^x[XɃob`ssBatchExecutor𐶐B<p>
     *
     * @param con RlNV
     * @param query ߍ݃NG
     * @param statementProps java.sql.Statementɑ΂vpeB̃}bv
     * @return BatchExecutor
     * @exception PersistentException BatchExecutor̐Ɏsꍇ
     */
    public BatchExecutor createQueryBatchExecutor(Connection con, String query, Map<String, Object> statementProps) throws PersistentException;
    
    /**
     * f[^x[XɃob`ssBatchExecutor𐶐B<p>
     *
     * @param con RlNV
     * @param sql ߍSQL
     * @param inputProps BeanƓ̓p[^̃}bsOBvpeBStringAString[]A܂List<String>
     * @return BatchExecutor
     * @exception PersistentException BatchExecutor̐Ɏsꍇ
     */
    public BatchExecutor createBatchExecutor(Connection con, String sql, Object inputProps) throws PersistentException;
    
    /**
     * f[^x[XɃob`ssBatchExecutor𐶐B<p>
     *
     * @param con RlNV
     * @param sql ߍSQL
     * @param statementProps java.sql.Statementɑ΂vpeB̃}bv
     * @param inputProps BeanƓ̓p[^̃}bsOBvpeBStringAString[]A܂List<String>
     * @return BatchExecutor
     * @exception PersistentException BatchExecutor̐Ɏsꍇ
     */
    public BatchExecutor createBatchExecutor(Connection con, String sql, Object inputProps, Map<String, Object> statementProps) throws PersistentException;
    
    /**
     * ǂݍ݃J[\B<p>
     *
     * @author M.Takata
     */
    public interface Cursor{
        
        /**
         * ̍sɈړB<p>
         *
         * @return ̍s݂ꍇ́Atrue
         * @exception PersistentException ړɎsꍇ
         */
        public boolean next() throws PersistentException;
        
        /**
         * O̍sɈړB<p>
         *
         * @return O̍s݂ꍇ́Atrue
         * @exception PersistentException ړɎsꍇ
         */
        public boolean previous() throws PersistentException;
        
        /**
         * 擪̍sɈړB<p>
         *
         * @return 擪̍s݂ꍇ́Atrue
         * @exception PersistentException ړɎsꍇ
         */
        public boolean first() throws PersistentException;
        
        /**
         * Ō̍sɈړB<p>
         *
         * @return Ō̍s݂ꍇ́Atrue
         * @exception PersistentException ړɎsꍇ
         */
        public boolean last() throws PersistentException;
        
        /**
         * 擪̍s̑OɈړB<p>
         *
         * @exception PersistentException ړɎsꍇ
         */
        public void beforeFirst() throws PersistentException;
        
        /**
         * Ō̍šɈړB<p>
         *
         * @exception PersistentException ړɎsꍇ
         */
        public void afterLast() throws PersistentException;
        
        /**
         * w肳ꂽsɈړB<p>
         *
         * @param row sԍ
         * @exception PersistentException ړɎsꍇ
         */
        public boolean absolute(int row) throws PersistentException;
        
        /**
         * w肳ꂽsړB<p>
         *
         * @param rows s
         * @exception PersistentException ړɎsꍇ
         */
        public boolean relative(int rows) throws PersistentException;
        
        /**
         * ݂̍s擪肷B<p>
         *
         * @return 擪̏ꍇAtrue
         * @exception PersistentException Ɏsꍇ
         */
        public boolean isFirst() throws PersistentException;
        
        /**
         * ݂̍sŌォ肷B<p>
         *
         * @return Ō̏ꍇAtrue
         * @exception PersistentException Ɏsꍇ
         */
        public boolean isLast() throws PersistentException;
        
        /**
         * ݂̍s擪̑O肷B<p>
         *
         * @return 擪̑ȌꍇAtrue
         * @exception PersistentException Ɏsꍇ
         */
        public boolean isBeforeFirst() throws PersistentException;
        
        /**
         * ݂̍sŌ̌ォ肷B<p>
         *
         * @return Ō̌̏ꍇAtrue
         * @exception PersistentException Ɏsꍇ
         */
        public boolean isAfterLast() throws PersistentException;
        
        /**
         * tFb`ݒ肷B<p>
         *
         * @param direction tFb`
         * @exception PersistentException ݒɎsꍇ
         * @see java.sql.ResultSet#FETCH_FORWARD
         * @see java.sql.ResultSet#FETCH_REVERSE
         * @see java.sql.ResultSet#FETCH_UNKNOWN
         */
        public void setFetchDirection(int direction) throws PersistentException;
        
        /**
         * tFb`擾B<p>
         *
         * @return tFb`
         * @exception PersistentException 擾Ɏsꍇ
         * @see java.sql.ResultSet#FETCH_FORWARD
         * @see java.sql.ResultSet#FETCH_REVERSE
         * @see java.sql.ResultSet#FETCH_UNKNOWN
         */
        public int getFetchDirection() throws PersistentException;
        
        /**
         * tFb`sݒ肷B<p>
         *
         * @param rows tFb`s
         * @exception PersistentException ݒɎsꍇ
         */
        public void setFetchSize(int rows) throws PersistentException;
        
        /**
         * tFb`s擾B<p>
         *
         * @return tFb`s
         * @exception PersistentException 擾Ɏsꍇ
         */
        public int getFetchSize() throws PersistentException;
        
        /**
         * ݂̍sԍ擾B<p>
         *
         * @return ݂̍sԍ
         * @exception PersistentException 擾Ɏsꍇ
         */
        public int getRow() throws PersistentException;
        
        /**
         * f[^x[XǂݍށB<p>
         *
         * @param output oBean
         * @return f[^x[Xǂݍ񂾏oBean
         * @exception PersistentException ǂݍ݂Ɏsꍇ
         */
        public Object load(Object output) throws PersistentException;
        
        /**
         * \[XJǂ肷B<p>
         * 
         * @return \[XJĂꍇtrue
         */
        public boolean isClosed();
        
        /**
         * \[XJB<p>
         */
        public void close();
    }
    
    /**
     * ob`sB<p>
     *
     * @author M.Takata
     */
    public interface BatchExecutor{
        
        /**
         * ob`šݒ肷B<p>
         * ob`sɁAw茏̃ob`o^܂ƎIɃob`ssB<br>
         *
         * @param count ob`s
         */
        public void setAutoBatchPersistCount(int count);
        
        /**
         * ob`š擾B<p>
         *
         * @return ob`s
         */
        public int getAutoBatchPersistCount();
        
        /**
         * ob`sɁAIɃR~bgsǂݒ肷B<p>
         * ftHgfalseŁAR~bgsȂB<br>
         *
         * @param isCommit IɃR~bgsꍇtrue
         */
        public void setAutoCommitOnPersist(boolean isCommit);
        
        /**
         * ob`sɁAIɃR~bgsǂ𔻒肷B<p>
         *
         * @return truȅꍇAIɃR~bgs
         */
        public boolean isAutoCommitOnPersist();
        
        /**
         * ob`o^sB<p>
         *
         * @param input Bean
         * @return ob`s̏ꍇŁAob`ssꂽ̍XV
         * @exception PersistentException ob`o^Ɏsꍇ
         */
        public int addBatch(Object input) throws PersistentException;
        
        /**
         * f[^x[XɃob`sŏށB<p>
         *
         * @return XV
         * @exception PersistentException ob`sɎsꍇ
         */
        public int persist() throws PersistentException;
        
        /**
         * ob`o^NAB<p>
         * 
         * @exception PersistentException ob`o^̃NAɎsꍇ
         */
        public void clearBatch() throws PersistentException;
        
        /**
         * \[XJB<p>
         */
        public void close();
    }
}