/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.Date;

/**
 * XPW[}X^B<p>
 * t̊TOȂXPW[̃}X^B<br>
 *
 * @author M.Takata
 */
public interface ScheduleMaster extends Comparable<ScheduleMaster>, Cloneable{
    
    /**
     * XPW[}X^ID擾B<p>
     *
     * @return XPW[}X^ID
     */
    public String getId();
    
    /**
     * XPW[ꂽ^XN擾B<p>
     *
     * @return ^XN
     */
    public String getTaskName();
    
    /**
     * XPW[ꂽXPW[̎ʂ擾B<p>
     *
     * @return XPW[
     */
    public String getScheduleType();
    
    /**
     * XPW[̓̓f[^擾B<p>
     *
     * @return ̓f[^
     */
    public Object getInput();
    
    /**
     * XPW[Jn擾B<p>
     *
     * @return Jn
     */
    public Date getStartTime();
    
    /**
     * XPW[I擾B<p>
     *
     * @return I
     */
    public Date getEndTime();
    
    /**
     * XPW[JԂsԊu[ms]擾B<p>
     *
     * @return JԂsԊu
     */
    public long getRepeatInterval();
    
    /**
     * XPW[gCsԊu[ms]擾B<p>
     *
     * @return gCsԊu
     */
    public long getRetryInterval();
    
    /**
     * XPW[gCI擾B<p>
     *
     * @return gCI
     */
    public Date getRetryEndTime();
    
    /**
     * XPW[̍őx[ms]擾B<p>
     *
     * @return XPW[őx
     */
    public long getMaxDelayTime();
    
    /**
     * ̃XPW[Lǂ𔻒肷B<p>
     *
     * @return Lȏꍇtrue
     */
    public boolean isEnabled();
    
    /**
     * ̃XPW[Lǂݒ肷B<p>
     *
     * @param isEnabled truȅꍇAL
     */
    public void setEnabled(boolean isEnabled);
    
    /**
     * ˑXPW[}X^ID擾B<p>
     *
     * @return XPW[}X^ID̔z
     */
    public String[] getDepends();
    
    /**
     * UŎs{@link ScheduleExecutor}w肷L[ݒ肷B<p>
     *
     * @param key ScheduleExecutor肷L[
     */
    public void setExecutorKey(String key);
    
    /**
     * UŎs{@link ScheduleExecutor}w肷L[擾B<p>
     *
     * @return ScheduleExecutor肷L[
     */
    public String getExecutorKey();
    
    /**
     * {@link ScheduleExecutor}̎ނݒ肷B<p>
     *
     * @param type ScheduleExecutor̎
     */
    public void setExecutorType(String type);
    
    /**
     * {@link ScheduleExecutor}̎ނ擾B<p>
     *
     * @return ScheduleExecutor̎
     */
    public String getExecutorType();
    
    /**
     * tKpB<p>
     *
     * @param date t
     */
    public void applyDate(Date date);
    
    /**
     * 쐬B<p>
     *
     * @return 
     */
    public Object clone();
}