/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectInput;

import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;

/**
 * LReLXgp̃R[hB<p>
 * XVT|[gB<br>
 *
 * @author M.Takata
 */
public class SharedContextRecord extends Record implements SharedContextValueDifferenceSupport{
    
    protected SharedContextRecordList recordList;
    protected int index = -1;
    protected int updateVersion;
    
    /**
     * `̃R[h𐶐B<p>
     */
    public SharedContextRecord(){
    }
    
    /**
     * R[h𐶐B<p>
     *
     * @param schema XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public SharedContextRecord(String schema) throws PropertySchemaDefineException{
        super(schema);
    }
    
    /**
     * R[h𐶐B<p>
     *
     * @param recordSchema XL[}񂩂琶ꂽR[hXL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public SharedContextRecord(RecordSchema recordSchema){
        super(recordSchema);
    }
    
    /**
     * eƂȂ郌R[hXgݒ肷B<p>
     *
     * @param list R[hXg
     */
    protected void setRecordList(SharedContextRecordList list){
        recordList = list;
    }
    
    /**
     * eƂȂ郌R[hXg擾B<p>
     *
     * @return R[hXg
     */
    protected SharedContextRecordList getRecordList(){
        return recordList;
    }
    
    /**
     * eƂȂ郌R[hXgł̃CfbNXݒ肷B<p>
     *
     * @param index CfbNX
     */
    protected void setIndex(int index){
        this.index = index;
    }
    
    /**
     * eƂȂ郌R[hXgł̃CfbNX擾B<p>
     *
     * @return CfbNX
     */
    public int getIndex(){
        return index;
    }
    
    @Override
    public void setUpdateVersion(int version){
        updateVersion = version;
    }
    
    @Override
    public int getUpdateVersion(){
        return updateVersion;
    }
    
    protected static int compareToUpdateVersion(int ver1, int ver2){
        long version1 = ver1;
        long version2 = ver2;
        final long middle = ((long)Integer.MAX_VALUE - (long)Integer.MIN_VALUE) / 2l;
        
        if(version1 == version2){
            return 0;
        }else{
            if(version1 > version2){
                if((version1 - version2) > middle){
                    version1 = version1 - (long)Integer.MAX_VALUE;
                    return version1 > version2 ? 1 : -1;
                }else{
                    return 1;
                }
            }else{
                if((version2 - version1) > middle){
                    version2 = version2 - (long)Integer.MAX_VALUE;
                    return version1 > version2 ? -1 : 1;
                }else{
                    return -1;
                }
            }
        }
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, Object val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        RecordSchema recordSchema = getRecordSchema();
        if(recordSchema == null){
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        final PropertySchema propertySchema = recordSchema.getPropertySchema(name);
        if(propertySchema == null){
            throw new PropertySetException(null, "No such property : " + name);
        }
        return updateProperty(recordSchema.getPropertyIndex(name), val, diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, Object val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        if(getRecordList() == null){
            if(diff == null){
                diff = new Difference();
            }else if(!(diff instanceof Difference)){
                throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
            }
            ((Difference)diff).updateProperty(this, index, val);
        }else{
            if(diff == null){
                diff = new SharedContextRecordList.Difference();
            }else if(!(diff instanceof SharedContextRecordList.Difference)){
                throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
            }
            Difference recordDiff = ((SharedContextRecordList.Difference)diff).getRecordDifference(this.index);
            if(recordDiff == null){
                recordDiff = new Difference();
            }
            recordDiff.updateProperty(this, index, val);
            ((SharedContextRecordList.Difference)diff).updateRecord(getRecordList(), this.index, recordDiff);
        }
        return diff;
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, boolean val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(name, val ? Boolean.TRUE : Boolean.FALSE, diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, boolean val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(index, val ? Boolean.TRUE : Boolean.FALSE, diff);
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, byte val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(name, new Byte(val), diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, byte val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(index, new Byte(val), diff);
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, char val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(name, new Character(val), diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, char val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(index, new Character(val), diff);
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, short val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(name, new Short(val), diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, short val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(index, new Short(val), diff);
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, int val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(name, new Integer(val), diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, int val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(index, new Integer(val), diff);
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, long val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(name, new Long(val), diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, long val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(index, new Long(val), diff);
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, float val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(name, new Float(val), diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, float val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(index, new Float(val), diff);
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(String name, double val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(name, new Double(val), diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateProperty(int index, double val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        return updateProperty(index, new Double(val), diff);
    }
    
    /**
     * w肳ꂽÕvpeBɁAw肳ꂽlp[XčXVꍇ̍擾B<p>
     *
     * @param name vpeB
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateParseProperty(String name, Object val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        RecordSchema recordSchema = getRecordSchema();
        if(recordSchema == null){
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        final PropertySchema propertySchema = recordSchema.getPropertySchema(name);
        if(propertySchema == null){
            throw new PropertySetException(null, "No such property : " + name);
        }
        return updateProperty(recordSchema.getPropertyIndex(name), propertySchema.parse(val), diff);
    }
    
    /**
     * w肳ꂽCfbNX̃vpeBɁAw肳ꂽlp[XčXVꍇ̍擾B<p>
     *
     * @param index vpeB̃CfbNX 
     * @param val vpeB̒l
     * @param diff 
     * @return 
     * @exception PropertySetException vpeB̐ݒɎsꍇ
     * @exception SharedContextUpdateException ̎擾Ɏsꍇ
     */
    public SharedContextValueDifference updateParseProperty(int index, Object val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException{
        RecordSchema recordSchema = getRecordSchema();
        if(recordSchema == null){
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        final PropertySchema propertySchema
             = recordSchema.getPropertySchema(index);
        if(propertySchema == null){
            throw new PropertySetException(null, "No such property : " + index);
        }
        return updateProperty(index, propertySchema.parse(val), diff);
    }
    
    @Override
    public boolean update(SharedContextValueDifference diff) throws SharedContextUpdateException{
        if(!(diff instanceof Difference)){
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        return ((Difference)diff).updateRecord(this);
    }
    
    protected static void writeInt(ObjectOutput out, int val) throws IOException{
        if(val >= Byte.MIN_VALUE && val <= Byte.MAX_VALUE){
            out.writeByte((byte)1);
            out.writeByte((byte)val);
        }else if(val >= Short.MIN_VALUE && val <= Short.MAX_VALUE){
            out.writeByte((byte)2);
            out.writeShort((short)val);
        }else{
            out.writeByte((byte)3);
            out.writeInt(val);
        }
    }
    
    protected static int readInt(ObjectInput in) throws IOException{
        final int type = in.readByte();
        switch(type){
        case 1:
            return in.readByte();
        case 2:
            return in.readShort();
        default:
            return in.readInt();
        }
    }
    
    @Override
    protected void writeExternalValues(ObjectOutput out) throws IOException{
        super.writeExternalValues(out);
        SharedContextRecord.writeInt(out, updateVersion);
    }
    
    @Override
    protected void readExternalValues(ObjectInput in) throws IOException, ClassNotFoundException{
        super.readExternalValues(in);
        updateVersion = SharedContextRecord.readInt(in);
    }
    
    /**
     * R[hB<p>
     *
     * @author M.Takata
     */
    public static class Difference implements SharedContextValueDifference, Externalizable{
        private int updateVersion;
        private Map<Integer,Object> updateValueMap;
        
        @Override
        public int getUpdateVersion(){
            return updateVersion;
        }
        
        /**
         * w肳ꂽvpeB̍XVi[B<p>
         * ݂̃vpeB̒lƍȂꍇ́AB<br>
         *
         * @param record XVΏۂ̃R[h
         * @param index vpeB̃CfbNX
         * @param value XVl
         * @exception SharedContextUpdateException XV̊i[Ɏsꍇ
         */
        public void updateProperty(SharedContextRecord record, int index, Object value) throws SharedContextUpdateException{
            Integer key = new Integer(index);
            try{
                Object old = record.getProperty(index);
                if((old == null && value != null)
                    || (old != null && value == null)
                    || (old != null && !old.equals(value))
                ){
                    if(updateValueMap == null){
                        updateValueMap = new HashMap<Integer,Object>();
                    }
                    updateValueMap.put(key, value);
                }else if(updateValueMap != null && updateValueMap.containsKey(key)){
                    updateValueMap.remove(key);
                }
            }catch(PropertyGetException e){
                throw new SharedContextUpdateException(e);
            }
            updateVersion = record.getUpdateVersion() + 1;
        }
        
        /**
         * w肳ꂽR[hɍXV𔽉fB<p>
         *
         * @param record XVΏۂ̃R[h
         * @return XVo[WvȂꍇfalse
         * @exception SharedContextUpdateException XV̔fɎsꍇ
         */
        public boolean updateRecord(SharedContextRecord record) throws SharedContextUpdateException{
            if(updateValueMap != null && updateValueMap.size() != 0){
                if(SharedContextRecord.compareToUpdateVersion(record.getUpdateVersion(), updateVersion) >= 0){
                    return true;
                }else if(record.getUpdateVersion() + 1 != updateVersion){
                    return false;
                }
                try{
                    for(Iterator<Map.Entry<Integer,Object>> itr = updateValueMap.entrySet().iterator(); itr.hasNext();){
                        Map.Entry<Integer,Object> entry = itr.next();
                        record.setProperty(((Integer)entry.getKey()).intValue(), entry.getValue());
                    }
                }catch(PropertySetException e){
                    throw new SharedContextUpdateException(e);
                }
            }
            record.setUpdateVersion(updateVersion);
            return true;
        }
        
        /**
         * XV̂vpeB̃CfbNX擾B<p>
         *
         * @return CfbNX̔zBXVȂꍇ́Anull
         */
        public int[] getUpdatePropertyIndexs(){
            if(updateValueMap == null || updateValueMap.size() == 0){
                return null;
            }
            int[] result = new int[updateValueMap.size()];
            int index = 0;
            for(Iterator<Integer> itr = updateValueMap.keySet().iterator(); itr.hasNext();){
                result[index++] = itr.next().intValue();
            }
            return result;
        }
        
        /**
         * w肳ꂽvpeB̍XVꂽl擾B<p>
         *
         * @param index vpeB̃CfbNX
         * @return vpeB̒lBXVĂȂꍇ́Anull
         */
        public Object getUpdateProperty(int index){
            return updateValueMap == null ? null : updateValueMap.get(index);
        }
        
        /**
         * w肳ꂽvpeB̍XV폜B<p>
         *
         * @param index vpeB̃CfbNX
         */
        public void removeUpdateProperty(int index){
            if(updateValueMap != null){
                updateValueMap.remove(index);
            }
        }
        
        /**
         * w肳ꂽvpeBXVꂽ𔻒肷B<p>
         *
         * @param index vpeB̃CfbNX
         * @return XVꂽꍇ́Atrue
         */
        public boolean isUpdate(int index){
            return updateValueMap == null ? false : updateValueMap.containsKey(index);
        }
        
        /**
         * XVꂽ𔻒肷B<p>
         *
         * @return XVꂽꍇ́Atrue
         */
        @Override
        public boolean isUpdate(){
            return updateValueMap != null && updateValueMap.size() != 0;
        }
        
        @Override
        public void writeExternal(ObjectOutput out) throws IOException{
            out.writeObject(updateValueMap);
            SharedContextRecord.writeInt(out, updateVersion);
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException{
            updateValueMap = (Map<Integer,Object>)in.readObject();
            updateVersion = SharedContextRecord.readInt(in);
        }
    }
}