/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import java.util.Set;

/**
 * ULReLXgB<p>
 *
 * @author M.Takata
 */
public interface DistributedSharedContext<K> extends SharedContext<K>{
    
    /**
     * nbVLǂݒ肷B<p>
     * ftHǵAtrueŗLB<br>
     *
     * @param isEnabled LɂꍇAtrue
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void setRehashEnabled(boolean isEnabled) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * nbVLǂ𔻒肷B<p>
     *
     * @return truȅꍇANCAg[h
     */
    public boolean isRehashEnabled();
    
    /**
     * ReLXgU̍ĔzusB<p>
     * m[h̏ꍇ́ASẴm[hɍĔzu߂oBm[hłȂꍇ́Am[hɍĔzu𑣂B<br>
     *
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void rehash() throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * ReLXgU̍ĔzusB<p>
     * m[h̏ꍇ́ASẴm[hɍĔzu߂oBm[hłȂꍇ́Am[hɍĔzu𑣂B<br>
     *
     * @param timeout ^CAEg
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public void rehash(long timeout) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽL[ǂ̃f[^m[hɊi[邩̃CfbNX擾B<p>
     *
     * @param key L[
     * @return f[^m[h̃CfbNX
     */
    public int getDataNodeIndex(Object key);
    
    /**
     * w肳ꂽCfbNX̃f[^m[hɓo^ĂL[̐擾B<p>
     *
     * @param nodeIndex f[^m[h̃CfbNX
     * @return L[̐
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public int size(int nodeIndex) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽCfbNX̃f[^m[h̃L[̏W擾B<p>
     *
     * @param nodeIndex f[^m[h̃CfbNX
     * @return L[̏W
     * @exception SharedContextSendException UT[oւ̃bZ[WMɎsꍇ
     * @exception SharedContextTimeoutException UT[ỏ҂Ń^CAEgꍇ
     */
    public Set<K> keySet(int nodeIndex) throws SharedContextSendException, SharedContextTimeoutException;
    
    /**
     * w肳ꂽCfbNX̃f[^m[hNCAg[hǂ𔻒肷B<p>
     *
     * @param nodeIndex f[^m[h̃CfbNX
     * @return truȅꍇANCAg[h
     */
    public boolean isClient(int nodeIndex);
    
    /**
     * w肳ꂽCfbNX̃f[^m[hm[hǂ𔻒肷B<p>
     *
     * @param nodeIndex f[^m[h̃CfbNX
     * @return truȅꍇAm[h
     */
    public boolean isMain(int nodeIndex);
}
