/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.util.*;
import java.lang.reflect.*;
import java.io.*;

import jp.ossc.nimbus.beans.dataset.*;

/**
 * CfbNXvpeBB<p>
 * CӂBeańAvpeB̃CfbNXtvpeBɃANZX邽߂{@link Property}B<br>
 * <p>
 * ȉ̂悤ȃCfbNXtvpeBɃANZX^CvZ[tȃR[hB<br>
 * <pre>
 *   Object propValue = obj.getHoge(0);
 *   obj.setHoge(0, propValue);
 * </pre>
 * CfbNXvpeBgŁÃR[h<br>
 * <pre>
 *   IndexedProperty prop = new IndexedProperty();
 *   prop.parse("hoge[0]");
 *   Object propValue = prop.getProperty(obj);
 *   prop.setProperty(obj, propValue);
 * </pre>
 * ƂR[hɒu鎖łB<br>
 * ̃R[h́A璷ɂȂĂ邪AΏۂƂȂBeaň^⃁\bh^CvZ[tɏȂIȃR[hɂȂĂB<br>
 * <p>
 * ̃CfbNXvpeBł́Aȉ̂悤BeañvpeBɑ΂ANZX@pӂĂB<br>
 * <table border="1">
 *   <tr bgcolor="#CCCCFF"><th rowspan="3">ANZX@</th><th>Java\</th><th rowspan="3">vpeB\</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>vpeB擾</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>vpeBݒ</th></tr>
 *   <tr><td rowspan="2">CfbNXtvpeB</td><td>bean.getHoge(0)</td><td rowspan="2">hoge[0]</td></tr>
 *   <tr><td>bean.setHoge(0, value)</td></tr>
 *   <tr><td rowspan="2">CfbNXt߂liz^j̒PvpeB</td><td>((Object[])bean.getHoge())[0]</td><td rowspan="2">hoge[0]</td></tr>
 *   <tr><td>((Object[])bean.getHoge())[0] = value</td></tr>
 *   <tr><td rowspan="2">CfbNXt߂lijava.util.Listj̒PvpeB</td><td>((java.util.List)bean.getHoge()).get(0)</td><td rowspan="2">hoge[0]</td></tr>
 *   <tr><td>((java.util.List)bean.getHoge()).set(0, value)</td></tr>
 *   <tr><td rowspan="2">CfbNXt߂liget(int)Aset(int, K؂Ȍ^)\bhCӂ̃NXj̒PvpeB</td><td>bean.getHoge().get(0)</td><td rowspan="2">hoge[0]</td></tr>
 *   <tr><td>bean.getHoge().set(0, value)</td></tr>
 *   <tr><td rowspan="2">z̗vf</td><td>array[0]</td><td rowspan="2">[0]</td></tr>
 *   <tr><td>array[0] = value</td></tr>
 *   <tr><td rowspan="2">java.util.List̗vf</td><td>bean.get(0)</td><td rowspan="2">[0]</td></tr>
 *   <tr><td>bean.set(0, value)</td></tr>
 * </table>
 * 
 * @author M.Takata
 */
public class IndexedProperty extends SimpleProperty implements Serializable{
    
    private static final long serialVersionUID = -3949215311238233792L;
    
    // G[bZ[W`
    private static final String MSG_00001 = "Illegal IndexedProperty : ";
    private static final String MSG_00002
        = "Length of property literal must be not null.";
    private static final String RECORD_PROP_NAME = "Property";
    
    /**
     * CfbNXvpeBGetter\bhB<p>
     */
    protected static final String GET_METHOD_NAME = "get";
    
    /**
     * CfbNXvpeBGetter\bḧ^zB<p>
     */
    protected static final Class<?>[] GET_METHOD_ARGS = new Class[]{int.class};
    
    /**
     * CfbNXvpeBSetter\bhB<p>
     */
    protected static final String SET_METHOD_NAME = "set";
    
    /**
     * CfbNXB<p>
     */
    protected int index;
    
    /**
     * CfbNXvpeBGetter\bhLbVB<p>
     */
    protected transient Map<Class<?>, Method> indexedReadMethodCache = new HashMap<Class<?>, Method>();
    
    /**
     * CfbNXvpeBSetter\bhLbVB<p>
     */
    protected transient Map<Class<?>, Object> indexedWriteMethodCache = new HashMap<Class<?>, Object>();
    
    /**
     * ̃CfbNXvpeB𐶐B<p>
     */
    public IndexedProperty(){
        super();
    }
    
    /**
     * w肵vpeBŁACfbNX0̃CfbNXvpeB𐶐B<p>
     *
     * @param name vpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public IndexedProperty(String name) throws IllegalArgumentException{
        super(name);
    }
    
    /**
     * w肵vpeBƃCfbNX̃CfbNXvpeB𐶐B<p>
     *
     * @param name vpeB
     * @param index CfbNX
     * @exception IllegalArgumentException namenullw肵ꍇ
     */
    public IndexedProperty(String name, int index)
     throws IllegalArgumentException{
        super(name);
        this.index = index;
    }
    
    /**
     * ̃vpeB\vpeB擾B<p>
     *
     * @return vpeB[CfbNX]
     */
    @Override
    public String getPropertyName(){
        return super.getPropertyName() + '[' + index + ']';
    }
    
    /**
     * vpeBݒ肷B<p>
     *
     * @param prop vpeB
     * @exception IllegalArgumentException w肳ꂽvpeBnull̏ꍇ
     */
    @Override
    protected void setPropertyName(String prop)
     throws IllegalArgumentException{
        if(prop == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        property = prop;
    }
    
    /**
     * w肵vpeB͂B<p>
     * Ŏw\ȕ́A<br>
     * &nbsp;vpeB[CfbNX]<br>
     * łB<br>
     * AAvpeB͏ȗB܂ACfbNXintlłȂ΂ȂȂB<br>
     *
     * @param prop vpeB
     * @exception IllegalArgumentException w肳ꂽvpeB̃vpeBIuWFNg͂łȂꍇ
     */
    @Override
    public void parse(String prop) throws IllegalArgumentException{
        final int startIndexedDelim = prop.indexOf('[');
        final int endIndexedDelim = prop.indexOf(']');
        if(startIndexedDelim == -1 || endIndexedDelim == -1
            || endIndexedDelim - startIndexedDelim <= 1
            || endIndexedDelim != prop.length() - 1){
            throw new IllegalArgumentException(MSG_00001 + prop);
        }else{
            final String indexStr = prop.substring(
                startIndexedDelim + 1,
                endIndexedDelim
            );
            try{
                index = Integer.parseInt(indexStr);
            }catch(NumberFormatException e){
                throw new IllegalArgumentException(MSG_00001 + prop);
            }
            setPropertyName(prop.substring(0, startIndexedDelim));
        }
    }
    
    /**
     * CfbNX擾B<p>
     *
     * @return CfbNX
     */
    public int getIndex(){
        return index;
    }
    
    /**
     * CfbNXݒ肷B<p>
     *
     * @param index CfbNX
     */
    public void setIndex(int index){
        this.index = index;
    }
    
    @Override
    public Class<?> getPropertyType(Object obj) throws NoSuchPropertyException{
        return (Class<?>)getPropertyType(obj, false);
    }
    
    @Override
    public Type getPropertyGenericType(Object obj) throws NoSuchPropertyException{
        return getPropertyType(obj, true);
    }
        
    @SuppressWarnings("unchecked")
    protected Type getPropertyType(Object obj, boolean isGeneric) throws NoSuchPropertyException{
        if(obj == null){
            return java.lang.Object.class;
        }
        if(obj instanceof Record
            && RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName())){
            final Record record = (Record)obj;
            final RecordSchema recSchema = record.getRecordSchema();
            if(recSchema != null){
                final PropertySchema propSchema = recSchema.getPropertySchema(getIndex());
                if(propSchema != null){
                    final Class<?> type = propSchema.getType();
                    if(type != null){
                        return type;
                    }
                }
            }
        }
        final Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if(property.length() == 0){
            return getIndexedObjectPropertyType(clazz, isGeneric);
        }else{
            if(indexedReadMethodCache.containsKey(clazz)){
                readMethod = indexedReadMethodCache.get(clazz);
            }else{
                readMethod = getReadIndexedMethod(clazz);
                indexedReadMethodCache.put(clazz, readMethod);
            }
            if(readMethod == null){
                Method setMethod = getWriteIndexedMethod(clazz, null);
                if(setMethod != null){
                    if(indexedWriteMethodCache.containsKey(clazz)){
                        final Object methodObj
                             = indexedWriteMethodCache.get(clazz);
                        if(!(methodObj instanceof Method)){
                            Map<Class<?>, Method> overloadMap = (Map<Class<?>, Method>)methodObj;
                            if(overloadMap.size() > 2
                                || (overloadMap.size() == 2
                                        && !overloadMap.containsKey(null))
                            ){
                                return null;
                            }
                        }
                    }
                    return isGeneric ? setMethod.getGenericParameterTypes()[1] : setMethod.getParameterTypes()[1];
                }
                Type retType = null;
                try{
                    retType = isGeneric ? super.getPropertyGenericType(obj) : super.getPropertyType(obj);
                }catch(NoSuchPropertyException e){
                    throw new NoSuchPropertyException(clazz, property + '[' + index + ']');
                }
                return getIndexedObjectPropertyType(retType, isGeneric);
            }else{
                return isGeneric ? readMethod.getGenericReturnType() : readMethod.getReturnType();
            }
        }
    }
    
    @Override
    public boolean isReadable(Object obj){
        try{
            getProperty(obj);
        }catch(NoSuchPropertyException e){
            return false;
        }catch(InvocationTargetException e){
            return false;
        }
        return true;
    }
    
    @Override
    public boolean isWritable(Object obj, Class<?> clazz){
        final Class<?> objClazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if(getMethodCache.containsKey(objClazz) && getMethodCache.get(objClazz) != null){
            readMethod = getMethodCache.get(objClazz);
            return isWritableNoIndexedProperty(obj, readMethod, clazz);
        }else if(property.length() == 0){
            return isWritableIndexedObjectProperty(obj, clazz);
        }else{
            writeMethod = getWriteIndexedMethod(
                objClazz,
                clazz
            );
            if(writeMethod != null){
                return true;
            }
            Object prop = null;
            try{
                prop = super.getProperty(obj);
            }catch(NoSuchPropertyException e){
                return false;
            }catch(InvocationTargetException e){
                return false;
            }
            if(prop == null){
                return false;
            }
            return isWritableIndexedObjectProperty(prop, clazz);
        }
    }
    
    /**
     * w肵IuWFNgÃvpeB\vpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return vpeBl
     * @exception NoSuchReadablePropertyException w肳ꂽvpeBGetter݂Ȃꍇ
     * @exception NullIndexPropertyException w肳ꂽvpeB̃CfbNXt߂lAnull̏ꍇ
     * @exception NoSuchIndexPropertyException w肳ꂽBeanɁÃCfbNXvpeBCfbNX݂Ȃꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public Object getProperty(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if(getMethodCache.containsKey(clazz) && getMethodCache.get(clazz) != null){
            readMethod = getMethodCache.get(clazz);
            return getNoIndexedProperty(obj, readMethod);
        }else if(indexedReadMethodCache.containsKey(clazz)){
            readMethod = indexedReadMethodCache.get(clazz);
            return getIndexedProperty(obj, readMethod);
        }else if(property.length() == 0){
            return getIndexedObjectProperty(clazz, obj);
        }else{
            readMethod = getReadIndexedMethod(clazz);
            if(readMethod != null){
                indexedReadMethodCache.put(clazz, readMethod);
                return getIndexedProperty(obj, readMethod);
            }
            Object prop = super.getProperty(obj);
            if(prop == null){
                throw new NoSuchPropertyException(
                    clazz,
                    property + '[' + index + ']'
                );
            }
            return getIndexedObjectProperty(prop.getClass(), prop);
        }
    }
    
    /**
     * w肳ꂽNXCfbNXtGetterigetvpeB(int)j\bh擾B<p>
     * \bhȂꍇ́AnullԂB
     *
     * @param clazz ΏۂBeañNXIuWFNg
     * @return CfbNXtGetterigetvpeB(int)j\bh
     */
    protected Method getReadIndexedMethod(Class<?> clazz){
        if(!isAccessableClass(clazz)){
            final Class<?>[] interfaces = clazz.getInterfaces();
            for(Class<?> itf : interfaces){
                final Method method = getReadIndexedMethod(itf);
                if(method != null){
                    return method;
                }
            }
            final Class<?> superClass = clazz.getSuperclass();
            if(superClass != null){
                return getReadIndexedMethod(superClass);
            }
            return null;
        }
        final StringBuilder methodName = new StringBuilder(GET_METHOD_NAME);
        if(property.length() != 0){
            char capital = property.charAt(0);
            if(Character.isUpperCase(capital)){
                methodName.append(property);
            }else{
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if(property.length() > 1){
                    methodName.append(property.substring(1));
                }
            }
        }
        try{
            return clazz.getMethod(
                methodName.toString(),
                GET_METHOD_ARGS
            );
        }catch(NoSuchMethodException e){
            try{
                return clazz.getMethod(
                    property,
                    GET_METHOD_ARGS
                );
            }catch(NoSuchMethodException e2){
                return null;
            }
        }
    }
    
    /**
     * w肵IuWFNgɁÃvpeB\vpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param value ݒ肷vpeBl
     * @exception NoSuchReadablePropertyException w肳ꂽvpeBGetter݂Ȃꍇ
     * @exception NullIndexPropertyException w肳ꂽvpeB̃CfbNXt߂lAnull̏ꍇ
     * @exception NoSuchIndexPropertyException w肳ꂽBeanɁÃCfbNXvpeBCfbNX݂Ȃꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        setProperty(obj, value == null ? null : value.getClass(), value);
    }
    
    /**
     * w肵IuWFNgɁÃvpeB\vpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param type vpeB̌^
     * @param value ݒ肷vpeBl
     * @exception NoSuchReadablePropertyException w肳ꂽvpeBGetter݂Ȃꍇ
     * @exception NullIndexPropertyException w肳ꂽvpeB̃CfbNXt߂lAnull̏ꍇ
     * @exception NoSuchIndexPropertyException w肳ꂽBeanɁÃCfbNXvpeBCfbNX݂Ȃꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Class<?> type, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if(getMethodCache.containsKey(clazz) && getMethodCache.get(clazz) != null){
            readMethod = getMethodCache.get(clazz);
            setNoIndexedProperty(obj, readMethod, value);
        }else if(property.length() == 0){
            setIndexedObjectProperty(clazz, obj, value);
        }else{
            if(type == null && value != null){
                type = value.getClass();
            }
            writeMethod = getWriteIndexedMethod(
                clazz,
                type
            );
            if(writeMethod != null){
                setIndexedProperty(obj, writeMethod, value);
                return;
            }
            Object prop = super.getProperty(obj);
            if(prop == null){
                throw new NoSuchPropertyException(
                    clazz,
                    property + '[' + index + ']'
                );
            }
            setIndexedObjectProperty(prop.getClass(), prop, value);
        }
    }
    
    /**
     * w肳ꂽNXCfbNXtSetterisetvpeB(int, Ŏw肵param̃NX^)j\bh擾B<p>
     * \bhȂꍇ́AnullԂB
     *
     * @param clazz ΏۂBeañNXIuWFNg
     * @param param ݒ肷l̃NXIuWFNg
     * @return CfbNXtSetterisetvpeB(int, Ŏw肵param̃NX^)j\bh
     */
    @SuppressWarnings("unchecked")
    protected Method getWriteIndexedMethod(Class<?> clazz, Class<?> param){
        if(indexedWriteMethodCache.containsKey(clazz)){
            final Object methodObj = indexedWriteMethodCache.get(clazz);
            if(methodObj instanceof Method){
                return (Method)methodObj;
            }
            final Map<Class<?>, Method> overloadMap = (Map<Class<?>, Method>)methodObj;
            if(param == null){
                if(overloadMap.size() == 1){
                    return overloadMap.values().iterator().next();
                }else{
                    Method setMethod = overloadMap.get(null);
                    if(setMethod != null){
                        return setMethod;
                    }
                    Object[] classes = overloadMap.keySet().toArray();
                    for(Object key : classes){
                        Method method = overloadMap.get(key);
                        final Class<?>[] params = method.getParameterTypes();
                        if(setMethod == null){
                            if(!params[1].isPrimitive()){
                                setMethod = method;
                            }
                            continue;
                        }
                        if(isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                            setMethod = method;
                        }
                    }
                    final Map<Class<?>, Method> tmpOverloadMap = new HashMap<Class<?>, Method>(overloadMap);
                    tmpOverloadMap.put(null, setMethod);
                    indexedWriteMethodCache.put(clazz, tmpOverloadMap);
                    return setMethod;
                }
            }else if(overloadMap.containsKey(param)){
                return overloadMap.get(param);
            }else{
                Method setMethod = overloadMap.get(null);
                if(setMethod != null){
                    return setMethod;
                }
                final Object[] classes = overloadMap.keySet().toArray();
                final Class<?> primitiveClazz = toPrimitive(param);
                for(Object key : classes){
                    Method method = overloadMap.get(key);
                    final Class<?>[] params = method.getParameterTypes();
                    if(setMethod == null){
                        if(!isAssignableFrom(params[1], param)
                            && !params[1].equals(primitiveClazz)){
                            continue;
                        }
                        setMethod = method;
                        if(param.equals(params[0])
                            || params[0].equals(primitiveClazz)){
                            break;
                        }
                        continue;
                    }
                    if(!isAssignableFrom(params[1], param)
                         && !params[1].equals(primitiveClazz)){
                        continue;
                    }
                    if(params[1].equals(param)
                        || params[1].equals(primitiveClazz)){
                        setMethod = method;
                        break;
                    }
                    if(isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                        setMethod = method;
                    }
                }
                final Map<Class<?>, Method> tmpOverloadMap = new HashMap<Class<?>, Method>(overloadMap);
                tmpOverloadMap.put(param, setMethod);
                indexedWriteMethodCache.put(clazz, tmpOverloadMap);
                return setMethod;
            }
        }
        if(!isAccessableClass(clazz)){
            final Class<?>[] interfaces = clazz.getInterfaces();
            for(Class<?> itf : interfaces){
                final Method method = getWriteIndexedMethod(
                    itf,
                    param
                );
                if(method != null){
                    return method;
                }
            }
            final Class<?> superClass = clazz.getSuperclass();
            if(superClass != null){
                return getWriteIndexedMethod(superClass, param);
            }
            return null;
        }
        final StringBuilder methodName = new StringBuilder(SET_METHOD_NAME);
        if(property.length() != 0){
            char capital = property.charAt(0);
            if(Character.isUpperCase(capital)){
                methodName.append(property);
            }else{
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if(property.length() > 1){
                    methodName.append(property.substring(1));
                }
            }
        }
        Method setMethod = null;
        final Method[] methods = clazz.getMethods();
        if(methods == null || methods.length == 0){
            return null;
        }
        final Class<?> primitiveClazz = toPrimitive(param);
        final Map<Class<?>, Method> overloadMap = new HashMap<Class<?>, Method>();
        boolean isMatch = false;
        for(Method method : methods){
            if(!methodName.toString().equals(method.getName())
                || Modifier.isNative(method.getModifiers())){
                continue;
            }
            final Class<?>[] params = method.getParameterTypes();
            if(params == null || params.length != 2
                 || !params[0].equals(Integer.TYPE)
            ){
                continue;
            }
            overloadMap.put(params[1], method);
            if(isMatch){
                continue;
            }
            if(setMethod == null){
                if(param == null){
                    setMethod = method;
                    continue;
                }
                if(!isAssignableFrom(params[1], param)
                    && !params[1].equals(primitiveClazz)){
                    continue;
                }
                setMethod = method;
                if(param.equals(params[0])
                    || params[0].equals(primitiveClazz)){
                    isMatch = true;
                }
                continue;
            }
            if(param == null){
                if(isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                    setMethod = method;
                }
                continue;
            }
            if(!isAssignableFrom(params[1], param)
                 && !params[1].equals(primitiveClazz)){
                continue;
            }
            if(params[1].equals(param)
                || params[1].equals(primitiveClazz)){
                isMatch = true;
                setMethod = method;
                continue;
            }
            if(isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                setMethod = method;
            }
        }
        if(param == null){
            overloadMap.put(null, setMethod);
        }
        if(setMethod != null){
            if(overloadMap.size() > 1){
                indexedWriteMethodCache.put(clazz, overloadMap);
            }else{
                indexedWriteMethodCache.put(clazz, setMethod);
            }
        }
        return setMethod;
    }
    
    /**
     * w肵IuWFNg̃CfbNXtGetterigetvpeB(int)jĂяovpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod CfbNXtGetterigetvpeB(int)j
     * @return vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    protected Object getIndexedProperty(Object obj, Method readMethod)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        try{
            return readMethod.invoke(
                obj,
                index
            );
        }catch(IllegalAccessException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '[' + index + ']',
                e
            );
        }catch(IllegalArgumentException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '[' + index + ']',
                e
            );
        }
    }
    
    /**
     * w肵IuWFNg̃CfbNXtSetterisetvpeB(int, Cӂ̃NX)jĂяovpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param writeMethod CfbNXtSetterisetvpeB(int, Cӂ̃NX)j
     * @param value ݒ肷vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    protected void setIndexedProperty(
        Object obj,
        Method writeMethod,
        Object value
    ) throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        try{
            final Class<?> paramType = writeMethod.getParameterTypes()[1];
            if(value instanceof Number
                 && !paramType.isPrimitive()
                 && !paramType.equals(value.getClass())
            ){
                value = castPrimitiveWrapper(paramType, (Number)value);
            }
            writeMethod.invoke(
                obj,
                index, value
            );
        }catch(IllegalAccessException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '[' + index + ']',
                e
            );
        }catch(IllegalArgumentException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '[' + index + ']',
                e
            );
        }
    }
    
    /**
     * w肵IuWFNg̃CfbNXt߂lGetteriCfbNXtIuWFNg getvpeB()jĂяoA̖߂l擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod CfbNXt߂lGetteriCfbNXtIuWFNg getvpeB()j
     * @return CfbNXt߂l
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇA܂͖߂lCfbNXt߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽBean܂̓CfbNXt߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    protected Object getIndexedObject(Object obj, Method readMethod)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        try{
            if(readMethod.getParameterTypes().length == 0){
                return readMethod.invoke(obj);
            }else{
                return readMethod.invoke(
                    obj,
                    super.getPropertyName()
                );
            }
        }catch(IllegalAccessException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '[' + index + ']',
                e
            );
        }catch(IllegalArgumentException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '[' + index + ']',
                e
            );
        }
    }
    
    /**
     * w肵IuWFNg̃CfbNXt߂lGetteriCfbNXtIuWFNg getvpeB()jĂяoA߂lvpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod CfbNXt߂lGetteriCfbNXtIuWFNg getvpeB()j
     * @return vpeBl
     * @exception NullIndexPropertyException w肳ꂽvpeB̃CfbNXt߂lAnull̏ꍇ
     * @exception NoSuchIndexPropertyException CfbNXt߂lɁÃCfbNXvpeBCfbNX݂Ȃꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇA܂͖߂lCfbNXt߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽBean܂̓CfbNXt߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    protected Object getNoIndexedProperty(Object obj, Method readMethod)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Object indexedObj = getIndexedObject(obj, readMethod);
        if(indexedObj == null){
            if(isIgnoreNullProperty){
                return null;
            }else{
                throw new NullIndexPropertyException(
                    clazz,
                    property + '[' + index + ']'
                );
            }
        }else{
            return getIndexedObjectProperty(indexedObj.getClass(), indexedObj);
        }
    }
    
    /**
     * w肵IuWFNg̃CfbNXt߂lGetteriCfbNXtIuWFNg getvpeB()jĂяoA߂lɃvpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod CfbNXt߂lGetteriCfbNXtIuWFNg getvpeB()j
     * @param value vpeBl
     * @exception NullIndexPropertyException w肳ꂽvpeB̃CfbNXt߂lAnull̏ꍇ
     * @exception NoSuchIndexPropertyException CfbNXt߂lɁÃCfbNXvpeBCfbNX݂Ȃꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇA܂͖߂lCfbNXt߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽBean܂̓CfbNXt߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    protected void setNoIndexedProperty(
        Object obj,
        Method readMethod,
        Object value
    ) throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Object indexedObj = getIndexedObject(obj, readMethod);
        if(indexedObj == null){
            throw new NullIndexPropertyException(
                clazz,
                property + '[' + index + ']'
            );
        }else{
            setIndexedObjectProperty(indexedObj.getClass(), indexedObj, value);
        }
    }
    
    /**
     * w肵IuWFNg̃CfbNXt߂lGetteriCfbNXtIuWFNg getvpeB()jĂяoA߂lɃvpeBlݒ\肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod CfbNXt߂lGetteriCfbNXtIuWFNg getvpeB()j
     * @param clazz vpeB̌^
     * @return CfbNXt߂lɃvpeBlݒ\ȏꍇtrue
     */
    protected boolean isWritableNoIndexedProperty(
        Object obj,
        Method readMethod,
        Class<?> clazz
    ){
        Object indexedObj = null;
        try{
            indexedObj = getIndexedObject(obj, readMethod);
        }catch(NoSuchPropertyException e){
            return false;
        }catch(InvocationTargetException e){
            return false;
        }
        if(indexedObj == null){
            return false;
        }else{
            return isWritableIndexedObjectProperty(indexedObj, clazz);
        }
    }
    
    /**
     * w肵CfbNXtIuWFNgɁÃCfbNXvpeBCfbNX̃vpeBlݒ\肷B<p>
     * ŌACfbNXtIuWFNgƂ́AzA{@link java.util.List}ACfbNXtSetteriset(int, vpeBľ^ɓKCӂ̃NX)jIuWFNĝꂩłB
     *
     * @param obj CfbNXtIuWFNg
     * @param clazz vpeB̌^
     * @return w肵CfbNXtIuWFNgɁÃCfbNXvpeBCfbNX̃vpeBlݒ\ȏꍇtrue
     */
    protected boolean isWritableIndexedObjectProperty(Object obj, Class<?> clazz){
        final Class<?> indexdClazz = obj.getClass();
        if(indexdClazz.isArray()){
            if(Array.getLength(obj) <= index){
                return false;
            }else{
                return true;
            }
        }else if(obj instanceof List<?>){
            final List<?> list = (List<?>)obj;
            if(list.size() <= index){
                return false;
            }else{
                return true;
            }
        }else{
            Method setMethod = null;
            final Method[] methods = indexdClazz.getMethods();
            if(methods == null || methods.length == 0){
                return false;
            }
            Class<?> valueClass = clazz == null ? null : clazz;
            for(Method method : methods){
                if(!SET_METHOD_NAME.equals(method.getName())
                    || !Modifier.isPublic(method.getModifiers())
                    || Modifier.isNative(method.getModifiers())
                ){
                    continue;
                }
                final Class<?>[] params = method.getParameterTypes();
                if(params == null || params.length != 2
                     || (!params[0].equals(Integer.class)
                         && !params[0].equals(Integer.TYPE))
                     || (valueClass != null
                         && !isAssignableFrom(params[1], valueClass))
                ){
                    continue;
                }
                if(setMethod == null
                     || isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                    setMethod = method;
                }
            }
            if(setMethod == null){
                return false;
            }
            return true;
        }
    }
    
    /**
     * w肵CfbNXtIuWFNgÃCfbNXvpeBCfbNX̃vpeBl擾B<p>
     * ŌACfbNXtIuWFNgƂ́AzA{@link java.util.List}ACfbNXtGetteriget(int)jIuWFNĝꂩłB
     *
     * @param obj CfbNXtIuWFNg
     * @return vpeBl
     * @exception NoSuchIndexPropertyException w肳ꂽCfbNXt߂lɁÃCfbNXvpeBCfbNX݂Ȃꍇ
     * @exception NoSuchPropertyException w肳ꂽCfbNXt߂lACfbNXt߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽCfbNXt߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    @SuppressWarnings("unchecked")
    protected Object getIndexedObjectProperty(Class<?> clazz, Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        if(clazz.isArray()){
            if(Array.getLength(obj) <= index){
                if(isIgnoreNullProperty){
                    return null;
                }else{
                    throw new NoSuchIndexPropertyException(
                        clazz,
                        property + '[' + index + ']',
                        index
                    );
                }
            }else{
                return Array.get(obj, index);
            }
        }else if(obj instanceof List){
            final List<Object> list = (List<Object>)obj;
            try{
                return list.get(index);
            }catch(IndexOutOfBoundsException e){
                if(isIgnoreNullProperty){
                    return null;
                }else{
                    throw new NoSuchIndexPropertyException(
                        clazz,
                        property + '[' + index + ']',
                        index,
                        e
                    );
                }
            }
        }else{
            if(!isAccessableClass(clazz)){
                final Class<?>[] interfaces = clazz.getInterfaces();
                for(Class<?> itf : interfaces){
                    if(isAccessableClass(itf)){
                        try{
                            return getIndexedObjectProperty(itf, obj);
                        }catch(NoSuchPropertyException e){
                        }
                    }
                }
                final Class<?> superClass = clazz.getSuperclass();
                if(superClass != null){
                    return getIndexedObjectProperty(superClass, obj);
                }
                throw new NoSuchIndexPropertyException(
                    clazz,
                    property + '[' + index + ']',
                    index
                );
            }
            Method getMethod = null;
            try{
                getMethod = clazz.getMethod(
                    GET_METHOD_NAME,
                    GET_METHOD_ARGS
                );
            }catch(NoSuchMethodException e){
                throw new NoSuchPropertyException(clazz, property + '[' + index + ']');
            }
            if(Modifier.isPublic(getMethod.getModifiers())
                && !Modifier.isNative(getMethod.getModifiers())){
                indexedReadMethodCache.put(clazz, getMethod);
                try{
                    return getMethod.invoke(
                        obj,
                        index
                    );
                }catch(IllegalAccessException e){
                    // NȂ͂
                    throw new NoSuchPropertyException(
                        clazz,
                        property + '[' + index + ']',
                        e
                    );
                }catch(IllegalArgumentException e){
                    // NȂ͂
                    throw new NoSuchPropertyException(
                        clazz,
                        property + '[' + index + ']',
                        e
                    );
                }
            }else{
                throw new NoSuchPropertyException(clazz, property + '[' + index + ']');
            }
        }
    }
    
    /**
     * w肵CfbNXtIuWFNgClassÃCfbNXvpeBCfbNX̃vpeB^擾B<p>
     * ŌACfbNXtIuWFNgƂ́AzA{@link java.util.List}ACfbNXtGetteriget(int)jIuWFNĝꂩłB
     *
     * @param indexdType CfbNXt^
     * @param isGeneric truȅꍇǍ^Ԃ
     * @return vpeB^
     * @exception NoSuchIndexPropertyException w肳ꂽCfbNXt߂lɁÃCfbNXvpeBCfbNX݂Ȃꍇ
     * @exception NoSuchPropertyException w肳ꂽCfbNXt߂lACfbNXt߂lłȂꍇ
     */
    protected Type getIndexedObjectPropertyType(Type indexdType, boolean isGeneric)
     throws NoSuchPropertyException{
        Class<?> indexdClazz = null;
        if(indexdType instanceof Class){
            indexdClazz = (Class<?>)indexdType;
        }else if(indexdType instanceof ParameterizedType){
            indexdClazz = (Class<?>)((ParameterizedType)indexdType).getRawType();
        }else if(indexdType instanceof GenericArrayType){
            return isGeneric ? ((GenericArrayType)indexdType).getGenericComponentType() : Object.class;
        }else{
            return isGeneric ? indexdType : Object.class;
        }
        if(indexdClazz.isArray()){
            return indexdClazz.getComponentType();
        }else if(List.class.isAssignableFrom(indexdClazz)){
            if(indexdType instanceof ParameterizedType){
                Type elementType = ((ParameterizedType)indexdType).getActualTypeArguments()[0];
                if(isGeneric){
                    return elementType;
                }else if(elementType instanceof Class){
                    return elementType;
                }else if(elementType instanceof ParameterizedType){
                    return ((ParameterizedType)elementType).getRawType();
                }else{
                    return Object.class;
                }
            }else{
                return Object.class;
            }
        }else{
            Method getMethod = null;
            try{
                getMethod = indexdClazz.getMethod(
                    GET_METHOD_NAME,
                    GET_METHOD_ARGS
                );
            }catch(NoSuchMethodException e){
                Method setMethod = null;
                final Method[] methods = indexdClazz.getMethods();
                if(methods == null || methods.length == 0){
                    throw new NoSuchPropertyException(indexdClazz, property + '[' + index + ']');
                }
                for(Method method : methods){
                    if(!SET_METHOD_NAME.equals(method.getName())
                         || !Modifier.isPublic(method.getModifiers())
                         || Modifier.isNative(method.getModifiers())
                    ){
                        continue;
                    }
                    final Class<?>[] params = method.getParameterTypes();
                    if(params == null || params.length != 2
                         || (!params[0].equals(Integer.class)
                             && !params[0].equals(Integer.TYPE))
                    ){
                        continue;
                    }
                    if(setMethod == null){
                        setMethod = method;
                    }else{
                        // młȂ̂ŃG[
                        throw new NoSuchPropertyException(
                            indexdClazz,
                            property + '[' + index + ']'
                        );
                    }
                }
                if(setMethod == null){
                    throw new NoSuchPropertyException(indexdClazz, property + '[' + index + ']');
                }
                return isGeneric ? setMethod.getGenericParameterTypes()[1] : setMethod.getParameterTypes()[1];
            }
            if(!Modifier.isPublic(getMethod.getModifiers()) || Modifier.isNative(getMethod.getModifiers())){
                throw new NoSuchPropertyException(indexdClazz, property + '[' + index + ']');
            }
            return isGeneric ? getMethod.getGenericReturnType() : getMethod.getReturnType();
        }
    }
    
    /**
     * w肵CfbNXtIuWFNgɁÃCfbNXvpeBCfbNX̃vpeBlݒ肷B<p>
     * ŌACfbNXtIuWFNgƂ́AzA{@link java.util.List}ACfbNXtSetteriset(int, vpeBľ^ɓKCӂ̃NX)jIuWFNĝꂩłB
     *
     * @param obj CfbNXtIuWFNg
     * @param value vpeBl
     * @exception NoSuchIndexPropertyException w肳ꂽCfbNXt߂lɁÃCfbNXvpeBCfbNX݂Ȃꍇ
     * @exception NoSuchPropertyException w肳ꂽCfbNXt߂lACfbNXt߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽCfbNXt߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    @SuppressWarnings("unchecked")
    protected void setIndexedObjectProperty(Class<?> clazz, Object obj, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        if(clazz.isArray()){
            if(Array.getLength(obj) <= index){
                throw new NoSuchIndexPropertyException(
                    clazz,
                    property + '[' + index + ']',
                    index
                );
            }else{
                Array.set(obj, index, value);
            }
        }else if(obj instanceof List){
            final List<Object> list = (List<Object>)obj;
            if(list.size() <= index){
                for(int i = list.size(); i <= index; i++){
                    list.add(null);
                }
            }
            try{
                list.set(index, value);
            }catch(IndexOutOfBoundsException e){
                throw new NoSuchIndexPropertyException(
                    clazz,
                    property + '[' + index + ']',
                    index,
                    e
                );
            }
        }else{
            if(!isAccessableClass(clazz)){
                final Class<?>[] interfaces = clazz.getInterfaces();
                for(Class<?> itf : interfaces){
                    if(isAccessableClass(itf)){
                        try{
                            setIndexedObjectProperty(itf, obj, value);
                            return;
                        }catch(NoSuchPropertyException e){
                        }
                    }
                }
                final Class<?> superClass = clazz.getSuperclass();
                if(superClass != null){
                    setIndexedObjectProperty(superClass, obj, value);
                    return;
                }
                throw new NoSuchIndexPropertyException(
                    clazz,
                    property + '[' + index + ']',
                    index
                );
            }
            Method setMethod = null;
            Class<?> valueClass = value == null ? null : value.getClass();
            final Method[] methods = clazz.getMethods();
            if(methods == null || methods.length == 0){
                throw new NoSuchPropertyException(clazz, property + '[' + index + ']');
            }
            for(Method method : methods){
                if(!SET_METHOD_NAME.equals(method.getName())
                     || !Modifier.isPublic(method.getModifiers())
                     || Modifier.isNative(method.getModifiers())){
                    continue;
                }
                final Class<?>[] params = method.getParameterTypes();
                if(params == null || params.length != 2
                     || (!params[0].equals(Integer.class)
                         && !params[0].equals(Integer.TYPE))
                     ||(valueClass != null
                         && !isAssignableFrom(params[1], valueClass))
                ){
                    continue;
                }
                if(setMethod == null
                     || isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                    setMethod = method;
                }
            }
            if(setMethod == null){
                throw new NoSuchPropertyException(clazz, property + '[' + index + ']');
            }
            try{
                setMethod.invoke(
                    obj,
                    index, value
                );
            }catch(IllegalAccessException e){
                // NȂ͂
                throw new NoSuchPropertyException(
                    clazz,
                    property + '[' + index + ']',
                    e
                );
            }catch(IllegalArgumentException e){
                // NȂ͂
                throw new NoSuchPropertyException(
                    clazz,
                    property + '[' + index + ']',
                    e
                );
            }
        }
    }
    
    /**
     * w肳ꂽBeańASẴCfbNXtvpeB擾B<p>
     * AACfbNX́A0B<br>
     *
     * @param bean ΏۂƂȂBean
     * @return w肳ꂽBeańASẴCfbNXtvpeB擾B
     */
    public static IndexedProperty[] getIndexedProperties(Object bean){
        return getIndexedProperties(bean.getClass());
    }
    
    /**
     * w肳ꂽNX́ASẴCfbNXtvpeB擾B<p>
     * AACfbNX́A0B<br>
     *
     * @param clazz ΏۂƂȂNX
     * @return w肳ꂽBeańASẴCfbNXtvpeB擾B
     */
    public static IndexedProperty[] getIndexedProperties(Class<?> clazz){
        Set<IndexedProperty> props = new HashSet<IndexedProperty>();
        if(isAccessableClass(clazz)){
            props = getIndexedProperties(clazz, props);
        }else{
            final Class<?>[] interfaces = clazz.getInterfaces();
                for(Class<?> itf : interfaces){
                if(isAccessableClass(itf)){
                    props = getIndexedProperties(itf, props);
                    break;
                }
            }
        }
        return props.toArray(new IndexedProperty[props.size()]);
    }
    
    private static Set<IndexedProperty> getIndexedProperties(Class<?> clazz, Set<IndexedProperty> props){
        final Method[] methods = clazz.getMethods();
        if(methods == null || methods.length == 0){
            return props;
        }
        for(Method method : methods){
            if(Modifier.isNative(method.getModifiers())){
                continue;
            }
            final Class<?>[] params = method.getParameterTypes();
            if(method.getName().startsWith(GET_METHOD_NAME)){
                final Class<?> retType = method.getReturnType();
                if(Void.TYPE.equals(retType)){
                    continue;
                }
                if(params == null){
                    if(retType.isArray()
                        || List.class.isAssignableFrom(retType)){
                        props.add(
                            new IndexedProperty(
                                method.getName().substring(3)
                            )
                        );
                    }else{
                        try{
                            retType.getMethod(
                                GET_METHOD_NAME,
                                GET_METHOD_ARGS
                            );
                            props.add(
                                new IndexedProperty(
                                    method.getName().substring(3)
                                )
                            );
                        }catch(NoSuchMethodException e){
                            final Method[] nestedMethods = retType.getMethods();
                            boolean isFound = false;
                            for(Method nestedMethod : nestedMethods){
                                final Class<?>[] nestedParams
                                     = nestedMethod.getParameterTypes();
                                if(SET_METHOD_NAME.equals(nestedMethod.getName())
                                    && !Modifier.isNative(nestedMethod.getModifiers())
                                    && nestedParams.length == 2
                                    && Integer.TYPE.equals(nestedParams[0])){
                                    isFound = true;
                                    break;
                                }
                            }
                            if(isFound){
                                props.add(
                                    new IndexedProperty(
                                        method.getName().substring(3)
                                    )
                                );
                            }
                        }
                    }
                }else if(params.length == 1){
                    if(!Integer.TYPE.equals(params[0])){
                        continue;
                    }
                    props.add(
                        new IndexedProperty(
                            method.getName().substring(3)
                        )
                    );
                }else{
                    continue;
                }
            }else if(method.getName().startsWith(SET_METHOD_NAME)){
                if(params != null && params.length == 2){
                    if(!Integer.TYPE.equals(params[0])){
                        continue;
                    }
                    props.add(
                        new IndexedProperty(
                            method.getName().substring(3)
                        )
                    );
                }else{
                    continue;
                }
            }else{
                continue;
            }
        }
        return props;
    }
    
    /**
     * ̃CfbNXvpeB̕\擾B<p>
     *
     * @return IndexedProperty{vpeB[CfbNX]}
     */
    @Override
    public String toString(){
        return "IndexedProperty{" + property + '[' + index + "]}";
    }
    
    /**
     * ̃IuWFNgƑ̃IuWFNgǂ܂B <p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return Ɏw肳ꂽIuWFNgƂ̃IuWFNgꍇ trueAłȂꍇ falseB
     */
    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(!(obj instanceof IndexedProperty)){
            return false;
        }
        final IndexedProperty comp = (IndexedProperty)obj;
        if(property == null && comp.property != null
            || property != null && comp.property == null){
            return false;
        }else if(property != null && comp.property != null
            && !property.equals(comp.property)){
            return false;
        }
        return index == comp.index;
    }
    
    /**
     * nbVl擾B<p>
     *
     * @return nbVl
     */
    @Override
    public int hashCode(){
        return (property == null ? 0 : property.hashCode()) + index + 2;
    }
    
    /**
     * ̃IuWFNgƎw肳ꂽIuWFNg̏rB<p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return ̃IuWFNgw肳ꂽIuWFNg菬ꍇ͕̐Aꍇ̓[A傫ꍇ͐̐
     */
    @Override
    public int compareTo(Property obj){
        if(obj == null){
            return 1;
        }
        if(!(obj instanceof IndexedProperty)){
            return 1;
        }
        final IndexedProperty comp = (IndexedProperty)obj;
        if(property == null && comp.property != null){
            return -1;
        }else if(property != null && comp.property == null){
            return 1;
        }else if(property != null && comp.property != null){
            final int val = property.compareTo(comp.property);
            if(val != 0){
                return val;
            }
        }
        return index - comp.index;
    }
    
    private void readObject(ObjectInputStream in)
     throws IOException, ClassNotFoundException{
        in.defaultReadObject();
        getMethodCache = new HashMap<Class<?>, Method>();
        setMethodCache = new HashMap<Class<?>, Object>();
        indexedReadMethodCache = new HashMap<Class<?>, Method>();
        indexedWriteMethodCache = new HashMap<Class<?>, Object>();
    }
}
