/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer.log4j;

import org.apache.log4j.*;
import org.apache.log4j.spi.LoggingEvent;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.writer.*;

/**
 * Log4JWriterAppendergMessageWriterT[rXB<p>
 * 
 * @author M.Takata
 */
public class WriterAppenderMessageWriterService extends ServiceBase
 implements WriterAppenderMessageWriterServiceMBean{
    
    private static final long serialVersionUID = -6684161299188208252L;
    
    private boolean isImmediateFlush;
    private String encoding;
    private String header;
    private String footer;
    
    /**
     * LoggingEvent̃L[ƂȂLoggerIuWFNgB<p>
     */
    protected Logger logger;
    
    /**
     * t@Co͂s WriterAppender IuWFNgB<p>
     */
    protected WriterAppender appender;
    
    /**
     * t@Co͂̃CAEg߂LayoutIuWFNgB<p>
     */
    protected Layout layout = new Layout(){
        private final StringBuilder sbuf = new StringBuilder(128);
        public String format(LoggingEvent event){
            sbuf.setLength(0);
            sbuf.append(event.getRenderedMessage());
            sbuf.append(LINE_SEP);
            return sbuf.toString();
        }
        public boolean ignoresThrowable(){
            return true;
        }
        public void activateOptions(){
        }
        public String getHeader() {
            return header;
        }
        public String getFooter() {
            return footer;
        }
    };
    
    /**
     * CX^X𐶐B<p>
     */
    public WriterAppenderMessageWriterService(){
        super();
    }
    
    // WriterAppenderMessageWriterServiceMBeanJavaDoc
    public void setImmediateFlush(boolean flush){
        isImmediateFlush = flush;
    }
    
    // WriterAppenderMessageWriterServiceMBeanJavaDoc
    public boolean isImmediateFlush(){
        return isImmediateFlush;
    }
    
    // WriterAppenderMessageWriterServiceMBeanJavaDoc
    public void setEncoding(String encoding){
        this.encoding = encoding;
    }
    
    // WriterAppenderMessageWriterServiceMBeanJavaDoc
    public String getEncoding(){
        return encoding;
    }
    
    // WriterAppenderMessageWriterServiceMBeanJavaDoc
    public void setHeader(String header){
        this.header = header;
    }
    
    // WriterAppenderMessageWriterServiceMBeanJavaDoc
    public String getHeader(){
        return header;
    }
    
    // WriterAppenderMessageWriterServiceMBeanJavaDoc
    public void setFooter(String footer){
        this.footer = footer;
    }
    
    // WriterAppenderWriterServiceMBeanJavaDoc
    public String getFooter(){
        return footer;
    }
    
    /**
     * JnsB<p>
     *
     * @exception Exception JnɎsꍇ
     */
    public void startService() throws Exception{
        logger = createLogger();
        appender = createWriterAppender();
        initWriterAppender(appender);
        appender.activateOptions();
    }
    
    /**
     * LoggerCX^X𐶐B<p>
     */
    protected Logger createLogger(){
        return Logger.getLogger(
            getServiceManagerName() + '#' + getServiceName()
        );
    }
    
    /**
     * WriterAppenderCX^X𐶐B<p>
     *
     * @exception Exception WriterAppender̐Ɏsꍇ
     */
    protected WriterAppender createWriterAppender() throws Exception{
        return new WriterAppender();
    }
    
    /**
     * WriterAppenderB<p>
     *
     * @exception Exception WriterAppendeȑɎsꍇ
     */
    protected void initWriterAppender(WriterAppender appender) throws Exception{
        appender.setLayout(layout);
        appender.setImmediateFlush(isImmediateFlush);
        if(encoding != null){
            appender.setEncoding(encoding);
        }
    }
    
    /**
     * ~sB<p>
     */
    public void stopService(){
        appender.close();
        appender = null;
    }
    
    /**
     * o̓t@C̃CAEgݒ肷B<p>
     *
     * @param layout CAEg
     */
    public void setLayout(Layout layout){
        this.layout = layout;
    }
    
    // MessageWriterJavaDoc
    public void write(WritableRecord rec){
        appender.append(
            new LoggingEvent(
                getClass().getName(),
                logger,
                Level.INFO,
                rec.toString(),
                null
            )
        );
    }
}
