/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.websocket.jetty;

import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link DefaultPingSenderService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface DefaultPingSenderServiceMBean extends ServiceBaseMBean{
    
    /**
     * PING̑MԊu[ms]ݒ肷B<p>
     * ftHǵA30bB<br>
     *
     * @param interval PING̑MԊu[ms]
     */
    public void setPingInterval(long interval);
    
    /**
     * PING̑MԊu[ms]擾B<p>
     *
     * @return PING̑MԊu[ms]
     */
    public long getPingInterval();
    
    /**
     * PING̉ȂꍇɁAgC񐔂ݒ肷B<p>
     * ftHǵA0ŃgCȂB<br>
     *
     * @param max gC
     */
    public void setMaxRetryCount(int max);
    
    /**
     * PING̉ȂꍇɁAgC񐔂擾B<p>
     *
     * @return gC
     */
    public int getMaxRetryCount();
    
    /**
     * PING̉Ȃꍇ́AIR[hݒ肷B<p>
     * ftHǵA1000B<br>
     *
     * @param code IR[h
     */
    public void setCloseCodeForNoPong(int code);
    
    /**
     * PING̉Ȃꍇ́AIR[h擾B<p>
     *
     * @return IR[h
     */
    public int getCloseCodeForNoPong();
    
    /**
     * PING̉ȂNCAge邩ǂݒ肷B<p>
     * ftHǵAfalseŁAeȂB<br>
     *
     * @param isAllow eꍇ́Atrue
     */
    public void setAllowNoPong(boolean isAllow);
    
    /**
     * PING̉ȂNCAge邩ǂ擾B<p>
     *
     * @return truȅꍇ́Ae
     */
    public boolean isAllowNoPong();
}
