/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sequence;

import jp.ossc.nimbus.core.*;

/**
 * {@link NumberSequenceService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface NumberSequenceServiceMBean extends ServiceBaseMBean{
    
    /**
     * lݒ肷B<p>
     *  >= 0̏ꍇ́Aőlȉ̒lɂȂ΂ȂȂB<br>
     *  < 0̏ꍇ́Aŏlȏ̒lɂȂ΂ȂȂB<br>
     * ftHǵA0B<p>
     *
     * @param value l
     */
    public void setInitialValue(long value);
    
    /**
     * l擾B<p>
     *
     * @return l
     */
    public long getInitialValue();
    
    /**
     * ŏlݒ肷B<p>
     * ől菬ȒlɂȂ΂ȂȂB<br>
     * ftHǵA0B<p>
     *
     * @param value ŏl
     */
    public void setMinValue(long value);
    
    /**
     * ŏl擾B<p>
     *
     * @return ŏl
     */
    public long getMinValue();
    
    /**
     * őlݒ肷B<p>
     * ŏl傫ȒlɂȂ΂ȂȂB<br>
     * ftHǵALong.MAX_VALUEB<p>
     *
     * @param value ől
     */
    public void setMaxValue(long value);
    
    /**
     * ől擾B<p>
     *
     * @return ől
     */
    public long getMaxValue();
    
    /**
     * ʂݒ肷B<p>
     * ꍇ́A̒lݒ肷B<br>
     * ftHǵA1B<p>
     *
     * @param value 
     */
    public void setIncrementValue(long value);
    
    /**
     * ʂ擾B<p>
     *
     * @return 
     */
    public long getIncrementValue();
    
    /**
     * tH[}bgw肷B<p>
     * w肳ꂽtH[}bgŁAjava.text.DecimalFormatgătH[}bgB<br>
     * w肵Ȃꍇ́AString.valueOf(long)ŕɕϊB<br>
     *
     * @param format tH[}bg
     */
    public void setFormat(String format);
    
    /**
     * tH[}bg擾B<p>
     *
     * @return tH[}bg
     */
    public String getFormat();
    
    /**
     * java.text.NumberFormatC^tF[XT[rX̃T[rXݒ肷B<p>
     *  java.text.NumberFormatC^tF[XT[rXAXbhZ[tłȂꍇ́At@NgT[rXƂ鎖B<br>
     *
     * @param name NumberFormatT[rX̃T[rX
     */
    public void setNumberFormatServiceName(ServiceName name);
    
    /**
     * java.text.NumberFormatC^tF[XT[rX̃T[rX擾B<p>
     *
     * @return NumberFormatT[rX̃T[rX
     */
    public ServiceName getNumberFormatServiceName();
    
    /** 
     * ݔԍς݂̍ŐV̔ԍl擾B<p>
     * 
     * @return ݔԍς݂̍ŐV̔ԍl
     */ 
    public long getCurrentValue();
    
    /**
     * Jnԍ擾B<p>
     * 
     * @return Jnԍ
     */
    public String getInitial();
    
    /** 
     * ݔԍς݂̍ŐV̔ԍ擾B<p>
     * 
     * @return ݔԍς݂̍ŐV̔ԍ
     */ 
    public String getCurrent();
    
    /**
     * ԂB<p>
     */
    public void reset();
}
