/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.util.regex.*;

/**
 * HTTPNGXgB<p>
 * 
 * @author M.Takata
 */
public class HttpRequest{
    
    private static final String HEADER_NAME_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_NAME_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_NAME_TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    
    private static final String CONTENT_ENCODING_DEFLATE = "deflate";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    
    private static final String CHARSET = "charset";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO8859_1";
    private static final String CHUNKED = "chunked";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private static final String HTTP_METHOD_PUT = "PUT";
    
    /**
     * HTTPNGXg̃wb_B<p>
     */
    protected RequestHeader header;
    
    /**
     * HTTPNGXg̃{fBB<p>
     */
    protected RequestBody body;
    
    /**
     * ̃C^X𐶐B<p>
     */
    public HttpRequest(){
    }
    
    /**
     * C^X𐶐B<p>
     * wb_̓ǂݍ݂܂ōsB<br>
     * {fB́AXg[̓ǂݍ݂͍s킸A{fB̊JnʒũXg[i[B<br>
     *
     * @param is HTTPNGXg̗vXg[
     * @exception Exception wb_̓ǂݍ݂Ɏsꍇ
     */
    public HttpRequest(InputStream is) throws Exception{
        header = new RequestHeader();
        header.read(is);
        if(HTTP_METHOD_POST.equals(header.method)
                || HTTP_METHOD_PUT.equals(header.method)){
            body = new RequestBody(header, is);
        }
    }
    
    /**
     * HTTPNGXg̃wb_擾B<p>
     *
     * @return HTTPNGXg̃wb_
     */
    public RequestHeader getHeader(){
        return header;
    }
    
    /**
     * HTTPNGXg̃{fB擾B<p>
     *
     * @return HTTPNGXg̃{fB
     */
    public RequestBody getBody(){
        return body;
    }
    
    /**
     * HTTPNGXgwb_B<p>
     * 
     * @author M.Takata
     */
    public class RequestHeader{
        
        /**
         * HTTPNGXgwb_̑SB<p>
         */
        protected String header;
        
        /**
         * HTTP\bhB<p>
         */
        protected String method;
        
        /**
         * NGXgURLB<p>
         * AANG͊܂܂ȂB<br>
         */
        protected String url;
        
        /**
         * NGB<p>
         */
        protected String query;
        
        /**
         * HTTPo[WB<p>
         */
        protected String version;
        
        /**
         * HTTPwb_}bvB<p>
         */
        protected Map<String, String[]> headerMap = new HashMap<String, String[]>();
        
        /**
         * HTTP\bh擾B<p>
         * 
         * @return HTTP\bh
         */
        public String getMethod(){
            return method;
        }
        
        /**
         * URL擾B<p>
         * AANG͊܂܂ȂB<br>
         * 
         * @return URL
         */
        public String getURL(){
            return url;
        }
        
        /**
         * URL̐K\v邽߂java.util.Matcher擾B<p>
         *
         * @param url URL̐K\
         * @return K\}b`GW
         */
        public Matcher getURLMatcher(String url){
             return Pattern.compile(url).matcher(this.url);
        }
        
        /**
         * NG擾B<p>
         * 
         * @return NG
         */
        public String getQuery(){
            return query;
        }
        
        /**
         * NG̐K\v邽߂java.util.Matcher擾B<p>
         *
         * @param query NG̐K\
         * @return K\}b`GW
         */
        public Matcher getQueryMatcher(String query){
            return Pattern.compile(query).matcher(this.query == null ? "" : this.query);
        }
        
        /**
         * HTTPo[W擾B<p>
         * 
         * @return HTTPo[W
         */
        public String getVersion(){
            return version;
        }
        
        /**
         * w肳ꂽOHTTPwb_擾B<p>
         *
         * @param name wb_
         * @return wb_l
         */
        public String getHeader(String name){
            final String[] vals = (String[])headerMap.get(name);
            return vals == null ? null : vals[0];
        }
        
        /**
         * w肳ꂽOHTTPwb_擾B<p>
         *
         * @param name wb_
         * @return wb_lz
         */
        public String[] getHeaders(String name){
            return (String[])headerMap.get(name);
        }
        
        /**
         * Content-Lengthwb_擾B<p>
         *
         * @return Content-Length̒lBȂꍇ-1
         */
        public int getContentLength(){
            final String contentLengthStr
                 = getHeader(HEADER_NAME_CONTENT_LENGTH);
            if(contentLengthStr == null){
                return -1;
            }
            int contentLength = -1;
            try{
                contentLength = Integer.parseInt(contentLengthStr);
            }catch(NumberFormatException e){
            }
            return contentLength;
        }
        
        /**
         * Content-Lengthwb_ݒ肷B<p>
         *
         * @param length Content-Length̒l
         */
        public void setContentLength(int length){
            headerMap.put(
                HEADER_NAME_CONTENT_LENGTH,
                new String[]{String.valueOf(length)}
            );
        }
        
        /**
         * Content-Typewb_charset擾B<p>
         *
         * @return charset̒lBȂꍇISO8859_1
         */
        public String getCharacterEncoding(){
            String characterEncoding = DEFAULT_CHARACTER_ENCODING;
            final String contentType
                 = getHeader(HEADER_NAME_CONTENT_TYPE);
            if(contentType == null){
                return characterEncoding;
            }
            final StringTokenizer tokens
                 = new StringTokenizer(contentType, ";");
            while(tokens.hasMoreTokens()){
                final String token = tokens.nextToken();
                if(token.indexOf(CHARSET) != -1){
                    final int index = token.indexOf('=');
                    if(index <= 0
                         || index == token.length() - 1){
                        continue;
                    }
                    final String charset = token.substring(index + 1).trim();
                    if(charset.length() != 0){
                        characterEncoding = charset;
                        break;
                    }
                }
            }
            return characterEncoding;
        }
        
        /**
         * Content-Encodingwb_擾B<p>
         *
         * @return Content-Encodingwb_
         */
        public String[] getContentEncoding(){
            final String[] contentEncoding
                 = getHeaders(HEADER_NAME_CONTENT_ENCODING);
            return contentEncoding;
        }
        
        /**
         * Accept-Encodingwb_擾B<p>
         *
         * @return Accept-Encodingwb_
         */
        public String getAcceptEncoding(){
            final String acceptEncoding
                 = getHeader(HEADER_ACCEPT_ENCODING);
            return acceptEncoding;
        }
        
        /**
         * Transfer-Encodingwb_chunkedw肳Ă邩𔻒肷B<p>
         *
         * @return Transfer-Encodingwb_̒lchunked̏ꍇtrue
         */
        public boolean isChunked(){
            final String transferEncoding
                 = getHeader(HEADER_NAME_TRANSFER_ENCODING);
            if(transferEncoding == null){
                return false;
            }
            return CHUNKED.equals(transferEncoding.trim());
        }
        
        /**
         * NGXgwb_ǂݍށB<p>
         *
         * @param is HTTPNGXg̓̓Xg[
         * @exception Exception ǂݍ݋yщ͂Ɏsꍇ
         */
        public void read(InputStream is) throws Exception{
            final StringWriter sw = new StringWriter();
            final PrintWriter pw = new PrintWriter(sw);
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String requestLine = readLine(is, baos);
            requestLine = requestLine.trim();
            pw.println(requestLine);
            String[] requests = requestLine.split(" ");
            if(requests.length != 3){
                throw new Exception("illegal request : " + requestLine);
            }
            method = requests[0];
            if(!method.equals(HTTP_METHOD_POST)
                    && !method.equals(HTTP_METHOD_GET)
                    && !method.equals(HTTP_METHOD_DELETE)
                    && !method.equals(HTTP_METHOD_PUT)
            ){
                throw new Exception("unsupported http method : " + method);
            }
            int index = requests[1].indexOf(';');
            if(index == -1){
                index = requests[1].indexOf('?');
                if(index == -1){
                    url = requests[1];
                }else{
                    url = requests[1].substring(0, index);
                    query = requests[1].substring(index + 1);
                }
            }else{
                url = requests[1].substring(0, index);
                index = requests[1].indexOf('?');
                if(index != -1){
                    query = requests[1].substring(index + 1);
                }
            }
            version = requests[2];
            
            String headerLine = null;
            do{
                headerLine = readLine(is, baos);
                if(headerLine == null){
                    break;
                }
                pw.println(headerLine);
                headerLine = headerLine.trim();
                if(headerLine.length() == 0){
                    break;
                }
                index = headerLine.indexOf(':');
                if(index == -1
                     || index == 0
                     || index == headerLine.length() - 1){
                    continue;
                }
                final String name = headerLine.substring(0, index).trim();
                final String val = headerLine.substring(index + 1).trim();
                String[] vals = (String[])headerMap.get(name);
                if(vals == null){
                    vals = new String[1];
                    vals[0] = val;
                    headerMap.put(name, vals);
                }else{
                    final String[] newVals = new String[vals.length + 1];
                    System.arraycopy(vals, 0, newVals, 0, vals.length);
                    newVals[newVals.length - 1] = val;
                    headerMap.put(name, newVals);
                }
            }while(true);
            pw.close();
            header = sw.toString();
        }
        
        /**
         * PsǂݍށB<p>
         *
         * @param is ̓Xg[
         * @param tmp ꎞobt@p̏o̓Xg[
         * @exception IOException ǂݍ݂Ɏsꍇ
         */
        protected String readLine(InputStream is, ByteArrayOutputStream tmp) throws IOException{
            tmp.reset();
            int val = 0;
            while((val = is.read()) != -1){
                if(val == (int)'\r'){
                    val = is.read();
                    boolean isBreak = false;
                    switch(val){
                    case -1:
                        isBreak = true;
                        break;
                    case (int)'\n':
                        isBreak = true;
                        break;
                    default:
                        tmp.write((int)'\r');
                        tmp.write(val);
                    }
                    if(isBreak){
                        break;
                    }
                }else{
                    tmp.write(val);
                }
            }
            return new String(tmp.toByteArray());
        }
        
        /**
         * wb_擾B<p>
         *
         * @return wb_
         */
        public String toString(){
            return header;
        }
    }
    
    /**
     * HTTPNGXg{fBB<p>
     * 
     * @author M.Takata
     */
    public class RequestBody{
        
        /**
         * HTTPNGXg̓̓Xg[B<p>
         */
        protected InputStream inputStream;
        
        /**
         * NGXgwb_B<p>
         */
        protected RequestHeader header;
        
        /**
         * HTTPNGXg̃{fBB<p>
         */
        protected String body;
        
        /**
         * Content-Encodingɏ]̓Xg[̉𓀂sǂtOB<p>
         * ftHgAtrueŉ𓀂B<br>
         */
        protected boolean isDecompress = true;
        
        /**
         * CX^X𐶐B<p>
         *
         * @param header HTTPNGXgwb_
         * @param is HTTPNGXg̓̓Xg[
         * @exception Exception ̓Xg[̉𓀂Ɏsꍇ
         */
        public RequestBody(RequestHeader header, InputStream is) throws Exception{
            this.header = header;
            inputStream = is;
            final int contentLength = header.getContentLength();
            final String[] contentEncoding = header.getContentEncoding();
            if(isDecompress && contentLength > 0 && contentEncoding != null){
                inputStream = decompress(inputStream, contentEncoding, contentLength);
            }
        }
        
        /**
         * Content-Encodingɏ]̓Xg[̉𓀂sǂݒ肷B<p>
         * ftHǵAtrueB<br>
         *
         * @param isDecompress 𓀂ꍇtrue
         */
        public void setDecompress(boolean isDecompress){
            this.isDecompress = isDecompress;
        }
        
        /**
         * Content-Encodingɏ]̓Xg[̉𓀂sǂ𔻒肷B<p>
         *
         * @return truȅꍇ́A𓀂
         */
        public boolean isDecompress(){
            return isDecompress;
        }
        
        /**
         * HTTPNGXg̓̓Xg[擾B<p>
         *
         * @return HTTPNGXg̓̓Xg[
         */
        public InputStream getInputStream(){
            return inputStream;
        }
        
        /**
         * HTTPNGXg̃{fB𕶎ƂēǂݍށB<p>
         *
         * @exception Exception ǂݍ݂Ɏsꍇ
         */
        public void read() throws Exception{
            
            final int contentLength = header.getContentLength();
            if(contentLength <= 0){
                return;
            }
            if(header.isChunked()){
                throw new Exception("Chunk is not supported.");
            }else{
                final byte[] readBytes = new byte[contentLength + 1];
                int readLength = 0;
                int offset = 0;
                while(offset < contentLength
                     && (readLength = inputStream.read(readBytes, offset, contentLength - offset)) != -1){
                    offset += readLength;
                }
                if(readLength == -1){
                    readLength = offset;
                }else{
                    readLength = contentLength;
                }
                final String characterEncoding = header.getCharacterEncoding();
                body = new String(readBytes, 0, readLength, characterEncoding);
            }
        }
        
        /**
         * Content-Encoding̎wɏ]āA̓Xg[𓀂B<p>
         * ΉĂContent-EncodinǵAdeflateAgzipAx-gzipłB<br>
         *
         * @param is ̓Xg[
         * @param contentEncoding Content-Encoding
         * @return 𓀂ꂽ̓Xg[B𓀂KvȂꍇ́Â܂ܕԂB
         * @exception IOException 𓀂ɎsꍇBΉĂȂContent-Encodingw肳ĂꍇB
         */
        protected InputStream decompress(InputStream is, String[] contentEncoding, int contentLength) throws IOException {
            if(contentEncoding == null || contentEncoding.length == 0){
                return is;
            }
            
            byte[] buf = new byte[contentLength];
            int length = 0;
            int offset = 0;
            while((length = is.read(buf, offset, contentLength - offset)) != -1
                && offset < contentLength){
                offset += length;
            }
            @SuppressWarnings("resource")
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            InputStream in = bais;
            for(int i = (contentEncoding.length - 1); i >= 0; i--){
                final String encode = contentEncoding[i];
                if(encode != null){
                    if(encode.indexOf(CONTENT_ENCODING_DEFLATE) != -1){
                        // deflatek
                        in = new InflaterInputStream(in);
                    }else if(encode.indexOf(CONTENT_ENCODING_GZIP) != -1
                                || encode.indexOf(CONTENT_ENCODING_X_GZIP) != -1){
                        // gzipk
                        in = new GZIPInputStream(in);
                    }else{
                        throw new IOException("Can not decompress. [" + encode + "]");
                    }
                }
            }
            int data = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while((data = in.read()) != -1){
                baos.write(data);
            }
            buf = baos.toByteArray();
            header.setContentLength(buf.length);
            bais = new ByteArrayInputStream(buf);
            return bais;
        }
        
        /**
         * HTTPNGXg̃{fB擾B<p>
         * I{@link #read()}Ăяo܂ł́AnullB<br>
         *
         * @return HTTPNGXg̃{fB
         */
        public String toString(){
            return body;
        }
        
        /**
         * {fB̐K\v邽߂java.util.Matcher擾B<p>
         *
         * @param body {fB̐K\
         * @return K\}b`GW
         */
        public Matcher getMatcher(String body){
             return Pattern.compile(body).matcher(this.body == null ? "" : this.body);
        }
    }
}
