/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import java.util.Properties;
import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link XYPlotFactoryService}MBeanC^tF[XB<p>
 *
 * @author k2-taniguchi
 */
public interface XYPlotFactoryServiceMBean
    extends ServiceBaseMBean {

    /**
     * [f[^Zbg=_[]̃vpeBݒ肷B<p>
     *
     * @param names [f[^Zbg=_[]̃vpeB
     */
    public void setDatasetRendererServiceNames(Properties names);

    /**
     * [f[^Zbg=_[]̃vpeB擾B<p>
     *
     * @return [f[^Zbg=_[T[rX]̃vpeB
     */
    public Properties getDatasetRendererServiceNames();

    /**
     * [f[^Zbg=]̃vpeBݒ肷B<p>
     *
     * @param names [f[^Zbg=]̃vpeB
     */
    public void setDatasetDomainAxisNames(Properties names);

    /**
     * [f[^Zbg=]̃vpeB擾B<p>
     *
     * @return [f[^Zbg=]̃vpeB
     */
    public Properties getDatasetDomainAxisNames();

    /**
     * [f[^Zbg=c]̃vpeBݒ肷B<p>
     *
     * @param names [f[^Zbg=c]̃vpeB
     */
    public void setDatasetRangeAxisNames(Properties names);

    /**
     * [f[^Zbg=c]̃vpeB擾B<p>
     *
     * @return [f[^Zbg=c]̃vpeB
     */
    public Properties getDatasetRangeAxisNames();

    /**
     * f[^Zbgt@NgT[rX̔zݒ肷B<p>
     *
     * @param names f[^Zbgt@NgT[rX̔z
     */
    public void setDatasetFactoryServiceNames(ServiceName[] names);

    /**
     * f[^Zbgt@NgT[rX̔z擾B<p>
     *
     * @return f[^Zbgt@NgT[rX̔z
     */
    public ServiceName[] getDatasetFactoryServiceNames();

    /**
     * T[rX̔zݒ肷B<p>
     *
     * @param serviceNames T[rX̔z
     */
    public void setDomainAxisServiceNames(ServiceName[] serviceNames);

    /**
     * T[rX̔z擾B<p>
     *
     * @return T[rX̔z
     */
    public ServiceName[] getDomainAxisServiceNames();

    /**
     * cT[rX̔zݒ肷B<p>
     *
     * @param serviceNames cT[rX̔z
     */
    public void setRangeAxisServiceNames(ServiceName[] serviceNames);

    /**
     * cT[rX̔z擾B<p>
     *
     * @return cT[rX̔z
     */
    public ServiceName[] getRangeAxisServiceNames();

    /**
     * ڐ蒲߃T[rXݒ肷B<p>
     *
     * @param adjusters ڐ蒲߃T[rX
     */
    public void setTickUnitAdjusters(TickUnitAdjuster[] adjusters);

    /**
     * ڐ蒲߃T[rX擾B<p>
     *
     * @return ڐ蒲߃T[rX
     */
    public TickUnitAdjuster[] getTickUnitAdjusters();

    /**
     * ڐ蒲߃T[rX̃T[rXݒ肷B<p>
     *
     * @param names ڐ蒲߃T[rX̃T[rX
     */
    public void setTickUnitAdjusterServiceNames(ServiceName[] names);

    /**
     * ڐ蒲߃T[rX̃T[rX擾B<p>
     *
     * @return ڐ蒲߃T[rX̃T[rX
     */
    public ServiceName[] getTickUnitAdjusterNames();

}
