/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * vbgB<p>
 *
 * @author k2-taniguchi
 */
public class PlotConditionImpl implements PlotCondition, java.io.Serializable {
    
    private static final long serialVersionUID = -5120322206925145655L;
    
    /** vbg */
    private String name;
    /** L[Ƀf[^ZbgAlɃf[^ZbgXg */
    private Map<String, List<DatasetCondition>> dsConditionMap = null;
    /** f[^ZbgXg */
    private List<DatasetCondition> dsConditionList = null;
    /** ݒ菇̃f[^ZbgZbg */
    private LinkedHashSet<String> dsNameOrderSet = null;
    /** Lȃf[^ZbgXg */
    private Set<String> enableDsNameSet = null;

    /**
     * RXgN^B<p>
     */
    public PlotConditionImpl() {
    }

    // PlotConditionJavaDoc
    public void setName(String name) {
        this.name = name;
    }

    // PlotConditionJavaDoc
    public String getName() {
        return name;
    }

    // PlotConditionJavaDoc
    public void addDatasetCondition(DatasetCondition dsCondition) {
        if (dsConditionMap == null) {
            dsConditionMap = new HashMap<String, List<DatasetCondition>>();
        }
        if (dsConditionList == null) {
            dsConditionList = new ArrayList<DatasetCondition>();
        }
        
        if (dsConditionMap.containsKey(dsCondition.getName())) {
            List<DatasetCondition> conditions = dsConditionMap.get(dsCondition.getName());
            conditions.add(dsCondition);
            dsConditionList.add(dsCondition);
        } else {
            List<DatasetCondition> conditions = new ArrayList<DatasetCondition>();
            conditions.add(dsCondition);
            // L[Ƀf[^ZbgAlɃf[^ZbgXg
            dsConditionMap.put(dsCondition.getName(), conditions);
            dsConditionList.add(dsCondition);
        }
    }

    // PlotConditionJavaDoc
    public DatasetCondition[] getDatasetConditions(String dsName) {
        if (dsConditionMap == null) {
            return new DatasetConditionImpl[0];
        }
        
        if (dsConditionMap.containsKey(dsName)) {
            List<DatasetCondition> conditions = dsConditionMap.get(dsName);
            return conditions.toArray(new DatasetCondition[conditions.size()]);
        }

        return new DatasetConditionImpl[0];
    }
    public DatasetCondition[] getDatasetConditions(){
        if (dsConditionList == null) {
            return new DatasetConditionImpl[0];
        }
        return (DatasetCondition[])dsConditionList.toArray(new DatasetCondition[dsConditionList.size()]);
    }
    
    public Map<String, List<DatasetCondition>> getDatasetConditionMap() {
        if (dsConditionMap == null) {
            return null;
        }
        return dsConditionMap;
    }
    
    public void addDatasetConditionMap(Map<String, List<DatasetCondition>> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        
        if (dsConditionMap == null) {
            dsConditionMap = new HashMap<String, List<DatasetCondition>>();
        }
        if (dsConditionList == null) {
            dsConditionList = new ArrayList<DatasetCondition>();
        }
        
        Iterator<String> itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String dsName = itr.next();
            dsConditionList.addAll(map.get(dsName));
            if (dsConditionMap.containsKey(dsName)) {
                List<DatasetCondition> list = dsConditionMap.get(dsName);
                list.addAll(map.get(dsName));
            } else {
                dsConditionMap.put(dsName, map.get(dsName));
            }
        }
    }

    // PlotConditionJavaDoc
    public void addDatasetNameOrder(String dsName) {
        if (dsNameOrderSet == null) {
            dsNameOrderSet = new LinkedHashSet<String>();
        }
        dsNameOrderSet.add(dsName);
    }

    // PlotConditionJavaDoc
    public String[] getDatasetNameOrder() {
        if (dsNameOrderSet == null) {
            return new String[0];
        }
        
        return (String[]) dsNameOrderSet.toArray(new String[dsNameOrderSet.size()]);
    }

    public void setDatasetNameOrderSet(LinkedHashSet<String> orders) {
        dsNameOrderSet = orders;
    }
    
    public LinkedHashSet<String> getDatasetNameOrderSet() {
        return dsNameOrderSet;
    }
    
    // PlotConditionJavaDoc
    public void addEnableDatasetName(String dsName) {
        if (enableDsNameSet == null) {
            enableDsNameSet = new HashSet<String>();
        }
        enableDsNameSet.add(dsName);
    }

    // PlotConditionJavaDoc
    public String[] getEnableDatasetNames() {
        if (enableDsNameSet == null) {
            return new String[0];
        }
        
        return (String[]) enableDsNameSet.toArray(new String[enableDsNameSet.size()]);
    }
    
    public void setEnableDatasetNameSet(Set<String> names) {
        enableDsNameSet = names;
    }
    
    public Set<String> getEnableDatasetNameSet() {
        return enableDsNameSet;
    }

    // PlotConditionJavaDoc
    public Iterator<String> getDatasetNames() {
        if (dsConditionMap == null) {
            dsConditionMap = new HashMap<String, List<DatasetCondition>>();
        }
        return dsConditionMap.keySet().iterator();
    }

}
