/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.ga;

import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link DefaultSeedMatchMakerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see DefaultSeedMatchMakerService
 */
public interface DefaultSeedMatchMakerServiceMBean extends ServiceBaseMBean{
    
    /**
     * lF_B<p>
     */
    public static final int MATCH_MAKE_METHOD_RANDOM   = 1;
    
    /**
     * lF[bgB<p>
     */
    public static final int MATCH_MAKE_METHOD_ROULETTE = 2;
    
    /**
     * G[gݒ肷B<p>
     * ftHǵA0.0B<br>
     *
     * @param rate G[gB0.0 &gt;= rate &gt; 1.0
     * @exception IllegalArgumentException w肳ꂽlsȏꍇ
     */
    public void setEliteRate(float rate) throws IllegalArgumentException;
    
    /**
     * G[g擾B<p>
     *
     * @return G[g
     */
    public float getEliteRate();
    
    /**
     * hbvݒ肷B<p>
     * ftHǵA0.0B<br>
     *
     * @param rate hbvB0.0 &gt;= rate &gt; 1.0
     * @exception IllegalArgumentException w肳ꂽlsȏꍇ
     */
    public void setDropRate(float rate) throws IllegalArgumentException;
    
    /**
     * hbv擾B<p>
     *
     * @return hbv
     */
    public float getDropRate();
    
    /**
     * VKݒ肷B<p>
     * ftHǵA0.0B<br>
     *
     * @param rate VKB0.0 &gt;= rate &gt; 1.0
     * @exception IllegalArgumentException w肳ꂽlsȏꍇ
     */
    public void setNewRate(float rate) throws IllegalArgumentException;
    
    /**
     * VK擾B<p>
     *
     * @return VK
     */
    public float getNewRate();
    
    /**
     * l@ݒ肷B<p>
     * ftHǵA{@link #MATCH_MAKE_METHOD_RANDOM _}B<br>
     *
     * @param method l@
     * @see #MATCH_MAKE_METHOD_RANDOM _
     * @see #MATCH_MAKE_METHOD_ROULETTE [bg
     */
    public void setMatchMakeMethod(int method) throws IllegalArgumentException;
    
    /**
     * l@擾B<p>
     *
     * @return l@
     */
    public int getMatchMakeMethod();
    
    /**
     * G[gΏۂɊ܂߂邩ǂݒ肷B<p>
     * ftHǵAtrueŌΏۂɊ܂߂B<br>
     *
     * @param isContanis ΏۂɊ܂߂ꍇtrue
     */
    public void setContanisEliteInMatchMake(boolean isContanis);
    
    /**
     * G[gΏۂɊ܂߂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAΏۂɊ܂߂
     */
    public boolean isContanisEliteInMatchMake();
}
