/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

/**
 * LReLXgXVXi[B<p>
 *
 * @author M.Takata
 */
public interface SharedContextUpdateListener<K>{
    
    /**
     * LReLXgɒǉOɌĂяoB<p>
     *
     * @param context LReLXg
     * @param isLocal [J̒ǉ̏ꍇAtrueB[g̒ǉ̏ꍇAfalseB
     * @param key ǉL[
     * @param value ǉl
     * @return LReLXgɒǉȂꍇ́Afalse
     */
    public boolean onPutBefore(SharedContext<K> context, boolean isLocal, K key, Object value);
    
    /**
     * LReLXgɒǉꂽɌĂяoB<p>
     *
     * @param context LReLXg
     * @param isLocal [J̒ǉ̏ꍇAtrueB[g̒ǉ̏ꍇAfalseB
     * @param key ǉꂽL[
     * @param value ǉꂽl
     * @param old ȑO̒lBAANCAg[hȂǂŁAɒl݂Ȃꍇnull
     */
    public void onPutAfter(SharedContext<K> context, boolean isLocal, K key, Object value, Object old);
    
    /**
     * ɂċLReLXgɒǉOɌĂяoB<p>
     *
     * @param context LReLXg
     * @param key ǉL[
     * @param value ǉl
     * @return LReLXgɒǉȂꍇ́Afalse
     */
    public boolean onPutSynchronize(SharedContext<K> context, K key, Object value);
    
    /**
     * LReLXgɍXVOɌĂяoB<p>
     *
     * @param context LReLXg
     * @param isLocal [J̍XV̏ꍇAtrueB[g̍XV̏ꍇAfalseB
     * @param key XVL[
     * @param diff XV鍷
     * @return LReLXgɍXVȂꍇ́Afalse
     */
    public boolean onUpdateBefore(SharedContext<K> context, boolean isLocal, K key, SharedContextValueDifference diff);
    
    /**
     * LReLXgɍXVꂽɌĂяoB<p>
     *
     * @param context LReLXg
     * @param isLocal [J̍XV̏ꍇAtrueB[g̍XV̏ꍇAfalseB
     * @param key XVꂽL[
     * @param diff XVꂽ
     */
    public void onUpdateAfter(SharedContext<K> context, boolean isLocal, K key, SharedContextValueDifference diff);
    
    /**
     * LReLXg폜OɌĂяoB<p>
     *
     * @param context LReLXg
     * @param isLocal [J̍폜̏ꍇAtrueB[g̍폜̏ꍇAfalseB
     * @param key 폜L[
     * @return LReLXg폜Ȃꍇ́Afalse
     */
    public boolean onRemoveBefore(SharedContext<K> context, boolean isLocal, Object key);
    
    /**
     * LReLXg폜ꂽɌĂяoB<p>
     *
     * @param context LReLXg
     * @param isLocal [J̍폜̏ꍇAtrueB[g̍폜̏ꍇAfalseB
     * @param key 폜ꂽL[
     * @param removed 폜ꂽlBAANCAg[hȂǂŁAɒl݂Ȃꍇnull
     */
    public void onRemoveAfter(SharedContext<K> context, boolean isLocal, Object key, Object removed);
    
    /**
     * ɂċLReLXgNAOɌĂяoB<p>
     *
     * @param context LReLXg
     */
    public void onClearSynchronize(SharedContext<K> context);
}