/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Map;

import jp.ossc.nimbus.core.*;

/**
 * {@link AuthenticateInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see AuthenticateInterceptorService
 */
public interface AuthenticateInterceptorServiceMBean
 extends ServletFilterInterceptorServiceMBean{
    
    /**
     * F؏NGXg擾鎞yуZbVɐݒ肷鎞Ɏgp鑮̃ftHglB<p>
     */
    public static final String DEFAULT_AUTH_INFO_ATTRIBUTE_NAME = AuthenticateInterceptorService.class.getName().replaceAll("\\.", "_") + "_AUTH_INFO";
    
    /**
     * vIuWFNg擾{@link jp.ossc.nimbus.service.context.Context Context}T[rXݒ肷B<p>
     * ̑ݒ肵Ȃꍇ́ANGXĝݎ擾B<br>
     *
     * @param name ContextT[rX
     */
    public void setThreadContextServiceName(ServiceName name);
    
    /**
     * vIuWFNg擾{@link jp.ossc.nimbus.service.context.Context Context}T[rX擾B<p>
     *
     * @return ContextT[rX
     */
    public ServiceName getThreadContextServiceName();
    
    /**
     * vIuWFNgNGXg擾鎞Ɏgp鑮ݒ肷B<p>
     * ftHgĺA{@link StreamExchangeInterceptorServiceMBean#DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME}B<br>
     *
     * @param name 
     * @see StreamExchangeInterceptorServiceMBean#DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME
     */
    public void setRequestObjectAttributeName(String name);
    
    /**
     * vIuWFNgNGXg擾鎞Ɏgp鑮擾B<p>
     *
     * @return 
     */
    public String getRequestObjectAttributeName();
    
    /**
     * vIuWFNgReLXg擾鎞ɎgpL[ݒ肷B<p>
     * ftHgĺA{@link StreamExchangeInterceptorServiceMBean#DEFAULT_REQUEST_OBJECT_CONTEXT_KEY}B<br>
     *
     * @param key L[
     * @see StreamExchangeInterceptorServiceMBean#DEFAULT_REQUEST_OBJECT_CONTEXT_KEY
     */
    public void setRequestObjectContextKey(String key);
    
    /**
     * vIuWFNgReLXg擾鎞ɎgpL[擾B<p>
     *
     * @return L[
     */
    public String getRequestObjectContextKey();
    
    /**
     * F؏NGXg擾鎞yуZbVɐݒ肷鎞Ɏgp鑮ݒ肷B<p>
     * ftHgĺA{@link #DEFAULT_AUTH_INFO_ATTRIBUTE_NAME}B<br>
     *
     * @param name 
     * @see #DEFAULT_AUTH_INFO_ATTRIBUTE_NAME
     */
    public void setAuthenticatedInfoAttributeName(String name);
    
    /**
     * F؏NGXg擾鎞yуZbVɐݒ肷鎞Ɏgp鑮擾B<p>
     *
     * @return 
     */
    public String getAuthenticatedInfoAttributeName();
    
    /**
     * F؏ReLXg擾鎞ɎgpL[ݒ肷B<p>
     * ftHgĺA{@link #DEFAULT_AUTH_INFO_ATTRIBUTE_NAME}B<br>
     *
     * @param key L[
     * @see #DEFAULT_AUTH_INFO_ATTRIBUTE_NAME
     */
    public void setAuthenticatedInfoContextKey(String key);
    
    /**
     * F؏ReLXg擾鎞ɎgpL[擾B<p>
     *
     * @return L[
     */
    public String getAuthenticatedInfoContextKey();
    
    /**
     * ̓IuWFNgƔF؏ǂr邩̃}bsOݒ肷B<p>
     *
     * @param mapping rΏۂƂȂ̓IuWFNgƔF؏̃vpeB}bsOB̓IuWFNg̃vpeB=F؏̃vpeB
     */
    public void setAuthenticatedInfoMapping(Map<String,String> mapping);
    
    /**
     * ̓IuWFNgƔF؏ǂr邩̃}bsO擾B<p>
     *
     * @return rΏۂƂȂ̓IuWFNgƔF؏̃vpeB}bsO
     */
    public Map<String,String> getAuthenticatedInfoMapping();
    
    /**
     * F؏𐶐郍OC̃pXݒ肷B<p>
     * OC̃NGXgsAvP[VŔF؏𐶐AF؃NGXg({@link #getAuthenticatedInfoAttributeName()})ɐݒ肷KvB<br>
     *
     * @param path OC̃pX
     */
    public void setLoginPath(String path);
    
    /**
     * F؏𐶐郍OC̃pX擾B<p>
     *
     * @return OC̃pX
     */
    public String getLoginPath();
    
    /**
     * F؏폜郍OAEg̃pXݒ肷B<p>
     *
     * @param path OAEg̃pX
     */
    public void setLogoutPath(String path);
    
    /**
     * F؏폜郍OAEg̃pX擾B<p>
     *
     * @return OAEg̃pX
     */
    public String getLogoutPath();
    
    /**
     * F؏XgA{@link AuthenticateStore}T[rX̃T[rXݒ肷B<p>
     *
     * @param name AuthenticateStoreT[rX̃T[rX
     */
    public void setAuthenticateStoreServiceName(ServiceName name);
    
    /**
     * F؏XgA{@link AuthenticateStore}T[rX̃T[rX擾B<p>
     *
     * @return AuthenticateStoreT[rX̃T[rX
     */
    public ServiceName getAuthenticateStoreServiceName();
    
    /**
     * OCɁA{@link AuthenticateStore#create(HttpServletRequest, Object)}ĂяoAF؏XgA邩ǂݒ肷B<p>
     * ftHǵAtrueŔF؏XgAB<br>
     * 
     * @param isCreate F؏XgAꍇtrue
     */
    public void setStoreCreate(boolean isCreate);
    
    /**
     * OCɁA{@link AuthenticateStore#create(HttpServletRequest, Object)}ĂяoAF؏XgA邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇAF؏XgA
     */
    public boolean isStoreCreate();
    
    /**
     * OAEgɁA{@link AuthenticateStore#destroy(HttpServletRequest, Object)}ĂяoAF؏XgA폜邩ǂݒ肷B<p>
     * ftHǵAtrueŔF؏XgA폜B<br>
     * 
     * @param isDestroy F؏XgA폜ꍇtrue
     */
    public void setStoreDestroy(boolean isDestroy);
    
    /**
     * OAEgɁA{@link AuthenticateStore#destroy(HttpServletRequest, Object)}ĂяoAF؏XgA폜邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇAF؏XgA폜
     */
    public boolean isStoreDestroy();
}