/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.service.aop.InvocationContext;

/**
 * 񓯊Ăяo̖߂i[NXB<p>
 *
 * @author M.Takata
 * @see MethodAsynchronousInterceptorService
 */
public class AsynchronousResponse implements java.io.Serializable{
    
    private static final long serialVersionUID = -6354918070435188105L;
    
    private InvocationContext context;
    private Object returnObject;
    private boolean throwException;
    
    /**
     * w肳ꂽ߂lCX^X𐶐B<p>
     *
     * @param context ĂяoReLXg
     * @param ret ߂l
     */
    protected AsynchronousResponse(InvocationContext context, Object ret){
        this(context, ret, false);
    }
    
    /**
     * w肳ꂽ߂CX^X𐶐B<p>
     *
     * @param context ĂяoReLXg
     * @param ret ߂l܂throwꂽO
     * @param throwException Othrowꂽǂ̃tO
     */
    protected AsynchronousResponse(
        InvocationContext context,
        Object ret,
        boolean throwException
    ){
        this.context = context;
        returnObject = ret;
        this.throwException = throwException;
    }
    
    /**
     * ĂяoReLXg擾B<p>
     *
     * @return ĂяoReLXg
     */
    public InvocationContext getInvocationContext(){
        return context;
    }
    
    /**
     * ߂l擾B<p>
     *
     * @return ߂lBOthrowꂽꍇnull
     */
    public Object getReturnObject(){
        return throwException ? null : returnObject;
    }
    
    /**
     * Othrowꂽǂ𔻒肷B<p>
     *
     * @return Othrowꂽꍇtrue
     */
    public boolean isThrownException(){
        return throwException;
    }
    
    /**
     * throwꂽO擾B<p>
     *
     * @return throwꂽOBOthrowĂȂꍇ́Anull
     */
    public Throwable getThrownException(){
        return throwException ? (Throwable)returnObject : null;
    }
}
