/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop;

import java.util.*;

/**
 * {@link InterceptorChainList}̃ftHgB<p>
 *
 * @author M.Takata
 */
public class DefaultInterceptorChainList implements InterceptorChainList, java.io.Serializable{
    
    private static final long serialVersionUID = -2068320773199878293L;
    
    private final List<Interceptor> interceptorList;
    
    /**
     * C^[Zv^o^ĂȂXg𐶐B<p>
     */
    public DefaultInterceptorChainList(){
        interceptorList = new ArrayList<Interceptor>();
    }
    
    /**
     * w肳ꂽC^[Zv^z`F[ƂĎXg𐶐B<p>
     *
     * @param interceptors o^C^[Zv^̔z
     */
    public DefaultInterceptorChainList(Interceptor[] interceptors){
        this();
        if(interceptors != null){
            for(int i = 0; i < interceptors.length; i++){
                interceptorList.add(interceptors[i]);
            }
        }
    }
    
    /**
     * w肳ꂽC^[Zv^`F[ɒǉB<p>
     *
     * @param interceptor C^[Zv^
     */
    public void addInterceptor(Interceptor interceptor){
        interceptorList.add(interceptor);
    }
    
    /**
     * w肳ꂽC^[Zv^`F[̎w肳ꂽCfbNXɑ}B<p>
     *
     * @param index `F[̃CfbNX
     * @param interceptor C^[Zv^
     */
    public void addInterceptor(int index, Interceptor interceptor){
        interceptorList.add(index, interceptor);
    }
    
    // InterceptorChainListJavaDoc
    @Override
    public Interceptor getInterceptor(InvocationContext context, int index){
        if(interceptorList.size() <= index){
            return null;
        }
        return (Interceptor)interceptorList.get(index);
    }
    
    /**
     * C^[Zv^̃Xg擾B<p>
     *
     * @return C^[Zv^̃Xg
     */
    public List<Interceptor> getInterceptors(){
        return interceptorList;
    }
    
    /**
     * w肳ꂽC^[Zv^Xg폜B<p>
     *
     * @param interceptor 폜C^[Zv^
     */
    public void removeInterceptor(Interceptor interceptor){
        interceptorList.remove(interceptor);
    }
    
    /**
     * w肳ꂽCfbNX̃C^[Zv^Xg폜B<p>
     *
     * @param index `F[̃CfbNX
     */
    public void removeInterceptor(int index){
        interceptorList.remove(index);
    }
    
    /**
     * C^[Zv^Sč폜B<p>
     */
    public void clearInterceptor(){
        interceptorList.clear();
    }
    
    /**
     * ̃Xgɓo^ĂC^[Zv^̐擾B<p>
     *
     * @return ̃Xgɓo^ĂC^[Zv^̐
     */
    public int size(){
        return interceptorList.size();
    }
}
