/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.validator;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.beans.dataset.RecordList;

/**
 * {@link MasterValidatorService}T[rXMBeanC^tF[XB<p>
 *
 * @author M.Takata
 */
public interface MasterValidatorServiceMBean extends ServiceBaseMBean{
    
    /**
     * {@link #setBindData(int, String)}̃oChϐw肷ۂ̌ؒl̂L[B<br>
     */
    public static final String BIND_DATA_VALUE_KEY = "VALUE";
    
    /**
     * {@link jp.ossc.nimbus.service.sql.ConnectionFactory ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ConnectionFactoryT[rX̃T[rX
     */
    public void setConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.sql.ConnectionFactory ConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getConnectionFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.sql.PersistentManager PersistentManager}T[rX̃T[rXݒ肷B<p>
     *
     * @param name PersistentManagerT[rX̃T[rX
     */
    public void setPersistentManagerServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.sql.PersistentManager PersistentManager}T[rX̃T[rX擾B<p>
     *
     * @return PersistentManagerT[rX̃T[rX
     */
    public ServiceName getPersistentManagerServiceName();
    
    /**
     * NGݒ肷B<p>
     * {@link jp.ossc.nimbus.service.sql.PersistentManager#loadQuery(java.sql.Connection, String, Object, Object) PersistentManager.loadQuery()}\bh̑queryɎgpB<br>
     *
     * @param query NG
     */
    public void setQuery(String query);
    
    /**
     * NG擾B<p>
     *
     * @return NG
     */
    public String getQuery();
    
    /**
     * {@link jp.ossc.nimbus.service.codemaster.CodeMasterFinder CodeMasterFinder}T[rX̃T[rXݒ肷B<p>
     * R[h}X^XbhReLXgɐݒ肳ĂȂꍇɁACodeMasterFindergăR[h}X^擾A{@link #setCodeMasterName(String)}Őݒ肳ꂽÕ}X^RecordListgāARecordList𓮓IČ؂B<br>
     *
     * @param name CodeMasterFinderT[rX̃T[rX
     */
    public void setCodeMasterFinderServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.codemaster.CodeMasterFinder CodeMasterFinder}T[rX̃T[rX擾B<p>
     *
     * @return CodeMasterFinderT[rX̃T[rX
     */
    public ServiceName getCodeMasterFinderServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.context.ThreadContextService ThreadContextService}̃T[rXݒ肷B<p>
     * {@link #setCodeMasterThreadContextKey(String)}Őݒ肳ꂽL[ŁÃXbhReLXgR[h}X^擾A{@link #setCodeMasterName(String)}Őݒ肳ꂽÕ}X^RecordListgāARecordList𓮓IČ؂B<br>
     *
     * @param name ThreadContextServicẽT[rX
     */
    public void setThreadContextServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.context.ThreadContextService ThreadContextService}̃T[rX擾B<p>
     *
     * @return ThreadContextServicẽT[rX
     */
    public ServiceName getThreadContextServiceName();
    
    /**
     * XbhReLXgR[h}X^擾ۂ̃L[ݒ肷B<p>
     * ftHǵA{@link jp.ossc.nimbus.service.aop.interceptor.ThreadContextKey#CODEMASTER}B<br>
     *
     * @param key R[h}X^L[
     */
    public void setCodeMasterThreadContextKey(String key);
    
    /**
     * XbhReLXgR[h}X^擾ۂ̃L[擾B<p>
     *
     * @return R[h}X^L[
     */
    public String getCodeMasterThreadContextKey();
    
    /**
     * R[h}X^}X^RecordList擾ۂ̃}X^ݒ肷B<p>
     *
     * @param name }X^
     */
    public void setCodeMasterName(String name);
    
    /**
     * R[h}X^}X^RecordList擾ۂ̃}X^擾B<p>
     *
     * @return }X^
     */
    public String getCodeMasterName();
    
    /**
     * }X^RecordList̓Iݒ肷B<p>
     * ÍAߍݏƂȂׂŁAߍݏ̂ǂ̖ߍ݃p[^Ɍ؂l܂͌؂l̃vpeB𖄂ߍނ{@link #setBindDataMap(String, String)}Őݒ肷KvB<br>
     * FCOLUMN1 &gt; VALUE<br>
     * Ȉ́A{@link RecordList#searchCondition(String, java.util.Map)}QƁB<br>
     *
     * @param name I
     */
    public void setSearchCondition(String name);
    
    /**
     * }X^RecordList̓I擾B<p>
     *
     * @return I
     */
    public String getSearchCondition();
    
    /**
     * ؂l܂͂̃vpeBA}X^RecordList̓Îǂ̖ߍ݃p[^Ƃ邩ݒ肷B<p>
     * ؂ĺA{@link #BIND_DATA_VALUE_KEY}ŎQƂB<br>
     * ؂l̃vpeB́A{@link jp.ossc.nimbus.beans.PropertyFactory PropertyFactory}̋Kɏ]AQƉ\łB<br>
     * FVALUE.hoge<br>
     *
     * @param name ߍ݃p[^
     * @param valueKey ؂l܂͂̃vpeB\L[
     */
    public void setBindDataMap(String name, String valueKey);
    
    /**
     * }X^RecordList̓I̎w肳ꂽߍ݃p[^ɁAǂ̂悤ȒloCh邩擾B<p>
     *
     * @param name ߍ݃p[^
     * @return ؂l܂͂̃vpeB\L[
     */
    public String getBindDataMap(String name);
}
