/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import jp.ossc.nimbus.core.*;

/**
 * {@link AbstractSchedulerService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface AbstractSchedulerServiceMBean extends ServiceBaseMBean{
    
    /**
     * XPW[̏ԕύXɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_STATE_CHANGE_ERROR = "AS___00001";
    
    /**
     * XPW[̎sɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_EXECUTE_ERROR = "AS___00002";
    
    /**
     * XPW[𓊓ꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_ENTRY = "AS___00003";
    
    /**
     * XPW[̎oɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_SCHEDULE_GET_ERROR = "AS___00004";
    
    /**
     * \ȂG[ꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_UNEXPEXTED_ERROR = "AS___00005";
    
    /**
     * XPW[̏ԑJڂɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_STATE_TRANS_ERROR = "AS___00006";
    
    /**
     * XPW[̓Ɏsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_ENTRY_ERROR = "AS___00007";
    
    /**
     * YXPW[s݂Ȃꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_NOT_FOUND_EXECUTOR_ERROR = "AS___00008";
    
    /**
     * sׂXPW[{@link ScheduleManager}ɊmFɂԊu[ms]ݒ肷B<p>
     * ftHǵA1000[ms]B<br>
     *
     * @param interval Ԋu[ms]
     */
    public void setScheduleTickerInterval(long interval);
    
    /**
     * sׂXPW[{@link ScheduleManager}ɊmFɂԊu[ms]擾B<p>
     *
     * @return Ԋu[ms]
     */
    public long getScheduleTickerInterval();
    
    /**
     * {@link ScheduleManager}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ScheduleManagerT[rX̃T[rX
     */
    public void setScheduleManagerServiceName(ServiceName name);
    
    /**
     * {@link ScheduleManager}T[rX̃T[rX擾B<p>
     *
     * @return ScheduleManagerT[rX̃T[rX
     */
    public ServiceName getScheduleManagerServiceName();
    
    /**
     * {@link ScheduleExecutor}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ScheduleExecutorT[rX̃T[rX
     */
    public void setScheduleExecutorServiceName(ServiceName name);
    
    /**
     * {@link ScheduleExecutor}T[rX̃T[rX擾B<p>
     *
     * @return ScheduleExecutorT[rX̃T[rX
     */
    public ServiceName getScheduleExecutorServiceName();
    
    /**
     * {@link ScheduleExecutor}T[rX̃T[rXzݒ肷B<p>
     *
     * @param name ScheduleExecutorT[rX̃T[rXz
     */
    public void setScheduleExecutorServiceNames(ServiceName[] names);
    
    /**
     * {@link ScheduleExecutor}T[rX̃T[rXz擾B<p>
     *
     * @return ScheduleExecutorT[rX̃T[rXz
     */
    public ServiceName[] getScheduleExecutorServiceNames();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rXݒ肷B<p>
     * {@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rXŔԂʔԂ悹B<br>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setThreadContextServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getThreadContextServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rXݒ肷B<p>
     *
     * @param name SequenceT[rX̃T[rX
     */
    public void setSequenceServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rX擾B<p>
     *
     * @return SequenceT[rX̃T[rX
     */
    public ServiceName getSequenceServiceName();
    
    /**
     * XPW[̓ŃgUNVsǂݒ肷B<p>
     * ftHǵAfalseŁAgUNV䂵ȂB<br>
     *
     * @param isControl gUNVsꍇtrue
     */
    public void setTransactionControl(boolean isControl);
    
    /**
     * XPW[̓ŃgUNVsǂ𔻒肷B<p>
     *
     * @return truȅꍇAgUNVs
     */
    public boolean isTransactionControl();
    
    /**
     * ̃XPW[s肷L[擾B<p>
     * XPW[ɃXPW[U肽ɎgpB<br>
     * ̃L[w肷ƁA{@link ScheduleManager}XPW[擾ۂɁA{@link ScheduleManager#findExecutableSchedules(Date, String[], String)}̑OƂēnB<br>
     * w肵Ȃꍇ́A{@link ScheduleManager#findExecutableSchedules(Date, String[])}gpB<br>
     *
     * @param key sL[
     */
    public void setExecutorKey(String key);
    
    /**
     * ̃XPW[s肷L[擾B<p>
     *
     * @return sL[
     */
    public String getExecutorKey();
    
    /**
     * {@link jp.ossc.nimbus.service.transaction.TransactionManagerFactory TransactionManagerFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name TransactionManagerFactoryT[rX̃T[rX
     */
    public void setTransactionManagerFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.transaction.TransactionManagerFactory TransactionManagerFactory}T[rX̃T[rX擾B<p>
     *
     * @return TransactionManagerFactoryT[rX̃T[rX
     */
    public ServiceName getTransactionManagerFactoryServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService NX^}T[rX̃T[rXݒ肷B<p>
     * ̑ݒ肵ꍇANX^T[rX{@link jp.ossc.nimbus.service.distribute.ClusterService#isMain() ClusterService.isMain()}=trueƂȂĂꍇ̂݁AXPW[̓sB<br>
     * NX^T[rX̃NX^ւ̎Q́ÃT[rX̏ԂƘAKv邽߁A{@link jp.ossc.nimbus.service.distribute.ClusterService#setJoinOnStart(boolean) ClusterService.setJoinOnStart(false)}ɂĂKvB<br>
     *
     * @param name NX^T[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService NX^}T[rX̃T[rX擾B<p>
     *
     * @return NX^T[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * XPW[̓JnB<p>
     */
    public void startEntry();
    
    /**
     * XPW[̓~B<p>
     */
    public void stopEntry();
    
    /**
     * XPW[̓JnĂ邩肷B<p>
     *
     * @return XPW[̓JnĂꍇtrue
     */
    public boolean isStartEntry();
}