/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.*;
import javax.servlet.ServletResponse;

import jp.ossc.nimbus.service.journal.EditorFinder;

/**
 * JouralServletResponseWrapperIuWFNgMaptH[}bgGfB^B<p>
 * ̃GfB^ɂĕҏWꂽMaṕA{@link ServletResponseMapJournalEditorService}̎Map\ɉāAȉ̍\B<br>
 * <table broder="1">
 *   <tr bgcolor="#CCCCFF"><th colspan="2">L[</th><th colspan="2">l</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>^</th><th>e</th></tr>
 *   <tr><td>java.lang.String</td><td>{@link #CONTENT_LENGTH_KEY}</td><td>java.lang.Integer</td><td>Reg</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #CONTENT_KEY}</td><td>java.lang.String</td><td>Reg</td></tr>
 * </table>
 * AAo͂Ȃ悤ɐݒ肳Ă̂AJournalServletResponseWrapperɊ܂܂ĂȂAJ2EẼo[WɂĎ擾łȂ͊܂܂ȂB<br>
 * 
 * @author M.Takata
 */
public class JournalServletResponseWrapperMapJournalEditorService
 extends ServletResponseMapJournalEditorService
 implements JournalServletResponseWrapperMapJournalEditorServiceMBean, Serializable{
    
    private static final long serialVersionUID = 1611548901441049696L;
    
    /**
     * W[iƂė^ꂽJournalServletResponseWrapper^̏W[iƂďo͂MapɕϊB<br>
     * 
     * @param finder K؂JournalEditor񋟂EditorFinder
     * @param key W[ĩL[
     * @param value W[i
     * @return W[iƂďo͂Map
     */
    @Override
    protected Map<String, Object> toMap(EditorFinder finder, String key, Object value){
        final ServletResponse response = (ServletResponse)value;
        final Map<String, Object> result = super.toMap(finder, key, response);
        
        final JournalServletResponseWrapper responsew
             = (JournalServletResponseWrapper)response;
        
        makeContentLengthFormat(finder, key, responsew, result);
        makeContentFormat(finder, key, responsew, result);
        
        return result;
    }
    
    protected Map<String, Object> makeContentLengthFormat(
        EditorFinder finder,
        String key,
        JournalServletResponseWrapper response,
        Map<String, Object> map
    ){
        putMap(map, CONTENT_LENGTH_KEY, response.getContentLength());
        return map;
    }
    
    protected Map<String, Object> makeContentFormat(
        EditorFinder finder,
        String key,
        JournalServletResponseWrapper response,
        Map<String, Object> map
    ){
        putMap(map, CONTENT_KEY, response.getContent());
        return map;
    }
}
