/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.*;
import java.util.*;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;

import jp.ossc.nimbus.beans.*;

/**
 * eXgpHTTPvLṼNGXgT[rXB<p>
 * HTTPNGXg̓et@Cɏo͂B<br>
 * HTTPX|X̓éAHTTPNGXg̏ɉāAt@CǂݍŉB܂́A{@link #addAction(TestHttpProcessService.Action)}Őݒ肳ꂽɁAt@CǂݍŉB<br>
 * 
 * @author M.Takata
 */
public class TestHttpProcessService extends HttpProcessServiceBase
 implements TestHttpProcessServiceMBean{
    
    private static final long serialVersionUID = 8149760369064471308L;
    private static final String HTTP_METHOD_CONNECT = "CONNECT";
    
    private String requestOutputFileEncoding;
    private String responseInputFileEncoding;
    private List<Condition> conditionActions = new ArrayList<Condition>();
    private List<Action> actions = new ArrayList<Action>();
    
    // TestHttpProcessServiceMBeanJavaDoc
    public String getRequestOutputFileEncoding(){
        return requestOutputFileEncoding;
    }
    // TestHttpProcessServiceMBeanJavaDoc
    public void setRequestOutputFileEncoding(String encoding){
        requestOutputFileEncoding = encoding;
    }
    
    // TestHttpProcessServiceMBeanJavaDoc
    public String getResponseInputFileEncoding(){
        return responseInputFileEncoding;
    }
    // TestHttpProcessServiceMBeanJavaDoc
    public void setResponseInputFileEncoding(String encoding){
        responseInputFileEncoding = encoding;
    }
    
    /**
     * {@link HttpRequest}ɑ΂ɃANVݒ肷B<p>
     * ́A{@link HttpRequest}IuWFNgɑ΂w肷B
     * ŁAHttpRequest́A"request"ƂϐŎw肷B<br>
     *
     * @param condition 
     * @param action ANV
     * @exception Exception ̉͂Ɏsꍇ
     */
    public void setAction(String condition, Action action) throws Exception{
        final Condition cond = new Condition(condition, action);
        if(conditionActions.contains(cond)){
            conditionActions.remove(cond);
        }
        conditionActions.add(cond);
    }
    
    /**
     * ANVo^B<p>
     * o^ꂽANV́AĂяo邽тɏ邽߁AĂяoɓo^KvB<br>
     * {@link #setAction(String, TestHttpProcessService.Action)}D悳B<br>
     *
     * @param action ANV
     */
    public void addAction(Action action){
        if(actions.contains(action)){
            actions.remove(action);
        }
        actions.add(action);
    }
    
    /**
     * ANVNAB<p>
     */
    public void clearAction(){
        actions.clear();
    }
    
    /**
     * HTTPNGXg̃vLVsB<p>
     * HTTPNGXg̓et@Cɏo͂B<br>
     * HTTPX|X̓éA{@link #setAction(String, TestHttpProcessService.Action)}Őݒ肳ꂽHTTPNGXg̏ɉāAt@CǂݍŉB܂́A{@link #addAction(TestHttpProcessService.Action)}Őݒ肳ꂽɁAt@CǂݍŉB<br>
     *
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @exception Exception HTTPNGXg̏Ɏsꍇ
     */
    public void doProcess(
        HttpRequest request,
        HttpResponse response
    ) throws Exception{
        
        if(request.getHeader().getMethod().equals(HTTP_METHOD_CONNECT)){
            response.setHeader("Connection", "Keep-Alive");
            return;
        }
        
        if(request.body != null){
            request.body.read();
        }
        
        Action targetAction = null;
        if(actions.size() != 0){
            targetAction = (Action)actions.remove(0);
        }else{
            
            for(int i = 0; i < conditionActions.size(); i++){
                Condition cond = (Condition)conditionActions.get(i);
                if(cond.matchRequest(request)){
                    targetAction = cond.action;
                    break;
                }
            }
        }
        if(targetAction == null){
            response.setStatusCode(404);
            response.setStatusMessage("No action.");
            return;
        }
        
        targetAction.processAction(
            request,
            requestOutputFileEncoding,
            response,
            responseInputFileEncoding
        );
    }
    
    /**
     * HTTPNGXg̏ݒsNXB<p>
     * HTTPNGXg̏o̓t@CAHTTPX|Xwb_̐ݒAHTTPX|X{fB̓̓t@C̐ݒ肪\łB<br>
     *
     * @author M.Takata
     */
    public static class Action implements java.io.Serializable{
        
        private static final long serialVersionUID = 4155428986485777449L;
        
        private String requestOutputFile;
        private String requestHeaderOutputFile;
        private String requestBodyOutputFile;
        private String responseVersion;
        private int responseStatusCode = -1;
        private String responseStatusMessage;
        private Map<String, String[]> responseHeaderMap = new LinkedHashMap<String, String[]>();
        private String responseBodyInputFile;
        private long processTime = 0;
        
        /**
         * HTTPNGXg̏o̓t@C擾B<p>
         *
         * @return HTTPNGXg̏o̓t@C
         */
        public String getRequestOutputFile(){
            return requestOutputFile;
        }
        
        /**
         * HTTPNGXg̏o̓t@Cݒ肷B<p>
         * ̐ݒsꍇAHTTPwb_yHTTP{fB̗Ãt@Cɏo͂B<br>
         *
         * @param file HTTPNGXg̏o̓t@C
         */
        public void setRequestOutputFile(String file){
            requestOutputFile = file;
        }
        
        /**
         * HTTPNGXgwb_̏o̓t@C擾B<p>
         *
         * @return HTTPNGXgwb_̏o̓t@C
         */
        public String getRequestHeaderOutputFile(){
            return requestHeaderOutputFile;
        }
        
        /**
         * HTTPNGXgwb_̏o̓t@Cݒ肷B<p>
         * ̐ݒsꍇAHTTPwb_݂̂Ãt@Cɏo͂B<br>
         *
         * @param file HTTPNGXgwb_̏o̓t@C
         */
        public void setRequestHeaderOutputFile(String file){
            requestHeaderOutputFile = file;
        }
        
        /**
         * HTTPNGXg{fB̏o̓t@C擾B<p>
         *
         * @return HTTPNGXg{fB̏o̓t@C
         */
        public String getRequestBodyOutputFile(){
            return requestBodyOutputFile;
        }
        
        /**
         * HTTPNGXg{fB̏o̓t@Cݒ肷B<p>
         * ̐ݒsꍇAHTTP{fB݂̂Ãt@Cɏo͂B<br>
         *
         * @param file HTTPNGXg{fB̏o̓t@C
         */
        public void setRequestBodyOutputFile(String file){
            requestBodyOutputFile = file;
        }
        
        /**
         * HTTPX|XHTTPo[Wݒ肷B<p>
         * ݒ肵Ȃꍇ́AHTTPNGXgHTTPo[WƓlɂȂB<br>
         *
         * @param version HTTPo[W
         */
        public void setResponseVersion(String version){
            responseVersion = version;
        }
        
        /**
         * HTTPX|X̃Xe[^XR[hݒ肷B<p>
         * ݒ肵Ȃꍇ́A{@link HttpResponse#getStatusCode()}ɂȂB<br>
         *
         * @param code HTTPX|X̃Xe[^XR[h
         */
        public void setResponseStatusCode(int code){
           responseStatusCode = code;
        }
        
        /**
         * HTTPX|X̃Xe[^XbZ[Wݒ肷B<p>
         * ݒ肵Ȃꍇ́A{@link HttpResponse#getStatusMessage()}ɂȂB<br>
         *
         * @param message HTTPX|X̃Xe[^XbZ[W
         */
        public void setResponseStatusMessage(String message){
            responseStatusMessage = message;
        }
        
        /**
         * [ms]ݒ肷B<p>
         */
        public void setProcessTime(long time){
            processTime = time;
        }
        
        /**
         * wb_ݒ肷B<p>
         *
         * @param name wb_
         * @param val wb_l
         */
        public void setHeader(String name, String val){
            String[] vals = (String[])responseHeaderMap.get(name);
            if(vals == null){
                vals = new String[1];
                vals[0] = val;
                responseHeaderMap.put(name, vals);
            }else{
                final String[] newVals = new String[vals.length + 1];
                System.arraycopy(vals, 0, newVals, 0, vals.length);
                newVals[newVals.length - 1] = val;
                responseHeaderMap.put(name, newVals);
            }
        }
        
        /**
         * wb_ݒ肷B<p>
         *
         * @param name wb_
         * @param vals wb_lz
         */
        public void setHeaders(String name, String[] vals){
            responseHeaderMap.put(name, vals);
        }
        
        /**
         * wb_̏W擾B<p>
         *
         * @return wb_̏W
         */
        protected Set<String> getHeaderNameSet(){
            return responseHeaderMap.keySet();
        }
        
        /**
         * wb_擾B<p>
         *
         * @param name wb_
         * @return wb_l
         */
        protected String getHeader(String name){
            final String[] vals = (String[])responseHeaderMap.get(name);
            return vals == null ? null : vals[0];
        }
        
        /**
         * wb_擾B<p>
         *
         * @param name wb_
         * @return wb_lz
         */
        protected String[] getHeaders(String name){
            return (String[])responseHeaderMap.get(name);
        }
        
        /**
         * HTTPX|X{fB̓̓t@C擾B<p>
         *
         * @return HTTPX|X{fB̓̓t@C
         */
        public String getResponseBodyInputFile(){
            return responseBodyInputFile;
        }
        
        /**
         * HTTPX|X{fB̓̓t@Cݒ肷B<p>
         *
         * @param file HTTPX|X{fB̓̓t@C
         */
        public void setResponseBodyInputFile(String file){
            responseBodyInputFile = file;
        }
        
        private void mkdirs(String path) throws IOException{
            File file = new File(path);
            if(!file.exists()){
                File parent = file.getParentFile();
                if(parent != null && !parent.exists()){
                    parent.mkdirs();
                }
            }
        }
        
        public void processAction(
            HttpRequest request,
            String requestOutputFileEncoding,
            HttpResponse response,
            String responseInputFileEncoding
        ) throws Exception{
            if(processTime > 0){
                Thread.sleep(processTime);
            }
            writeRequest(request, requestOutputFileEncoding);
            writeResponse(response, responseInputFileEncoding);
        }
        
        /**
         * HTTPNGXgt@Cɏo͂B<p>
         *
         * @param request HTTPNGXg
         * @param requestOutputFileEncoding o̓t@CGR[fBO
         * @exception IOException t@C̏o͂Ɏsꍇ
         */
        protected void writeRequest(
            HttpRequest request,
            String requestOutputFileEncoding
        ) throws IOException{
            if(requestOutputFile != null){
                mkdirs(requestOutputFile);
                final FileOutputStream fos
                     = new FileOutputStream(requestOutputFile);
                fos.write(
                    requestOutputFileEncoding == null
                         ? request.header.header.getBytes()
                            : request.header.header.getBytes(requestOutputFileEncoding)
                );
                if(request.body != null){
                    fos.write(
                        requestOutputFileEncoding == null
                             ? request.body.body.getBytes()
                                : request.body.body.getBytes(requestOutputFileEncoding)
                    );
                }
                fos.close();
            }else{
                if(requestHeaderOutputFile != null){
                    mkdirs(requestHeaderOutputFile);
                    final FileOutputStream fos
                         = new FileOutputStream(requestHeaderOutputFile);
                    fos.write(
                        requestOutputFileEncoding == null
                             ? request.header.header.getBytes()
                                : request.header.header.getBytes(requestOutputFileEncoding)
                    );
                    fos.close();
                }
                if(request.body != null && requestBodyOutputFile != null){
                    mkdirs(requestBodyOutputFile);
                    final FileOutputStream fos
                         = new FileOutputStream(requestBodyOutputFile);
                    fos.write(
                        requestOutputFileEncoding == null
                             ? request.body.body.getBytes()
                                : request.body.body.getBytes(requestOutputFileEncoding)
                    );
                    fos.close();
                }
            }
        }
        
        /**
         * HTTPX|Xt@CǂݍŁAX|XXg[ɏo͂B<p>
         *
         * @param response HTTPX|X
         * @param responseInputFileEncoding ̓t@CGR[fBO
         * @exception IOException t@C̓͂Ɏsꍇ
         */
        protected void writeResponse(HttpResponse response, String responseInputFileEncoding) throws IOException{
            if(responseVersion != null){
                response.setVersion(responseVersion);
            }
            if(responseStatusCode != -1){
                response.setStatusCode(responseStatusCode);
            }
            if(responseStatusMessage != null){
                response.setStatusMessage(responseStatusMessage);
            }
            final Iterator<String> headerNames = getHeaderNameSet().iterator();
            while(headerNames.hasNext()){
                final String headerName = (String)headerNames.next();
                response.setHeaders(headerName, getHeaders(headerName));
            }
            if(responseBodyInputFile != null){
                final OutputStream os = response.getOutputStream();
                final ByteArrayOutputStream baos = new ByteArrayOutputStream();
                final FileInputStream fis
                     = new FileInputStream(responseBodyInputFile);
                try{
                    int length = 0;
                    byte[] buf = new byte[1024];
                    while((length = fis.read(buf)) != -1){
                        baos.write(buf, 0, length);
                    }
                    if(responseInputFileEncoding == null){
                        buf = new String(baos.toByteArray())
                            .getBytes(response.getCharacterEncoding());
                    }else{
                        buf = new String(
                            baos.toByteArray(),
                            responseInputFileEncoding
                        ).getBytes(response.getCharacterEncoding());
                    }
                    os.write(buf);
                }finally{
                    fis.close();
                }
            }
        }
    }
    
    /**
     * B<p>
     *
     * @author M.Takata
     */
    private static class Condition implements java.io.Serializable{
        
        private static final long serialVersionUID = -5495011425410843307L;
        
        private static final String PROP_FUNCTION_NAME = "prop";
        protected static final String REQUEST_KEY = "request";
        
        private transient Expression expression;
        private String condition;
        
        /**
         * ̏ɍvꍇ̃ANVB<p>
         */
        Action action;
        
        /**
         * CX^X𐶐B<p>
         *
         * @param cond 
         * @param action ̏ɍvꍇ̃ANV
         * @exception Exception ̉͂Ɏsꍇ
         */
        public Condition(String cond, Action action) throws Exception{
            initCondition(cond);
            this.action = action;
        }
        
        /**
         * ͂B<p>
         *
         * @param cond 
         */
        public void initCondition(String cond){
            JexlEngine jexl = new JexlEngine();
            jexl.setSilent(true);
            Map<String, Object> funcs = new HashMap<String, Object>();
            PropertyAccess propAccess = new PropertyAccess();
            propAccess.setIgnoreNullProperty(true);
            funcs.put(PROP_FUNCTION_NAME, propAccess);
            jexl.setFunctions(funcs);
            expression = jexl.createExpression(cond);
            matchRequest(new HttpRequest(), true);
            condition = cond;
        }
        
        /**
         * w肳ꂽHTTPNGXg̏ɍv邩肷B<p>
         *
         * @param request HTTPNGXg
         * @return ɍvꍇtrue
         */
        protected boolean matchRequest(HttpRequest request){
            return matchRequest(request, false);
        }
        
        /**
         * w肳ꂽHTTPNGXg̏ɍv邩肷B<p>
         *
         * @param request HTTPNGXg
         * @param isTest ̃eXgsǂBtruȅꍇAeXgsłAnHTTPNGXgł邽߁A]ʂbooleanɂȂȂĂOthrowȂ
         * @return ɍvꍇtrue
         * @exception IllegalArgumentException ]ʂbooleanłȂꍇBAAeXgs̏ꍇ́AthrowȂB
         * @exception RuntimeException ̕]ɗOꍇ
         */
        protected boolean matchRequest(HttpRequest request, boolean isTest){
            JexlContext jexlContext = new MapContext();
            jexlContext.set(REQUEST_KEY, request);
            
            Object exp = expression.evaluate(jexlContext);
            if(exp instanceof Boolean){
                return ((Boolean)exp).booleanValue();
            }else{
                if(exp == null && isTest){
                    return true;
                }
                throw new IllegalArgumentException(
                    "Result of condition is not boolean : " + condition
                );
            }
        }
        
        private void readObject(ObjectInputStream in)
         throws IOException, ClassNotFoundException{
            in.defaultReadObject();
            try{
                initCondition(condition);
            }catch(Exception e){
                // NȂ͂
            }
        }
        
        /**
         * w肳ꂽIuWFNg̃IuWFNgƓConditionIuWFNgǂ𔻒肷B<p>
         *
         * @param obj rΏۃIuWFNg
         * @return ConditionIuWFNg̏ꍇtrue
         */
        public boolean equals(Object obj){
            if(obj == null){
                return false;
            }
            if(obj == this){
                return true;
            }
            if(!(obj instanceof Condition)){
                return false;
            }
            Condition comp = (Condition)obj;
            if(condition == null){
                return comp.condition == null;
            }else{
                return condition.equals(comp.condition);
            }
        }
        
        /**
         * nbVl擾B<p>
         *
         * @return nbVl
         */
        public int hashCode(){
            return condition == null ? 0 : condition.hashCode();
        }
    }
}