/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.context;

import java.util.*;

/**
 * ReLXgB<p>
 * ӂȃL[Ɋ֘AtꂽReLXgێB<br>
 *
 * @author M.Takata
 */
public interface Context<K, V> extends Map<K, V>{
    
    /**
     * ێĂReLXg̐擾B<p>
     *
     * @return ێĂReLXg̐
     */
    public int size();
    
    /**
     * ReLXgێĂȂׂB<p>
     *
     * @return ReLXgێĂȂꍇtrue
     */
    public boolean isEmpty();
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽReLXg񂪑݂邩ׂB<p>
     *
     * @param key L[
     * @return w肳ꂽL[Ɋ֘AtꂽReLXg񂪑݂ꍇtrue
     */
    public boolean containsKey(Object key);
    
    /**
     * w肳ꂽReLXg񂪑݂邩ׂB<p>
     *
     * @param value ReLXg
     * @return w肳ꂽReLXg񂪑݂ꍇtrue
     */
    public boolean containsValue(Object value);
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽReLXg擾B<p>
     *
     * @param key L[
     * @return L[Ɋ֘AtꂽReLXgBYReLXg񂪂Ȃꍇ́Anull
     */
    public V get(Object key);
    
    /**
     * w肳ꂽReLXgw肳ꂽL[Ɋ֘AtĐݒ肷B<p>
     * 
     * @param key L[
     * @param value ReLXg
     * @return w肳ꂽL[Ɋ֘AtĂReLXgB݂Ȃꍇ́Anull
     */
    public V put(K key, V value);
    
    /**
     * w肳ꂽL[Ɋ֘AtꂽReLXg폜B<p>
     *
     * @param key L[
     * @return 폜ꂽReLXgB폜ReLXg񂪂Ȃꍇ́Anull
     */
    public V remove(Object key);
    
    /**
     * w肳ꂽ}bvɊ܂܂SẴL[ƒlReLXgƂĐݒ肷B<p>
     *
     * @param t ReLXgƂĐݒ肷}bv
     */
    public void putAll(Map<? extends K, ? extends V> t);
    
    /**
     * SẴReLXg폜B<p>
     */
    public void clear();
    
    /**
     * ReLXg̃L[W擾B<p>
     *
     * @return ReLXg̃L[W
     */
    public Set<K> keySet();
    
    /**
     * ReLXg̏W擾B<p>
     *
     * @return ReLXg̏W
     */
    public Collection<V> values();
    
    /**
     * ReLXg̃GgW擾B<p>
     *
     * @return ReLXg̃GgW
     */
    public Set<Map.Entry<K, V>> entrySet();
    
    /**
     * w肳ꂽIuWFNgƓrB<p>
     *
     * @return ꍇtrue
     */
    public boolean equals(Object o);
    
    /**
     * ̃ReLXg̃nbVl擾B<p>
     *
     * @return nbVl
     */
    public int hashCode();
}
