/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Method;
import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * {@link NoCalledMethodMetricsInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see NoCalledMethodMetricsInterceptorService
 */
public interface NoCalledMethodMetricsInterceptorServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * vΏۂ̃NX̃NXCqw肷B<p>
     * Ŏw肳ꂽNXCq̃NXvΏۂƂȂBw肵Ȃꍇ́ANXCq͌肳ȂB<br>
     * Cqے肷ꍇ́AeCq̑O"!"t^邱ƁB
     *
     * @param modifiers NXCq
     */
    public void setTargetClassModifiers(String modifiers);
    
    /**
     * vΏۂ̃NX̃NXCq擾B<p>
     *
     * @return NXCq
     */
    public String getTargetClassModifiers();
    
    /**
     * vΏۂ̃NXw肷B<p>
     * Ŏw肳ꂽNX̃NXvΏۂƂȂBw肵Ȃꍇ́ANX͌肳ȂB܂AK\w肷鎖\łB
     *
     * @param name pbP[W܂ފSCNXBK\B
     */
    public void setTargetClassName(String name);
    
    /**
     * vΏۂ̃NX擾B<p>
     *
     * @return pbP[W܂ފSCNXBK\B
     */
    public String getTargetClassName();
    
    /**
     * vΏۂ̃CX^X̃NXw肷B<p>
     * Ŏw肳ꂽNX̃CX^XvΏۂƂȂBw肵Ȃꍇ́ACX^X͌肳ȂB
     *
     * @param name pbP[W܂ފSCNX
     */
    public void setTargetInstanceClassName(String name);
    
    /**
     * vΏۂ̃CX^X̃NX擾B<p>
     *
     * @return pbP[W܂ފSCNXB
     */
    public String getTargetInstanceClassName();
    
    /**
     * vΏۂ̃\bh̃\bhCqw肷B<p>
     * Ŏw肳ꂽ\bhCq̃\bhvΏۂƂȂBw肵Ȃꍇ́A\bhCq͌肳ȂB<br>
     * Cqے肷ꍇ́AeCq̑O"!"t^邱ƁB
     *
     * @param modifiers \bhCq
     */
    public void setTargetMethodModifiers(String modifiers);
    
    /**
     * vΏۂ̃\bh̃\bhCq擾B<p>
     *
     * @return \bhCq
     */
    public String getTargetMethodModifiers();
    
    /**
     * vΏۂ̃\bhw肷B<p>
     * Ŏw肳ꂽ\bh̃\bhvΏۂƂȂBw肵Ȃꍇ́A\bh͌肳ȂB܂AK\w肷鎖\łB
     *
     * @param name \bhBK\B
     */
    public void setTargetMethodName(String name);
    
    /**
     * vΏۂ̃\bh擾B<p>
     *
     * @return \bhBK\B
     */
    public String getTargetMethodName();
    
    /**
     * vΏۂ̃\bḧ̌^\NXw肷B<p>
     * Ŏw肳ꂽ^\bhvΏۂƂȂBw肵Ȃꍇ́A^͌肳ȂB܂AK\w肷鎖\łB
     *
     * @param paramTypes \bḧ̌^\NX̔zBK\B
     */
    public void setTargetParameterTypes(String[] paramTypes);
    
    /**
     * vΏۂ̃\bḧ̌^\NX擾B<p>
     *
     * @return \bḧ̌^\NX̔zBK\B
     */
    public String[] getTargetParameterTypes();
    
    /**
     * vΏۂ̃NXɐ錾Ă郁\bhΏۂɂ邩ǂݒ肷B<p>
     * ftHǵAfalseŁApꂽ\bhΏۂɂ
     *
     * @param isDeclaring vΏۂ̃NXɐ錾Ă郁\bhΏۂɂꍇAtrue
     */
    public void setDeclaringMethod(boolean isDeclaring);
    
    /**
     * vΏۂ̃NXɐ錾Ă郁\bhΏۂɂ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAvΏۂ̃NXɐ錾Ă郁\bhΏۂɂ
     */
    public boolean isDeclaringMethod();
    
    /**
     * JVM̃NXpXɉāANXpXǉB<p>
     * ΃pXw肵ꍇ́AspX̑΃pXɉāÃT[rX`ĂT[rX`t@C̑΃pXɂpXsB<br>
     *
     * @param paths NXpX̔z
     */
    public void setClassPaths(String[] paths);
    
    /**
     * JVM̃NXpXɉNXpX擾B<p>
     *
     * @return NXpX̔z
     */
    public String[] getClassPaths();
    
    /**
     * vΏۂ̃\bhW擾B<p>
     *
     * @return vΏۂMethodIuWFNg̏W
     */
    public Set<Method> getTargetMethodSet();
    
    /**
     * vΏۂ̃\bhꗗ擾B<p>
     *
     * @return vΏۂ̃\bhꗗ
     */
    public String getTargetMethodString();
    
    /**
     * v擾ʁAΏۂ̃\bĥŌĂяoĂȂ\bhW擾B<p>
     *
     * @return vΏۂ̃\bĥŌĂяoĂȂ\bhW
     */
    public Set<Method> getNoCalledMethodSet();
    
    /**
     * v擾ʁAΏۂ̃\bĥŌĂяoĂȂ\bhꗗ擾B<p>
     *
     * @return vΏۂ̃\bĥŌĂяoĂȂ\bhꗗ
     */
    public String getNoCalledMethodString();
    
    /**
     * vʂT[rX̒~ɕWo͂ɏo͂邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isOutput o͂ꍇ́Atrue
     */
    public void setOutputSystemOut(boolean isOutput);
    
    /**
     * vʂT[rX̒~ɕWo͂ɏo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean isOutputSystemOut();
}
