/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util;

/**
 * j^B<p>
 * 
 * @author M.Takata
 */
public interface SynchronizeMonitor{
    
    /**
     * ĂяoXbhɑ΂郂j^B<p>
     * {@link #waitMonitor()}A{@link #waitMonitor(long)}ĂяoOɁÃ\bhĂԕKvB<br>
     *
     * @return j^OɒʒmĂtrue
     */
    public boolean initMonitor();
    
    /**
     * w肵Xbhɑ΂郂j^B<p>
     * w肵XbhA{@link #waitMonitor()}A{@link #waitMonitor(long)}ĂяoOɁÃ\bhĂԕKvB<br>
     *
     * @param thread ̃j^ɑ΂đҋ@Xbh
     * @return j^OɒʒmĂtrue
     */
    public boolean initMonitor(Thread thread);
    
    /**
     * ĂяoXbhɑ΂郂j^B<p>
     * Xbhł̃j^ėpꍇɂ́Ã\bhĂяoȂĂǂB<br>
     */
    public void releaseMonitor();
    
    /**
     * SẴj^B<p>
     */
    public void releaseAllMonitor();
    
    /**
     * ʒm܂őҋ@B<p>
     * {@link #notifyMonitor()}A{@link #notifyAllMonitor()}ɂĒʒm܂őҋ@B<br>
     *
     * @exception InterruptedException 肱܂ꂽꍇ
     */
    public void initAndWaitMonitor() throws InterruptedException;
    
    /**
     * ʒm邩Aw肳ꂽԂo߂܂őҋ@B<p>
     * {@link #notifyMonitor()}A{@link #notifyAllMonitor()}ɂĒʒm܂őҋ@B<br>
     *
     * @return ʒmɂċNꂽꍇtrueB^CAEgꍇfalse
     * @exception InterruptedException 肱܂ꂽꍇ
     */
    public boolean initAndWaitMonitor(long timeout) throws InterruptedException;
    
    /**
     * ʒm܂őҋ@B<p>
     * {@link #notifyMonitor()}A{@link #notifyAllMonitor()}ɂĒʒm܂őҋ@B<br>
     *
     * @exception InterruptedException 肱܂ꂽꍇ
     */
    public void waitMonitor() throws InterruptedException;
    
    /**
     * ʒm邩Aw肳ꂽԂo߂܂őҋ@B<p>
     * {@link #notifyMonitor()}A{@link #notifyAllMonitor()}ɂĒʒm܂őҋ@B<br>
     *
     * @return ʒmɂċNꂽꍇtrueB^CAEgꍇfalse
     * @exception InterruptedException 肱܂ꂽꍇ
     */
    public boolean waitMonitor(long timeout) throws InterruptedException;
    
    /**
     * ҋ@Ăŏ̃XbhɒʒmB<p>
     */
    public void notifyMonitor();
    
    /**
     * ҋ@ĂSẴXbhɒʒmB<p>
     */
    public void notifyAllMonitor();
    
    /**
     * ̃XbhʒmɂċNꂽǂ𔻒肷B<p>
     * 
     * @return ʒmɂċNꂽꍇtrue
     */
    public boolean isNotify();
    
    /**
     * ŏɑҋ@ĂXbh݂̃Xbhǂ𔻒肷B<p>
     * 
     * @return ŏɑҋ@ĂXbh݂̃Xbhłꍇtrue
     */
    public boolean isFirst();
    
    /**
     * ҋ@ĂXbh݂邩ǂ𔻒肷B<p>
     * 
     * @return ҋ@ĂXbh݂ꍇtrue
     */
    public boolean isWait();
    
    /**
     * ҋ@ĂXbh̐擾B<p>
     * 
     * @return ҋ@ĂXbh̐
     */
    public int getWaitCount();
    
    /**
     * ҋ@ĂXbh擾B<p>
     * 
     * @return ҋ@ĂXbh̔z
     */
    public Thread[] getWaitThreads();
    
    /**
     * IB<p>
     * ҋ@ĂSẴXbhɒʒmÃj^𖳌ɂB<br>
     */
    public void close();
}