/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import java.io.Serializable;
import java.sql.*;
import java.util.*;
import java.lang.reflect.*;

import jp.ossc.nimbus.beans.*;
import jp.ossc.nimbus.core.*;

/**
 * bvRlNVt@NgB<p>
 * w肳ꂽRlNVt@NgRlNVRlNVbpŃbvĕԂB<br>
 * RlNVbpNX́Ajava.sql.ConnectionC^tF[XAjava.sql.ConnectionRXgN^Ȃ΂ȂȂB<br>
 * ȉɁAT[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="ConnectionFactory"
 *                  code="jp.ossc.nimbus.service.sql.WrappedConnectionFactoryService"&gt;
 *             &lt;attribute name="ConnectionFactoryServiceName"&gt;#JDBCConnectionFactory&lt;/attribute&gt;
 *             &lt;attribute name="ConnectionWrapperClassName"&gt;sample.sql.ConnectionWrapper&lt;/attribute&gt;
 *             &lt;depends&gt;JDBCConnectionFactory&lt;/depends&gt;
 *         &lt;/service&gt;
 *         
 *         &lt;service name="JDBCConnectionFactory"
 *                  code="jp.ossc.nimbus.service.sql.JDBCConnectionFactoryService"&gt;
 *             &lt;attribute name="DriverName"&gt;com.mysql.jdbc.Driver&lt;/attribute&gt;
 *             &lt;attribute name="ConnectionURL"&gt;jdbc:mysql://localhost/sample?useUnicode=true&amp;characterEncoding=MS932&lt;/attribute&gt;
 *             &lt;attribute name="UserName"&gt;hoge&lt;/attribute&gt;
 *             &lt;attribute name="Password"&gt;fuga&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class WrappedConnectionFactoryService extends ServiceBase
 implements ConnectionFactory, WrappedConnectionFactoryServiceMBean, Serializable{
    
    private static final long serialVersionUID = -7525550711109470382L;
    
    /**
     * bvConnectionFactoryT[rX̃T[rXB<p>
     */
    private ServiceName connectionFactoryServiceName;
    
    /**
     * bvConnectionFactoryT[rXB<p>
     */
    private ConnectionFactory connectionFactory;
    
    /**
     * {@link java.sql.Connection}bvNXB<p>
     */
    private Class<Connection> connectionWrapperClass;
    
    private Map<String, Object> connectionWrapperProperties;
    
    private Map<Property, Object> properties;
    
    /**
     * JnsB<p>
     *
     * @exception Exception JnɎsꍇ
     */
    public void startService() throws Exception{
        
        if(connectionFactoryServiceName != null){
            connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(
                connectionFactoryServiceName
            );
        } else if(connectionFactory == null) {
            throw new IllegalArgumentException(
                "Argument : ConnectionFactoryServiceName or ConnectionFactory is null."
            );
        }
        
        if(connectionWrapperProperties != null
            && connectionWrapperProperties.size() != 0){
            properties = new LinkedHashMap<Property, Object>();
            for(Map.Entry<String, Object> entry : connectionWrapperProperties.entrySet()){
                final Property property
                     = PropertyFactory.createProperty(entry.getKey());
                properties.put(property, entry.getValue());
            }
        }
    }
    
    /**
     * ~sB<p>
     *
     * @exception Exception ~Ɏsꍇ
     */
    public void stopService() throws Exception{
        connectionFactory = null;
        connectionWrapperClass = null;
        properties = null;
    }
    
    // ConnectionFactoryJavaDoc
    public Connection getConnection() throws ConnectionFactoryException{
        Connection con = connectionFactory.getConnection();
        if(con != null && connectionWrapperClass != null){
            try{
                final Constructor<Connection> constructor
                     = connectionWrapperClass.getConstructor(
                        new Class[]{Connection.class}
                    );
                con = constructor.newInstance(new Object[]{con});
                if(properties != null){
                    for(Map.Entry<Property, Object> entry : properties.entrySet()){
                        entry.getKey().setProperty(con, entry.getValue());
                    }
                }
            }catch(InstantiationException e){
                throw new ConnectionFactoryException(e);
            }catch(IllegalAccessException e){
                throw new ConnectionFactoryException(e);
            }catch(InvocationTargetException e){
                throw new ConnectionFactoryException(e.getTargetException());
            }catch(NoSuchMethodException e){
                throw new ConnectionFactoryException(e);
            }catch(NoSuchPropertyException e){
                throw new ConnectionFactoryException(e);
            }
        }
        return con;
    }
    
    // WrappedConnectionFactoryServiceMBeanJavaDoc
    public void setConnectionFactoryServiceName(ServiceName name){
        connectionFactoryServiceName = name;
    }
    
    // WrappedConnectionFactoryServiceMBeanJavaDoc
    public ServiceName getConnectionFactoryServiceName(){
        return connectionFactoryServiceName;
    }
    
    // WrappedConnectionFactoryServiceMBeanJavaDoc
    public void setConnectionWrapperClass(Class<Connection> clazz){
        connectionWrapperClass = clazz;
    }
    
    // WrappedConnectionFactoryServiceMBeanJavaDoc
    public Class<Connection> getConnectionWrapperClass(){
        return connectionWrapperClass;
    }
    
    // WrappedConnectionFactoryServiceMBeanJavaDoc
    public void setConnectionWrapperProperties(Map<String, Object> prop){
        connectionWrapperProperties = prop;
    }
    
    // WrappedConnectionFactoryServiceMBeanJavaDoc
    public Map<String, Object> getConnectionWrapperProperties(){
        return connectionWrapperProperties;
    }
    
    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}