/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.proxy;

import jp.ossc.nimbus.core.*;

/**
 * {@link RemoteServiceServerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see RemoteServiceServerService
 */
public interface RemoteServiceServerServiceMBean extends ServiceBaseMBean{
    
    /**
     * [gĂяoT[rX̃T[rXݒ肷B<p>
     * Ŏw肳ꂽT[rX́A{@link jp.ossc.nimbus.service.aop.InvocationContext#getTargetObject() InvocationContext.getTargetObject()}ŁAĂяoΏۂ̃T[rXw肳Ăꍇ́ÃT[rXƈv邩ǂ̃`FbNɗpAvȂꍇ́AIllegalAccessExceptionthrowB<br>
     * ܂AInvocationContext.getTargetObject()ŁAĂяoΏۂ̃T[rXw肳ĂȂꍇ́AŎw肳ꂽT[rXĂяoB<br>
     * 
     * @param name [gĂяoT[rX̃T[rX
     */
    public void setRemoteServiceName(ServiceName name);
    
    /**
     * [gĂяoT[rX̃T[rX擾B<p>
     * 
     * @return [gĂяoT[rX̃T[rX
     */
    public ServiceName getRemoteServiceName();
    
    /**
     * [gĂяoT[rXɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChainList InterceptorChainList}T[rX̃T[rXݒ肷B<p>
     * C^[Zv^ݍ܂Ȃꍇ́Aݒ肵ȂĂǂB<br>
     *
     * @param name InterceptorChainListT[rX̃T[rX
     */
    public void setInterceptorChainListServiceName(ServiceName name);
    
    /**
     * [gĂяoT[rXɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChainList InterceptorChainList}T[rX̃T[rX擾B<p>
     *
     * @return InterceptorChainListT[rX̃T[rX
     */
    public ServiceName getInterceptorChainListServiceName();
    
    /**
     * [gĂяoT[rXĂяo{@link jp.ossc.nimbus.service.aop.Invoker Invoker}T[rX̃T[rXݒ肷B<p>
     * ftHǵA{@link jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService MethodReflectionCallInvokerService}T[rXŐgpB<br>
     *
     * @param name InvokerT[rX̃T[rX
     */
    public void setInvokerServiceName(ServiceName name);
    
    /**
     * [gĂяoT[rXĂяo{@link jp.ossc.nimbus.service.aop.Invoker Invoker}T[rX̃T[rX擾B<p>
     *
     * @return InvokerT[rX̃T[rX
     */
    public ServiceName getInvokerServiceName();
    
    /**
     * [gĂяoT[rXɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChain InterceptorChain}𐶐{@link jp.ossc.nimbus.service.aop.InterceptorChainFactory InterceptorChainFactory}̃T[rXݒ肷B<p>
     *
     * @param name InterceptorChainFactoryT[rX̃T[rX
     */
    public void setInterceptorChainFactoryServiceName(ServiceName name);
    
    /**
     * [gĂяoT[rXɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChain InterceptorChain}𐶐{@link jp.ossc.nimbus.service.aop.InterceptorChainFactory InterceptorChainFactory}̃T[rX擾B<p>
     *
     * @return InterceptorChainFactoryT[rX̃T[rX
     */
    public ServiceName getInterceptorChainFactoryServiceName();
    
    /**
     * {@link RemoteServerInvoker}JNDIɃoChۂJNDIݒ肷B<p>
     * ̑ݒ肵ĂȂA{@link #setRemoteServiceName(ServiceName)}ݒ肳Ăꍇ́AŐݒ肳ꂽ[gĂяoT[rX{@link ServiceName}A"}l[W/T[rX"ƂJNDIKpB<br>
     * ǂݒ肳ĂȂꍇ́AT[rX̊JnŗOB<br>
     *
     * @param name RemoteServerInvokerJNDIɃoChۂJNDI
     */
    public void setJndiName(String name);
    
    /**
     * {@link RemoteServerInvoker}JNDIɃoChۂJNDI擾B<p>
     *
     * @return RemoteServerInvokerJNDIɃoChۂJNDI
     */
    public String getJndiName();
    
    /**
     * {@link RemoteServerInvoker}JNDIɃoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rXݒ肷B<p>
     *
     * @param name RepositoryT[rX̃T[rX
     */
    public void setJndiRepositoryServiceName(ServiceName name);
    
    /**
     * {@link RemoteServerInvoker}JNDIɃoCh{@link jp.ossc.nimbus.service.repository.Repository Repository}T[rX̃T[rX擾B<p>
     *
     * @return RepositoryT[rX̃T[rX
     */
    public ServiceName getJndiRepositoryServiceName();
    
    /**
     * {@link RemoteServerInvoker}ɑ΂RMIĂяo鎞̃|[gԍݒ肷B<p>
     * ftHǵA0ŔCӂ̃|[ggpB<br>
     *
     * @param port |[gԍ
     */
    public void setRMIPort(int port);
    
    /**
     * {@link RemoteServerInvoker}ɑ΂RMIĂяo鎞̃|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getRMIPort();
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService NX^}T[rX̃T[rXݒ肷B<p>
     * ̑ݒ肵ꍇ́ANX^T[rX̃o[̃IvV{@link jp.ossc.nimbus.service.aop.KeepAliveCheckInvoker KeepAliveCheckInvoker}ݒ肷鎖ŁANX^T[rXoRł̃[gĂяoT|[gB<br>
     * NX^T[rX̃NX^ւ̎Q́ÃT[rX̏ԂƘAKv邽߁A{@link jp.ossc.nimbus.service.distribute.ClusterService#setJoinOnStart(boolean) ClusterService.setJoinOnStart(false)}ɂĂKvB<br>
     *
     * @param name NX^T[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService NX^}T[rX̃T[rX擾B<p>
     *
     * @return NX^T[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * java.rmi.server.RMIClientSocketFactoryT[rX̃T[rXݒ肷B<p>
     *
     * @param name RMIClientSocketFactoryT[rX̃T[rX
     */
    public void setRMIClientSocketFactoryServiceName(ServiceName name);
    
    /**
     * java.rmi.server.RMIClientSocketFactoryT[rX̃T[rX擾B<p>
     *
     * @return RMIClientSocketFactoryT[rX̃T[rX
     */
    public ServiceName getRMIClientSocketFactoryServiceName();
    
    /**
     * java.rmi.server.RMIServerSocketFactoryT[rX̃T[rXݒ肷B<p>
     *
     * @param name RMIServerSocketFactoryT[rX̃T[rX
     */
    public void setRMIServerSocketFactoryServiceName(ServiceName name);
    
    /**
     * java.rmi.server.RMIServerSocketFactoryT[rX̃T[rX擾B<p>
     *
     * @return RMIServerSocketFactoryT[rX̃T[rX
     */
    public ServiceName getRMIServerSocketFactoryServiceName();
}
