/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.log;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.context.*;
import jp.ossc.nimbus.service.message.*;
import jp.ossc.nimbus.service.queue.*;
import jp.ossc.nimbus.service.writer.*;

/**
 * {@link DefaultLoggerService}T[rXMBeanC^tF[XB<p>
 *
 * @author Y.Tokuda
 */
public interface DefaultLoggerServiceMBean extends ServiceBaseMBean{
    
    /** VXeDEBUGJeS */
    public static final String SYSTEM_DEBUG_CATEGORY
         = "jp.ossc.nimbus.service.log.SYSTEM_DEBUG_CATEGORY";
    /** VXeDEBUGJeS̗Dx͈͂̍ŏl */
    public static final int SYSTEM_DEBUG_CATEGORY_PRIORITY_MIN = 0;
    /** VXeDEBUGJeS̗Dx͈͂̍ől */
    public static final int SYSTEM_DEBUG_CATEGORY_PRIORITY_MAX = 49;
    /** VXeDEBUGJeS̏o̓x */
    public static final String SYSTEM_DEBUG_CATEGORY_LABEL = "SYSTEM_DEBUG";
    
    /** VXeINFOJeS */
    public static final String SYSTEM_INFO_CATEGORY
         = "jp.ossc.nimbus.service.log.SYSTEM_INFO_CATEGORY";
    /** VXeINFOJeS̗Dx͈͂̍ŏl */
    public static final int SYSTEM_INFO_CATEGORY_PRIORITY_MIN = 50;
    /** VXeINFOJeS̗Dx͈͂̍ől */
    public static final int SYSTEM_INFO_CATEGORY_PRIORITY_MAX = 99;
    /** VXeDEBUGJeS̏o̓x */
    public static final String SYSTEM_INFO_CATEGORY_LABEL = "SYSTEM_INFO";
    
    /** VXeWARNJeS */
    public static final String SYSTEM_WARN_CATEGORY
         = "jp.ossc.nimbus.service.log.SYSTEM_WARN_CATEGORY";
    /** VXeWARNJeS̗Dx͈͂̍ŏl */
    public static final int SYSTEM_WARN_CATEGORY_PRIORITY_MIN = 100;
    /** VXeWARNJeS̗Dx͈͂̍ől */
    public static final int SYSTEM_WARN_CATEGORY_PRIORITY_MAX = 149;
    /** VXeWARNJeS̏o̓x */
    public static final String SYSTEM_WARN_CATEGORY_LABEL = "SYSTEM_WARN";
    
    /** VXeERRORJeS */
    public static final String SYSTEM_ERROR_CATEGORY
         = "jp.ossc.nimbus.service.log.SYSTEM_ERROR_CATEGORY";
    /** VXeERRORJeS̗Dx͈͂̍ŏl */
    public static final int SYSTEM_ERROR_CATEGORY_PRIORITY_MIN = 150;
    /** VXeERRORJeS̗Dx͈͂̍ől */
    public static final int SYSTEM_ERROR_CATEGORY_PRIORITY_MAX = 199;
    /** VXeERRORJeS̏o̓x */
    public static final String SYSTEM_ERROR_CATEGORY_LABEL = "SYSTEM_ERROR";
    
    /** VXeFATALJeS */
    public static final String SYSTEM_FATAL_CATEGORY
         = "jp.ossc.nimbus.service.log.SYSTEM_FATAL_CATEGORY";
    /** VXeFATALJeS̗Dx͈͂̍ŏl */
    public static final int SYSTEM_FATAL_CATEGORY_PRIORITY_MIN = 200;
    /** VXeFATALJeS̗Dx͈͂̍ől */
    public static final int SYSTEM_FATAL_CATEGORY_PRIORITY_MAX = 249;
    /** VXeFATALJeS̏o̓x */
    public static final String SYSTEM_FATAL_CATEGORY_LABEL = "SYSTEM_FATAL";
    
    /** JeS\o̓tH[}bg̃L[ */
    public static final String FORMAT_CATEGORY_KEY = "CATEGORY";
    /** R[h\o̓tH[}bg̃L[ */
    public static final String FORMAT_CODE_KEY = "CODE";
    /** t\o̓tH[}bg̃L[ */
    public static final String FORMAT_DATE_KEY = "DATE";
    /** Dx\o̓tH[}bg̃L[ */
    public static final String FORMAT_PRIORITY_KEY = "PRIORITY";
    /** bZ[W\o̓tH[}bg̃L[ */
    public static final String FORMAT_MESSAGE_KEY = "MESSAGE";
    
    /**
     * ftHgtH[}bgB<p>
     * "%DATE%,%PRIORITY%,[%CODE%]%MESSAGE%"
     */
    public static final String DEFAULT_FORMAT
         = '%' + FORMAT_DATE_KEY + "%,%" + FORMAT_PRIORITY_KEY + "%,[%"
             + FORMAT_CODE_KEY + "%]%" + FORMAT_MESSAGE_KEY + '%';
    
    /**
     * o͂郍ÕJeS`{@link LogCategory}T[rX̖Oݒ肷B<p>
     * 
     * @param names LogCategoryT[rX̔z
     */
    public void setCategoryServiceNames(ServiceName[] names);
    
    /**
     * o͂郍ÕJeS`{@link LogCategory}T[rX̖O擾B<p>
     * 
     * @return LogCategoryT[rX̔z
     */
    public ServiceName[] getCategoryServiceNames();
    
    /**
     * ftHg{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     * ftHg̃JeSWritableRecordFactoryT[rXw肳ĂȂꍇɎgpB<br>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setDefaultWritableRecordFactoryServiceName(ServiceName name);
    
    /**
     * ftHg{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     * ftHg̃JeSWritableRecordFactoryT[rXw肳ĂȂꍇɎgpB<br>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getDefaultWritableRecordFactoryServiceName();
    
    /**
     * ftHg{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     * ftHg̃JeSMessageWriterT[rXw肳ĂȂꍇɎgpB<br>
     *
     * @param name MessageWriterT[rX
     */
    public void setDefaultMessageWriterServiceName(ServiceName name);
    
    /**
     * ftHg{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     * ftHg̃JeSMessageWriterT[rXw肳ĂȂꍇɎgpB<br>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getDefaultMessageWriterServiceName();
    
    /**
     * Oo͂Ɏgp郁bZ[WǗ{@link MessageRecordFactory}T[rXݒ肷B<p>
     * 
     * @param name MessageRecordFactoryT[rX
     */
    public void setMessageRecordFactoryServiceName(ServiceName name);
    
    /**
     * Oo͂Ɏgp郁bZ[WǗ{@link MessageRecordFactory}T[rX擾B<p>
     * 
     * @return MessageRecordFactoryT[rX
     */
    public ServiceName getMessageRecordFactoryServiceName();
    
    /**
     * ˗ꂽOo͂UL[CO{@link Queue}𐶐{@link Queue}T[rXݒ肷B<p>
     * 
     * @param name QueueT[rX
     */
    public void setQueueServiceName(ServiceName name);
    
    /**
     * ˗ꂽOo͂UL[CO{@link Queue}T[rX擾B<p>
     * 
     * @return QueueT[rX
     */
    public ServiceName getQueueServiceName();
    
    /**
     * O̎ʏێ{@link Context}T[rXݒ肷B<p>
     * 
     * @param name ContextT[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * O̎ʏێ{@link Context}T[rX擾B<p>
     * 
     * @return ContextT[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * {@link Context}T[rX擾tH[}bg̃L[ݒ肷B<p>
     * 
     * @param keys ContextT[rX擾tH[}bg̃L[z
     */
    public void setContextFormatKeys(String[] keys);
    
    /**
     * {@link Context}T[rX擾tH[}bg̃L[擾B<p>
     * 
     * @return ContextT[rX擾tH[}bg̃L[
     */
    public String[] getContextFormatKeys();
    
    /**
     * {@link #SYSTEM_DEBUG_CATEGORY}JeS̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setSystemDebugEnabled(boolean isEnabled);
    
    /**
     * {@link #SYSTEM_DEBUG_CATEGORY}JeS̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isSystemDebugEnabled();
    
    /**
     * {@link #SYSTEM_INFO_CATEGORY}JeS̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setSystemInfoEnabled(boolean isEnabled);
    
    /**
     * {@link #SYSTEM_INFO_CATEGORY}JeS̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isSystemInfoEnabled();
    
    /**
     * {@link #SYSTEM_WARN_CATEGORY}JeS̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setSystemWarnEnabled(boolean isEnabled);
    
    /**
     * {@link #SYSTEM_WARN_CATEGORY}JeS̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isSystemWarnEnabled();
    
    /**
     * {@link #SYSTEM_ERROR_CATEGORY}JeS̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setSystemErrorEnabled(boolean isEnabled);
    
    /**
     * {@link #SYSTEM_ERROR_CATEGORY}JeS̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isSystemErrorEnabled();
    
    /**
     * {@link #SYSTEM_FATAL_CATEGORY}JeS̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setSystemFatalEnabled(boolean isEnabled);
    
    /**
     * {@link #SYSTEM_FATAL_CATEGORY}JeS̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isSystemFatalEnabled();
    
    /**
     * {@link #DEBUG_METHOD_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setDebugMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link #DEBUG_METHOD_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getDebugMessageWriterServiceName();
    
    /**
     * {@link #SYSTEM_DEBUG_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setSystemDebugMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link #SYSTEM_DEBUG_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getSystemDebugMessageWriterServiceName();
    
    /**
     * {@link #SYSTEM_INFO_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setSystemInfoMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link #SYSTEM_INFO_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getSystemInfoMessageWriterServiceName();
    
    /**
     * {@link #SYSTEM_WARN_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setSystemWarnMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link #SYSTEM_WARN_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getSystemWarnMessageWriterServiceName();
    
    /**
     * {@link #SYSTEM_ERROR_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setSystemErrorMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link #SYSTEM_ERROR_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getSystemErrorMessageWriterServiceName();
    
    /**
     * {@link #SYSTEM_FATAL_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setSystemFatalMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link #SYSTEM_FATAL_CATEGORY}JeS̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getSystemFatalMessageWriterServiceName();
    
    /**
     * {@link #DEBUG_METHOD_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setDebugWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link #DEBUG_METHOD_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getDebugWritableRecordFactoryServiceName();
    
    /**
     * {@link #SYSTEM_DEBUG_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setSystemDebugWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link #SYSTEM_DEBUG_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getSystemDebugWritableRecordFactoryServiceName();
    
    /**
     * {@link #SYSTEM_INFO_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setSystemInfoWritableRecordFactoryServiceName(ServiceName name);
    
    /**
     * {@link #SYSTEM_INFO_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getSystemInfoWritableRecordFactoryServiceName();
    
    /**
     * {@link #SYSTEM_WARN_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setSystemWarnWritableRecordFactoryServiceName(ServiceName name);
    
    /**
     * {@link #SYSTEM_WARN_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getSystemWarnWritableRecordFactoryServiceName();
    
    /**
     * {@link #SYSTEM_ERROR_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setSystemErrorWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link #SYSTEM_ERROR_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getSystemErrorWritableRecordFactoryServiceName();
    
    /**
     * {@link #SYSTEM_FATAL_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setSystemFatalWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link #SYSTEM_FATAL_CATEGORY}JeS̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getSystemFatalWritableRecordFactoryServiceName();
    
    /**
     * Oo̓Xbhf[Xbhɂ邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isDaemon f[Xbhɂꍇtrue
     */
    public void setDaemon(boolean isDaemon);
    
    /**
     * Oo̓Xbhf[Xbhǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Af[Xbh
     */
    public boolean isDaemon();
}
