/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import jp.ossc.nimbus.core.*;

/**
 * {@link DefaultOverflowControllerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see DefaultOverflowControllerService
 */
public interface DefaultOverflowControllerServiceMBean extends ServiceBaseMBean{
    
    /**
     * ӂꌟ؂sOverflowValidatorT[rX̃T[rXݒ肷B<p>
     * ݒ肵Ȃꍇ́Aӂꐧ䂪sȂB<br>
     *
     * @param name T[rX
     */
    public void setOverflowValidatorServiceName(ServiceName name);
    
    /**
     * ӂꌟ؂sOverflowValidatorT[rX̃T[rX擾B<p>
     *
     * @return T[rX
     */
    public ServiceName getOverflowValidatorServiceName();
    
    /**
     * ӂꌟ،ʂɏ]ĂӂLbVIuWFNg肷OverflowAlgorithmT[rX̃T[rXݒ肷B<p>
     * {@link #setOverflowValidatorServiceName(ServiceName)}łӂꌟ؃T[rXݒ肳Ăꍇ́ȂKݒ肵Ȃ΂ȂȂB<br>
     *
     * @param name T[rX
     */
    public void setOverflowAlgorithmServiceName(ServiceName name);
    
    /**
     * ӂꌟ،ʂɏ]ĂӂLbVIuWFNg肷OverflowAlgorithmT[rX̃T[rX擾B<p>
     *
     * @return T[rX
     */
    public ServiceName getOverflowAlgorithmServiceName();
    
    /**
     * ӂASYɂČ肳ꂽӂLbVIuWFNgӂꂳOverflowActionT[rX̃T[rXݒ肷B<p>
     * ݒ肵Ȃꍇɂ́A{@link RemoveOverflowActionService}gpB<br>
     *
     * @param name T[rX
     */
    public void setOverflowActionServiceName(ServiceName name);
    
    /**
     * ӂASYɂČ肳ꂽӂLbVIuWFNgӂꂳOverflowActionT[rX̃T[rX擾B<p>
     *
     * @return T[rX
     */
    public ServiceName getOverflowActionServiceName();
    
    /**
     * ӂꐧ̗vʃXbhŏ邽߂ɁAUL[ɗ߂邽߂QueueT[rX̃T[rXݒ肷B<p>
     * ݒ肵Ȃꍇɂ́A{@link jp.ossc.nimbus.service.queue.DefaultQueueService DefaultQueueService}gpB<br>
     *
     * @param name T[rX
     */
    public void setQueueServiceName(ServiceName name);
    
    /**
     * ӂꐧ̗vʃXbhŏ邽߂ɁAUL[ɗ߂邽߂QueueT[rX̃T[rX擾B<p>
     *
     * @return T[rX
     */
    public ServiceName getQueueServiceName();
    
    /**
     * IɂӂꐧsԊԊu[ms]ݒ肷B<p>
     * ftHg0ŁAIȂӂꐧ͍sȂB<br>
     *
     * @param time IɂӂꐧsԊԊu[ms]
     */
    public void setPeriodicOverflowIntervalTime(long time);
    
    /**
     * IɂӂꐧsԊԊu[ms]擾B<p>
     *
     * @return IɂӂꐧsԊԊu[ms]
     */
    public long getPeriodicOverflowIntervalTime();
    
    /**
     * LbVQƂǉ邽тɂӂꐧsǂݒ肷B<p>
     * ftHǵAtrueŁAǉ̂тɂӂꐧsB<br>
     *
     * @param isOverflow ǉ̂тɂӂꐧsꍇ́Atrue
     */
    public void setOverflowByAdding(boolean isOverflow);
    
    /**
     * LbVQƂǉ邽тɂӂꐧsǂ𔻒肷B<p>
     *
     * @return truȅꍇAǉ̂тɂӂꐧs
     */
    public boolean isOverflowByAdding();
    
    /**
     * ӂꐧsтɂӂꌟ؂sǂݒ肷B<p>
     * ftHǵAtrueŁAӂꐧsтɂӂꌟ؂sB<br>
     *
     * @param isValidate ӂꐧsтɂӂꌟ؂sꍇ́Atrue
     */
    public void setValidateByOverflow(boolean isValidate);
    
    /**
     * ӂꐧsтɂӂꌟ؂sǂ𔻒肷B<p>
     *
     * @return truȅꍇAӂꐧsтɂӂꌟ؂s
     */
    public boolean isValidateByOverflow();
    
    /**
     * ӂꐧs߂ɕێĂB<p>
     */
    public void reset();
}
