/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.daemon.*;
import jp.ossc.nimbus.service.queue.*;

/**
 * ftHgӂꐧB<p>
 * {@link OverflowValidator}A{@link OverflowAlgorithm}A{@link OverflowAction}̂RgɂāAӂꐧsOverflowControllerłB<br>
 * ܂Aӂꐧ́ALbV̒ǉƓKv͂Ȃ߁AʃXbhłӂꐧsł悤{@link Queue}T[rXݒłB<br>
 * ȉɁALbVTCY10𒴂ƁAFIFOłӂΏۂƂȂLbVIuWFNg肵ALbV폜邠ӂꐧT[rX̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="OverflowController"
 *                  code="jp.ossc.nimbus.service.cache.DefaultOverflowControllerService"&gt;
 *             &lt;attribute name="OverflowValidatorServiceName"&gt;#CacheSizeOverflowValidator&lt;/attribute&gt;
 *             &lt;attribute name="OverflowAlgorithmServiceName"&gt;#FIFOOverflowAlgorithm&lt;/attribute&gt;
 *             &lt;depends&gt;CacheSizeOverflowValidator&lt;/depends&gt;
 *             &lt;depends&gt;FIFOOverflowAlgorithm&lt;/depends&gt;
 *         &lt;/service&gt;
 *         
 *         &lt;service name="CacheSizeOverflowValidator"
 *                  code="jp.ossc.nimbus.service.cache.CacheSizeOverflowValidatorService"&gt;
 *             &lt;attribute name="MaxSize"&gt;10&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *         &lt;service name="FIFOOverflowAlgorithm"
 *                  code="jp.ossc.nimbus.service.cache.FIFOOverflowAlgorithmService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 * @see OverflowValidator
 * @see OverflowAlgorithm
 * @see OverflowAction
 * @see Queue
 */
public class DefaultOverflowControllerService<E> extends ServiceBase
 implements OverflowController<E>, DaemonRunnable<CachedReference<E>>,
            DefaultOverflowControllerServiceMBean{
    
    private static final long serialVersionUID = 304577650295674609L;
    
    /**
     * ӂꌟ؃T[rX̃T[rXB<p>
     */
    protected ServiceName validatorServiceName;
    
    /**
     * ӂꌟ؃T[rXB<p>
     */
    protected OverflowValidator<E> validator;
    
    /**
     * ӂASYT[rX̃T[rXB<p>
     */
    protected ServiceName algorithmServiceName;
    
    /**
     * ӂASYT[rXB<p>
     */
    protected OverflowAlgorithm<E> algorithm;
    
    /**
     * ӂꓮT[rX̃T[rXB<p>
     */
    protected ServiceName actionServiceName;
    
    /**
     * ӂꓮT[rXB<p>
     */
    protected OverflowAction<E> action;
    
    /**
     * ftHĝӂꓮT[rXB<p>
     * ftHĝӂꓮ́AӂꂽLbVIuWFNg폜B<br>
     */
    protected RemoveOverflowActionService<E> defaultAction;
    
    /**
     * ӂꐧ̗vʃXbhŏ邽߂ɈUL[ɗ߂邽߂̃L[T[rX̃T[rXB<p>
     */
    protected ServiceName queueServiceName;
    
    /**
     * ӂꐧ̗vʃXbhŏ邽߂ɈUL[ɗ߂邽߂̃L[T[rXB<p>
     */
    protected Queue<CachedReference<E>> queue;
    
    /**
     * ӂꐧ̗vʃXbhŏ邽߂̃f[IuWFNgB<p>
     */
    protected Daemon daemon;
    
    /**
     * ӂꐧ䏈̃LbVQƂɑ΂铯p̃bNIuWFNgB<p>
     */
    protected Object lock = "lock";
    
    /**
     * LbVQƂǉ邽тɂӂꐧsǂ̃tOB<p>
     * ftHǵAtrueŁAǉ̂тɂӂꐧsB<br>
     */
    protected boolean isOverflowByAdding = true;
    
    /**
     * ӂꐧsтɂӂꌟ؂sǂ̃tOB<p>
     * ftHǵAtrueŁAӂꐧsтɂӂꌟ؂sB<br>
     */
    protected boolean isValidateByOverflow = true;
    
    /**
     * IɂӂꐧsԊԊu[ms]̑lB<p>
     */
    protected long periodicOverflowIntervalTime;
    
    /**
     * IɂӂꐧsԊԊu[ms]B<p>
     */
    protected long periodicOverflowInterval;
    
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public void setOverflowValidatorServiceName(ServiceName name){
        validatorServiceName = name;
    }
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public ServiceName getOverflowValidatorServiceName(){
        return validatorServiceName;
    }
    
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public void setOverflowAlgorithmServiceName(ServiceName name){
        algorithmServiceName = name;
    }
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public ServiceName getOverflowAlgorithmServiceName(){
        return algorithmServiceName;
    }
    
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public void setOverflowActionServiceName(ServiceName name){
        actionServiceName = name;
    }
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public ServiceName getOverflowActionServiceName(){
        return actionServiceName;
    }
    
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public void setQueueServiceName(ServiceName name){
        queueServiceName = name;
    }
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public ServiceName getQueueServiceName(){
        return queueServiceName;
    }
    
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public void setPeriodicOverflowIntervalTime(long time){
        periodicOverflowIntervalTime = time;
    }
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public long getPeriodicOverflowIntervalTime(){
        return periodicOverflowIntervalTime;
    }
    
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public void setOverflowByAdding(boolean isOverflow){
        isOverflowByAdding = isOverflow;
    }
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public boolean isOverflowByAdding(){
        return isOverflowByAdding;
    }
    
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public void setValidateByOverflow(boolean isValidate){
        isValidateByOverflow = isValidate;
    }
    // DefaultOverflowControllerServiceMBeanJavaDoc
    @Override
    public boolean isValidateByOverflow(){
        return isValidateByOverflow;
    }
    
    /**
     * OverflowActionݒ肷B
     */
    public void setOverflowAction(OverflowAction<E> action) {
        this.action = action;
    }
    /**
     * OverflowAlgorithmݒ肷B
     */
    public void setOverflowAlgorithm(OverflowAlgorithm<E> algorithm) {
        this.algorithm = algorithm;
    }
    /**
     * Queueݒ肷B
     */
    public void setQueue(Queue<CachedReference<E>> queue) {
        this.queue = queue;
    }
    /**
     * OverflowValidatorݒ肷B
     */
    public void setOverflowValidator(OverflowValidator<E> validator) {
        this.validator = validator;
    }
    
    /**
     * T[rX̐sB<p>
     * f[𐶐B<br>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        daemon = new Daemon(this);
        daemon.setName("Nimbus OverflowControllerDaemon " + getServiceNameObject());
    }
    
    /**
     * T[rX̊JnsB<p>
     * ӂꌟ؃T[rX擾B<br>
     * ӂASYT[rX擾B<br>
     * ӂꓮT[rX擾B<br>
     * ӂꓮT[rXɁA{@link OverflowAction#setOverflowController(OverflowController)}Ŏgݒ肷B<br>
     * L[T[rX擾B<br>
     * f[JnB<br>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        if(validatorServiceName != null){
            validator = ServiceManagerFactory
                .getServiceObject(validatorServiceName);
        }
        if(algorithmServiceName != null){
            algorithm = ServiceManagerFactory
                .getServiceObject(algorithmServiceName);
        }
        if(validator != null && algorithm == null){
            throw new IllegalArgumentException(
                "OverflowAlgorithm must specify when OverflowValidator is specified."
            );
        }
        if(actionServiceName != null){
            action = ServiceManagerFactory
                .getServiceObject(actionServiceName);
        }else{
            action = getDefaultOverflowActionService();
        }
        action.setOverflowController(this);
        
        if(queueServiceName != null){
            queue = ServiceManagerFactory
                .getServiceObject(queueServiceName);
        }
        if(periodicOverflowIntervalTime > 0){
            periodicOverflowInterval = periodicOverflowIntervalTime;
        }
        if(queue != null || periodicOverflowInterval > 0){
            
            if(queue != null){
                // L[tJn
                queue.accept();
            }
            
            // f[N
            daemon.start();
        }
    }
    
    /**
     * T[rX̒~sB<p>
     * f[~B<br>
     * ӂꌟ؃T[rX̎QƂjB<br>
     * ӂASYT[rX̎QƂjB<br>
     * ӂꓮT[rX̎QƂjB<br>
     * L[T[rX̎QƂjB<br>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    @Override
    public void stopService() throws Exception{
        
        if(queue != null || periodicOverflowInterval > 0){
            
            // f[~
            daemon.stop();
            
            if(queue != null){
                // L[t~
                queue.release();
            }
        }
        
        validator = null;
        algorithm = null;
        if(defaultAction != null && action == defaultAction){
            defaultAction.stop();
        }
        action = null;
        queue = null;
    }
    
    /**
     * T[rX̔jsB<p>
     * ftHĝӂꓮT[rXjB<br>
     * ftHg̃L[T[rXjB<br>
     * f[jB<br>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        if(defaultAction != null){
            defaultAction.destroy();
            defaultAction = null;
        }
        daemon = null;
    }
    
    /**
     * ftHĝӂꓮT[rX擾B<p>
     *
     * @return {@link RemoveOverflowActionService}
     * @exception Exception ftHĝӂꓮT[rX̐ENɎsꍇ
     */
    protected OverflowAction<E> getDefaultOverflowActionService() throws Exception{
        if(defaultAction == null){
            final RemoveOverflowActionService<E> act
                 = new RemoveOverflowActionService<E>();
            act.create();
            act.start();
            defaultAction = act;
        }else if(defaultAction.getState() != State.STARTED){
            defaultAction.start();
        }
        return defaultAction;
    }
    
    /**
     * ӂꐧsB<p>
     * ӂꐧ́AʃXbhōs߁Ał́As킸ɂɏ߂B<br>
     * ʃXbhōsӂꐧ́A{@link #consume(Object, DaemonControl)}QƁB<br>
     *
     * @param ref LbVɒǉꂽLbVQ
     */
    @Override
    public void control(CachedReference<E> ref){
        if(getState() != State.STARTED){
            return;
        }
        if(queue == null){
            consume(ref, daemon);
        }else{
            queue.push(ref);
        }
    }
    
    /**
     * ӂꐧs߂ɕێĂB<p>
     * {@link OverflowValidator#reset()}A{@link OverflowAlgorithm#reset()}A{@link OverflowAction#reset()}ĂяoB<br>
     */
    @Override
    public void reset(){
        if(validator != null){
            validator.reset();
        }
        if(algorithm != null){
            algorithm.reset();
        }
        if(action != null){
            action.reset();
        }
    }
    
    /**
     * f[JnɌĂяoB<p>
     * 
     * @return trueԂ
     */
    @Override
    public boolean onStart() {
        return true;
    }
    
    /**
     * f[~ɌĂяoB<p>
     * 
     * @return trueԂ
     */
    @Override
    public boolean onStop() {
        return true;
    }
    
    /**
     * f[fɌĂяoB<p>
     * 
     * @return trueԂ
     */
    @Override
    public boolean onSuspend() {
        return true;
    }
    
    /**
     * f[ĊJɌĂяoB<p>
     * 
     * @return trueԂ
     */
    @Override
    public boolean onResume() {
        return true;
    }
    
    /**
     * L[PoĕԂB<p>
     * 
     * @param ctrl DaemonControlIuWFNg
     * @return {@link CachedReference}IuWFNg
     */
    @Override
    public CachedReference<E> provide(DaemonControl ctrl){
        if(getState() != State.STARTED){
            return null;
        }
        CachedReference<E> ref = null;
        if(queue == null){
            try{
                Thread.sleep(periodicOverflowInterval);
            }catch(InterruptedException e){
            }
        }else{
            if(periodicOverflowInterval > 0){
                ref = queue.get(periodicOverflowInterval);
            }else{
                ref = queue.get();
            }
        }
        return ref;
    }
    
    /**
     * dequeuedœnꂽIuWFNgB<p>
     * dequeuedœnꂽIuWFNg{@link CachedReference}ɃLXg{@link OverflowValidator}A{@link OverflowAlgorithm}A{@link OverflowAction}ĂяoB<br>
     * ӂꐧ́Aȉ̏ōsB<br>
     * <ol>
     *     <li>{@link OverflowValidator#add(CachedReference)}ĂяoB</li>
     *     <li>{@link OverflowValidator#validate()}ĂяoB</li>
     *     <li>{@link OverflowAlgorithm#add(CachedReference)}ĂяoB</li>
     *     <li>{@link OverflowValidator#validate()}̖߂lintl̉񐔂Aȉ̏JԂB</li>
     *     <li>{@link OverflowAlgorithm#overflow()}ĂяoB</li>
     *     <li>{@link OverflowValidator#remove(CachedReference)}ĂяoB</li>
     *     <li>{@link OverflowAlgorithm#overflow()}̖߂lgāA{@link OverflowAction#action(OverflowValidator, OverflowAlgorithm, CachedReference)}ĂяoB</li>
     * </ol>
      *
     * @param ref L[oꂽIuWFNg
     * @param ctrl DaemonControlIuWFNg
     */
    @Override
    public void consume(CachedReference<E> ref, DaemonControl ctrl){
        if(validator == null || getState() != State.STARTED){
            return;
        }
        int overflowSize = 0;
        if(ref == null || isOverflowByAdding){
            overflowSize = validator.validate();
        }
        if(overflowSize > 0){
            if(!isValidateByOverflow){
                synchronized(lock){
                    overflowSize = validator.validate();
                    if(overflowSize > 0){
                        CachedReference<E>[] overflowRefs = null;
                        if(algorithm != null){
                            overflowRefs = algorithm.overflow(overflowSize);
                        }
                        if(overflowRefs != null){
                            for(int i = 0; i < overflowRefs.length; i++){
                                CachedReference<E> overflowRef = overflowRefs[i];
                                if(overflowRef == null){
                                    continue;
                                }else if(!overflowRef.isRemoved()){
                                    if(validator != null){
                                        validator.remove(overflowRef);
                                    }
                                    if(overflowRef != null && action != null && !overflowRef.isRemoved()){
                                        action.action(validator, algorithm, overflowRef);
                                    }
                                }
                            }
                        }
                    }
                }
            }else{
                while(overflowSize > 0){
                    CachedReference<E> overflowRef = null;
                    if(algorithm != null){
                        overflowRef = algorithm.overflow();
                    }
                    if(overflowRef == null){
                        break;
                    }else if(!overflowRef.isRemoved()){
                        if(validator != null){
                            validator.remove(overflowRef);
                        }
                        if(overflowRef != null && action != null && !overflowRef.isRemoved()){
                            action.action(validator, algorithm, overflowRef);
                        }
                    }
                    if(validator != null){
                        overflowSize = validator.validate();
                    }else{
                        overflowSize = 0;
                    }
                }
            }
        }
        if(ref != null && !ref.isRemoved() && validator != null){
            validator.add(ref);
        }
        if(ref != null && !ref.isRemoved() && algorithm != null){
            algorithm.add(ref);
        }
    }
    
    /**
     * L[̒gfoB<p>
     */
    @Override
    public void garbage(){
        if(queue != null){
            while(queue.size() > 0){
                consume(queue.get(0), daemon);
            }
        }
    }
}
