/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The Nimbus Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus Project.
 */
package jp.ossc.nimbus.service.beanflow;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link DefaultBeanFlowFactoryService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see DefaultBeanFlowFactoryService
 */
public interface DefaultBeanFlowFactoryServiceMBean extends ServiceBaseMBean{
    
    /**
     * BeanFlow`t@C̊i[ꏊƂȂfBNgݒ肷B<p>
     * ΃pXAsfBNg̑΃pXAT[rX`t@C̑΃pX̂ꂩw肷B<br>
     *
     * @param dirs fBNg̃pXz
     */
    public void setFlowDirs(String[] dirs);
    
    /**
     * BeanFlow`t@C̊i[ꏊƂȂfBNg擾B<p>
     *
     * @return fBNg̃pXz
     */
    public String[] getFlowDirs();
    
    /**
     * BeanFlow`t@C̃pXݒ肷B<p>
     * ΃pXAsfBNg̑΃pXANXpX̃\[XpXAT[rX`t@C̑΃pX̂ꂩw肷B<br>
     *
     * @param dirs BeanFlow`t@C̃pXz
     */
    public void setFlowPaths(String[] paths);
    
    /**
     * BeanFlow`t@C̃pX擾B<p>
     *
     * @return BeanFlow`t@C̃pXz
     */
    public String[] getFlowPaths();
    
    /**
     * BeanFlow`t@Cp[Xjavax.xml.parsers.DocumentBuilderFactorỹNXݒ肷B<p>
     * w肵Ȃꍇ́ADocumentBuilderFactory.newInstance()DocumentBuilderFactory𐶐B<br>
     *
     * @param name DocumentBuilderFactorỹNX
     */
    public void setDocumentBuilderFactoryClassName(String name);
    
    /**
     * BeanFlow`t@Cp[Xjavax.xml.parsers.DocumentBuilderFactorỹNX擾B<p>
     *
     * @return DocumentBuilderFactorỹNX
     */
    public String getDocumentBuilderFactoryClassName();
    
    /**
     * BeanFlow`t@C؂邩ǂݒ肷B<p>
     * ftHǵAfalseŌ؂ȂB<br>
     * 
     * @param validate ؂ꍇAtrue
     */
    public void setValidate(boolean validate);
    
    /**
     * BeanFlow`t@C؂邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇA؂
     */
    public boolean isValidate();
    
    public void setContextServiceName(ServiceName name);
    public ServiceName getContextServiceName();
    
    public void setInterceptorChainFactoryServiceName(ServiceName name);
    public ServiceName getInterceptorChainFactoryServiceName();
    
    public void setJournalServiceName(ServiceName name);
    public ServiceName getJournalServiceName();
    
    public void setEditorFinderServiceName(ServiceName name);
    public ServiceName getEditorFinderServiceName();
    
    /**
     * expressionvf̕]Ɏgp{@link jp.ossc.nimbus.service.interpreter.Interpreter Interpreter}T[rX̃T[rXݒ肷B<p>
     *
     * @param name InterpreterT[rX̃T[rX
     */
    public void setExpressionInterpreterServiceName(ServiceName name);
    
    /**
     * expressionvf̕]Ɏgp{@link jp.ossc.nimbus.service.interpreter.Interpreter Interpreter}T[rX̃T[rX擾B<p>
     *
     * @return InterpreterT[rX̃T[rX
     */
    public ServiceName getExpressionInterpreterServiceName();
    
    /**
     * ifvfAcasevftest̔Ɏgp{@link jp.ossc.nimbus.service.interpreter.Interpreter Interpreter}T[rX̃T[rXݒ肷B<p>
     *
     * @param name InterpreterT[rX̃T[rX
     */
    public void setTestInterpreterServiceName(ServiceName name);
    
    /**
     * ifvfAcasevftest̔Ɏgp{@link jp.ossc.nimbus.service.interpreter.Interpreter Interpreter}T[rX̃T[rX擾B<p>
     *
     * @return InterpreterT[rX̃T[rX
     */
    public ServiceName getTestInterpreterServiceName();
    
    /**
     * interpertervf̎sɎgp{@link jp.ossc.nimbus.service.interpreter.Interpreter Interpreter}T[rX̃T[rXݒ肷B<p>
     *
     * @param name InterpreterT[rX̃T[rX
     */
    public void setInterpreterServiceName(ServiceName name);
    
    /**
     * interpertervf̎sɎgp{@link jp.ossc.nimbus.service.interpreter.Interpreter Interpreter}T[rX̃T[rX擾B<p>
     *
     * @return InterpreterT[rX̃T[rX
     */
    public ServiceName getInterpreterServiceName();
    
    public void setTransactionManagerFactoryServiceName(ServiceName name);
    public ServiceName getTransactionManagerFactoryServiceName();
    
    public void setAsynchExecuteQueueHandlerContainerServiceName(ServiceName name);
    public ServiceName getAsynchExecuteQueueHandlerContainerServiceName();
    
    /**
     * 񓯊s̃nhOɃG[ꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     * ftHǵAnullŁAOo͂ȂB<br>
     *
     * @param id ÕbZ[WID
     */
    public void setAsynchExecuteErrorLogMessageId(String id);
    
    /**
     * 񓯊s̃nhOɃG[ꍇɏo͂郍ÕbZ[WID擾B<p>
     * 
     * @return ÕbZ[WID
     */
    public String getAsynchExecuteErrorLogMessageId();
    
    /**
     * 񓯊s̃nhOɃG[AK̃gC񐔂zꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     * ftHǵAnullŁAOo͂ȂB<br>
     *
     * @param id ÕbZ[WID
     */
    public void setAsynchExecuteRetryOverErrorLogMessageId(String id);
    
    /**
     * 񓯊s̃nhOɃG[AK̃gC񐔂zꍇɏo͂郍ÕbZ[WID擾B<p>
     * 
     * @return ÕbZ[WID
     */
    public String getAsynchExecuteRetryOverErrorLogMessageId();
    
    /**
     * ēǂݍ݂B<p>
     *
     * @exception Exception ēǂݍ݂Ɏsꍇ
     */
    public void reload() throws Exception;
}
