/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.beanflow;

import java.rmi.*;
import java.util.Set;
import java.util.Map;

/**
 * Ɩt[T[oB<p>
 *
 * @author M.Takata
 */
public interface BeanFlowServer extends Remote{
    
    /**
     * ̃T[oNGXgt\𔻒肷B<p>
     *
     * @return NGXgt\ȏꍇtrue
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public boolean isAcceptable() throws RemoteException;
    
    /**
     * ̃T[oɐĂBeant[̐擾B<p>
     *
     * @return ĂBeant[̐
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public int getCurrentFlowCount() throws RemoteException;
    
    /**
     * ̃T[õ\[Xpʂ擾B<p>
     *
     * @return \[Xp
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public <T extends Comparable<?>> T getResourceUsage() throws RemoteException;
    
    /**
     * ̋Ɩt[sT[oێĂBeant[̏W擾B<p>
     *
     * @return Beant[̏W
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public Set<String> getBeanFlowNameSet() throws RemoteException;
    
    /**
     * w肳ꂽBeant[̋Ɩt[sT[oێĂ邩ǂ𔻒肷B<p>
     *
     * @param name Beant[
     * @return ̋Ɩt[sT[oێĂꍇtrue
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public boolean containsFlow(String name) throws RemoteException;
    
    /**
     * T[oBeant[𐶐B<p>
     *
     * @param flowName Beant[
     * @param caller ĂяoBeant[
     * @param isOverwride I[o[ChĂ邩ǂ
     * @return Beant[sۂ̎sID
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception BeanFlowException w肳ꂽBeant[݂Ȃꍇ
     */
    public Object createFlow(String flowName, String caller, boolean isOverwride) throws RemoteException, BeanFlowException;
    
    /**
     * w肳ꂽsIDBeant[T[oɐĂ邩𔻒肷B<p>
     *
     * @param id sID
     * @return Beant[Ăꍇtrue
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public boolean isExistsFlow(Object id) throws RemoteException;
    
    /**
     * w肳ꂽsIDBeant[̏㏑t[擾B<p>
     *
     * @param id sID
     * @return ㏑t[̔z
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public String[] getOverwrideFlowNames(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * Beant[sB<p>
     * 
     * @param id sID
     * @param input Beant[ւ̈
     * @param context ReLXg
     * @return Beant[̎s
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     * @exception Exception Beant[̎sɗOꍇ
     */
    public Object execute(Object id, Object input, Map<?, ?> context) throws NoSuchBeanFlowIdException, RemoteException, Exception;
    
    /**
     * Beant[񓯊sB<p>
     * 
     * @param id sID
     * @param input Beant[ւ̈
     * @param context ReLXg
     * @param callback R[obN
     * @param maxAsynchWait ő񓯊sҋ@
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     * @exception Exception Beant[̎sɗOꍇ
     */
    public void executeAsynch(Object id, Object input, Map<?, ?> context, BeanFlowAsynchCallback callback, int maxAsynchWait) throws NoSuchBeanFlowIdException, RemoteException, Exception;
    
    /**
     * w肳ꂽsIDBeant[ꎞ~B<p>
     *
     * @param id sID
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public void suspendFlow(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * w肳ꂽsIDBeant[ꎞ~߂󂯂Ă邩𔻒肷B<p>
     *
     * @param id sID
     * @return ꎞ~߂󂯂ĂꍇAtrue
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public boolean isSuspendFlow(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * w肳ꂽsIDBeant[ꎞ~Ă邩𔻒肷B<p>
     *
     * @param id sID
     * @return ꎞ~ĂꍇAtrue
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public boolean isSuspendedFlow(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * w肳ꂽsIDBeant[ĊJB<p>
     *
     * @param id sID
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public void resumeFlow(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * w肳ꂽsIDBeant[~B<p>
     *
     * @param id sID
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public void stopFlow(Object id) throws RemoteException;
    
    /**
     * w肳ꂽsIDBeant[~߂󂯂Ă邩𔻒肷B<p>
     *
     * @param id sID
     * @return ~߂󂯂ĂꍇAtrue
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public boolean isStopFlow(Object id) throws RemoteException;
    
    /**
     * w肳ꂽsIDBeant[~Ă邩𔻒肷B<p>
     *
     * @param id sID
     * @return ~ĂꍇAtrue
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public boolean isStoppedFlow(Object id) throws RemoteException;
    
    /**
     * w肳ꂽsIDBeant[̃t[擾B<p>
     *
     * @param id sID
     * @return t[
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public String getFlowName(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * w肳ꂽsIDBeant[ݎsĂt[擾B<p>
     *
     * @param id sID
     * @return ݎsĂt[
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public String getCurrentFlowName(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * w肳ꂽsIDBeant[ݎsĂXebv擾B<p>
     *
     * @param id sID
     * @return ݎsĂXebv
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public String getCurrentStepName(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * w肳ꂽsIDBeant[̃j^B<p>
     *
     * @param id sID
     * @exception RemoteException [gĂяoɎsꍇ
     * @exception NoSuchBeanFlowIdException w肳ꂽsIDBeant[݂Ȃꍇ
     */
    public void clearMonitor(Object id) throws RemoteException, NoSuchBeanFlowIdException;
    
    /**
     * w肳ꂽsIDBeant[̎sB<p>
     *
     * @param id sID
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public void cancel(Object id) throws RemoteException;
    
    /**
     * w肳ꂽsIDBeant[IB<p>
     *
     * @param id sID
     * @exception RemoteException [gĂяoɎsꍇ
     */
    public void end(Object id) throws RemoteException;
}
