/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.beanflow;

/**
 * Beant[OB<p>
 * 
 * @author M.Takata
 */
public class BeanFlowException extends Exception{
    
    private static final long serialVersionUID = -3824946263057374015L;
    
    protected String flowName;
    
    protected String stepName;
    
    /**
     * RXgN^
     */
    public BeanFlowException(){
        super();
    }
    
    /**
     * RXgN^
     * 
     * @param message bZ[W
     */
    public BeanFlowException(String message){
        super(message);
    }
    
    /**
     * RXgN^
     * 
     * @param cause 
     */
    public BeanFlowException(Throwable cause){
        super(cause);
    }
    
    /**
     * RXgN^
     * 
     * @param message bZ[W
     * @param cause 
     */
    public BeanFlowException(String message, Throwable cause){
        super(message, cause);
    }
    
    /**
     * RXgN^
     * 
     * @param flowName t[
     * @param message bZ[W
     */
    public BeanFlowException(String flowName, String message){
        this(flowName, null, message);
    }
    
    /**
     * RXgN^
     * 
     * @param flowName t[
     * @param message bZ[W
     * @param cause 
     */
    public BeanFlowException(String flowName, String message, Throwable cause){
        this(flowName, null, message, cause);
    }
    
    /**
     * RXgN^
     * 
     * @param flowName t[
     * @param stepName Xebv
     * @param message bZ[W
     */
    public BeanFlowException(String flowName, String stepName, String message){
        super(message == null ? (stepName == null ? flowName : flowName + '.' + stepName) : (flowName == null ? message : message + " : flow=" + (stepName == null ? flowName : flowName + '.' + stepName)));
        this.flowName = flowName;
        this.stepName = stepName;
    }
    
    /**
     * RXgN^
     * 
     * @param flowName t[
     * @param stepName Xebv
     * @param message bZ[W
     * @param cause 
     */
    public BeanFlowException(String flowName, String stepName, String message, Throwable cause){
        super(message == null ? (stepName == null ? flowName : flowName + '.' + stepName) : (flowName == null ? message : message + " : flow=" + (stepName == null ? flowName : flowName + '.' + stepName)), cause);
        this.flowName = flowName;
        this.stepName = stepName;
    }
    
    public String getFlowName(){
        return flowName;
    }
    
    public String getStepName(){
        return stepName;
    }
}
