/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.beanflow;

import java.rmi.RemoteException;

import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.AsynchContext;

/**
 * Beant[񓯊ĂяoReLXgB<p>
 *
 * @author M.Takata
 */
public class BeanFlowAsynchContext extends AsynchContext<Object, Object>{
    
    private static final long serialVersionUID = -7498301586072252478L;
    
    protected String flowName;
    protected BeanFlow flow;
    protected BeanFlowMonitor monitor;
    protected BeanFlowAsynchCallback callback;
    
    public BeanFlowAsynchContext(){
    }
    
    public BeanFlowAsynchContext(String flowName){
        this.flowName = flowName;
    }
    
    public BeanFlowAsynchContext(String flowName, Object input){
        super(input);
        this.flowName = flowName;
    }
    
    public BeanFlowAsynchContext(String flowName, Object input, Queue<AsynchContext<Object, Object>> queue){
        super(input, queue);
        this.flowName = flowName;
    }
    
    public BeanFlowAsynchContext(BeanFlow flow, Object input, BeanFlowMonitor monitor){
        this(flow, input, monitor, (Queue<AsynchContext<Object, Object>>)null);
    }
    
    public BeanFlowAsynchContext(BeanFlow flow, Object input, BeanFlowMonitor monitor, Queue<AsynchContext<Object, Object>> queue){
        super(input, queue);
        this.flow = flow;
        this.monitor = monitor;
    }
    public BeanFlowAsynchContext(BeanFlow flow, Object input, BeanFlowMonitor monitor, BeanFlowAsynchCallback callback){
        super(input);
        this.flow = flow;
        this.monitor = monitor;
        this.callback = callback;
    }
    
    public void setFlowName(String name){
        flowName = name;
    }
    
    public String getFlowName(){
        return flow == null ? flowName : flow.getFlowName();
    }
    
    public void setBeanFlow(BeanFlow flow){
        this.flow = flow;
    }
    
    public BeanFlow getBeanFlow(){
        return flow;
    }
    
    public void setBeanFlowMonitor(BeanFlowMonitor monitor){
        this.monitor = monitor;
    }
    
    public BeanFlowMonitor getBeanFlowMonitor(){
        return monitor;
    }
    
    public void setOutput(Object output){
        super.setOutput(output);
        if(callback != null && !isCancel()){
            try{
                callback.reply(output, null);
            }catch(RemoteException e){
            }
        }
    }
    
    public void setThrowable(Throwable th){
        super.setThrowable(th);
        if(callback != null && !isCancel()){
            try{
                callback.reply(null, th);
            }catch(RemoteException e){
            }
        }
    }
    
    public String toString(){
        StringBuilder buf = new StringBuilder(super.toString());
        buf.deleteCharAt(buf.length() - 1);
        buf.append(", flowName=").append(getFlowName());
        buf.append('}');
        return buf.toString();
    }
}
