/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.Serializable;
import java.util.Map;
import java.util.Iterator;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.*;

import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;

/**
 * F؃C^[Zv^B<p>
 * OC̃NGXgsAvP[VŔF؏𐶐AF؃NGXg({@link #getAuthenticatedInfoAttributeName()})ɐݒ肷ƁÃC^[Zv^F؏ZbV̑ƂĐݒ肷B<br>
 * OC̃NGXgł́A̓NGXg({@link #getRequestObjectAttributeName()})̓IuWFNg擾AF؃ZbV擾F؏Ƃ̔rsAF؂Ă邩ǂ`FbNB̓IuWFNgƔF؏̔rǂ̂悤ɍśA{@link #setAuthenticatedInfoMapping(Map)}Őݒ肷BF؏ƍvȂꍇ́A{@link AuthenticateException}throwB<br>
 * OAEg̃NGXgƁAZbVF؏폜B<br>
 * <p>
 * {@link AuthenticateStore}ݒ肷ƁAOCɂ{@link AuthenticateStore#create(HttpServletRequest, Object)}ĂяoAF؏XgAB<br>
 * OC̃NGXgŁAF؃ZbVF؏񂪎擾łȂꍇA{@link AuthenticateStore#activate(HttpServletRequest, Object)}ĂяoAF؏𕜌B<br>
 * OAEg̃NGXgƁA{@link AuthenticateStore#destroy(HttpServletRequest, Object)}ĂяoAF؏폜B<br>
 * ZbV^CAEgƁA{@link AuthenticateStore#deactivate(HttpSession, Object)}ĂяoAF؏񊈐B<br>
 *
 * @author M.Takata
 */
public class AuthenticateInterceptorService extends ServletFilterInterceptorService
 implements AuthenticateInterceptorServiceMBean{
    
    private static final long serialVersionUID = -4298385595443568724L;

    protected String authenticatedInfoAttributeName
         = DEFAULT_AUTH_INFO_ATTRIBUTE_NAME;
    
    protected String requestObjectAttributeName
         = StreamExchangeInterceptorServiceMBean.DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    
    protected Map<String,String> authenticatedInfoMapping;
    protected PropertyAccess propertyAccess;
    protected String loginPath;
    protected String logoutPath;
    protected ServiceName authenticateStoreServiceName;
    protected AuthenticateStore authenticateStore;
    protected boolean isStoreCreate = true;
    protected boolean isStoreDestroy = true;
    
    // AuthenticateInterceptorServiceMBean JavaDoc
    public void setRequestObjectAttributeName(String name){
        requestObjectAttributeName = name;
    }
    // AuthenticateInterceptorServiceMBean JavaDoc
    public String getRequestObjectAttributeName(){
        return requestObjectAttributeName;
    }
    
    // AuthenticateInterceptorServiceMBean JavaDoc
    public void setAuthenticatedInfoAttributeName(String name){
        authenticatedInfoAttributeName = name;
    }
    // AuthenticateInterceptorServiceMBean JavaDoc
    public String getAuthenticatedInfoAttributeName(){
        return authenticatedInfoAttributeName;
    }
    
    // AuthenticateInterceptorServiceMBean JavaDoc
    public void setAuthenticatedInfoMapping(Map<String,String> mapping){
        authenticatedInfoMapping = mapping;
    }
    // AuthenticateInterceptorServiceMBean JavaDoc
    public Map<String,String> getAuthenticatedInfoMapping(){
        return authenticatedInfoMapping;
    }
    
    // AuthenticateInterceptorServiceMBean JavaDoc
    public void setLoginPath(String path){
        loginPath = path;
    }
    // AuthenticateInterceptorServiceMBean JavaDoc
    public String getLoginPath(){
        return loginPath;
    }
    
    // AuthenticateInterceptorServiceMBean JavaDoc
    public void setLogoutPath(String path){
        logoutPath = path;
    }
    // AuthenticateInterceptorServiceMBean JavaDoc
    public String getLogoutPath(){
        return logoutPath;
    }
    
    // AuthenticateInterceptorServiceMBean JavaDoc
    public void setAuthenticateStoreServiceName(ServiceName name){
        authenticateStoreServiceName = name;
    }
    // AuthenticateInterceptorServiceMBean JavaDoc
    public ServiceName getAuthenticateStoreServiceName(){
        return authenticateStoreServiceName;
    }
    
    // AuthenticateInterceptorServiceMBean JavaDoc
    public void setStoreCreate(boolean isCreate){
        isStoreCreate = isCreate;
    }
    // AuthenticateInterceptorServiceMBean JavaDoc
    public boolean isStoreCreate(){
        return isStoreCreate;
    }
    
    // AuthenticateInterceptorServiceMBean JavaDoc
    public void setStoreDestroy(boolean isDestroy){
        isStoreDestroy = isDestroy;
    }
    // AuthenticateInterceptorServiceMBean JavaDoc
    public boolean isStoreDestroy(){
        return isStoreDestroy;
    }
    
    /**
     * T[rX̐sB<p>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    @Override
    public void createService() throws Exception{
        propertyAccess = new PropertyAccess();
        propertyAccess.setIgnoreNullProperty(true);
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        if(loginPath == null){
            throw new IllegalArgumentException("LoginPath must be specified.");
        }
        if(authenticatedInfoMapping == null || authenticatedInfoMapping.size() == 0){
            throw new IllegalArgumentException("AuthenticatedInfoMapping must be specified.");
        }
        if(authenticateStoreServiceName != null){
            authenticateStore = (AuthenticateStore)ServiceManagerFactory.getServiceObject(authenticateStoreServiceName);
        }
    }
    
    /**
     * T[rX̔jsB<p>
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        propertyAccess = null;
    }
    
    /**
     * F؏̕ێAF؏̌؁AF؏̍폜sB<p>
     * OCpX̏ꍇA㑱̏IAF؃NGXg({@link #getAuthenticatedInfoAttributeName()})ɐݒ肳ꂽF؏擾AZbV̑ƂĐݒ肷B<br>
     * OAEgpX̏ꍇA̓NGXg({@link #getRequestObjectAttributeName()})̓IuWFNg擾AF؃ZbV擾F؏Ƃ̔rsAF؂Ă邩ǂ`FbNB̓IuWFNgƔF؏̔rǂ̂悤ɍśA{@link #setAuthenticatedInfoMapping(Map)}Őݒ肷BF؏ƍvȂꍇ́A{@link AuthenticateException}throwB̌A㑱̏IAF؏ZbV폜B<br>
     * LȊÕpX̏ꍇA̓NGXg({@link #getRequestObjectAttributeName()})̓IuWFNg擾AF؃ZbV擾F؏Ƃ̔rsAF؂Ă邩ǂ`FbNB<br>
     * <p>
     * LɉāA{@link AuthenticateStore}ݒ肷ƁAOCpX̏ꍇA{@link AuthenticateStore#create(HttpServletRequest, Object)}ĂяoAF؏XgAB<br>
     * OAEgpX̏ꍇA㑱̏IA{@link AuthenticateStore#destroy(HttpServletRequest, Object)}ĂяoAF؏폜B<br>
     * LȊÕpX̏ꍇAF؃ZbVF؏񂪎擾łȂꍇA{@link AuthenticateStore#activate(HttpServletRequest, Object)}ĂяoAF؏𕜌B<br>
     * T[rXJnĂȂꍇ́AɎ̃C^[Zv^ĂяoB<br>
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    @Override
    public Object invokeFilter(
        ServletFilterInvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() != State.STARTED){
            return chain.invokeNext(context);
        }
        final HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
        String reqPath = request.getPathInfo();
        if(reqPath == null){
            reqPath = request.getServletPath();
        }
        if(loginPath.equals(reqPath)){
            Object ret = chain.invokeNext(context);
            setAuthenticatedInfo(request);
            return ret;
        }else if(logoutPath != null && logoutPath.equals(reqPath)){
            checkAuthenticated(request);
            Object ret = chain.invokeNext(context);
            removeAuthenticatedInfo(request);
            return ret;
        }else{
            checkAuthenticated(request);
            return chain.invokeNext(context);
        }
    }
    
    protected void setAuthenticatedInfo(HttpServletRequest request) throws AuthenticateException{
        Object authenticatedInfo = request.getAttribute(authenticatedInfoAttributeName);
        if(authenticatedInfo != null){
            HttpSession session = request.getSession(false);
            if(session == null){
                session = request.getSession(true);
            }
            session.setAttribute(authenticatedInfoAttributeName, new AuthenticatedInfo(authenticatedInfo, authenticateStoreServiceName));
            if(authenticateStore != null && isStoreCreate){
                authenticateStore.create(request, authenticatedInfo);
            }
        }
    }
    
    protected void removeAuthenticatedInfo(HttpServletRequest request) throws AuthenticateException{
        Object requestObject = request.getAttribute(requestObjectAttributeName);
        if(requestObject == null){
            throw new IllegalAuthenticateException("RequestObject is null.");
        }
        try{
            if(authenticateStore != null && isStoreDestroy){
                authenticateStore.destroy(request, requestObject);
            }
        }finally{
            HttpSession session = request.getSession(false);
            if(session != null){
                session.removeAttribute(authenticatedInfoAttributeName);
            }
        }
    }
    
    protected void checkAuthenticated(HttpServletRequest request) throws AuthenticateException{
        Object requestObject = request.getAttribute(requestObjectAttributeName);
        if(requestObject == null){
            throw new IllegalAuthenticateException("RequestObject is null.");
        }
        Object authenticatedInfo = null;
        HttpSession session = request.getSession(false);
        if(session != null){
            authenticatedInfo = session.getAttribute(authenticatedInfoAttributeName);
            if(authenticatedInfo != null && authenticatedInfo instanceof AuthenticatedInfo){
                authenticatedInfo = ((AuthenticatedInfo)authenticatedInfo).authenticatedInfo;
            }
        }
        if(authenticatedInfo == null && authenticateStore != null){
            authenticatedInfo = authenticateStore.activate(request, requestObject);
            session.setAttribute(authenticatedInfoAttributeName, new AuthenticatedInfo(authenticatedInfo, authenticateStoreServiceName));
        }
        if(authenticatedInfo == null){
            throw new NoAuthenticateException("AuthenticatedInfo is null.");
        }
        Iterator<Map.Entry<String,String>> entries = authenticatedInfoMapping.entrySet().iterator();
        while(entries.hasNext()){
            Map.Entry<String,String> entry = entries.next();
            Object requestValue = null;
            try{
                requestValue = propertyAccess.get(requestObject, entry.getKey());
            }catch(IllegalArgumentException e){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' cannot acquire from a request.", e);
            }catch(NoSuchPropertyException e){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' cannot acquire from a request.", e);
            }catch(InvocationTargetException e){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' cannot acquire from a request.", e.getTargetException());
            }
            if(requestValue == null){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' cannot acquire from a request. value=null");
            }
            Object authenticatedValue = null;
            try{
                authenticatedValue = propertyAccess.get(authenticatedInfo, entry.getValue());
            }catch(IllegalArgumentException e){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getValue() + "' cannot acquire from a session.", e);
            }catch(NoSuchPropertyException e){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getValue() + "' cannot acquire from a session.", e);
            }catch(InvocationTargetException e){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getValue() + "' cannot acquire from a session.", e.getTargetException());
            }
            if(authenticatedValue == null){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getValue() + "' cannot acquire from a session. value=null");
            }
            if(!requestValue.equals(authenticatedValue)){
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' and '" + entry.getValue() + "' are not in agreement. requestValue=" + requestValue + ", authenticatedValue=" + authenticatedValue);
            }
        }
    }
    
    public static class AuthenticatedInfo implements HttpSessionBindingListener, Serializable{
        
        private static final long serialVersionUID = -5976568672626640653L;

        public Object authenticatedInfo;
        
        protected ServiceName authenticateStoreServiceName;
        
        public AuthenticatedInfo(){}
        
        public AuthenticatedInfo(Object authInfo, ServiceName storeServiceName){
            authenticatedInfo = authInfo;
            authenticateStoreServiceName = storeServiceName;
        }
        
        public void valueBound(HttpSessionBindingEvent event){
        }
        
        public void valueUnbound(HttpSessionBindingEvent event){
            if(authenticateStoreServiceName != null){
                AuthenticateStore authenticateStore = (AuthenticateStore)ServiceManagerFactory.getServiceObject(authenticateStoreServiceName);
                authenticateStore.deactivate(event.getSession(), authenticatedInfo);
            }
        }
    }
}