/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.Properties;

import jp.ossc.nimbus.core.*;

/**
 * {@link MethodMappingInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see MethodMappingInterceptorService
 */
public interface MethodMappingInterceptorServiceMBean extends ServiceBaseMBean{
    
    /**
     * \bhƃC^[Zv^T[rX̃}bsOݒ肷B<p>
     * w肳ꂽ\bhĂяoꂽꍇɁAΉC^[Zv^T[rXĂяo悤ɐݒ肷B<br>
     * NX#\bh(^,^,c)=C^[Zv^T[rX<br>
     * NXA\bhA^ɂ́AK\w肷鎖łB܂Av邩rȂꍇ́A*w肷B<br>
     * v}bsOꍇ͕̓ۏ؂ȂB<br>
     *
     * @param mapping \bhƃC^[Zv^T[rX̃}bsO
     */
    public void setTargetMethodMapping(Properties mapping);
    
    /**
     * \bhƃC^[Zv^T[rX̃}bsO擾B<p>
     *
     * @return \bhƃC^[Zv^T[rX̃}bsO
     */
    public Properties getTargetMethodMapping();
    
    /**
     * \bhƃReLXgL[̃}bsOݒ肷B<p>
     * w肳ꂽ\bhĂяoꂽꍇɁAΉReLXgL[̒lReLXg擾ĕԂ悤ɐݒ肷B<br>
     * NX#\bh(^,^,c)=ReLXgL[<br>
     * NXA\bhA^ɂ́AK\w肷鎖łB܂Av邩rȂꍇ́A*w肷B<br>
     * v}bsOꍇ͕̓ۏ؂ȂB<br>
     *
     * @param mapping \bhƃReLXgL[̃}bsO
     */
    public void setTargetMethodReturnMapping(Properties mapping);
    
    /**
     * \bhƃReLXgL[̃}bsO擾B<p>
     *
     * @return \bhƃReLXgL[̃}bsO
     */
    public Properties getTargetMethodReturnMapping();
    
    /**
     * ReLXgT[rXݒ肷B<p>
     *
     * @param name ReLXgT[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * ReLXgT[rX擾B<p>
     *
     * @return ReLXgT[rX
     */
    public ServiceName getContextServiceName();
}
