/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 *
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import static org.testng.Assert.assertEquals;

import java.math.BigDecimal;
import java.math.BigInteger;

import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * {@link NumberCastConverter}eXgP[XB<p>
 *
 * @author M.Ishida
 */
public class NumberCastConverterTest {

    @Test(groups = {
            "jp.ossc.nimbus.util.converter.NumberCastConverter#NumberCastConverter()",
            "Normal" })
    public void testNumberCastConverter() {
        NumberCastConverter convertter = new NumberCastConverter();
        assertEquals(convertter.getReturnType(),Double.class);
    }

    @DataProvider(name = "NumberCastConverter")
    public Object[][] dataNumberCastConverter() {
        return new Object[][] {
                {BigDecimal.class, BigDecimal.class},
                {BigInteger.class, BigInteger.class},
                {Double.class, Double.class},
                {Float.class, Float.class},
                {Long.class, Long.class},
                {Integer.class, Integer.class},
                {Short.class, Short.class},
                {Byte.class, Byte.class},
                {byte.class, Byte.class},
                {short.class, Short.class},
                {int.class, Integer.class},
                {long.class, Long.class},
                {float.class, Float.class},
                {double.class, Double.class}
            };
    }

    @Test(groups = {
            "jp.ossc.nimbus.util.converter.NumberCastConverter#NumberCastConverter(java.lang.Class)",
            "Normal" },
            dataProvider = "NumberCastConverter")
    public void testNumberCastConverter(Class<?> type, Class<?> returnType) {
        NumberCastConverter convertter = new NumberCastConverter(type);
        assertEquals(convertter.getReturnType(), returnType);
    }

    @DataProvider(name = "NumberCastConverterError")
    public Object[][] dataNumberCastConverterError() {
        return new Object[][] {
                {null},
                {Object.class},
                {boolean.class},
                {char.class}
            };
    }

    @Test(groups = {
            "jp.ossc.nimbus.util.converter.NumberCastConverter#NumberCastConverter(java.lang.Class)",
            "Error" },
            expectedExceptions = { IllegalArgumentException.class },
            dataProvider = "NumberCastConverterError")
    public void testNumberCastConverterError(Class<?> type) throws IllegalArgumentException {
        new NumberCastConverter(type);
    }

    @DataProvider(name = "SetReturnType")
    public Object[][] dataSetReturnType() {
        return new Object[][] {
                {BigDecimal.class, BigDecimal.class},
                {BigInteger.class, BigInteger.class},
                {Double.class, Double.class},
                {Float.class, Float.class},
                {Long.class, Long.class},
                {Integer.class, Integer.class},
                {Short.class, Short.class},
                {Byte.class, Byte.class},
                {byte.class, Byte.class},
                {short.class, Short.class},
                {int.class, Integer.class},
                {long.class, Long.class},
                {float.class, Float.class},
                {double.class, Double.class}
            };
    }

    @Test(groups = {
            "jp.ossc.nimbus.util.converter.NumberCastConverter#setReturnType(java.lang.Class)",
            "jp.ossc.nimbus.util.converter.NumberCastConverter#getReturnType()",
            "Normal" },
            dataProvider = "SetReturnType")
    public void testSetReturnType(Class<?> type, Class<?> returnType) {
        NumberCastConverter convertter = new NumberCastConverter();
        convertter.setReturnType(type);
        assertEquals(convertter.getReturnType(), returnType);
    }

    @DataProvider(name = "SetReturnTypeError")
    public Object[][] dataSetReturnTypeError() {
        return new Object[][] {
                {null},
                {Object.class},
                {boolean.class},
                {char.class}
            };
    }

    @Test(groups = {
            "jp.ossc.nimbus.util.converter.NumberCastConverter#setReturnType(java.lang.Class)",
            "jp.ossc.nimbus.util.converter.NumberCastConverter#getReturnType()",
            "Error" },
            expectedExceptions = { IllegalArgumentException.class },
            dataProvider = "SetReturnTypeError")
    public void testSetReturnTypeError(Class<?> type) throws IllegalArgumentException {
        NumberCastConverter convertter = new NumberCastConverter();
        convertter.setReturnType(type);
    }

    @DataProvider(name = "Convert")
    public Object[][] dataConvert() {
        return new Object[][] {
                {BigDecimal.class, "-1", new BigDecimal("-1")},
                {BigDecimal.class, 0, new BigDecimal("0")},
                {BigDecimal.class, 1l, new BigDecimal("1")},
                {BigDecimal.class, (byte)2, new BigDecimal("2")},
                {BigDecimal.class, (short)3, new BigDecimal("3")},
                {BigDecimal.class, 4f, new BigDecimal("4")},
                {BigDecimal.class, 5d, new BigDecimal("5")},
                {BigDecimal.class, new BigDecimal("5"), new BigDecimal("5")},
                {BigDecimal.class, new BigInteger("6"), new BigDecimal("6")},
                {BigDecimal.class, new Byte("7"), new BigDecimal("7")},
                {BigDecimal.class, new Double("8"), new BigDecimal("8")},
                {BigDecimal.class, new Float("9"), new BigDecimal("9")},
                {BigDecimal.class, new Integer("10"), new BigDecimal("10")},
                {BigDecimal.class, new Long("11"), new BigDecimal("11")},
                {BigDecimal.class, new Short("12"), new BigDecimal("12")},
                {BigInteger.class, "-1", new BigInteger("-1")},
                {BigInteger.class, 0, new BigInteger("0")},
                {BigInteger.class, 1l, new BigInteger("1")},
                {BigInteger.class, (byte)2, new BigInteger("2")},
                {BigInteger.class, (short)3, new BigInteger("3")},
                {BigInteger.class, 4f, new BigInteger("4")},
                {BigInteger.class, 5d, new BigInteger("5")},
                {BigInteger.class, new BigDecimal("5"), new BigInteger("5")},
                {BigInteger.class, new BigInteger("6"), new BigInteger("6")},
                {BigInteger.class, new Byte("7"), new BigInteger("7")},
                {BigInteger.class, new Double("8"), new BigInteger("8")},
                {BigInteger.class, new Float("9"), new BigInteger("9")},
                {BigInteger.class, new Integer("10"), new BigInteger("10")},
                {BigInteger.class, new Long("11"), new BigInteger("11")},
                {BigInteger.class, new Short("12"), new BigInteger("12")},
                {Byte.class, "-1", new Byte("-1")},
                {Byte.class, 0, new Byte("0")},
                {Byte.class, 1l, new Byte("1")},
                {Byte.class, (byte)2, new Byte("2")},
                {Byte.class, (short)3, new Byte("3")},
                {Byte.class, 4f, new Byte("4")},
                {Byte.class, 5d, new Byte("5")},
                {Byte.class, new BigDecimal("5"), new Byte("5")},
                {Byte.class, new BigInteger("6"), new Byte("6")},
                {Byte.class, new Byte("7"), new Byte("7")},
                {Byte.class, new Double("8"), new Byte("8")},
                {Byte.class, new Float("9"), new Byte("9")},
                {Byte.class, new Integer("10"), new Byte("10")},
                {Byte.class, new Long("11"), new Byte("11")},
                {Byte.class, new Short("12"), new Byte("12")},
                {Double.class, "-1", new Double("-1")},
                {Double.class, 0, new Double("0")},
                {Double.class, 1l, new Double("1")},
                {Double.class, (byte)2, new Double("2")},
                {Double.class, (short)3, new Double("3")},
                {Double.class, 4f, new Double("4")},
                {Double.class, 5d, new Double("5")},
                {Double.class, new BigDecimal("5"), new Double("5")},
                {Double.class, new BigInteger("6"), new Double("6")},
                {Double.class, new Byte("7"), new Double("7")},
                {Double.class, new Double("8"), new Double("8")},
                {Double.class, new Float("9"), new Double("9")},
                {Double.class, new Integer("10"), new Double("10")},
                {Double.class, new Long("11"), new Double("11")},
                {Double.class, new Short("12"), new Double("12")},
                {Float.class, "-1", new Float("-1")},
                {Float.class, 0, new Float("0")},
                {Float.class, 1l, new Float("1")},
                {Float.class, (byte)2, new Float("2")},
                {Float.class, (short)3, new Float("3")},
                {Float.class, 4f, new Float("4")},
                {Float.class, 5d, new Float("5")},
                {Float.class, new BigDecimal("5"), new Float("5")},
                {Float.class, new BigInteger("6"), new Float("6")},
                {Float.class, new Byte("7"), new Float("7")},
                {Float.class, new Double("8"), new Float("8")},
                {Float.class, new Float("9"), new Float("9")},
                {Float.class, new Integer("10"), new Float("10")},
                {Float.class, new Long("11"), new Float("11")},
                {Float.class, new Short("12"), new Float("12")},
                {Integer.class, "-1", new Integer("-1")},
                {Integer.class, 0, new Integer("0")},
                {Integer.class, 1l, new Integer("1")},
                {Integer.class, (byte)2, new Integer("2")},
                {Integer.class, (short)3, new Integer("3")},
                {Integer.class, 4f, new Integer("4")},
                {Integer.class, 5d, new Integer("5")},
                {Integer.class, new BigDecimal("5"), new Integer("5")},
                {Integer.class, new BigInteger("6"), new Integer("6")},
                {Integer.class, new Byte("7"), new Integer("7")},
                {Integer.class, new Double("8"), new Integer("8")},
                {Integer.class, new Float("9"), new Integer("9")},
                {Integer.class, new Integer("10"), new Integer("10")},
                {Integer.class, new Long("11"), new Integer("11")},
                {Integer.class, new Short("12"), new Integer("12")},
                {Long.class, "-1", new Long("-1")},
                {Long.class, 0, new Long("0")},
                {Long.class, 1l, new Long("1")},
                {Long.class, (byte)2, new Long("2")},
                {Long.class, (short)3, new Long("3")},
                {Long.class, 4f, new Long("4")},
                {Long.class, 5d, new Long("5")},
                {Long.class, new BigDecimal("5"), new Long("5")},
                {Long.class, new BigInteger("6"), new Long("6")},
                {Long.class, new Byte("7"), new Long("7")},
                {Long.class, new Double("8"), new Long("8")},
                {Long.class, new Float("9"), new Long("9")},
                {Long.class, new Integer("10"), new Long("10")},
                {Long.class, new Long("11"), new Long("11")},
                {Long.class, new Short("12"), new Long("12")},
                {Short.class, "-1", new Short("-1")},
                {Short.class, 0, new Short("0")},
                {Short.class, 1l, new Short("1")},
                {Short.class, (byte)2, new Short("2")},
                {Short.class, (short)3, new Short("3")},
                {Short.class, 4f, new Short("4")},
                {Short.class, 5d, new Short("5")},
                {Short.class, new BigDecimal("5"), new Short("5")},
                {Short.class, new BigInteger("6"), new Short("6")},
                {Short.class, new Byte("7"), new Short("7")},
                {Short.class, new Double("8"), new Short("8")},
                {Short.class, new Float("9"), new Short("9")},
                {Short.class, new Integer("10"), new Short("10")},
                {Short.class, new Long("11"), new Short("11")},
                {Short.class, new Short("12"), new Short("12")},
                {byte.class, "-1", new Byte("-1")},
                {byte.class, 0, new Byte("0")},
                {byte.class, 1l, new Byte("1")},
                {byte.class, (byte)2, new Byte("2")},
                {byte.class, (short)3, new Byte("3")},
                {byte.class, 4f, new Byte("4")},
                {byte.class, 5d, new Byte("5")},
                {byte.class, new BigDecimal("5"), new Byte("5")},
                {byte.class, new BigInteger("6"), new Byte("6")},
                {byte.class, new Byte("7"), new Byte("7")},
                {byte.class, new Double("8"), new Byte("8")},
                {byte.class, new Float("9"), new Byte("9")},
                {byte.class, new Integer("10"), new Byte("10")},
                {byte.class, new Long("11"), new Byte("11")},
                {byte.class, new Short("12"), new Byte("12")},
                {short.class, "-1", new Short("-1")},
                {short.class, 0, new Short("0")},
                {short.class, 1l, new Short("1")},
                {short.class, (byte)2, new Short("2")},
                {short.class, (short)3, new Short("3")},
                {short.class, 4f, new Short("4")},
                {short.class, 5d, new Short("5")},
                {short.class, new BigDecimal("5"), new Short("5")},
                {short.class, new BigInteger("6"), new Short("6")},
                {short.class, new Byte("7"), new Short("7")},
                {short.class, new Double("8"), new Short("8")},
                {short.class, new Float("9"), new Short("9")},
                {short.class, new Integer("10"), new Short("10")},
                {short.class, new Long("11"), new Short("11")},
                {short.class, new Short("12"), new Short("12")},
                {int.class, "-1", new Integer("-1")},
                {int.class, 0, new Integer("0")},
                {int.class, 1l, new Integer("1")},
                {int.class, (byte)2, new Integer("2")},
                {int.class, (short)3, new Integer("3")},
                {int.class, 4f, new Integer("4")},
                {int.class, 5d, new Integer("5")},
                {int.class, new BigDecimal("5"), new Integer("5")},
                {int.class, new BigInteger("6"), new Integer("6")},
                {int.class, new Byte("7"), new Integer("7")},
                {int.class, new Double("8"), new Integer("8")},
                {int.class, new Float("9"), new Integer("9")},
                {int.class, new Integer("10"), new Integer("10")},
                {int.class, new Long("11"), new Integer("11")},
                {int.class, new Short("12"), new Integer("12")},
                {long.class, "-1", new Long("-1")},
                {long.class, 0, new Long("0")},
                {long.class, 1l, new Long("1")},
                {long.class, (byte)2, new Long("2")},
                {long.class, (short)3, new Long("3")},
                {long.class, 4f, new Long("4")},
                {long.class, 5d, new Long("5")},
                {long.class, new BigDecimal("5"), new Long("5")},
                {long.class, new BigInteger("6"), new Long("6")},
                {long.class, new Byte("7"), new Long("7")},
                {long.class, new Double("8"), new Long("8")},
                {long.class, new Float("9"), new Long("9")},
                {long.class, new Integer("10"), new Long("10")},
                {long.class, new Long("11"), new Long("11")},
                {long.class, new Short("12"), new Long("12")},
                {float.class, "-1", new Float("-1")},
                {float.class, 0, new Float("0")},
                {float.class, 1l, new Float("1")},
                {float.class, (byte)2, new Float("2")},
                {float.class, (short)3, new Float("3")},
                {float.class, 4f, new Float("4")},
                {float.class, 5d, new Float("5")},
                {float.class, new BigDecimal("5"), new Float("5")},
                {float.class, new BigInteger("6"), new Float("6")},
                {float.class, new Byte("7"), new Float("7")},
                {float.class, new Double("8"), new Float("8")},
                {float.class, new Float("9"), new Float("9")},
                {float.class, new Integer("10"), new Float("10")},
                {float.class, new Long("11"), new Float("11")},
                {float.class, new Short("12"), new Float("12")},
                {double.class, "-1", new Double("-1")},
                {double.class, 0, new Double("0")},
                {double.class, 1l, new Double("1")},
                {double.class, (byte)2, new Double("2")},
                {double.class, (short)3, new Double("3")},
                {double.class, 4f, new Double("4")},
                {double.class, 5d, new Double("5")},
                {double.class, new BigDecimal("5"), new Double("5")},
                {double.class, new BigInteger("6"), new Double("6")},
                {double.class, new Byte("7"), new Double("7")},
                {double.class, new Double("8"), new Double("8")},
                {double.class, new Float("9"), new Double("9")},
                {double.class, new Integer("10"), new Double("10")},
                {double.class, new Long("11"), new Double("11")},
                {double.class, new Short("12"), new Double("12")},
                {BigDecimal.class, new Boolean(true), new Boolean(true)},
                {BigDecimal.class, null, null},
            };
    }

    @Test(groups = {
            "jp.ossc.nimbus.util.converter.NumberCastConverter#convert(java.lang.Object)",
            "Normal" },
            dataProvider = "Convert")
    public void testConvert(Class<?> type, Object obj, Object returnObj) {
        NumberCastConverter convertter = new NumberCastConverter();
        convertter.setReturnType(type);
        assertEquals(convertter.convert(obj), returnObj);
    }

    @DataProvider(name = "ConvertError")
    public Object[][] dataConvertError() {
        return new Object[][] {
                {BigDecimal.class, ""},
            };
    }

    @Test(groups = {
            "jp.ossc.nimbus.util.converter.NumberCastConverter#convert(java.lang.Object)",
            "Error" },
            expectedExceptions = { ConvertException.class },
            dataProvider = "ConvertError")
    public void testConvertError(Class<?> type, Object obj) {
        NumberCastConverter convertter = new NumberCastConverter();
        convertter.setReturnType(type);
        convertter.convert(obj);
    }

}
