/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import static org.testng.Assert.*;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;
import org.w3c.dom.Element;

import static jp.ossc.nimbus.TestUtility.*;

/**
 * {@link ServiceRefMetaData}eXgP[XB<p>
 * 
 * @author M.Takata
 */
public class ServiceRefMetaDataTest{

    @DataProvider(name = "ServiceRefMetaData")
    public Object[][] dataServiceRefMetaData(){
        return new Object[][]{
            {null},
            {new AttributeMetaData(null)},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceRefMetaData#ServiceRefMetaData(jp.ossc.nimbus.core.MetaData)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.ServiceNameMetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.AttributeMetaData#AttributeMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "ServiceRefMetaData")
    public void testServiceRefMetaData(MetaData parent){
        ServiceRefMetaData metaData = new ServiceRefMetaData(parent);
        assertEquals(metaData.tagName, ServiceRefMetaData.SERIVCE_REF_TAG_NAME);
        assertEquals(metaData.getParent(), parent);
        assertEquals(metaData.getManagerName(), ServiceManager.DEFAULT_NAME);
        assertNull(metaData.getServiceName());
    }

    @DataProvider(name = "ServiceRefMetaData2")
    public Object[][] dataServiceRefMetaData2(){
        return new Object[][]{
            {null, null, ServiceManager.DEFAULT_NAME},
            {new AttributeMetaData(null), null, ServiceManager.DEFAULT_NAME},
            {new AttributeMetaData(null), "manager1", "manager1"},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceRefMetaData#ServiceRefMetaData(jp.ossc.nimbus.core.MetaData,java.lang.String)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.ServiceNameMetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.AttributeMetaData#AttributeMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "ServiceRefMetaData2")
    public void testServiceRefMetaData2(MetaData parent, String manager, String expected){
        ServiceRefMetaData metaData = new ServiceRefMetaData(parent, manager);
        assertEquals(metaData.tagName, ServiceRefMetaData.SERIVCE_REF_TAG_NAME);
        assertEquals(metaData.getParent(), parent);
        assertEquals(metaData.getManagerName(), expected);
        assertNull(metaData.getServiceName());
    }

    @DataProvider(name = "ServiceRefMetaData3")
    public Object[][] dataServiceRefMetaData3(){
        return new Object[][]{
            {null, null, null, new String[]{ServiceManager.DEFAULT_NAME, null}},
            {new AttributeMetaData(null), null, null, new String[]{ServiceManager.DEFAULT_NAME, null}},
            {new AttributeMetaData(null), "manager1", null, new String[]{"manager1", null}},
            {new AttributeMetaData(null), "manager1", "service1", new String[]{"manager1", "service1"}},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceRefMetaData#ServiceRefMetaData(jp.ossc.nimbus.core.MetaData,java.lang.String,java.lang.String)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.ServiceNameMetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.AttributeMetaData#AttributeMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "ServiceRefMetaData3")
    public void testServiceRefMetaData3(MetaData parent, String manager, String service, String[] expected){
        ServiceRefMetaData metaData = new ServiceRefMetaData(parent, manager, service);
        assertEquals(metaData.tagName, ServiceRefMetaData.SERIVCE_REF_TAG_NAME);
        assertEquals(metaData.getParent(), parent);
        assertEquals(metaData.getManagerName(), expected[0]);
        assertEquals(metaData.getServiceName(), expected[1]);
    }

    @DataProvider(name = "ImportXML")
    public Object[][] dataImportXML() throws Exception{
        return new Object[][]{
            {createElement("<service-ref>Service</service-ref>"), new Object[]{ServiceManager.DEFAULT_NAME, "Service"}},
            {createElement("<service-ref>#Service</service-ref>"), new Object[]{ServiceManager.DEFAULT_NAME, "Service"}},
            {createElement("<service-ref>manager#Service</service-ref>"), new Object[]{"manager", "Service"}},
            {createElement("<service-ref unknown=\"hoge\">Service</service-ref>"), new Object[]{ServiceManager.DEFAULT_NAME, "Service"}},
            {createElement("<service-ref>Service<unknown/></service-ref>"), new Object[]{ServiceManager.DEFAULT_NAME, "Service"}},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceRefMetaData#importXML(org.w3c.dom.Element)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.ServiceNameMetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.ServiceRefMetaData#ServiceRefMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          dataProvider = "ImportXML")
    public void testImportXML(
        Element element,
        Object[] assertValues
    ) throws DeploymentException{
        ServiceRefMetaData metaData = new ServiceRefMetaData(null);
        metaData.importXML(element);
        assertEquals(metaData.getManagerName(), assertValues[0]);
        assertEquals(metaData.getServiceName(), assertValues[1]);
    }

    @DataProvider(name = "ImportXML2")
    public Object[][] dataImportXML2() throws Exception{
        return new Object[][]{
            {null, createElement("<service-ref>Service</service-ref>"), new Object[]{ServiceManager.DEFAULT_NAME, "Service"}},
            {null, createElement("<service-ref>#Service</service-ref>"), new Object[]{ServiceManager.DEFAULT_NAME, "Service"}},
            {null, createElement("<service-ref>manager#Service</service-ref>"), new Object[]{"manager", "Service"}},
            {"manager", createElement("<service-ref>Service</service-ref>"), new Object[]{"manager", "Service"}},
            {"manager", createElement("<service-ref>#Service</service-ref>"), new Object[]{"manager", "Service"}},
            {"manager", createElement("<service-ref>manager2#Service</service-ref>"), new Object[]{"manager2", "Service"}},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceRefMetaData#importXML(org.w3c.dom.Element)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.ServiceNameMetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.ServiceRefMetaData#ServiceRefMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData,java\\.lang\\.String\\)"},
          dataProvider = "ImportXML2")
    public void testImportXML2(
        String manager,
        Element element,
        Object[] assertValues
    ) throws DeploymentException{
        ServiceRefMetaData metaData = new ServiceRefMetaData(null, manager);
        metaData.importXML(element);
        assertEquals(metaData.getManagerName(), assertValues[0]);
        assertEquals(metaData.getServiceName(), assertValues[1]);
    }

    @DataProvider(name = "ImportXMLError")
    public Object[][] dataImportXMLError() throws Exception{
        return new Object[][]{
            {null},
            {createElement("<service-ref/>")},
            {createElement("<service-ref>manager#</service-ref>")},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ServiceRefMetaData#importXML(org.w3c.dom.Element)",
                    "Error"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.ServiceNameMetaData#.*",
                             "jp\\.ossc\\.nimbus\\.core\\.ServiceRefMetaData#ServiceRefMetaData\\(jp\\.ossc\\.nimbus\\.core\\.MetaData\\)"},
          expectedExceptions = {NullPointerException.class, DeploymentException.class},
          dataProvider = "ImportXMLError")
    public void testImportXMLError(Element element) throws DeploymentException{
        ServiceRefMetaData metaData = new ServiceRefMetaData(null);
        metaData.importXML(element);
    }
}
