/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.validator;

import java.math.*;

/**
 * lof[^B<p>
 * 
 * @author M.Takata
 */
public class NumberValidator implements Validator, java.io.Serializable{
    
    private static final long serialVersionUID = -1507930380189770984L;
    
    /**
     * nulle邩ǂ̃tOB<p>
     * truȅꍇAeBftHǵAtrueB<br>
     */
    protected boolean isAllowNull = true;
    
    /**
     * NaNe邩ǂ̃tOB<p>
     * truȅꍇAeBftHǵAtrueB<br>
     */
    protected boolean isAllowNaN = true;
    
    /**
     * e邩ǂ̃tOB<p>
     * truȅꍇAeBftHǵAtrueB<br>
     */
    protected boolean isAllowInfinity = true;
    
    /**
     * le邩ǂ̃tOB<p>
     * truȅꍇAeBftHǵAfalseB<br>
     */
    protected boolean isAllowNumberString;
    
    /**
     * ؒl &gt; l؂臒lB<p>
     */
    protected BigDecimal moreThanValue;
    
    /**
     * ؒl &gt;= l؂臒lB<p>
     */
    protected BigDecimal moreEqualValue;
    
    /**
     * ؒl &lt; l؂臒lB<p>
     */
    protected BigDecimal lessThanValue;
    
    /**
     * ؒl &lt;= l؂臒lB<p>
     */
    protected BigDecimal lessEqualValue;
    
    /**
     * ؒl == l؂臒lB<p>
     */
    protected BigDecimal equalValue;
    
    /**
     * ؒl != l؂臒lB<p>
     */
    protected BigDecimal notEqualValue;
    
    /**
     * nulle邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     * 
     * @param isAllow truȅꍇAe
     */
    public void setAllowNull(boolean isAllow){
        isAllowNull = isAllow;
    }
    
    /**
     * nulle邩ǂ𔻒肷B<p>
     * 
     * @return eꍇAtrue
     */
    public boolean isAllowNull(){
        return isAllowNull;
    }
    
    /**
     * NaNe邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     * 
     * @param isAllow truȅꍇAe
     */
    public void setAllowNaN(boolean isAllow){
        isAllowNaN = isAllow;
    }
    
    /**
     * NaNe邩ǂ𔻒肷B<p>
     * 
     * @return eꍇAtrue
     */
    public boolean isAllowNaN(){
        return isAllowNaN;
    }
    
    /**
     * e邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     * 
     * @param isAllow truȅꍇAe
     */
    public void setAllowInfinity(boolean isAllow){
        isAllowInfinity = isAllow;
    }
    
    /**
     * e邩ǂ𔻒肷B<p>
     * 
     * @return eꍇAtrue
     */
    public boolean isAllowInfinity(){
        return isAllowInfinity;
    }
    
    /**
     * le邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     * 
     * @param isAllow truȅꍇAe
     */
    public void setAllowNumberString(boolean isAllow){
        isAllowNumberString = isAllow;
    }
    
    /**
     * le邩ǂ𔻒肷B<p>
     * 
     * @return eꍇAtrue
     */
    public boolean isAllowNumberString(){
        return isAllowNumberString;
    }
    
    /**
     * ؒl &gt; l؂臒lݒ肷B<p>
     *
     * @param max 臒l
     */
    public void setMoreThanValue(BigDecimal max){
        moreThanValue = max;
    }
    
    /**
     * ؒl &gt; l؂臒l擾B<p>
     *
     * @return 臒l
     */
    public BigDecimal getMoreThanValue(){
        return moreThanValue;
    }
    
    /**
     * ؒl &gt;= l؂臒lݒ肷B<p>
     *
     * @param max 臒l
     */
    public void setMoreEqualValue(BigDecimal max){
        moreEqualValue = max;
    }
    
    /**
     * ؒl &gt;= l؂臒l擾B<p>
     *
     * @return 臒l
     */
    public BigDecimal getMoreEqualValue(){
        return moreEqualValue;
    }
    
    /**
     * ؒl &lt; l؂臒lݒ肷B<p>
     *
     * @param min 臒l
     */
    public void setLessThanValue(BigDecimal min){
        lessThanValue = min;
    }
    
    /**
     * ؒl &lt; l؂臒l擾B<p>
     *
     * @return 臒l
     */
    public BigDecimal getLessThanValue(){
        return lessThanValue;
    }
    
    /**
     * ؒl &lt;= l؂臒lݒ肷B<p>
     *
     * @param min 臒l
     */
    public void setLessEqualValue(BigDecimal min){
        lessEqualValue = min;
    }
    
    /**
     * ؒl &lt;= l؂臒l擾B<p>
     *
     * @return 臒l
     */
    public BigDecimal getLessEqualValue(){
        return lessEqualValue;
    }
    
    /**
     * ؒl == l؂臒lݒ肷B<p>
     *
     * @param eq 臒l
     */
    public void setEqualValue(BigDecimal eq){
        equalValue = eq;
    }
    
    /**
     * ؒl == l؂臒l擾B<p>
     *
     * @return 臒l
     */
    public BigDecimal getEqualValue(){
        return equalValue;
    }
    
    /**
     * ؒl != l؂臒lݒ肷B<p>
     *
     * @param neq 臒l
     */
    public void setNotEqualValue(BigDecimal neq){
        notEqualValue = neq;
    }
    
    /**
     * ؒl != l؂臒l擾B<p>
     *
     * @return 臒l
     */
    public BigDecimal getNotEqualValue(){
        return notEqualValue;
    }
    
    /**
     * w肳ꂽIuWFNgK؂Ȑlǂ؂B<p>
     *
     * @param obj ؑΏۂ̃IuWFNg
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    @Override
    public boolean validate(Object obj) throws ValidateException{
        if(obj == null){
            return isAllowNull;
        }
        if(!(obj instanceof Number)){
            if(obj instanceof String && isAllowNumberString){
                return validateString((String)obj);
            }
            return false;
        }
        if(obj instanceof Byte){
            return validate(((Byte)obj).byteValue());
        }else if(obj instanceof Short){
            return validate(((Short)obj).shortValue());
        }else if(obj instanceof Integer){
            return validate(((Integer)obj).intValue());
        }else if(obj instanceof Long){
            return validate(((Long)obj).longValue());
        }else if(obj instanceof Float){
            return validate(((Float)obj).floatValue());
        }else if(obj instanceof Double){
            return validate(((Double)obj).doubleValue());
        }else if(obj instanceof BigInteger){
            return validateBigInteger((BigInteger)obj);
        }else if(obj instanceof BigDecimal){
            return validateBigDecimal((BigDecimal)obj);
        }
        throw new ValidateException(
            "Not support number." + obj.getClass().getName()
        );
    }
    
    /**
     * w肳ꂽlK؂Ȑlǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    public boolean validate(byte val) throws ValidateException{
        if(moreThanValue != null){
            if(moreThanValue.byteValue() >= val){
                return false;
            }
        }
        if(moreEqualValue != null){
            if(moreEqualValue.byteValue() > val){
                return false;
            }
        }
        if(lessThanValue != null){
            if(lessThanValue.byteValue() <= val){
                return false;
            }
        }
        if(lessEqualValue != null){
            if(lessEqualValue.byteValue() < val){
                return false;
            }
        }
        if(equalValue != null){
            if(equalValue.byteValue() != val){
                return false;
            }
        }
        if(notEqualValue != null){
            if(notEqualValue.byteValue() == val){
                return false;
            }
        }
        return true;
    }
    
    /**
     * w肳ꂽlK؂Ȑlǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    public boolean validate(short val) throws ValidateException{
        if(moreThanValue != null){
            if(moreThanValue.shortValue() >= val){
                return false;
            }
        }
        if(moreEqualValue != null){
            if(moreEqualValue.shortValue() > val){
                return false;
            }
        }
        if(lessThanValue != null){
            if(lessThanValue.shortValue() <= val){
                return false;
            }
        }
        if(lessEqualValue != null){
            if(lessEqualValue.shortValue() < val){
                return false;
            }
        }
        if(equalValue != null){
            if(equalValue.shortValue() != val){
                return false;
            }
        }
        if(notEqualValue != null){
            if(notEqualValue.shortValue() == val){
                return false;
            }
        }
        return true;
    }
    
    /**
     * w肳ꂽlK؂Ȑlǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    public boolean validate(int val) throws ValidateException{
        if(moreThanValue != null){
            if(moreThanValue.intValue() >= val){
                return false;
            }
        }
        if(moreEqualValue != null){
            if(moreEqualValue.intValue() > val){
                return false;
            }
        }
        if(lessThanValue != null){
            if(lessThanValue.intValue() <= val){
                return false;
            }
        }
        if(lessEqualValue != null){
            if(lessEqualValue.intValue() < val){
                return false;
            }
        }
        if(equalValue != null){
            if(equalValue.intValue() != val){
                return false;
            }
        }
        if(notEqualValue != null){
            if(notEqualValue.intValue() == val){
                return false;
            }
        }
        return true;
    }
    
    /**
     * w肳ꂽlK؂Ȑlǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    public boolean validate(long val) throws ValidateException{
        if(moreThanValue != null){
            if(moreThanValue.longValue() >= val){
                return false;
            }
        }
        if(moreEqualValue != null){
            if(moreEqualValue.longValue() > val){
                return false;
            }
        }
        if(lessThanValue != null){
            if(lessThanValue.longValue() <= val){
                return false;
            }
        }
        if(lessEqualValue != null){
            if(lessEqualValue.longValue() < val){
                return false;
            }
        }
        if(equalValue != null){
            if(equalValue.longValue() != val){
                return false;
            }
        }
        if(notEqualValue != null){
            if(notEqualValue.longValue() == val){
                return false;
            }
        }
        return true;
    }
    
    /**
     * w肳ꂽlK؂Ȑlǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    public boolean validate(float val) throws ValidateException{
        if(Float.isNaN(val)){
            return isAllowNaN;
        }
        if(Float.isInfinite(val)){
            return isAllowInfinity;
        }
        if(moreThanValue != null){
            if(moreThanValue.floatValue() >= val){
                return false;
            }
        }
        if(moreEqualValue != null){
            if(moreEqualValue.floatValue() > val){
                return false;
            }
        }
        if(lessThanValue != null){
            if(lessThanValue.floatValue() <= val){
                return false;
            }
        }
        if(lessEqualValue != null){
            if(lessEqualValue.floatValue() < val){
                return false;
            }
        }
        if(equalValue != null){
            if(equalValue.floatValue() != val){
                return false;
            }
        }
        if(notEqualValue != null){
            if(notEqualValue.floatValue() == val){
                return false;
            }
        }
        return true;
    }
    
    /**
     * w肳ꂽlK؂Ȑlǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    public boolean validate(double val) throws ValidateException{
        if(Double.isNaN(val)){
            return isAllowNaN;
        }
        if(Double.isInfinite(val)){
            return isAllowInfinity;
        }
        if(moreThanValue != null){
            if(moreThanValue.doubleValue() >= val){
                return false;
            }
        }
        if(moreEqualValue != null){
            if(moreEqualValue.doubleValue() > val){
                return false;
            }
        }
        if(lessThanValue != null){
            if(lessThanValue.doubleValue() <= val){
                return false;
            }
        }
        if(lessEqualValue != null){
            if(lessEqualValue.doubleValue() < val){
                return false;
            }
        }
        if(equalValue != null){
            if(equalValue.doubleValue() != val){
                return false;
            }
        }
        if(notEqualValue != null){
            if(notEqualValue.doubleValue() == val){
                return false;
            }
        }
        return true;
    }
    
    /**
     * w肳ꂽlK؂Ȑlǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    protected boolean validateBigInteger(BigInteger val) throws ValidateException{
        if(val == null){
            return isAllowNull;
        }
        
        if(moreThanValue != null){
            final int comp = moreThanValue.toBigInteger().compareTo(val);
            if(comp >= 0){
                return false;
            }
        }
        if(moreEqualValue != null){
            final int comp = moreEqualValue.toBigInteger().compareTo(val);
            if(comp > 0){
                return false;
            }
        }
        if(lessThanValue != null){
            final int comp = lessThanValue.toBigInteger().compareTo(val);
            if(comp <= 0){
                return false;
            }
        }
        if(lessEqualValue != null){
            final int comp = lessEqualValue.toBigInteger().compareTo(val);
            if(comp < 0){
                return false;
            }
        }
        if(equalValue != null){
            final int comp = equalValue.toBigInteger().compareTo(val);
            if(comp != 0){
                return false;
            }
        }
        if(notEqualValue != null){
            final int comp = notEqualValue.toBigInteger().compareTo(val);
            if(comp == 0){
                return false;
            }
        }
        return true;
    }
    
    /**
     * w肳ꂽlK؂Ȑlǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    protected boolean validateBigDecimal(BigDecimal val) throws ValidateException{
        if(val == null){
            return isAllowNull;
        }
        
        if(moreThanValue != null){
            final int comp = moreThanValue.compareTo(val);
            if(comp >= 0){
                return false;
            }
        }
        if(moreEqualValue != null){
            final int comp = moreEqualValue.compareTo(val);
            if(comp > 0){
                return false;
            }
        }
        if(lessThanValue != null){
            final int comp = lessThanValue.compareTo(val);
            if(comp <= 0){
                return false;
            }
        }
        if(lessEqualValue != null){
            final int comp = lessEqualValue.compareTo(val);
            if(comp < 0){
                return false;
            }
        }
        if(equalValue != null){
            final int comp = equalValue.compareTo(val);
            if(comp != 0){
                return false;
            }
        }
        if(notEqualValue != null){
            final int comp = notEqualValue.compareTo(val);
            if(comp == 0){
                return false;
            }
        }
        return true;
    }
    
    /**
     * w肳ꂽ񂪓K؂Ȑl񂩂ǂ؂B<p>
     *
     * @param val ؑΏۂ̒l
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    protected boolean validateString(String val) throws ValidateException{
        if(val == null){
            return isAllowNull;
        }
        
        if(Double.toString(Double.NaN).equals(val)){
            return isAllowNaN;
        }
        if(Double.toString(Double.NEGATIVE_INFINITY).equals(val)
            || Double.toString(Double.POSITIVE_INFINITY).equals(val)){
            return isAllowInfinity;
        }
        
        try{
            return validateBigDecimal(new BigDecimal(val));
        }catch(NumberFormatException e){
            return false;
        }
    }
}
