/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.io.*;

/**
 * ̃Xg[Ro[^B<p>
 * 
 * @author M.Takata
 */
public class StringStreamConverter extends BufferedStreamConverter implements StreamStringConverter, Serializable{
    
    private static final long serialVersionUID = -4431451590828201935L;
    
    /**
     * 񁨃Xg[\ϊʒ萔B<p>
     */
    public static final int STRING_TO_STREAM = OBJECT_TO_STREAM;
    
    /**
     * Xg[\ϊʒ萔B<p>
     */
    public static final int STREAM_TO_STRING = STREAM_TO_OBJECT;
    
    /**
     * ϊʁB<p>
     */
    protected int convertType;
    
    /**
     * 񁨃Xg[ϊɎgp镶GR[fBOB<p>
     */
    protected String characterEncodingToStream;
    
    /**
     * Xg[ϊɎgp镶GR[fBOB<p>
     */
    protected String characterEncodingToObject;
    
    /**
     * 񁨃Xg[ϊsRo[^𐶐B<p>
     */
    public StringStreamConverter(){
        this(STRING_TO_STREAM);
    }
    
    /**
     * w肳ꂽϊʂ̃Ro[^𐶐B<p>
     *
     * @param type ϊ
     * @see #STRING_TO_STREAM
     * @see #STREAM_TO_STRING
     */
    public StringStreamConverter(int type){
        convertType = type;
    }
    
    /**
     * ϊʂݒ肷B<p>
     *
     * @param type ϊ
     * @see #getConvertType()
     * @see #STRING_TO_STREAM
     * @see #STREAM_TO_STRING
     */
    public void setConvertType(int type){
        convertType = type;
    }
    
    /**
     * ϊʂ擾B<p>
     *
     * @return ϊ
     * @see #setConvertType(int)
     */
    public int getConvertType(){
        return convertType;
    }
    
    /**
     * 񁨃Xg[ϊɎgp镶GR[fBOݒ肷B<p>
     * 
     * @param encoding GR[fBO
     */
    public void setCharacterEncodingToStream(String encoding){
        characterEncodingToStream = encoding;
    }
    
    /**
     * 񁨃Xg[ϊɎgp镶GR[fBO擾B<p>
     * 
     * @return GR[fBO
     */
    public String getCharacterEncodingToStream(){
        return characterEncodingToStream;
    }
    
    /**
     * Xg[ϊɎgp镶GR[fBOݒ肷B<p>
     * 
     * @param encoding GR[fBO
     */
    public void setCharacterEncodingToObject(String encoding){
        characterEncodingToObject = encoding;
    }
    
    /**
     * Xg[ϊɎgp镶GR[fBO擾B<p>
     * 
     * @return GR[fBO
     */
    public String getCharacterEncodingToObject(){
        return characterEncodingToObject;
    }
    
    /**
     * w肳ꂽIuWFNgϊB<p>
     *
     * @param obj ϊΏۂ̃IuWFNg
     * @return ϊ̃IuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    public Object convert(Object obj) throws ConvertException{
        if(obj == null){
            return null;
        }
        switch(convertType){
        case STRING_TO_STREAM:
            return convertToStream(obj);
        case STREAM_TO_STRING:
            if(!(obj instanceof InputStream)){
                throw new ConvertException(
                    "Invalid input type : " + obj.getClass()
                );
            }
            return convertToObject((InputStream)obj);
        default:
            throw new ConvertException(
                "Invalid convert type : " + convertType
            );
        }
    }
    
    /**
     * 񂩂oCgzɕϊB<p>
     *
     * @param obj 
     * @return oCgz
     * @exception ConvertException ϊɎsꍇ
     */
    protected byte[] convertToByteArray(Object obj) throws ConvertException{
        byte[] bytes = null;
        if(characterEncodingToStream == null){
            bytes = ((String)obj).getBytes();
        }else{
            try{
                bytes = ((String)obj).getBytes(characterEncodingToStream);
            }catch(UnsupportedEncodingException e){
                throw new ConvertException(e);
            }
        }
        return bytes;
    }
    
    /**
     * Xg[當ɕϊB<p>
     *
     * @param is Xg[
     * @return 
     * @exception ConvertException ϊɎsꍇ
     */
    public Object convertToObject(InputStream is) throws ConvertException{
        return toString(toBytes(is));
    }
    
    protected byte[] toBytes(InputStream is) throws ConvertException{
        byte[] bytes = new byte[1024];
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int length = 0;
        try{
            while((length = is.read(bytes)) != -1){
                baos.write(bytes, 0, length);
            }
        }catch(IOException e){
            throw new ConvertException(e);
        }
        return baos.toByteArray();
    }
    
    protected String toString(byte[] bytes) throws ConvertException{
        if(characterEncodingToObject == null){
            return new String(bytes);
        }else{
            try{
                return new String(bytes, characterEncodingToObject);
            }catch(UnsupportedEncodingException e){
                throw new ConvertException(e);
            }
        }
    }
}
