/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.util.*;

/**
 * JX^Ro[^B<p>
 * 
 * @author M.Takata
 */
public class CustomConverter
 implements Converter, StringConverter, CharacterConverter,
            java.io.Serializable{
    
    private static final long serialVersionUID = 727589924434574684L;
    
    protected List<Converter> converters;
    
    /**
     * ̃JX^Ro[^𐶐B<p>
     */
    public CustomConverter(){
    }
    
    /**
     * JX^Ro[^𐶐B<p>
     * 
     * @param convs Ro[^z
     */
    public CustomConverter(Converter[] convs){
        if(convs != null && convs.length != 0){
            converters = new ArrayList<Converter>();
            for(int i = 0; i < convs.length; i++){
                converters.add(convs[i]);
            }
        }
    }
    
    /**
     * Ro[^ǉB<p>
     *
     * @param converter Ro[^
     * @return g̃CX^X
     */
    public Converter add(Converter converter){
        if(converters == null){
            converters = new ArrayList<Converter>();
        }
        converters.add(converter);
        return this;
    }
    
    /**
     * Ro[^폜B<p>
     *
     * @param converter Ro[^
     */
    public void remove(Converter converter){
        if(converters == null){
            return;
        }
        converters.remove(converter);
    }
    
    /**
     * Ro[^Sč폜B<p>
     */
    public void clear(){
        if(converters == null){
            return;
        }
        converters.clear();
    }
    
    /**
     * w肳ꂽIuWFNgϊB<p>
     * ǉꂽRo[^ɏAϊ˗ĕϊʂԂB<br>
     *
     * @param obj ϊΏۂ̃IuWFNg
     * @return ϊ̃IuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Object convert(Object obj) throws ConvertException{
        Object tmp = obj;
        if(converters != null){
            for(int i = 0, max = converters.size(); i < max; i++){
                tmp = ((Converter)converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }
    
    /**
     * w肳ꂽϊB<p>
     * ǉꂽRo[^ɏAϊ˗ĕϊʂԂB<br>
     * {@link StringConverter}ȊOConverter͖B
     *
     * @param str ϊΏۂ̃LN^
     * @return ϊ̃LN^
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public String convert(String str) throws ConvertException{
        String tmp = str;
        if(converters != null){
            for(int i = 0, max = converters.size(); i < max; i++){
                if(converters.get(i) instanceof StringConverter){
                    tmp = ((StringConverter)converters.get(i)).convert(tmp);
                }
            }
        }
        return tmp;
    }
    
    /**
     * w肳ꂽLN^ϊB<p>
     * ǉꂽLN^Ro[^ɏAϊ˗ĕϊʂԂB<br>
     * {@link CharacterConverter}ȊOConverter͖B
     *
     * @param c ϊΏۂ̃LN^
     * @return ϊ̃LN^
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public char convert(char c) throws ConvertException{
        char tmp = c;
        if(converters != null){
            for(int i = 0, max = converters.size(); i < max; i++){
                if(converters.get(i) instanceof CharacterConverter){
                    tmp = ((CharacterConverter)converters.get(i)).convert(tmp);
                }
            }
        }
        return tmp;
    }
    
    /**
     * w肳ꂽLN^ϊB<p>
     * ǉꂽLN^Ro[^ɏAϊ˗ĕϊʂԂB<br>
     * {@link CharacterConverter}ȊOConverter͖B
     *
     * @param c ϊΏۂ̃LN^
     * @return ϊ̃LN^
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Character convert(Character c) throws ConvertException{
        Character tmp = c;
        if(converters != null){
            for(int i = 0, max = converters.size(); i < max; i++){
                if(converters.get(i) instanceof CharacterConverter){
                    tmp = ((CharacterConverter)converters.get(i)).convert(tmp);
                }
            }
        }
        return tmp;
    }
}
